/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SupplierInvoiceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SupplierInvoiceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SupplierInvoiceOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SupplierInvoiceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierInvoiceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierInvoice extends VdmEntity<SupplierInvoice>
{

    /**
     * Selector for all available fields of SupplierInvoice.
     *
     */
    public final static SupplierInvoiceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Invoice Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_INVOICE =
        new SupplierInvoiceField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> FISCAL_YEAR = new SupplierInvoiceField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> COMPANY_CODE = new SupplierInvoiceField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Invoice Date in Document
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> DOCUMENT_DATE =
        new SupplierInvoiceField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> POSTING_DATE =
        new SupplierInvoiceField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Day On Which Accounting Document Was Entered
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> CREATION_DATE =
        new SupplierInvoiceField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceIDByInvcgParty</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "SupplierInvoiceIDByInvcgParty" )
    @JsonProperty( "SupplierInvoiceIDByInvcgParty" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceIDByInvcgParty" )
    private String supplierInvoiceIDByInvcgParty;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceIDByInvcgParty</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_INVOICE_ID_BY_INVCG_PARTY =
        new SupplierInvoiceField<String>("SupplierInvoiceIDByInvcgParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @return Different Invoicing Party
     */
    @SerializedName( "InvoicingParty" )
    @JsonProperty( "InvoicingParty" )
    @Nullable
    @ODataField( odataName = "InvoicingParty" )
    private String invoicingParty;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingParty</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> INVOICING_PARTY =
        new SupplierInvoiceField<String>("InvoicingParty");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> DOCUMENT_CURRENCY =
        new SupplierInvoiceField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceGrossAmount</b>
     * </p>
     *
     * @return Gross Invoice Amount in Document Currency
     */
    @SerializedName( "InvoiceGrossAmount" )
    @JsonProperty( "InvoiceGrossAmount" )
    @Nullable
    @ODataField( odataName = "InvoiceGrossAmount" )
    private BigDecimal invoiceGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceGrossAmount</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> INVOICE_GROSS_AMOUNT =
        new SupplierInvoiceField<BigDecimal>("InvoiceGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnplannedDeliveryCost</b>
     * </p>
     *
     * @return Unplanned Delivery Costs
     */
    @SerializedName( "UnplannedDeliveryCost" )
    @JsonProperty( "UnplannedDeliveryCost" )
    @Nullable
    @ODataField( odataName = "UnplannedDeliveryCost" )
    private BigDecimal unplannedDeliveryCost;
    /**
     * Use with available fluent helpers to apply the <b>UnplannedDeliveryCost</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> UNPLANNED_DELIVERY_COST =
        new SupplierInvoiceField<BigDecimal>("UnplannedDeliveryCost");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentHeaderText</b>
     * </p>
     *
     * @return Document Header Text
     */
    @SerializedName( "DocumentHeaderText" )
    @JsonProperty( "DocumentHeaderText" )
    @Nullable
    @ODataField( odataName = "DocumentHeaderText" )
    private String documentHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentHeaderText</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> DOCUMENT_HEADER_TEXT =
        new SupplierInvoiceField<String>("DocumentHeaderText");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ManualCashDiscount</b>
     * </p>
     *
     * @return Cash Discount Amount in Document Currency
     */
    @SerializedName( "ManualCashDiscount" )
    @JsonProperty( "ManualCashDiscount" )
    @Nullable
    @ODataField( odataName = "ManualCashDiscount" )
    private BigDecimal manualCashDiscount;
    /**
     * Use with available fluent helpers to apply the <b>ManualCashDiscount</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> MANUAL_CASH_DISCOUNT =
        new SupplierInvoiceField<BigDecimal>("ManualCashDiscount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYMENT_TERMS = new SupplierInvoiceField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueCalculationBaseDate</b>
     * </p>
     *
     * @return Baseline Date for Due Date Calculation
     */
    @SerializedName( "DueCalculationBaseDate" )
    @JsonProperty( "DueCalculationBaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DueCalculationBaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime dueCalculationBaseDate;
    /**
     * Use with available fluent helpers to apply the <b>DueCalculationBaseDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> DUE_CALCULATION_BASE_DATE =
        new SupplierInvoiceField<LocalDateTime>("DueCalculationBaseDate");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new SupplierInvoiceField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new SupplierInvoiceField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new SupplierInvoiceField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new SupplierInvoiceField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> NET_PAYMENT_DAYS =
        new SupplierInvoiceField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     *
     * @return Payment Block Key
     */
    @SerializedName( "PaymentBlockingReason" )
    @JsonProperty( "PaymentBlockingReason" )
    @Nullable
    @ODataField( odataName = "PaymentBlockingReason" )
    private String paymentBlockingReason;
    /**
     * Use with available fluent helpers to apply the <b>PaymentBlockingReason</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYMENT_BLOCKING_REASON =
        new SupplierInvoiceField<String>("PaymentBlockingReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "AccountingDocumentType" )
    @JsonProperty( "AccountingDocumentType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType" )
    private String accountingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> ACCOUNTING_DOCUMENT_TYPE =
        new SupplierInvoiceField<String>("AccountingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPBankAccountInternalID</b>
     * </p>
     *
     * @return Partner bank type
     */
    @SerializedName( "BPBankAccountInternalID" )
    @JsonProperty( "BPBankAccountInternalID" )
    @Nullable
    @ODataField( odataName = "BPBankAccountInternalID" )
    private String bPBankAccountInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BPBankAccountInternalID</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> BP_BANK_ACCOUNT_INTERNAL_ID =
        new SupplierInvoiceField<String>("BPBankAccountInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceStatus</b>
     * </p>
     *
     * @return Invoice document status
     */
    @SerializedName( "SupplierInvoiceStatus" )
    @JsonProperty( "SupplierInvoiceStatus" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceStatus" )
    private String supplierInvoiceStatus;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceStatus</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_INVOICE_STATUS =
        new SupplierInvoiceField<String>("SupplierInvoiceStatus");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>IndirectQuotedExchangeRate</b>
     * </p>
     *
     * @return Indirect Quoted Exchange Rate
     */
    @SerializedName( "IndirectQuotedExchangeRate" )
    @JsonProperty( "IndirectQuotedExchangeRate" )
    @Nullable
    @ODataField( odataName = "IndirectQuotedExchangeRate" )
    private BigDecimal indirectQuotedExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>IndirectQuotedExchangeRate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> INDIRECT_QUOTED_EXCHANGE_RATE =
        new SupplierInvoiceField<BigDecimal>("IndirectQuotedExchangeRate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>DirectQuotedExchangeRate</b>
     * </p>
     *
     * @return Direct Quoted Exchange Rate
     */
    @SerializedName( "DirectQuotedExchangeRate" )
    @JsonProperty( "DirectQuotedExchangeRate" )
    @Nullable
    @ODataField( odataName = "DirectQuotedExchangeRate" )
    private BigDecimal directQuotedExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>DirectQuotedExchangeRate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<BigDecimal> DIRECT_QUOTED_EXCHANGE_RATE =
        new SupplierInvoiceField<BigDecimal>("DirectQuotedExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StateCentralBankPaymentReason</b>
     * </p>
     *
     * @return State Central Bank Indicator
     */
    @SerializedName( "StateCentralBankPaymentReason" )
    @JsonProperty( "StateCentralBankPaymentReason" )
    @Nullable
    @ODataField( odataName = "StateCentralBankPaymentReason" )
    private String stateCentralBankPaymentReason;
    /**
     * Use with available fluent helpers to apply the <b>StateCentralBankPaymentReason</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> STATE_CENTRAL_BANK_PAYMENT_REASON =
        new SupplierInvoiceField<String>("StateCentralBankPaymentReason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingCountry</b>
     * </p>
     *
     * @return Supplying Country/Region
     */
    @SerializedName( "SupplyingCountry" )
    @JsonProperty( "SupplyingCountry" )
    @Nullable
    @ODataField( odataName = "SupplyingCountry" )
    private String supplyingCountry;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingCountry</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLYING_COUNTRY =
        new SupplierInvoiceField<String>("SupplyingCountry");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYMENT_METHOD = new SupplierInvoiceField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplement</b>
     * </p>
     *
     * @return Payment method supplement
     */
    @SerializedName( "PaymentMethodSupplement" )
    @JsonProperty( "PaymentMethodSupplement" )
    @Nullable
    @ODataField( odataName = "PaymentMethodSupplement" )
    private String paymentMethodSupplement;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethodSupplement</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYMENT_METHOD_SUPPLEMENT =
        new SupplierInvoiceField<String>("PaymentMethodSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @return Payment Reference
     */
    @SerializedName( "PaymentReference" )
    @JsonProperty( "PaymentReference" )
    @Nullable
    @ODataField( odataName = "PaymentReference" )
    private String paymentReference;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReference</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYMENT_REFERENCE =
        new SupplierInvoiceField<String>("PaymentReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReference</b>
     * </p>
     *
     * @return Invoice reference: Document number for invoice reference
     */
    @SerializedName( "InvoiceReference" )
    @JsonProperty( "InvoiceReference" )
    @Nullable
    @ODataField( odataName = "InvoiceReference" )
    private String invoiceReference;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReference</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> INVOICE_REFERENCE =
        new SupplierInvoiceField<String>("InvoiceReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReferenceFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of the Relevant Invoice (for Credit Memo)
     */
    @SerializedName( "InvoiceReferenceFiscalYear" )
    @JsonProperty( "InvoiceReferenceFiscalYear" )
    @Nullable
    @ODataField( odataName = "InvoiceReferenceFiscalYear" )
    private String invoiceReferenceFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReferenceFiscalYear</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> INVOICE_REFERENCE_FISCAL_YEAR =
        new SupplierInvoiceField<String>("InvoiceReferenceFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedCashDiscount</b>
     * </p>
     *
     * @return Fixed Payment Terms
     */
    @SerializedName( "FixedCashDiscount" )
    @JsonProperty( "FixedCashDiscount" )
    @Nullable
    @ODataField( odataName = "FixedCashDiscount" )
    private String fixedCashDiscount;
    /**
     * Use with available fluent helpers to apply the <b>FixedCashDiscount</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> FIXED_CASH_DISCOUNT =
        new SupplierInvoiceField<String>("FixedCashDiscount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>UnplannedDeliveryCostTaxCode</b>
     * </p>
     *
     * @return Tax Code
     */
    @SerializedName( "UnplannedDeliveryCostTaxCode" )
    @JsonProperty( "UnplannedDeliveryCostTaxCode" )
    @Nullable
    @ODataField( odataName = "UnplannedDeliveryCostTaxCode" )
    private String unplannedDeliveryCostTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>UnplannedDeliveryCostTaxCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> UNPLANNED_DELIVERY_COST_TAX_CODE =
        new SupplierInvoiceField<String>("UnplannedDeliveryCostTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>UnplndDelivCostTaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "UnplndDelivCostTaxJurisdiction" )
    @JsonProperty( "UnplndDelivCostTaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "UnplndDelivCostTaxJurisdiction" )
    private String unplndDelivCostTaxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>UnplndDelivCostTaxJurisdiction</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> UNPLND_DELIV_COST_TAX_JURISDICTION =
        new SupplierInvoiceField<String>("UnplndDelivCostTaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnplndDeliveryCostTaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "UnplndDeliveryCostTaxCountry" )
    @JsonProperty( "UnplndDeliveryCostTaxCountry" )
    @Nullable
    @ODataField( odataName = "UnplndDeliveryCostTaxCountry" )
    private String unplndDeliveryCostTaxCountry;
    /**
     * Use with available fluent helpers to apply the <b>UnplndDeliveryCostTaxCountry</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> UNPLND_DELIVERY_COST_TAX_COUNTRY =
        new SupplierInvoiceField<String>("UnplndDeliveryCostTaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> ASSIGNMENT_REFERENCE =
        new SupplierInvoiceField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPostingLineItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "SupplierPostingLineItemText" )
    @JsonProperty( "SupplierPostingLineItemText" )
    @Nullable
    @ODataField( odataName = "SupplierPostingLineItemText" )
    private String supplierPostingLineItemText;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPostingLineItemText</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_POSTING_LINE_ITEM_TEXT =
        new SupplierInvoiceField<String>("SupplierPostingLineItemText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxIsCalculatedAutomatically</b>
     * </p>
     *
     * @return Calculate Tax Automatically
     */
    @SerializedName( "TaxIsCalculatedAutomatically" )
    @JsonProperty( "TaxIsCalculatedAutomatically" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TaxIsCalculatedAutomatically" )
    private Boolean taxIsCalculatedAutomatically;
    /**
     * Use with available fluent helpers to apply the <b>TaxIsCalculatedAutomatically</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<Boolean> TAX_IS_CALCULATED_AUTOMATICALLY =
        new SupplierInvoiceField<Boolean>("TaxIsCalculatedAutomatically");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @return Business Place
     */
    @SerializedName( "BusinessPlace" )
    @JsonProperty( "BusinessPlace" )
    @Nullable
    @ODataField( odataName = "BusinessPlace" )
    private String businessPlace;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlace</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> BUSINESS_PLACE = new SupplierInvoiceField<String>("BusinessPlace");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSectionCode</b>
     * </p>
     *
     * @return Section Code
     */
    @SerializedName( "BusinessSectionCode" )
    @JsonProperty( "BusinessSectionCode" )
    @Nullable
    @ODataField( odataName = "BusinessSectionCode" )
    private String businessSectionCode;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSectionCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> BUSINESS_SECTION_CODE =
        new SupplierInvoiceField<String>("BusinessSectionCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> BUSINESS_AREA = new SupplierInvoiceField<String>("BusinessArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcIsCapitalGoodsRelated</b>
     * </p>
     *
     * @return Indicator: Capital Goods Affected?
     */
    @SerializedName( "SuplrInvcIsCapitalGoodsRelated" )
    @JsonProperty( "SuplrInvcIsCapitalGoodsRelated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SuplrInvcIsCapitalGoodsRelated" )
    private Boolean suplrInvcIsCapitalGoodsRelated;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcIsCapitalGoodsRelated</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<Boolean> SUPLR_INVC_IS_CAPITAL_GOODS_RELATED =
        new SupplierInvoiceField<Boolean>("SuplrInvcIsCapitalGoodsRelated");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceIsCreditMemo</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "SupplierInvoiceIsCreditMemo" )
    @JsonProperty( "SupplierInvoiceIsCreditMemo" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceIsCreditMemo" )
    private String supplierInvoiceIsCreditMemo;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceIsCreditMemo</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_INVOICE_IS_CREDIT_MEMO =
        new SupplierInvoiceField<String>("SupplierInvoiceIsCreditMemo");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>PaytSlipWthRefSubscriber</b>
     * </p>
     *
     * @return ISR Subscriber Number
     */
    @SerializedName( "PaytSlipWthRefSubscriber" )
    @JsonProperty( "PaytSlipWthRefSubscriber" )
    @Nullable
    @ODataField( odataName = "PaytSlipWthRefSubscriber" )
    private String paytSlipWthRefSubscriber;
    /**
     * Use with available fluent helpers to apply the <b>PaytSlipWthRefSubscriber</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYT_SLIP_WTH_REF_SUBSCRIBER =
        new SupplierInvoiceField<String>("PaytSlipWthRefSubscriber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaytSlipWthRefCheckDigit</b>
     * </p>
     *
     * @return POR check digit
     */
    @SerializedName( "PaytSlipWthRefCheckDigit" )
    @JsonProperty( "PaytSlipWthRefCheckDigit" )
    @Nullable
    @ODataField( odataName = "PaytSlipWthRefCheckDigit" )
    private String paytSlipWthRefCheckDigit;
    /**
     * Use with available fluent helpers to apply the <b>PaytSlipWthRefCheckDigit</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYT_SLIP_WTH_REF_CHECK_DIGIT =
        new SupplierInvoiceField<String>("PaytSlipWthRefCheckDigit");
    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>PaytSlipWthRefReference</b>
     * </p>
     *
     * @return ISR/QR Reference Number
     */
    @SerializedName( "PaytSlipWthRefReference" )
    @JsonProperty( "PaytSlipWthRefReference" )
    @Nullable
    @ODataField( odataName = "PaytSlipWthRefReference" )
    private String paytSlipWthRefReference;
    /**
     * Use with available fluent helpers to apply the <b>PaytSlipWthRefReference</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> PAYT_SLIP_WTH_REF_REFERENCE =
        new SupplierInvoiceField<String>("PaytSlipWthRefReference");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determining Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> TAX_DETERMINATION_DATE =
        new SupplierInvoiceField<LocalDateTime>("TaxDeterminationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxReportingDate</b>
     * </p>
     *
     * @return Tax Reporting Date
     */
    @SerializedName( "TaxReportingDate" )
    @JsonProperty( "TaxReportingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxReportingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxReportingDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxReportingDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> TAX_REPORTING_DATE =
        new SupplierInvoiceField<LocalDateTime>("TaxReportingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxFulfillmentDate</b>
     * </p>
     *
     * @return Tax Fulfillment Date
     */
    @SerializedName( "TaxFulfillmentDate" )
    @JsonProperty( "TaxFulfillmentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxFulfillmentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxFulfillmentDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxFulfillmentDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> TAX_FULFILLMENT_DATE =
        new SupplierInvoiceField<LocalDateTime>("TaxFulfillmentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReceiptDate</b>
     * </p>
     *
     * @return Invoice Receipt Date
     */
    @SerializedName( "InvoiceReceiptDate" )
    @JsonProperty( "InvoiceReceiptDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InvoiceReceiptDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime invoiceReceiptDate;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReceiptDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> INVOICE_RECEIPT_DATE =
        new SupplierInvoiceField<LocalDateTime>("InvoiceReceiptDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryOfGoodsReportingCntry</b>
     * </p>
     *
     * @return Reporting Country/Region for Delivery of Goods Within the EU
     */
    @SerializedName( "DeliveryOfGoodsReportingCntry" )
    @JsonProperty( "DeliveryOfGoodsReportingCntry" )
    @Nullable
    @ODataField( odataName = "DeliveryOfGoodsReportingCntry" )
    private String deliveryOfGoodsReportingCntry;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryOfGoodsReportingCntry</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> DELIVERY_OF_GOODS_REPORTING_CNTRY =
        new SupplierInvoiceField<String>("DeliveryOfGoodsReportingCntry");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierVATRegistration</b>
     * </p>
     *
     * @return VAT Registration Number
     */
    @SerializedName( "SupplierVATRegistration" )
    @JsonProperty( "SupplierVATRegistration" )
    @Nullable
    @ODataField( odataName = "SupplierVATRegistration" )
    private String supplierVATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>SupplierVATRegistration</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_VAT_REGISTRATION =
        new SupplierInvoiceField<String>("SupplierVATRegistration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     *
     * @return Indicator: Triangular Deal Within the EU
     */
    @SerializedName( "IsEUTriangularDeal" )
    @JsonProperty( "IsEUTriangularDeal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEUTriangularDeal" )
    private Boolean isEUTriangularDeal;
    /**
     * Use with available fluent helpers to apply the <b>IsEUTriangularDeal</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<Boolean> IS_EU_TRIANGULAR_DEAL =
        new SupplierInvoiceField<Boolean>("IsEUTriangularDeal");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDebitCrdtCodeDelivery</b>
     * </p>
     *
     * @return Posting logic for delivery items (invoice/credit memo)
     */
    @SerializedName( "SuplrInvcDebitCrdtCodeDelivery" )
    @JsonProperty( "SuplrInvcDebitCrdtCodeDelivery" )
    @Nullable
    @ODataField( odataName = "SuplrInvcDebitCrdtCodeDelivery" )
    private String suplrInvcDebitCrdtCodeDelivery;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcDebitCrdtCodeDelivery</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPLR_INVC_DEBIT_CRDT_CODE_DELIVERY =
        new SupplierInvoiceField<String>("SuplrInvcDebitCrdtCodeDelivery");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDebitCrdtCodeReturns</b>
     * </p>
     *
     * @return Posting logic for returns items (invoice/credit memo)
     */
    @SerializedName( "SuplrInvcDebitCrdtCodeReturns" )
    @JsonProperty( "SuplrInvcDebitCrdtCodeReturns" )
    @Nullable
    @ODataField( odataName = "SuplrInvcDebitCrdtCodeReturns" )
    private String suplrInvcDebitCrdtCodeReturns;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcDebitCrdtCodeReturns</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPLR_INVC_DEBIT_CRDT_CODE_RETURNS =
        new SupplierInvoiceField<String>("SuplrInvcDebitCrdtCodeReturns");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RetentionDueDate</b>
     * </p>
     *
     * @return Due Date for Retention (Default)
     */
    @SerializedName( "RetentionDueDate" )
    @JsonProperty( "RetentionDueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RetentionDueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime retentionDueDate;
    /**
     * Use with available fluent helpers to apply the <b>RetentionDueDate</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> RETENTION_DUE_DATE =
        new SupplierInvoiceField<LocalDateTime>("RetentionDueDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceOrigin</b>
     * </p>
     *
     * @return Origin of a Logistics Invoice Verification Document
     */
    @SerializedName( "SupplierInvoiceOrigin" )
    @JsonProperty( "SupplierInvoiceOrigin" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceOrigin" )
    private String supplierInvoiceOrigin;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceOrigin</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> SUPPLIER_INVOICE_ORIGIN =
        new SupplierInvoiceField<String>("SupplierInvoiceOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @return Reversal document number
     */
    @SerializedName( "ReverseDocument" )
    @JsonProperty( "ReverseDocument" )
    @Nullable
    @ODataField( odataName = "ReverseDocument" )
    private String reverseDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocument</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> REVERSE_DOCUMENT =
        new SupplierInvoiceField<String>("ReverseDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @return Fiscal year of reversal document
     */
    @SerializedName( "ReverseDocumentFiscalYear" )
    @JsonProperty( "ReverseDocumentFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReverseDocumentFiscalYear" )
    private String reverseDocumentFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentFiscalYear</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> REVERSE_DOCUMENT_FISCAL_YEAR =
        new SupplierInvoiceField<String>("ReverseDocumentFiscalYear");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @return Is Reversal
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversal" )
    private Boolean isReversal;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<Boolean> IS_REVERSAL = new SupplierInvoiceField<Boolean>("IsReversal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @return Is Reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversed" )
    private Boolean isReversed;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<Boolean> IS_REVERSED = new SupplierInvoiceField<Boolean>("IsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IN_GSTPartner</b>
     * </p>
     *
     * @return GST Partner
     */
    @SerializedName( "IN_GSTPartner" )
    @JsonProperty( "IN_GSTPartner" )
    @Nullable
    @ODataField( odataName = "IN_GSTPartner" )
    private String iN_GSTPartner;
    /**
     * Use with available fluent helpers to apply the <b>IN_GSTPartner</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> INGST_PARTNER = new SupplierInvoiceField<String>("IN_GSTPartner");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IN_GSTPlaceOfSupply</b>
     * </p>
     *
     * @return Place of Supply
     */
    @SerializedName( "IN_GSTPlaceOfSupply" )
    @JsonProperty( "IN_GSTPlaceOfSupply" )
    @Nullable
    @ODataField( odataName = "IN_GSTPlaceOfSupply" )
    private String iN_GSTPlaceOfSupply;
    /**
     * Use with available fluent helpers to apply the <b>IN_GSTPlaceOfSupply</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> INGST_PLACE_OF_SUPPLY =
        new SupplierInvoiceField<String>("IN_GSTPlaceOfSupply");
    /**
     * Constraints: Not nullable, Maximum length: 64
     * <p>
     * Original property name from the Odata EDM: <b>IN_InvoiceReferenceNumber</b>
     * </p>
     *
     * @return Invoice Reference Number
     */
    @SerializedName( "IN_InvoiceReferenceNumber" )
    @JsonProperty( "IN_InvoiceReferenceNumber" )
    @Nullable
    @ODataField( odataName = "IN_InvoiceReferenceNumber" )
    private String iN_InvoiceReferenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>IN_InvoiceReferenceNumber</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> IN_INVOICE_REFERENCE_NUMBER =
        new SupplierInvoiceField<String>("IN_InvoiceReferenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef1</b>
     * </p>
     *
     * @return Country/Region Specific Reference 1 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificRef1" )
    @JsonProperty( "JrnlEntryCntrySpecificRef1" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificRef1" )
    private String jrnlEntryCntrySpecificRef1;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificRef1</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_REF1 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificRef1");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate1</b>
     * </p>
     *
     * @return Country/Region Specific Date 1 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificDate1" )
    @JsonProperty( "JrnlEntryCntrySpecificDate1" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JrnlEntryCntrySpecificDate1",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime jrnlEntryCntrySpecificDate1;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificDate1</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> JRNL_ENTRY_CNTRY_SPECIFIC_DATE1 =
        new SupplierInvoiceField<LocalDateTime>("JrnlEntryCntrySpecificDate1");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef2</b>
     * </p>
     *
     * @return Country/Region Specific Reference 2 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificRef2" )
    @JsonProperty( "JrnlEntryCntrySpecificRef2" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificRef2" )
    private String jrnlEntryCntrySpecificRef2;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificRef2</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_REF2 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificRef2");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate2</b>
     * </p>
     *
     * @return Country/Region Specific Date 2 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificDate2" )
    @JsonProperty( "JrnlEntryCntrySpecificDate2" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JrnlEntryCntrySpecificDate2",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime jrnlEntryCntrySpecificDate2;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificDate2</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> JRNL_ENTRY_CNTRY_SPECIFIC_DATE2 =
        new SupplierInvoiceField<LocalDateTime>("JrnlEntryCntrySpecificDate2");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef3</b>
     * </p>
     *
     * @return Country/Region Specific Reference 3 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificRef3" )
    @JsonProperty( "JrnlEntryCntrySpecificRef3" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificRef3" )
    private String jrnlEntryCntrySpecificRef3;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificRef3</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_REF3 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificRef3");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate3</b>
     * </p>
     *
     * @return Country/Region Specific Date 3 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificDate3" )
    @JsonProperty( "JrnlEntryCntrySpecificDate3" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JrnlEntryCntrySpecificDate3",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime jrnlEntryCntrySpecificDate3;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificDate3</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> JRNL_ENTRY_CNTRY_SPECIFIC_DATE3 =
        new SupplierInvoiceField<LocalDateTime>("JrnlEntryCntrySpecificDate3");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef4</b>
     * </p>
     *
     * @return Country/Region Specific Reference 4 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificRef4" )
    @JsonProperty( "JrnlEntryCntrySpecificRef4" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificRef4" )
    private String jrnlEntryCntrySpecificRef4;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificRef4</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_REF4 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificRef4");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate4</b>
     * </p>
     *
     * @return Country/Region Specific Date 4 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificDate4" )
    @JsonProperty( "JrnlEntryCntrySpecificDate4" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JrnlEntryCntrySpecificDate4",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime jrnlEntryCntrySpecificDate4;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificDate4</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> JRNL_ENTRY_CNTRY_SPECIFIC_DATE4 =
        new SupplierInvoiceField<LocalDateTime>("JrnlEntryCntrySpecificDate4");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef5</b>
     * </p>
     *
     * @return Country/Region Specific Reference 5 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificRef5" )
    @JsonProperty( "JrnlEntryCntrySpecificRef5" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificRef5" )
    private String jrnlEntryCntrySpecificRef5;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificRef5</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_REF5 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificRef5");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate5</b>
     * </p>
     *
     * @return Country/Region Specific Date 5 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificDate5" )
    @JsonProperty( "JrnlEntryCntrySpecificDate5" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JrnlEntryCntrySpecificDate5",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime jrnlEntryCntrySpecificDate5;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificDate5</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<LocalDateTime> JRNL_ENTRY_CNTRY_SPECIFIC_DATE5 =
        new SupplierInvoiceField<LocalDateTime>("JrnlEntryCntrySpecificDate5");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificBP1</b>
     * </p>
     *
     * @return Country/Region specific Business Partner 1 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificBP1" )
    @JsonProperty( "JrnlEntryCntrySpecificBP1" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificBP1" )
    private String jrnlEntryCntrySpecificBP1;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificBP1</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_B_P1 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificBP1");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificBP2</b>
     * </p>
     *
     * @return Country/Region Specific Business Partner 2 in the Document
     */
    @SerializedName( "JrnlEntryCntrySpecificBP2" )
    @JsonProperty( "JrnlEntryCntrySpecificBP2" )
    @Nullable
    @ODataField( odataName = "JrnlEntryCntrySpecificBP2" )
    private String jrnlEntryCntrySpecificBP2;
    /**
     * Use with available fluent helpers to apply the <b>JrnlEntryCntrySpecificBP2</b> field to query operations.
     *
     */
    public final static SupplierInvoiceField<String> JRNL_ENTRY_CNTRY_SPECIFIC_B_P2 =
        new SupplierInvoiceField<String>("JrnlEntryCntrySpecificBP2");
    /**
     * Navigation property <b>to_SelectedDeliveryNotes</b> for <b>SupplierInvoice</b> to multiple
     * <b>SuplrInvcSeldInbDeliveryNote</b>.
     *
     */
    @SerializedName( "to_SelectedDeliveryNotes" )
    @JsonProperty( "to_SelectedDeliveryNotes" )
    @ODataField( odataName = "to_SelectedDeliveryNotes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrInvcSeldInbDeliveryNote> toSelectedDeliveryNotes;
    /**
     * Navigation property <b>to_SelectedPurchaseOrders</b> for <b>SupplierInvoice</b> to multiple
     * <b>SuplrInvcSeldPurgDocument</b>.
     *
     */
    @SerializedName( "to_SelectedPurchaseOrders" )
    @JsonProperty( "to_SelectedPurchaseOrders" )
    @ODataField( odataName = "to_SelectedPurchaseOrders" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrInvcSeldPurgDocument> toSelectedPurchaseOrders;
    /**
     * Navigation property <b>to_SelectedServiceEntrySheets</b> for <b>SupplierInvoice</b> to multiple
     * <b>SuplrInvcSeldSrvcEntrShtLean</b>.
     *
     */
    @SerializedName( "to_SelectedServiceEntrySheets" )
    @JsonProperty( "to_SelectedServiceEntrySheets" )
    @ODataField( odataName = "to_SelectedServiceEntrySheets" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrInvcSeldSrvcEntrShtLean> toSelectedServiceEntrySheets;
    /**
     * Navigation property <b>to_SuplrInvcItemPurOrdRef</b> for <b>SupplierInvoice</b> to multiple
     * <b>SuplrInvcItemPurOrdRef</b>.
     *
     */
    @SerializedName( "to_SuplrInvcItemPurOrdRef" )
    @JsonProperty( "to_SuplrInvcItemPurOrdRef" )
    @ODataField( odataName = "to_SuplrInvcItemPurOrdRef" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrInvcItemPurOrdRef> toSuplrInvcItemPurOrdRef;
    /**
     * Navigation property <b>to_SuplrInvoiceAdditionalData</b> for <b>SupplierInvoice</b> to single
     * <b>SuplrInvoiceAdditionalData</b>.
     *
     */
    @SerializedName( "to_SuplrInvoiceAdditionalData" )
    @JsonProperty( "to_SuplrInvoiceAdditionalData" )
    @ODataField( odataName = "to_SuplrInvoiceAdditionalData" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrInvoiceAdditionalData toSuplrInvoiceAdditionalData;
    /**
     * Navigation property <b>to_SupplierInvoiceItemGLAcct</b> for <b>SupplierInvoice</b> to multiple
     * <b>SupplierInvoiceItemGLAcct</b>.
     *
     */
    @SerializedName( "to_SupplierInvoiceItemGLAcct" )
    @JsonProperty( "to_SupplierInvoiceItemGLAcct" )
    @ODataField( odataName = "to_SupplierInvoiceItemGLAcct" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplierInvoiceItemGLAcct> toSupplierInvoiceItemGLAcct;
    /**
     * Navigation property <b>to_SupplierInvoiceTax</b> for <b>SupplierInvoice</b> to multiple
     * <b>SupplierInvoiceTax</b>.
     *
     */
    @SerializedName( "to_SupplierInvoiceTax" )
    @JsonProperty( "to_SupplierInvoiceTax" )
    @ODataField( odataName = "to_SupplierInvoiceTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplierInvoiceTax> toSupplierInvoiceTax;
    /**
     * Navigation property <b>to_SupplierInvoiceWhldgTax</b> for <b>SupplierInvoice</b> to multiple
     * <b>SuplrInvcHeaderWhldgTax</b>.
     *
     */
    @SerializedName( "to_SupplierInvoiceWhldgTax" )
    @JsonProperty( "to_SupplierInvoiceWhldgTax" )
    @ODataField( odataName = "to_SupplierInvoiceWhldgTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrInvcHeaderWhldgTax> toSupplierInvoiceWhldgTax;
    /**
     * Use with available fluent helpers to apply the <b>to_SelectedDeliveryNotes</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SuplrInvcSeldInbDeliveryNote> TO_SELECTED_DELIVERY_NOTES =
        new SupplierInvoiceLink<SuplrInvcSeldInbDeliveryNote>("to_SelectedDeliveryNotes");
    /**
     * Use with available fluent helpers to apply the <b>to_SelectedPurchaseOrders</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SuplrInvcSeldPurgDocument> TO_SELECTED_PURCHASE_ORDERS =
        new SupplierInvoiceLink<SuplrInvcSeldPurgDocument>("to_SelectedPurchaseOrders");
    /**
     * Use with available fluent helpers to apply the <b>to_SelectedServiceEntrySheets</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SuplrInvcSeldSrvcEntrShtLean> TO_SELECTED_SERVICE_ENTRY_SHEETS =
        new SupplierInvoiceLink<SuplrInvcSeldSrvcEntrShtLean>("to_SelectedServiceEntrySheets");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrInvcItemPurOrdRef</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SuplrInvcItemPurOrdRef> TO_SUPLR_INVC_ITEM_PUR_ORD_REF =
        new SupplierInvoiceLink<SuplrInvcItemPurOrdRef>("to_SuplrInvcItemPurOrdRef");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrInvoiceAdditionalData</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceOneToOneLink<SuplrInvoiceAdditionalData> TO_SUPLR_INVOICE_ADDITIONAL_DATA =
        new SupplierInvoiceOneToOneLink<SuplrInvoiceAdditionalData>("to_SuplrInvoiceAdditionalData");
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierInvoiceItemGLAcct</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SupplierInvoiceItemGLAcct> TO_SUPPLIER_INVOICE_ITEM_GL_ACCT =
        new SupplierInvoiceLink<SupplierInvoiceItemGLAcct>("to_SupplierInvoiceItemGLAcct");
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierInvoiceTax</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SupplierInvoiceTax> TO_SUPPLIER_INVOICE_TAX =
        new SupplierInvoiceLink<SupplierInvoiceTax>("to_SupplierInvoiceTax");
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierInvoiceWhldgTax</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierInvoiceLink<SuplrInvcHeaderWhldgTax> TO_SUPPLIER_INVOICE_WHLDG_TAX =
        new SupplierInvoiceLink<SuplrInvcHeaderWhldgTax>("to_SupplierInvoiceWhldgTax");

    @Nonnull
    @Override
    public Class<SupplierInvoice> getType()
    {
        return SupplierInvoice.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Invoice Date in Document
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceIDByInvcgParty</b>
     * </p>
     *
     * @param supplierInvoiceIDByInvcgParty
     *            Reference Document Number
     */
    public void setSupplierInvoiceIDByInvcgParty( @Nullable final String supplierInvoiceIDByInvcgParty )
    {
        rememberChangedField("SupplierInvoiceIDByInvcgParty", this.supplierInvoiceIDByInvcgParty);
        this.supplierInvoiceIDByInvcgParty = supplierInvoiceIDByInvcgParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @param invoicingParty
     *            Different Invoicing Party
     */
    public void setInvoicingParty( @Nullable final String invoicingParty )
    {
        rememberChangedField("InvoicingParty", this.invoicingParty);
        this.invoicingParty = invoicingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceGrossAmount</b>
     * </p>
     *
     * @param invoiceGrossAmount
     *            Gross Invoice Amount in Document Currency
     */
    public void setInvoiceGrossAmount( @Nullable final BigDecimal invoiceGrossAmount )
    {
        rememberChangedField("InvoiceGrossAmount", this.invoiceGrossAmount);
        this.invoiceGrossAmount = invoiceGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnplannedDeliveryCost</b>
     * </p>
     *
     * @param unplannedDeliveryCost
     *            Unplanned Delivery Costs
     */
    public void setUnplannedDeliveryCost( @Nullable final BigDecimal unplannedDeliveryCost )
    {
        rememberChangedField("UnplannedDeliveryCost", this.unplannedDeliveryCost);
        this.unplannedDeliveryCost = unplannedDeliveryCost;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentHeaderText</b>
     * </p>
     *
     * @param documentHeaderText
     *            Document Header Text
     */
    public void setDocumentHeaderText( @Nullable final String documentHeaderText )
    {
        rememberChangedField("DocumentHeaderText", this.documentHeaderText);
        this.documentHeaderText = documentHeaderText;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ManualCashDiscount</b>
     * </p>
     *
     * @param manualCashDiscount
     *            Cash Discount Amount in Document Currency
     */
    public void setManualCashDiscount( @Nullable final BigDecimal manualCashDiscount )
    {
        rememberChangedField("ManualCashDiscount", this.manualCashDiscount);
        this.manualCashDiscount = manualCashDiscount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueCalculationBaseDate</b>
     * </p>
     *
     * @param dueCalculationBaseDate
     *            Baseline Date for Due Date Calculation
     */
    public void setDueCalculationBaseDate( @Nullable final LocalDateTime dueCalculationBaseDate )
    {
        rememberChangedField("DueCalculationBaseDate", this.dueCalculationBaseDate);
        this.dueCalculationBaseDate = dueCalculationBaseDate;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     *
     * @param paymentBlockingReason
     *            Payment Block Key
     */
    public void setPaymentBlockingReason( @Nullable final String paymentBlockingReason )
    {
        rememberChangedField("PaymentBlockingReason", this.paymentBlockingReason);
        this.paymentBlockingReason = paymentBlockingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @param accountingDocumentType
     *            Document Type
     */
    public void setAccountingDocumentType( @Nullable final String accountingDocumentType )
    {
        rememberChangedField("AccountingDocumentType", this.accountingDocumentType);
        this.accountingDocumentType = accountingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPBankAccountInternalID</b>
     * </p>
     *
     * @param bPBankAccountInternalID
     *            Partner bank type
     */
    public void setBPBankAccountInternalID( @Nullable final String bPBankAccountInternalID )
    {
        rememberChangedField("BPBankAccountInternalID", this.bPBankAccountInternalID);
        this.bPBankAccountInternalID = bPBankAccountInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceStatus</b>
     * </p>
     *
     * @param supplierInvoiceStatus
     *            Invoice document status
     */
    public void setSupplierInvoiceStatus( @Nullable final String supplierInvoiceStatus )
    {
        rememberChangedField("SupplierInvoiceStatus", this.supplierInvoiceStatus);
        this.supplierInvoiceStatus = supplierInvoiceStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>IndirectQuotedExchangeRate</b>
     * </p>
     *
     * @param indirectQuotedExchangeRate
     *            Indirect Quoted Exchange Rate
     */
    public void setIndirectQuotedExchangeRate( @Nullable final BigDecimal indirectQuotedExchangeRate )
    {
        rememberChangedField("IndirectQuotedExchangeRate", this.indirectQuotedExchangeRate);
        this.indirectQuotedExchangeRate = indirectQuotedExchangeRate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>DirectQuotedExchangeRate</b>
     * </p>
     *
     * @param directQuotedExchangeRate
     *            Direct Quoted Exchange Rate
     */
    public void setDirectQuotedExchangeRate( @Nullable final BigDecimal directQuotedExchangeRate )
    {
        rememberChangedField("DirectQuotedExchangeRate", this.directQuotedExchangeRate);
        this.directQuotedExchangeRate = directQuotedExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StateCentralBankPaymentReason</b>
     * </p>
     *
     * @param stateCentralBankPaymentReason
     *            State Central Bank Indicator
     */
    public void setStateCentralBankPaymentReason( @Nullable final String stateCentralBankPaymentReason )
    {
        rememberChangedField("StateCentralBankPaymentReason", this.stateCentralBankPaymentReason);
        this.stateCentralBankPaymentReason = stateCentralBankPaymentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingCountry</b>
     * </p>
     *
     * @param supplyingCountry
     *            Supplying Country/Region
     */
    public void setSupplyingCountry( @Nullable final String supplyingCountry )
    {
        rememberChangedField("SupplyingCountry", this.supplyingCountry);
        this.supplyingCountry = supplyingCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplement</b>
     * </p>
     *
     * @param paymentMethodSupplement
     *            Payment method supplement
     */
    public void setPaymentMethodSupplement( @Nullable final String paymentMethodSupplement )
    {
        rememberChangedField("PaymentMethodSupplement", this.paymentMethodSupplement);
        this.paymentMethodSupplement = paymentMethodSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReference</b>
     * </p>
     *
     * @param invoiceReference
     *            Invoice reference: Document number for invoice reference
     */
    public void setInvoiceReference( @Nullable final String invoiceReference )
    {
        rememberChangedField("InvoiceReference", this.invoiceReference);
        this.invoiceReference = invoiceReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReferenceFiscalYear</b>
     * </p>
     *
     * @param invoiceReferenceFiscalYear
     *            Fiscal Year of the Relevant Invoice (for Credit Memo)
     */
    public void setInvoiceReferenceFiscalYear( @Nullable final String invoiceReferenceFiscalYear )
    {
        rememberChangedField("InvoiceReferenceFiscalYear", this.invoiceReferenceFiscalYear);
        this.invoiceReferenceFiscalYear = invoiceReferenceFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedCashDiscount</b>
     * </p>
     *
     * @param fixedCashDiscount
     *            Fixed Payment Terms
     */
    public void setFixedCashDiscount( @Nullable final String fixedCashDiscount )
    {
        rememberChangedField("FixedCashDiscount", this.fixedCashDiscount);
        this.fixedCashDiscount = fixedCashDiscount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>UnplannedDeliveryCostTaxCode</b>
     * </p>
     *
     * @param unplannedDeliveryCostTaxCode
     *            Tax Code
     */
    public void setUnplannedDeliveryCostTaxCode( @Nullable final String unplannedDeliveryCostTaxCode )
    {
        rememberChangedField("UnplannedDeliveryCostTaxCode", this.unplannedDeliveryCostTaxCode);
        this.unplannedDeliveryCostTaxCode = unplannedDeliveryCostTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>UnplndDelivCostTaxJurisdiction</b>
     * </p>
     *
     * @param unplndDelivCostTaxJurisdiction
     *            Tax Jurisdiction
     */
    public void setUnplndDelivCostTaxJurisdiction( @Nullable final String unplndDelivCostTaxJurisdiction )
    {
        rememberChangedField("UnplndDelivCostTaxJurisdiction", this.unplndDelivCostTaxJurisdiction);
        this.unplndDelivCostTaxJurisdiction = unplndDelivCostTaxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnplndDeliveryCostTaxCountry</b>
     * </p>
     *
     * @param unplndDeliveryCostTaxCountry
     *            Tax Reporting Country/Region
     */
    public void setUnplndDeliveryCostTaxCountry( @Nullable final String unplndDeliveryCostTaxCountry )
    {
        rememberChangedField("UnplndDeliveryCostTaxCountry", this.unplndDeliveryCostTaxCountry);
        this.unplndDeliveryCostTaxCountry = unplndDeliveryCostTaxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPostingLineItemText</b>
     * </p>
     *
     * @param supplierPostingLineItemText
     *            Item Text
     */
    public void setSupplierPostingLineItemText( @Nullable final String supplierPostingLineItemText )
    {
        rememberChangedField("SupplierPostingLineItemText", this.supplierPostingLineItemText);
        this.supplierPostingLineItemText = supplierPostingLineItemText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxIsCalculatedAutomatically</b>
     * </p>
     *
     * @param taxIsCalculatedAutomatically
     *            Calculate Tax Automatically
     */
    public void setTaxIsCalculatedAutomatically( @Nullable final Boolean taxIsCalculatedAutomatically )
    {
        rememberChangedField("TaxIsCalculatedAutomatically", this.taxIsCalculatedAutomatically);
        this.taxIsCalculatedAutomatically = taxIsCalculatedAutomatically;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @param businessPlace
     *            Business Place
     */
    public void setBusinessPlace( @Nullable final String businessPlace )
    {
        rememberChangedField("BusinessPlace", this.businessPlace);
        this.businessPlace = businessPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSectionCode</b>
     * </p>
     *
     * @param businessSectionCode
     *            Section Code
     */
    public void setBusinessSectionCode( @Nullable final String businessSectionCode )
    {
        rememberChangedField("BusinessSectionCode", this.businessSectionCode);
        this.businessSectionCode = businessSectionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcIsCapitalGoodsRelated</b>
     * </p>
     *
     * @param suplrInvcIsCapitalGoodsRelated
     *            Indicator: Capital Goods Affected?
     */
    public void setSuplrInvcIsCapitalGoodsRelated( @Nullable final Boolean suplrInvcIsCapitalGoodsRelated )
    {
        rememberChangedField("SuplrInvcIsCapitalGoodsRelated", this.suplrInvcIsCapitalGoodsRelated);
        this.suplrInvcIsCapitalGoodsRelated = suplrInvcIsCapitalGoodsRelated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceIsCreditMemo</b>
     * </p>
     *
     * @param supplierInvoiceIsCreditMemo
     *            Single-Character Flag
     */
    public void setSupplierInvoiceIsCreditMemo( @Nullable final String supplierInvoiceIsCreditMemo )
    {
        rememberChangedField("SupplierInvoiceIsCreditMemo", this.supplierInvoiceIsCreditMemo);
        this.supplierInvoiceIsCreditMemo = supplierInvoiceIsCreditMemo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>PaytSlipWthRefSubscriber</b>
     * </p>
     *
     * @param paytSlipWthRefSubscriber
     *            ISR Subscriber Number
     */
    public void setPaytSlipWthRefSubscriber( @Nullable final String paytSlipWthRefSubscriber )
    {
        rememberChangedField("PaytSlipWthRefSubscriber", this.paytSlipWthRefSubscriber);
        this.paytSlipWthRefSubscriber = paytSlipWthRefSubscriber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaytSlipWthRefCheckDigit</b>
     * </p>
     *
     * @param paytSlipWthRefCheckDigit
     *            POR check digit
     */
    public void setPaytSlipWthRefCheckDigit( @Nullable final String paytSlipWthRefCheckDigit )
    {
        rememberChangedField("PaytSlipWthRefCheckDigit", this.paytSlipWthRefCheckDigit);
        this.paytSlipWthRefCheckDigit = paytSlipWthRefCheckDigit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>PaytSlipWthRefReference</b>
     * </p>
     *
     * @param paytSlipWthRefReference
     *            ISR/QR Reference Number
     */
    public void setPaytSlipWthRefReference( @Nullable final String paytSlipWthRefReference )
    {
        rememberChangedField("PaytSlipWthRefReference", this.paytSlipWthRefReference);
        this.paytSlipWthRefReference = paytSlipWthRefReference;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determining Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxReportingDate</b>
     * </p>
     *
     * @param taxReportingDate
     *            Tax Reporting Date
     */
    public void setTaxReportingDate( @Nullable final LocalDateTime taxReportingDate )
    {
        rememberChangedField("TaxReportingDate", this.taxReportingDate);
        this.taxReportingDate = taxReportingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxFulfillmentDate</b>
     * </p>
     *
     * @param taxFulfillmentDate
     *            Tax Fulfillment Date
     */
    public void setTaxFulfillmentDate( @Nullable final LocalDateTime taxFulfillmentDate )
    {
        rememberChangedField("TaxFulfillmentDate", this.taxFulfillmentDate);
        this.taxFulfillmentDate = taxFulfillmentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReceiptDate</b>
     * </p>
     *
     * @param invoiceReceiptDate
     *            Invoice Receipt Date
     */
    public void setInvoiceReceiptDate( @Nullable final LocalDateTime invoiceReceiptDate )
    {
        rememberChangedField("InvoiceReceiptDate", this.invoiceReceiptDate);
        this.invoiceReceiptDate = invoiceReceiptDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryOfGoodsReportingCntry</b>
     * </p>
     *
     * @param deliveryOfGoodsReportingCntry
     *            Reporting Country/Region for Delivery of Goods Within the EU
     */
    public void setDeliveryOfGoodsReportingCntry( @Nullable final String deliveryOfGoodsReportingCntry )
    {
        rememberChangedField("DeliveryOfGoodsReportingCntry", this.deliveryOfGoodsReportingCntry);
        this.deliveryOfGoodsReportingCntry = deliveryOfGoodsReportingCntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierVATRegistration</b>
     * </p>
     *
     * @param supplierVATRegistration
     *            VAT Registration Number
     */
    public void setSupplierVATRegistration( @Nullable final String supplierVATRegistration )
    {
        rememberChangedField("SupplierVATRegistration", this.supplierVATRegistration);
        this.supplierVATRegistration = supplierVATRegistration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     *
     * @param isEUTriangularDeal
     *            Indicator: Triangular Deal Within the EU
     */
    public void setIsEUTriangularDeal( @Nullable final Boolean isEUTriangularDeal )
    {
        rememberChangedField("IsEUTriangularDeal", this.isEUTriangularDeal);
        this.isEUTriangularDeal = isEUTriangularDeal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDebitCrdtCodeDelivery</b>
     * </p>
     *
     * @param suplrInvcDebitCrdtCodeDelivery
     *            Posting logic for delivery items (invoice/credit memo)
     */
    public void setSuplrInvcDebitCrdtCodeDelivery( @Nullable final String suplrInvcDebitCrdtCodeDelivery )
    {
        rememberChangedField("SuplrInvcDebitCrdtCodeDelivery", this.suplrInvcDebitCrdtCodeDelivery);
        this.suplrInvcDebitCrdtCodeDelivery = suplrInvcDebitCrdtCodeDelivery;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDebitCrdtCodeReturns</b>
     * </p>
     *
     * @param suplrInvcDebitCrdtCodeReturns
     *            Posting logic for returns items (invoice/credit memo)
     */
    public void setSuplrInvcDebitCrdtCodeReturns( @Nullable final String suplrInvcDebitCrdtCodeReturns )
    {
        rememberChangedField("SuplrInvcDebitCrdtCodeReturns", this.suplrInvcDebitCrdtCodeReturns);
        this.suplrInvcDebitCrdtCodeReturns = suplrInvcDebitCrdtCodeReturns;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RetentionDueDate</b>
     * </p>
     *
     * @param retentionDueDate
     *            Due Date for Retention (Default)
     */
    public void setRetentionDueDate( @Nullable final LocalDateTime retentionDueDate )
    {
        rememberChangedField("RetentionDueDate", this.retentionDueDate);
        this.retentionDueDate = retentionDueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceOrigin</b>
     * </p>
     *
     * @param supplierInvoiceOrigin
     *            Origin of a Logistics Invoice Verification Document
     */
    public void setSupplierInvoiceOrigin( @Nullable final String supplierInvoiceOrigin )
    {
        rememberChangedField("SupplierInvoiceOrigin", this.supplierInvoiceOrigin);
        this.supplierInvoiceOrigin = supplierInvoiceOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *            Reversal document number
     */
    public void setReverseDocument( @Nullable final String reverseDocument )
    {
        rememberChangedField("ReverseDocument", this.reverseDocument);
        this.reverseDocument = reverseDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @param reverseDocumentFiscalYear
     *            Fiscal year of reversal document
     */
    public void setReverseDocumentFiscalYear( @Nullable final String reverseDocumentFiscalYear )
    {
        rememberChangedField("ReverseDocumentFiscalYear", this.reverseDocumentFiscalYear);
        this.reverseDocumentFiscalYear = reverseDocumentFiscalYear;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Is Reversal
     */
    public void setIsReversal( @Nullable final Boolean isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Is Reversed
     */
    public void setIsReversed( @Nullable final Boolean isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IN_GSTPartner</b>
     * </p>
     *
     * @param iN_GSTPartner
     *            GST Partner
     */
    public void setIN_GSTPartner( @Nullable final String iN_GSTPartner )
    {
        rememberChangedField("IN_GSTPartner", this.iN_GSTPartner);
        this.iN_GSTPartner = iN_GSTPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IN_GSTPlaceOfSupply</b>
     * </p>
     *
     * @param iN_GSTPlaceOfSupply
     *            Place of Supply
     */
    public void setIN_GSTPlaceOfSupply( @Nullable final String iN_GSTPlaceOfSupply )
    {
        rememberChangedField("IN_GSTPlaceOfSupply", this.iN_GSTPlaceOfSupply);
        this.iN_GSTPlaceOfSupply = iN_GSTPlaceOfSupply;
    }

    /**
     * Constraints: Not nullable, Maximum length: 64
     * <p>
     * Original property name from the Odata EDM: <b>IN_InvoiceReferenceNumber</b>
     * </p>
     *
     * @param iN_InvoiceReferenceNumber
     *            Invoice Reference Number
     */
    public void setIN_InvoiceReferenceNumber( @Nullable final String iN_InvoiceReferenceNumber )
    {
        rememberChangedField("IN_InvoiceReferenceNumber", this.iN_InvoiceReferenceNumber);
        this.iN_InvoiceReferenceNumber = iN_InvoiceReferenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef1</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificRef1
     *            Country/Region Specific Reference 1 in the Document
     */
    public void setJrnlEntryCntrySpecificRef1( @Nullable final String jrnlEntryCntrySpecificRef1 )
    {
        rememberChangedField("JrnlEntryCntrySpecificRef1", this.jrnlEntryCntrySpecificRef1);
        this.jrnlEntryCntrySpecificRef1 = jrnlEntryCntrySpecificRef1;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate1</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificDate1
     *            Country/Region Specific Date 1 in the Document
     */
    public void setJrnlEntryCntrySpecificDate1( @Nullable final LocalDateTime jrnlEntryCntrySpecificDate1 )
    {
        rememberChangedField("JrnlEntryCntrySpecificDate1", this.jrnlEntryCntrySpecificDate1);
        this.jrnlEntryCntrySpecificDate1 = jrnlEntryCntrySpecificDate1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef2</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificRef2
     *            Country/Region Specific Reference 2 in the Document
     */
    public void setJrnlEntryCntrySpecificRef2( @Nullable final String jrnlEntryCntrySpecificRef2 )
    {
        rememberChangedField("JrnlEntryCntrySpecificRef2", this.jrnlEntryCntrySpecificRef2);
        this.jrnlEntryCntrySpecificRef2 = jrnlEntryCntrySpecificRef2;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate2</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificDate2
     *            Country/Region Specific Date 2 in the Document
     */
    public void setJrnlEntryCntrySpecificDate2( @Nullable final LocalDateTime jrnlEntryCntrySpecificDate2 )
    {
        rememberChangedField("JrnlEntryCntrySpecificDate2", this.jrnlEntryCntrySpecificDate2);
        this.jrnlEntryCntrySpecificDate2 = jrnlEntryCntrySpecificDate2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef3</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificRef3
     *            Country/Region Specific Reference 3 in the Document
     */
    public void setJrnlEntryCntrySpecificRef3( @Nullable final String jrnlEntryCntrySpecificRef3 )
    {
        rememberChangedField("JrnlEntryCntrySpecificRef3", this.jrnlEntryCntrySpecificRef3);
        this.jrnlEntryCntrySpecificRef3 = jrnlEntryCntrySpecificRef3;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate3</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificDate3
     *            Country/Region Specific Date 3 in the Document
     */
    public void setJrnlEntryCntrySpecificDate3( @Nullable final LocalDateTime jrnlEntryCntrySpecificDate3 )
    {
        rememberChangedField("JrnlEntryCntrySpecificDate3", this.jrnlEntryCntrySpecificDate3);
        this.jrnlEntryCntrySpecificDate3 = jrnlEntryCntrySpecificDate3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef4</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificRef4
     *            Country/Region Specific Reference 4 in the Document
     */
    public void setJrnlEntryCntrySpecificRef4( @Nullable final String jrnlEntryCntrySpecificRef4 )
    {
        rememberChangedField("JrnlEntryCntrySpecificRef4", this.jrnlEntryCntrySpecificRef4);
        this.jrnlEntryCntrySpecificRef4 = jrnlEntryCntrySpecificRef4;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate4</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificDate4
     *            Country/Region Specific Date 4 in the Document
     */
    public void setJrnlEntryCntrySpecificDate4( @Nullable final LocalDateTime jrnlEntryCntrySpecificDate4 )
    {
        rememberChangedField("JrnlEntryCntrySpecificDate4", this.jrnlEntryCntrySpecificDate4);
        this.jrnlEntryCntrySpecificDate4 = jrnlEntryCntrySpecificDate4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificRef5</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificRef5
     *            Country/Region Specific Reference 5 in the Document
     */
    public void setJrnlEntryCntrySpecificRef5( @Nullable final String jrnlEntryCntrySpecificRef5 )
    {
        rememberChangedField("JrnlEntryCntrySpecificRef5", this.jrnlEntryCntrySpecificRef5);
        this.jrnlEntryCntrySpecificRef5 = jrnlEntryCntrySpecificRef5;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificDate5</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificDate5
     *            Country/Region Specific Date 5 in the Document
     */
    public void setJrnlEntryCntrySpecificDate5( @Nullable final LocalDateTime jrnlEntryCntrySpecificDate5 )
    {
        rememberChangedField("JrnlEntryCntrySpecificDate5", this.jrnlEntryCntrySpecificDate5);
        this.jrnlEntryCntrySpecificDate5 = jrnlEntryCntrySpecificDate5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificBP1</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificBP1
     *            Country/Region specific Business Partner 1 in the Document
     */
    public void setJrnlEntryCntrySpecificBP1( @Nullable final String jrnlEntryCntrySpecificBP1 )
    {
        rememberChangedField("JrnlEntryCntrySpecificBP1", this.jrnlEntryCntrySpecificBP1);
        this.jrnlEntryCntrySpecificBP1 = jrnlEntryCntrySpecificBP1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JrnlEntryCntrySpecificBP2</b>
     * </p>
     *
     * @param jrnlEntryCntrySpecificBP2
     *            Country/Region Specific Business Partner 2 in the Document
     */
    public void setJrnlEntryCntrySpecificBP2( @Nullable final String jrnlEntryCntrySpecificBP2 )
    {
        rememberChangedField("JrnlEntryCntrySpecificBP2", this.jrnlEntryCntrySpecificBP2);
        this.jrnlEntryCntrySpecificBP2 = jrnlEntryCntrySpecificBP2;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierInvoice";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("CompanyCode", getCompanyCode());
        values.put("DocumentDate", getDocumentDate());
        values.put("PostingDate", getPostingDate());
        values.put("CreationDate", getCreationDate());
        values.put("SupplierInvoiceIDByInvcgParty", getSupplierInvoiceIDByInvcgParty());
        values.put("InvoicingParty", getInvoicingParty());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("InvoiceGrossAmount", getInvoiceGrossAmount());
        values.put("UnplannedDeliveryCost", getUnplannedDeliveryCost());
        values.put("DocumentHeaderText", getDocumentHeaderText());
        values.put("ManualCashDiscount", getManualCashDiscount());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("DueCalculationBaseDate", getDueCalculationBaseDate());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("PaymentBlockingReason", getPaymentBlockingReason());
        values.put("AccountingDocumentType", getAccountingDocumentType());
        values.put("BPBankAccountInternalID", getBPBankAccountInternalID());
        values.put("SupplierInvoiceStatus", getSupplierInvoiceStatus());
        values.put("IndirectQuotedExchangeRate", getIndirectQuotedExchangeRate());
        values.put("DirectQuotedExchangeRate", getDirectQuotedExchangeRate());
        values.put("StateCentralBankPaymentReason", getStateCentralBankPaymentReason());
        values.put("SupplyingCountry", getSupplyingCountry());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("PaymentMethodSupplement", getPaymentMethodSupplement());
        values.put("PaymentReference", getPaymentReference());
        values.put("InvoiceReference", getInvoiceReference());
        values.put("InvoiceReferenceFiscalYear", getInvoiceReferenceFiscalYear());
        values.put("FixedCashDiscount", getFixedCashDiscount());
        values.put("UnplannedDeliveryCostTaxCode", getUnplannedDeliveryCostTaxCode());
        values.put("UnplndDelivCostTaxJurisdiction", getUnplndDelivCostTaxJurisdiction());
        values.put("UnplndDeliveryCostTaxCountry", getUnplndDeliveryCostTaxCountry());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("SupplierPostingLineItemText", getSupplierPostingLineItemText());
        values.put("TaxIsCalculatedAutomatically", getTaxIsCalculatedAutomatically());
        values.put("BusinessPlace", getBusinessPlace());
        values.put("BusinessSectionCode", getBusinessSectionCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("SuplrInvcIsCapitalGoodsRelated", getSuplrInvcIsCapitalGoodsRelated());
        values.put("SupplierInvoiceIsCreditMemo", getSupplierInvoiceIsCreditMemo());
        values.put("PaytSlipWthRefSubscriber", getPaytSlipWthRefSubscriber());
        values.put("PaytSlipWthRefCheckDigit", getPaytSlipWthRefCheckDigit());
        values.put("PaytSlipWthRefReference", getPaytSlipWthRefReference());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        values.put("TaxReportingDate", getTaxReportingDate());
        values.put("TaxFulfillmentDate", getTaxFulfillmentDate());
        values.put("InvoiceReceiptDate", getInvoiceReceiptDate());
        values.put("DeliveryOfGoodsReportingCntry", getDeliveryOfGoodsReportingCntry());
        values.put("SupplierVATRegistration", getSupplierVATRegistration());
        values.put("IsEUTriangularDeal", getIsEUTriangularDeal());
        values.put("SuplrInvcDebitCrdtCodeDelivery", getSuplrInvcDebitCrdtCodeDelivery());
        values.put("SuplrInvcDebitCrdtCodeReturns", getSuplrInvcDebitCrdtCodeReturns());
        values.put("RetentionDueDate", getRetentionDueDate());
        values.put("SupplierInvoiceOrigin", getSupplierInvoiceOrigin());
        values.put("ReverseDocument", getReverseDocument());
        values.put("ReverseDocumentFiscalYear", getReverseDocumentFiscalYear());
        values.put("IsReversal", getIsReversal());
        values.put("IsReversed", getIsReversed());
        values.put("IN_GSTPartner", getIN_GSTPartner());
        values.put("IN_GSTPlaceOfSupply", getIN_GSTPlaceOfSupply());
        values.put("IN_InvoiceReferenceNumber", getIN_InvoiceReferenceNumber());
        values.put("JrnlEntryCntrySpecificRef1", getJrnlEntryCntrySpecificRef1());
        values.put("JrnlEntryCntrySpecificDate1", getJrnlEntryCntrySpecificDate1());
        values.put("JrnlEntryCntrySpecificRef2", getJrnlEntryCntrySpecificRef2());
        values.put("JrnlEntryCntrySpecificDate2", getJrnlEntryCntrySpecificDate2());
        values.put("JrnlEntryCntrySpecificRef3", getJrnlEntryCntrySpecificRef3());
        values.put("JrnlEntryCntrySpecificDate3", getJrnlEntryCntrySpecificDate3());
        values.put("JrnlEntryCntrySpecificRef4", getJrnlEntryCntrySpecificRef4());
        values.put("JrnlEntryCntrySpecificDate4", getJrnlEntryCntrySpecificDate4());
        values.put("JrnlEntryCntrySpecificRef5", getJrnlEntryCntrySpecificRef5());
        values.put("JrnlEntryCntrySpecificDate5", getJrnlEntryCntrySpecificDate5());
        values.put("JrnlEntryCntrySpecificBP1", getJrnlEntryCntrySpecificBP1());
        values.put("JrnlEntryCntrySpecificBP2", getJrnlEntryCntrySpecificBP2());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SupplierInvoiceIDByInvcgParty") ) {
                final Object value = values.remove("SupplierInvoiceIDByInvcgParty");
                if( (value == null) || (!value.equals(getSupplierInvoiceIDByInvcgParty())) ) {
                    setSupplierInvoiceIDByInvcgParty(((String) value));
                }
            }
            if( values.containsKey("InvoicingParty") ) {
                final Object value = values.remove("InvoicingParty");
                if( (value == null) || (!value.equals(getInvoicingParty())) ) {
                    setInvoicingParty(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("InvoiceGrossAmount") ) {
                final Object value = values.remove("InvoiceGrossAmount");
                if( (value == null) || (!value.equals(getInvoiceGrossAmount())) ) {
                    setInvoiceGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnplannedDeliveryCost") ) {
                final Object value = values.remove("UnplannedDeliveryCost");
                if( (value == null) || (!value.equals(getUnplannedDeliveryCost())) ) {
                    setUnplannedDeliveryCost(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentHeaderText") ) {
                final Object value = values.remove("DocumentHeaderText");
                if( (value == null) || (!value.equals(getDocumentHeaderText())) ) {
                    setDocumentHeaderText(((String) value));
                }
            }
            if( values.containsKey("ManualCashDiscount") ) {
                final Object value = values.remove("ManualCashDiscount");
                if( (value == null) || (!value.equals(getManualCashDiscount())) ) {
                    setManualCashDiscount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("DueCalculationBaseDate") ) {
                final Object value = values.remove("DueCalculationBaseDate");
                if( (value == null) || (!value.equals(getDueCalculationBaseDate())) ) {
                    setDueCalculationBaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentBlockingReason") ) {
                final Object value = values.remove("PaymentBlockingReason");
                if( (value == null) || (!value.equals(getPaymentBlockingReason())) ) {
                    setPaymentBlockingReason(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentType") ) {
                final Object value = values.remove("AccountingDocumentType");
                if( (value == null) || (!value.equals(getAccountingDocumentType())) ) {
                    setAccountingDocumentType(((String) value));
                }
            }
            if( values.containsKey("BPBankAccountInternalID") ) {
                final Object value = values.remove("BPBankAccountInternalID");
                if( (value == null) || (!value.equals(getBPBankAccountInternalID())) ) {
                    setBPBankAccountInternalID(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceStatus") ) {
                final Object value = values.remove("SupplierInvoiceStatus");
                if( (value == null) || (!value.equals(getSupplierInvoiceStatus())) ) {
                    setSupplierInvoiceStatus(((String) value));
                }
            }
            if( values.containsKey("IndirectQuotedExchangeRate") ) {
                final Object value = values.remove("IndirectQuotedExchangeRate");
                if( (value == null) || (!value.equals(getIndirectQuotedExchangeRate())) ) {
                    setIndirectQuotedExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("DirectQuotedExchangeRate") ) {
                final Object value = values.remove("DirectQuotedExchangeRate");
                if( (value == null) || (!value.equals(getDirectQuotedExchangeRate())) ) {
                    setDirectQuotedExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("StateCentralBankPaymentReason") ) {
                final Object value = values.remove("StateCentralBankPaymentReason");
                if( (value == null) || (!value.equals(getStateCentralBankPaymentReason())) ) {
                    setStateCentralBankPaymentReason(((String) value));
                }
            }
            if( values.containsKey("SupplyingCountry") ) {
                final Object value = values.remove("SupplyingCountry");
                if( (value == null) || (!value.equals(getSupplyingCountry())) ) {
                    setSupplyingCountry(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("PaymentMethodSupplement") ) {
                final Object value = values.remove("PaymentMethodSupplement");
                if( (value == null) || (!value.equals(getPaymentMethodSupplement())) ) {
                    setPaymentMethodSupplement(((String) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((String) value));
                }
            }
            if( values.containsKey("InvoiceReference") ) {
                final Object value = values.remove("InvoiceReference");
                if( (value == null) || (!value.equals(getInvoiceReference())) ) {
                    setInvoiceReference(((String) value));
                }
            }
            if( values.containsKey("InvoiceReferenceFiscalYear") ) {
                final Object value = values.remove("InvoiceReferenceFiscalYear");
                if( (value == null) || (!value.equals(getInvoiceReferenceFiscalYear())) ) {
                    setInvoiceReferenceFiscalYear(((String) value));
                }
            }
            if( values.containsKey("FixedCashDiscount") ) {
                final Object value = values.remove("FixedCashDiscount");
                if( (value == null) || (!value.equals(getFixedCashDiscount())) ) {
                    setFixedCashDiscount(((String) value));
                }
            }
            if( values.containsKey("UnplannedDeliveryCostTaxCode") ) {
                final Object value = values.remove("UnplannedDeliveryCostTaxCode");
                if( (value == null) || (!value.equals(getUnplannedDeliveryCostTaxCode())) ) {
                    setUnplannedDeliveryCostTaxCode(((String) value));
                }
            }
            if( values.containsKey("UnplndDelivCostTaxJurisdiction") ) {
                final Object value = values.remove("UnplndDelivCostTaxJurisdiction");
                if( (value == null) || (!value.equals(getUnplndDelivCostTaxJurisdiction())) ) {
                    setUnplndDelivCostTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("UnplndDeliveryCostTaxCountry") ) {
                final Object value = values.remove("UnplndDeliveryCostTaxCountry");
                if( (value == null) || (!value.equals(getUnplndDeliveryCostTaxCountry())) ) {
                    setUnplndDeliveryCostTaxCountry(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("SupplierPostingLineItemText") ) {
                final Object value = values.remove("SupplierPostingLineItemText");
                if( (value == null) || (!value.equals(getSupplierPostingLineItemText())) ) {
                    setSupplierPostingLineItemText(((String) value));
                }
            }
            if( values.containsKey("TaxIsCalculatedAutomatically") ) {
                final Object value = values.remove("TaxIsCalculatedAutomatically");
                if( (value == null) || (!value.equals(getTaxIsCalculatedAutomatically())) ) {
                    setTaxIsCalculatedAutomatically(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPlace") ) {
                final Object value = values.remove("BusinessPlace");
                if( (value == null) || (!value.equals(getBusinessPlace())) ) {
                    setBusinessPlace(((String) value));
                }
            }
            if( values.containsKey("BusinessSectionCode") ) {
                final Object value = values.remove("BusinessSectionCode");
                if( (value == null) || (!value.equals(getBusinessSectionCode())) ) {
                    setBusinessSectionCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcIsCapitalGoodsRelated") ) {
                final Object value = values.remove("SuplrInvcIsCapitalGoodsRelated");
                if( (value == null) || (!value.equals(getSuplrInvcIsCapitalGoodsRelated())) ) {
                    setSuplrInvcIsCapitalGoodsRelated(((Boolean) value));
                }
            }
            if( values.containsKey("SupplierInvoiceIsCreditMemo") ) {
                final Object value = values.remove("SupplierInvoiceIsCreditMemo");
                if( (value == null) || (!value.equals(getSupplierInvoiceIsCreditMemo())) ) {
                    setSupplierInvoiceIsCreditMemo(((String) value));
                }
            }
            if( values.containsKey("PaytSlipWthRefSubscriber") ) {
                final Object value = values.remove("PaytSlipWthRefSubscriber");
                if( (value == null) || (!value.equals(getPaytSlipWthRefSubscriber())) ) {
                    setPaytSlipWthRefSubscriber(((String) value));
                }
            }
            if( values.containsKey("PaytSlipWthRefCheckDigit") ) {
                final Object value = values.remove("PaytSlipWthRefCheckDigit");
                if( (value == null) || (!value.equals(getPaytSlipWthRefCheckDigit())) ) {
                    setPaytSlipWthRefCheckDigit(((String) value));
                }
            }
            if( values.containsKey("PaytSlipWthRefReference") ) {
                final Object value = values.remove("PaytSlipWthRefReference");
                if( (value == null) || (!value.equals(getPaytSlipWthRefReference())) ) {
                    setPaytSlipWthRefReference(((String) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxReportingDate") ) {
                final Object value = values.remove("TaxReportingDate");
                if( (value == null) || (!value.equals(getTaxReportingDate())) ) {
                    setTaxReportingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxFulfillmentDate") ) {
                final Object value = values.remove("TaxFulfillmentDate");
                if( (value == null) || (!value.equals(getTaxFulfillmentDate())) ) {
                    setTaxFulfillmentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InvoiceReceiptDate") ) {
                final Object value = values.remove("InvoiceReceiptDate");
                if( (value == null) || (!value.equals(getInvoiceReceiptDate())) ) {
                    setInvoiceReceiptDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DeliveryOfGoodsReportingCntry") ) {
                final Object value = values.remove("DeliveryOfGoodsReportingCntry");
                if( (value == null) || (!value.equals(getDeliveryOfGoodsReportingCntry())) ) {
                    setDeliveryOfGoodsReportingCntry(((String) value));
                }
            }
            if( values.containsKey("SupplierVATRegistration") ) {
                final Object value = values.remove("SupplierVATRegistration");
                if( (value == null) || (!value.equals(getSupplierVATRegistration())) ) {
                    setSupplierVATRegistration(((String) value));
                }
            }
            if( values.containsKey("IsEUTriangularDeal") ) {
                final Object value = values.remove("IsEUTriangularDeal");
                if( (value == null) || (!value.equals(getIsEUTriangularDeal())) ) {
                    setIsEUTriangularDeal(((Boolean) value));
                }
            }
            if( values.containsKey("SuplrInvcDebitCrdtCodeDelivery") ) {
                final Object value = values.remove("SuplrInvcDebitCrdtCodeDelivery");
                if( (value == null) || (!value.equals(getSuplrInvcDebitCrdtCodeDelivery())) ) {
                    setSuplrInvcDebitCrdtCodeDelivery(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcDebitCrdtCodeReturns") ) {
                final Object value = values.remove("SuplrInvcDebitCrdtCodeReturns");
                if( (value == null) || (!value.equals(getSuplrInvcDebitCrdtCodeReturns())) ) {
                    setSuplrInvcDebitCrdtCodeReturns(((String) value));
                }
            }
            if( values.containsKey("RetentionDueDate") ) {
                final Object value = values.remove("RetentionDueDate");
                if( (value == null) || (!value.equals(getRetentionDueDate())) ) {
                    setRetentionDueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SupplierInvoiceOrigin") ) {
                final Object value = values.remove("SupplierInvoiceOrigin");
                if( (value == null) || (!value.equals(getSupplierInvoiceOrigin())) ) {
                    setSupplierInvoiceOrigin(((String) value));
                }
            }
            if( values.containsKey("ReverseDocument") ) {
                final Object value = values.remove("ReverseDocument");
                if( (value == null) || (!value.equals(getReverseDocument())) ) {
                    setReverseDocument(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentFiscalYear") ) {
                final Object value = values.remove("ReverseDocumentFiscalYear");
                if( (value == null) || (!value.equals(getReverseDocumentFiscalYear())) ) {
                    setReverseDocumentFiscalYear(((String) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((Boolean) value));
                }
            }
            if( values.containsKey("IN_GSTPartner") ) {
                final Object value = values.remove("IN_GSTPartner");
                if( (value == null) || (!value.equals(getIN_GSTPartner())) ) {
                    setIN_GSTPartner(((String) value));
                }
            }
            if( values.containsKey("IN_GSTPlaceOfSupply") ) {
                final Object value = values.remove("IN_GSTPlaceOfSupply");
                if( (value == null) || (!value.equals(getIN_GSTPlaceOfSupply())) ) {
                    setIN_GSTPlaceOfSupply(((String) value));
                }
            }
            if( values.containsKey("IN_InvoiceReferenceNumber") ) {
                final Object value = values.remove("IN_InvoiceReferenceNumber");
                if( (value == null) || (!value.equals(getIN_InvoiceReferenceNumber())) ) {
                    setIN_InvoiceReferenceNumber(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificRef1") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificRef1");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificRef1())) ) {
                    setJrnlEntryCntrySpecificRef1(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificDate1") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificDate1");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificDate1())) ) {
                    setJrnlEntryCntrySpecificDate1(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificRef2") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificRef2");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificRef2())) ) {
                    setJrnlEntryCntrySpecificRef2(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificDate2") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificDate2");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificDate2())) ) {
                    setJrnlEntryCntrySpecificDate2(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificRef3") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificRef3");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificRef3())) ) {
                    setJrnlEntryCntrySpecificRef3(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificDate3") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificDate3");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificDate3())) ) {
                    setJrnlEntryCntrySpecificDate3(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificRef4") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificRef4");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificRef4())) ) {
                    setJrnlEntryCntrySpecificRef4(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificDate4") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificDate4");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificDate4())) ) {
                    setJrnlEntryCntrySpecificDate4(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificRef5") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificRef5");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificRef5())) ) {
                    setJrnlEntryCntrySpecificRef5(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificDate5") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificDate5");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificDate5())) ) {
                    setJrnlEntryCntrySpecificDate5(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificBP1") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificBP1");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificBP1())) ) {
                    setJrnlEntryCntrySpecificBP1(((String) value));
                }
            }
            if( values.containsKey("JrnlEntryCntrySpecificBP2") ) {
                final Object value = values.remove("JrnlEntryCntrySpecificBP2");
                if( (value == null) || (!value.equals(getJrnlEntryCntrySpecificBP2())) ) {
                    setJrnlEntryCntrySpecificBP2(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SelectedDeliveryNotes") ) {
                final Object value = (values).remove("to_SelectedDeliveryNotes");
                if( value instanceof Iterable ) {
                    if( toSelectedDeliveryNotes == null ) {
                        toSelectedDeliveryNotes = Lists.newArrayList();
                    } else {
                        toSelectedDeliveryNotes = Lists.newArrayList(toSelectedDeliveryNotes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrInvcSeldInbDeliveryNote entity;
                        if( toSelectedDeliveryNotes.size() > i ) {
                            entity = toSelectedDeliveryNotes.get(i);
                        } else {
                            entity = new SuplrInvcSeldInbDeliveryNote();
                            toSelectedDeliveryNotes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SelectedPurchaseOrders") ) {
                final Object value = (values).remove("to_SelectedPurchaseOrders");
                if( value instanceof Iterable ) {
                    if( toSelectedPurchaseOrders == null ) {
                        toSelectedPurchaseOrders = Lists.newArrayList();
                    } else {
                        toSelectedPurchaseOrders = Lists.newArrayList(toSelectedPurchaseOrders);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrInvcSeldPurgDocument entity;
                        if( toSelectedPurchaseOrders.size() > i ) {
                            entity = toSelectedPurchaseOrders.get(i);
                        } else {
                            entity = new SuplrInvcSeldPurgDocument();
                            toSelectedPurchaseOrders.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SelectedServiceEntrySheets") ) {
                final Object value = (values).remove("to_SelectedServiceEntrySheets");
                if( value instanceof Iterable ) {
                    if( toSelectedServiceEntrySheets == null ) {
                        toSelectedServiceEntrySheets = Lists.newArrayList();
                    } else {
                        toSelectedServiceEntrySheets = Lists.newArrayList(toSelectedServiceEntrySheets);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrInvcSeldSrvcEntrShtLean entity;
                        if( toSelectedServiceEntrySheets.size() > i ) {
                            entity = toSelectedServiceEntrySheets.get(i);
                        } else {
                            entity = new SuplrInvcSeldSrvcEntrShtLean();
                            toSelectedServiceEntrySheets.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrInvcItemPurOrdRef") ) {
                final Object value = (values).remove("to_SuplrInvcItemPurOrdRef");
                if( value instanceof Iterable ) {
                    if( toSuplrInvcItemPurOrdRef == null ) {
                        toSuplrInvcItemPurOrdRef = Lists.newArrayList();
                    } else {
                        toSuplrInvcItemPurOrdRef = Lists.newArrayList(toSuplrInvcItemPurOrdRef);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrInvcItemPurOrdRef entity;
                        if( toSuplrInvcItemPurOrdRef.size() > i ) {
                            entity = toSuplrInvcItemPurOrdRef.get(i);
                        } else {
                            entity = new SuplrInvcItemPurOrdRef();
                            toSuplrInvcItemPurOrdRef.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrInvoiceAdditionalData") ) {
                final Object value = (values).remove("to_SuplrInvoiceAdditionalData");
                if( value instanceof Map ) {
                    if( toSuplrInvoiceAdditionalData == null ) {
                        toSuplrInvoiceAdditionalData = new SuplrInvoiceAdditionalData();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrInvoiceAdditionalData.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SupplierInvoiceItemGLAcct") ) {
                final Object value = (values).remove("to_SupplierInvoiceItemGLAcct");
                if( value instanceof Iterable ) {
                    if( toSupplierInvoiceItemGLAcct == null ) {
                        toSupplierInvoiceItemGLAcct = Lists.newArrayList();
                    } else {
                        toSupplierInvoiceItemGLAcct = Lists.newArrayList(toSupplierInvoiceItemGLAcct);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplierInvoiceItemGLAcct entity;
                        if( toSupplierInvoiceItemGLAcct.size() > i ) {
                            entity = toSupplierInvoiceItemGLAcct.get(i);
                        } else {
                            entity = new SupplierInvoiceItemGLAcct();
                            toSupplierInvoiceItemGLAcct.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SupplierInvoiceTax") ) {
                final Object value = (values).remove("to_SupplierInvoiceTax");
                if( value instanceof Iterable ) {
                    if( toSupplierInvoiceTax == null ) {
                        toSupplierInvoiceTax = Lists.newArrayList();
                    } else {
                        toSupplierInvoiceTax = Lists.newArrayList(toSupplierInvoiceTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplierInvoiceTax entity;
                        if( toSupplierInvoiceTax.size() > i ) {
                            entity = toSupplierInvoiceTax.get(i);
                        } else {
                            entity = new SupplierInvoiceTax();
                            toSupplierInvoiceTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SupplierInvoiceWhldgTax") ) {
                final Object value = (values).remove("to_SupplierInvoiceWhldgTax");
                if( value instanceof Iterable ) {
                    if( toSupplierInvoiceWhldgTax == null ) {
                        toSupplierInvoiceWhldgTax = Lists.newArrayList();
                    } else {
                        toSupplierInvoiceWhldgTax = Lists.newArrayList(toSupplierInvoiceWhldgTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrInvcHeaderWhldgTax entity;
                        if( toSupplierInvoiceWhldgTax.size() > i ) {
                            entity = toSupplierInvoiceWhldgTax.get(i);
                        } else {
                            entity = new SuplrInvcHeaderWhldgTax();
                            toSupplierInvoiceWhldgTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierInvoiceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierInvoiceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierInvoiceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierInvoiceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSelectedDeliveryNotes != null ) {
            (values).put("to_SelectedDeliveryNotes", toSelectedDeliveryNotes);
        }
        if( toSelectedPurchaseOrders != null ) {
            (values).put("to_SelectedPurchaseOrders", toSelectedPurchaseOrders);
        }
        if( toSelectedServiceEntrySheets != null ) {
            (values).put("to_SelectedServiceEntrySheets", toSelectedServiceEntrySheets);
        }
        if( toSuplrInvcItemPurOrdRef != null ) {
            (values).put("to_SuplrInvcItemPurOrdRef", toSuplrInvcItemPurOrdRef);
        }
        if( toSuplrInvoiceAdditionalData != null ) {
            (values).put("to_SuplrInvoiceAdditionalData", toSuplrInvoiceAdditionalData);
        }
        if( toSupplierInvoiceItemGLAcct != null ) {
            (values).put("to_SupplierInvoiceItemGLAcct", toSupplierInvoiceItemGLAcct);
        }
        if( toSupplierInvoiceTax != null ) {
            (values).put("to_SupplierInvoiceTax", toSupplierInvoiceTax);
        }
        if( toSupplierInvoiceWhldgTax != null ) {
            (values).put("to_SupplierInvoiceWhldgTax", toSupplierInvoiceWhldgTax);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrInvcSeldInbDeliveryNote</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SelectedDeliveryNotes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrInvcSeldInbDeliveryNote</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcSeldInbDeliveryNote> fetchSelectedDeliveryNotes()
    {
        return fetchFieldAsList("to_SelectedDeliveryNotes", SuplrInvcSeldInbDeliveryNote.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvcSeldInbDeliveryNote</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelectedDeliveryNotes</b>.
     * <p>
     * If the navigation property <b>to_SelectedDeliveryNotes</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvcSeldInbDeliveryNote</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcSeldInbDeliveryNote> getSelectedDeliveryNotesOrFetch()
    {
        if( toSelectedDeliveryNotes == null ) {
            toSelectedDeliveryNotes = fetchSelectedDeliveryNotes();
        }
        return toSelectedDeliveryNotes;
    }

    /**
     * Retrieval of associated <b>SuplrInvcSeldInbDeliveryNote</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelectedDeliveryNotes</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SelectedDeliveryNotes</b> is already loaded, the result
     *         will contain the <b>SuplrInvcSeldInbDeliveryNote</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrInvcSeldInbDeliveryNote>> getSelectedDeliveryNotesIfPresent()
    {
        return Option.of(toSelectedDeliveryNotes);
    }

    /**
     * Overwrites the list of associated <b>SuplrInvcSeldInbDeliveryNote</b> entities for the loaded navigation property
     * <b>to_SelectedDeliveryNotes</b>.
     * <p>
     * If the navigation property <b>to_SelectedDeliveryNotes</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrInvcSeldInbDeliveryNote</b> entities.
     */
    public void setSelectedDeliveryNotes( @Nonnull final List<SuplrInvcSeldInbDeliveryNote> value )
    {
        if( toSelectedDeliveryNotes == null ) {
            toSelectedDeliveryNotes = Lists.newArrayList();
        }
        toSelectedDeliveryNotes.clear();
        toSelectedDeliveryNotes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrInvcSeldInbDeliveryNote</b> entities. This corresponds to the
     * OData navigation property <b>to_SelectedDeliveryNotes</b>.
     * <p>
     * If the navigation property <b>to_SelectedDeliveryNotes</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrInvcSeldInbDeliveryNote</b> entities.
     */
    public void addSelectedDeliveryNotes( SuplrInvcSeldInbDeliveryNote... entity )
    {
        if( toSelectedDeliveryNotes == null ) {
            toSelectedDeliveryNotes = Lists.newArrayList();
        }
        toSelectedDeliveryNotes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrInvcSeldPurgDocument</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SelectedPurchaseOrders</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrInvcSeldPurgDocument</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcSeldPurgDocument> fetchSelectedPurchaseOrders()
    {
        return fetchFieldAsList("to_SelectedPurchaseOrders", SuplrInvcSeldPurgDocument.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvcSeldPurgDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelectedPurchaseOrders</b>.
     * <p>
     * If the navigation property <b>to_SelectedPurchaseOrders</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvcSeldPurgDocument</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcSeldPurgDocument> getSelectedPurchaseOrdersOrFetch()
    {
        if( toSelectedPurchaseOrders == null ) {
            toSelectedPurchaseOrders = fetchSelectedPurchaseOrders();
        }
        return toSelectedPurchaseOrders;
    }

    /**
     * Retrieval of associated <b>SuplrInvcSeldPurgDocument</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelectedPurchaseOrders</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SelectedPurchaseOrders</b> is already loaded, the result
     *         will contain the <b>SuplrInvcSeldPurgDocument</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrInvcSeldPurgDocument>> getSelectedPurchaseOrdersIfPresent()
    {
        return Option.of(toSelectedPurchaseOrders);
    }

    /**
     * Overwrites the list of associated <b>SuplrInvcSeldPurgDocument</b> entities for the loaded navigation property
     * <b>to_SelectedPurchaseOrders</b>.
     * <p>
     * If the navigation property <b>to_SelectedPurchaseOrders</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrInvcSeldPurgDocument</b> entities.
     */
    public void setSelectedPurchaseOrders( @Nonnull final List<SuplrInvcSeldPurgDocument> value )
    {
        if( toSelectedPurchaseOrders == null ) {
            toSelectedPurchaseOrders = Lists.newArrayList();
        }
        toSelectedPurchaseOrders.clear();
        toSelectedPurchaseOrders.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrInvcSeldPurgDocument</b> entities. This corresponds to the OData
     * navigation property <b>to_SelectedPurchaseOrders</b>.
     * <p>
     * If the navigation property <b>to_SelectedPurchaseOrders</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrInvcSeldPurgDocument</b> entities.
     */
    public void addSelectedPurchaseOrders( SuplrInvcSeldPurgDocument... entity )
    {
        if( toSelectedPurchaseOrders == null ) {
            toSelectedPurchaseOrders = Lists.newArrayList();
        }
        toSelectedPurchaseOrders.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrInvcSeldSrvcEntrShtLean</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SelectedServiceEntrySheets</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrInvcSeldSrvcEntrShtLean</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcSeldSrvcEntrShtLean> fetchSelectedServiceEntrySheets()
    {
        return fetchFieldAsList("to_SelectedServiceEntrySheets", SuplrInvcSeldSrvcEntrShtLean.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvcSeldSrvcEntrShtLean</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelectedServiceEntrySheets</b>.
     * <p>
     * If the navigation property <b>to_SelectedServiceEntrySheets</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvcSeldSrvcEntrShtLean</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcSeldSrvcEntrShtLean> getSelectedServiceEntrySheetsOrFetch()
    {
        if( toSelectedServiceEntrySheets == null ) {
            toSelectedServiceEntrySheets = fetchSelectedServiceEntrySheets();
        }
        return toSelectedServiceEntrySheets;
    }

    /**
     * Retrieval of associated <b>SuplrInvcSeldSrvcEntrShtLean</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelectedServiceEntrySheets</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SelectedServiceEntrySheets</b> is already loaded, the
     *         result will contain the <b>SuplrInvcSeldSrvcEntrShtLean</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrInvcSeldSrvcEntrShtLean>> getSelectedServiceEntrySheetsIfPresent()
    {
        return Option.of(toSelectedServiceEntrySheets);
    }

    /**
     * Overwrites the list of associated <b>SuplrInvcSeldSrvcEntrShtLean</b> entities for the loaded navigation property
     * <b>to_SelectedServiceEntrySheets</b>.
     * <p>
     * If the navigation property <b>to_SelectedServiceEntrySheets</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrInvcSeldSrvcEntrShtLean</b> entities.
     */
    public void setSelectedServiceEntrySheets( @Nonnull final List<SuplrInvcSeldSrvcEntrShtLean> value )
    {
        if( toSelectedServiceEntrySheets == null ) {
            toSelectedServiceEntrySheets = Lists.newArrayList();
        }
        toSelectedServiceEntrySheets.clear();
        toSelectedServiceEntrySheets.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrInvcSeldSrvcEntrShtLean</b> entities. This corresponds to the
     * OData navigation property <b>to_SelectedServiceEntrySheets</b>.
     * <p>
     * If the navigation property <b>to_SelectedServiceEntrySheets</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrInvcSeldSrvcEntrShtLean</b> entities.
     */
    public void addSelectedServiceEntrySheets( SuplrInvcSeldSrvcEntrShtLean... entity )
    {
        if( toSelectedServiceEntrySheets == null ) {
            toSelectedServiceEntrySheets = Lists.newArrayList();
        }
        toSelectedServiceEntrySheets.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrInvcItemPurOrdRef</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrInvcItemPurOrdRef</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrInvcItemPurOrdRef</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcItemPurOrdRef> fetchSuplrInvcItemPurOrdRef()
    {
        return fetchFieldAsList("to_SuplrInvcItemPurOrdRef", SuplrInvcItemPurOrdRef.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvcItemPurOrdRef</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrInvcItemPurOrdRef</b>.
     * <p>
     * If the navigation property <b>to_SuplrInvcItemPurOrdRef</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvcItemPurOrdRef</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcItemPurOrdRef> getSuplrInvcItemPurOrdRefOrFetch()
    {
        if( toSuplrInvcItemPurOrdRef == null ) {
            toSuplrInvcItemPurOrdRef = fetchSuplrInvcItemPurOrdRef();
        }
        return toSuplrInvcItemPurOrdRef;
    }

    /**
     * Retrieval of associated <b>SuplrInvcItemPurOrdRef</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrInvcItemPurOrdRef</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrInvcItemPurOrdRef</b> is already loaded, the result
     *         will contain the <b>SuplrInvcItemPurOrdRef</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrInvcItemPurOrdRef>> getSuplrInvcItemPurOrdRefIfPresent()
    {
        return Option.of(toSuplrInvcItemPurOrdRef);
    }

    /**
     * Overwrites the list of associated <b>SuplrInvcItemPurOrdRef</b> entities for the loaded navigation property
     * <b>to_SuplrInvcItemPurOrdRef</b>.
     * <p>
     * If the navigation property <b>to_SuplrInvcItemPurOrdRef</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrInvcItemPurOrdRef</b> entities.
     */
    public void setSuplrInvcItemPurOrdRef( @Nonnull final List<SuplrInvcItemPurOrdRef> value )
    {
        if( toSuplrInvcItemPurOrdRef == null ) {
            toSuplrInvcItemPurOrdRef = Lists.newArrayList();
        }
        toSuplrInvcItemPurOrdRef.clear();
        toSuplrInvcItemPurOrdRef.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrInvcItemPurOrdRef</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrInvcItemPurOrdRef</b>.
     * <p>
     * If the navigation property <b>to_SuplrInvcItemPurOrdRef</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrInvcItemPurOrdRef</b> entities.
     */
    public void addSuplrInvcItemPurOrdRef( SuplrInvcItemPurOrdRef... entity )
    {
        if( toSuplrInvcItemPurOrdRef == null ) {
            toSuplrInvcItemPurOrdRef = Lists.newArrayList();
        }
        toSuplrInvcItemPurOrdRef.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrInvoiceAdditionalData</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrInvoiceAdditionalData</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrInvoiceAdditionalData</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrInvoiceAdditionalData fetchSuplrInvoiceAdditionalData()
    {
        return fetchFieldAsSingle("to_SuplrInvoiceAdditionalData", SuplrInvoiceAdditionalData.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvoiceAdditionalData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrInvoiceAdditionalData</b>.
     * <p>
     * If the navigation property <b>to_SuplrInvoiceAdditionalData</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvoiceAdditionalData</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrInvoiceAdditionalData getSuplrInvoiceAdditionalDataOrFetch()
    {
        if( toSuplrInvoiceAdditionalData == null ) {
            toSuplrInvoiceAdditionalData = fetchSuplrInvoiceAdditionalData();
        }
        return toSuplrInvoiceAdditionalData;
    }

    /**
     * Retrieval of associated <b>SuplrInvoiceAdditionalData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrInvoiceAdditionalData</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrInvoiceAdditionalData</b> is already loaded, the
     *         result will contain the <b>SuplrInvoiceAdditionalData</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrInvoiceAdditionalData> getSuplrInvoiceAdditionalDataIfPresent()
    {
        return Option.of(toSuplrInvoiceAdditionalData);
    }

    /**
     * Overwrites the associated <b>SuplrInvoiceAdditionalData</b> entity for the loaded navigation property
     * <b>to_SuplrInvoiceAdditionalData</b>.
     *
     * @param value
     *            New <b>SuplrInvoiceAdditionalData</b> entity.
     */
    public void setSuplrInvoiceAdditionalData( final SuplrInvoiceAdditionalData value )
    {
        toSuplrInvoiceAdditionalData = value;
    }

    /**
     * Fetches the <b>SupplierInvoiceItemGLAcct</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SupplierInvoiceItemGLAcct</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SupplierInvoiceItemGLAcct</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierInvoiceItemGLAcct> fetchSupplierInvoiceItemGLAcct()
    {
        return fetchFieldAsList("to_SupplierInvoiceItemGLAcct", SupplierInvoiceItemGLAcct.class);
    }

    /**
     * Retrieval of associated <b>SupplierInvoiceItemGLAcct</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceItemGLAcct</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceItemGLAcct</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierInvoiceItemGLAcct</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierInvoiceItemGLAcct> getSupplierInvoiceItemGLAcctOrFetch()
    {
        if( toSupplierInvoiceItemGLAcct == null ) {
            toSupplierInvoiceItemGLAcct = fetchSupplierInvoiceItemGLAcct();
        }
        return toSupplierInvoiceItemGLAcct;
    }

    /**
     * Retrieval of associated <b>SupplierInvoiceItemGLAcct</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceItemGLAcct</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierInvoiceItemGLAcct</b> is already loaded, the
     *         result will contain the <b>SupplierInvoiceItemGLAcct</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplierInvoiceItemGLAcct>> getSupplierInvoiceItemGLAcctIfPresent()
    {
        return Option.of(toSupplierInvoiceItemGLAcct);
    }

    /**
     * Overwrites the list of associated <b>SupplierInvoiceItemGLAcct</b> entities for the loaded navigation property
     * <b>to_SupplierInvoiceItemGLAcct</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceItemGLAcct</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SupplierInvoiceItemGLAcct</b> entities.
     */
    public void setSupplierInvoiceItemGLAcct( @Nonnull final List<SupplierInvoiceItemGLAcct> value )
    {
        if( toSupplierInvoiceItemGLAcct == null ) {
            toSupplierInvoiceItemGLAcct = Lists.newArrayList();
        }
        toSupplierInvoiceItemGLAcct.clear();
        toSupplierInvoiceItemGLAcct.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplierInvoiceItemGLAcct</b> entities. This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceItemGLAcct</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceItemGLAcct</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SupplierInvoiceItemGLAcct</b> entities.
     */
    public void addSupplierInvoiceItemGLAcct( SupplierInvoiceItemGLAcct... entity )
    {
        if( toSupplierInvoiceItemGLAcct == null ) {
            toSupplierInvoiceItemGLAcct = Lists.newArrayList();
        }
        toSupplierInvoiceItemGLAcct.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SupplierInvoiceTax</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SupplierInvoiceTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SupplierInvoiceTax</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierInvoiceTax> fetchSupplierInvoiceTax()
    {
        return fetchFieldAsList("to_SupplierInvoiceTax", SupplierInvoiceTax.class);
    }

    /**
     * Retrieval of associated <b>SupplierInvoiceTax</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceTax</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceTax</b> of a queried <b>SupplierInvoice</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierInvoiceTax</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierInvoiceTax> getSupplierInvoiceTaxOrFetch()
    {
        if( toSupplierInvoiceTax == null ) {
            toSupplierInvoiceTax = fetchSupplierInvoiceTax();
        }
        return toSupplierInvoiceTax;
    }

    /**
     * Retrieval of associated <b>SupplierInvoiceTax</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceTax</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierInvoiceTax</b> is already loaded, the result
     *         will contain the <b>SupplierInvoiceTax</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplierInvoiceTax>> getSupplierInvoiceTaxIfPresent()
    {
        return Option.of(toSupplierInvoiceTax);
    }

    /**
     * Overwrites the list of associated <b>SupplierInvoiceTax</b> entities for the loaded navigation property
     * <b>to_SupplierInvoiceTax</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceTax</b> of a queried <b>SupplierInvoice</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SupplierInvoiceTax</b> entities.
     */
    public void setSupplierInvoiceTax( @Nonnull final List<SupplierInvoiceTax> value )
    {
        if( toSupplierInvoiceTax == null ) {
            toSupplierInvoiceTax = Lists.newArrayList();
        }
        toSupplierInvoiceTax.clear();
        toSupplierInvoiceTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplierInvoiceTax</b> entities. This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceTax</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceTax</b> of a queried <b>SupplierInvoice</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SupplierInvoiceTax</b> entities.
     */
    public void addSupplierInvoiceTax( SupplierInvoiceTax... entity )
    {
        if( toSupplierInvoiceTax == null ) {
            toSupplierInvoiceTax = Lists.newArrayList();
        }
        toSupplierInvoiceTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrInvcHeaderWhldgTax</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SupplierInvoiceWhldgTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrInvcHeaderWhldgTax</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcHeaderWhldgTax> fetchSupplierInvoiceWhldgTax()
    {
        return fetchFieldAsList("to_SupplierInvoiceWhldgTax", SuplrInvcHeaderWhldgTax.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvcHeaderWhldgTax</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceWhldgTax</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceWhldgTax</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvcHeaderWhldgTax</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcHeaderWhldgTax> getSupplierInvoiceWhldgTaxOrFetch()
    {
        if( toSupplierInvoiceWhldgTax == null ) {
            toSupplierInvoiceWhldgTax = fetchSupplierInvoiceWhldgTax();
        }
        return toSupplierInvoiceWhldgTax;
    }

    /**
     * Retrieval of associated <b>SuplrInvcHeaderWhldgTax</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceWhldgTax</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierInvoice</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierInvoiceWhldgTax</b> is already loaded, the
     *         result will contain the <b>SuplrInvcHeaderWhldgTax</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrInvcHeaderWhldgTax>> getSupplierInvoiceWhldgTaxIfPresent()
    {
        return Option.of(toSupplierInvoiceWhldgTax);
    }

    /**
     * Overwrites the list of associated <b>SuplrInvcHeaderWhldgTax</b> entities for the loaded navigation property
     * <b>to_SupplierInvoiceWhldgTax</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceWhldgTax</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrInvcHeaderWhldgTax</b> entities.
     */
    public void setSupplierInvoiceWhldgTax( @Nonnull final List<SuplrInvcHeaderWhldgTax> value )
    {
        if( toSupplierInvoiceWhldgTax == null ) {
            toSupplierInvoiceWhldgTax = Lists.newArrayList();
        }
        toSupplierInvoiceWhldgTax.clear();
        toSupplierInvoiceWhldgTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrInvcHeaderWhldgTax</b> entities. This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceWhldgTax</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceWhldgTax</b> of a queried <b>SupplierInvoice</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrInvcHeaderWhldgTax</b> entities.
     */
    public void addSupplierInvoiceWhldgTax( SuplrInvcHeaderWhldgTax... entity )
    {
        if( toSupplierInvoiceWhldgTax == null ) {
            toSupplierInvoiceWhldgTax = Lists.newArrayList();
        }
        toSupplierInvoiceWhldgTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SupplierInvoice instances.
     *
     */
    public final static class SupplierInvoiceBuilder
    {

        private List<SuplrInvcSeldInbDeliveryNote> toSelectedDeliveryNotes = Lists.newArrayList();
        private List<SuplrInvcSeldPurgDocument> toSelectedPurchaseOrders = Lists.newArrayList();
        private List<SuplrInvcSeldSrvcEntrShtLean> toSelectedServiceEntrySheets = Lists.newArrayList();
        private List<SuplrInvcItemPurOrdRef> toSuplrInvcItemPurOrdRef = Lists.newArrayList();
        private SuplrInvoiceAdditionalData toSuplrInvoiceAdditionalData;
        private List<SupplierInvoiceItemGLAcct> toSupplierInvoiceItemGLAcct = Lists.newArrayList();
        private List<SupplierInvoiceTax> toSupplierInvoiceTax = Lists.newArrayList();
        private List<SuplrInvcHeaderWhldgTax> toSupplierInvoiceWhldgTax = Lists.newArrayList();

        private SupplierInvoice.SupplierInvoiceBuilder toSelectedDeliveryNotes(
            final List<SuplrInvcSeldInbDeliveryNote> value )
        {
            toSelectedDeliveryNotes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SelectedDeliveryNotes</b> for <b>SupplierInvoice</b> to multiple
         * <b>SuplrInvcSeldInbDeliveryNote</b>.
         *
         * @param value
         *            The SuplrInvcSeldInbDeliveryNotes to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder selectedDeliveryNotes( SuplrInvcSeldInbDeliveryNote... value )
        {
            return toSelectedDeliveryNotes(Lists.newArrayList(value));
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSelectedPurchaseOrders(
            final List<SuplrInvcSeldPurgDocument> value )
        {
            toSelectedPurchaseOrders.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SelectedPurchaseOrders</b> for <b>SupplierInvoice</b> to multiple
         * <b>SuplrInvcSeldPurgDocument</b>.
         *
         * @param value
         *            The SuplrInvcSeldPurgDocuments to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder selectedPurchaseOrders( SuplrInvcSeldPurgDocument... value )
        {
            return toSelectedPurchaseOrders(Lists.newArrayList(value));
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSelectedServiceEntrySheets(
            final List<SuplrInvcSeldSrvcEntrShtLean> value )
        {
            toSelectedServiceEntrySheets.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SelectedServiceEntrySheets</b> for <b>SupplierInvoice</b> to multiple
         * <b>SuplrInvcSeldSrvcEntrShtLean</b>.
         *
         * @param value
         *            The SuplrInvcSeldSrvcEntrShtLeans to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder selectedServiceEntrySheets(
            SuplrInvcSeldSrvcEntrShtLean... value )
        {
            return toSelectedServiceEntrySheets(Lists.newArrayList(value));
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSuplrInvcItemPurOrdRef(
            final List<SuplrInvcItemPurOrdRef> value )
        {
            toSuplrInvcItemPurOrdRef.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrInvcItemPurOrdRef</b> for <b>SupplierInvoice</b> to multiple
         * <b>SuplrInvcItemPurOrdRef</b>.
         *
         * @param value
         *            The SuplrInvcItemPurOrdRefs to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder suplrInvcItemPurOrdRef( SuplrInvcItemPurOrdRef... value )
        {
            return toSuplrInvcItemPurOrdRef(Lists.newArrayList(value));
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSuplrInvoiceAdditionalData(
            final SuplrInvoiceAdditionalData value )
        {
            toSuplrInvoiceAdditionalData = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrInvoiceAdditionalData</b> for <b>SupplierInvoice</b> to single
         * <b>SuplrInvoiceAdditionalData</b>.
         *
         * @param value
         *            The SuplrInvoiceAdditionalData to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder suplrInvoiceAdditionalData(
            final SuplrInvoiceAdditionalData value )
        {
            return toSuplrInvoiceAdditionalData(value);
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSupplierInvoiceItemGLAcct(
            final List<SupplierInvoiceItemGLAcct> value )
        {
            toSupplierInvoiceItemGLAcct.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SupplierInvoiceItemGLAcct</b> for <b>SupplierInvoice</b> to multiple
         * <b>SupplierInvoiceItemGLAcct</b>.
         *
         * @param value
         *            The SupplierInvoiceItemGLAccts to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder supplierInvoiceItemGLAcct( SupplierInvoiceItemGLAcct... value )
        {
            return toSupplierInvoiceItemGLAcct(Lists.newArrayList(value));
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSupplierInvoiceTax( final List<SupplierInvoiceTax> value )
        {
            toSupplierInvoiceTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SupplierInvoiceTax</b> for <b>SupplierInvoice</b> to multiple
         * <b>SupplierInvoiceTax</b>.
         *
         * @param value
         *            The SupplierInvoiceTaxs to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder supplierInvoiceTax( SupplierInvoiceTax... value )
        {
            return toSupplierInvoiceTax(Lists.newArrayList(value));
        }

        private SupplierInvoice.SupplierInvoiceBuilder toSupplierInvoiceWhldgTax(
            final List<SuplrInvcHeaderWhldgTax> value )
        {
            toSupplierInvoiceWhldgTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SupplierInvoiceWhldgTax</b> for <b>SupplierInvoice</b> to multiple
         * <b>SuplrInvcHeaderWhldgTax</b>.
         *
         * @param value
         *            The SuplrInvcHeaderWhldgTaxs to build this SupplierInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierInvoice.SupplierInvoiceBuilder supplierInvoiceWhldgTax( SuplrInvcHeaderWhldgTax... value )
        {
            return toSupplierInvoiceWhldgTax(Lists.newArrayList(value));
        }

    }

}
