/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SupplierInvoiceItemGLAcctField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SupplierInvoiceItemGLAcctSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item for G/L Account Posting
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierInvoiceItemGLAcctType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierInvoiceItemGLAcct extends VdmEntity<SupplierInvoiceItemGLAcct>
{

    /**
     * Selector for all available fields of SupplierInvoiceItemGLAcct.
     *
     */
    public final static SupplierInvoiceItemGLAcctSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SUPPLIER_INVOICE =
        new SupplierInvoiceItemGLAcctField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> FISCAL_YEAR =
        new SupplierInvoiceItemGLAcctField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItem</b>
     * </p>
     *
     * @return Four Character Sequential Number for Coding Block
     */
    @Key
    @SerializedName( "SupplierInvoiceItem" )
    @JsonProperty( "SupplierInvoiceItem" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItem" )
    private String supplierInvoiceItem;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItem</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SUPPLIER_INVOICE_ITEM =
        new SupplierInvoiceItemGLAcctField<String>("SupplierInvoiceItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> COMPANY_CODE =
        new SupplierInvoiceItemGLAcctField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> COST_CENTER =
        new SupplierInvoiceItemGLAcctField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> CONTROLLING_AREA =
        new SupplierInvoiceItemGLAcctField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> BUSINESS_AREA =
        new SupplierInvoiceItemGLAcctField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> PROFIT_CENTER =
        new SupplierInvoiceItemGLAcctField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> FUNCTIONAL_AREA =
        new SupplierInvoiceItemGLAcctField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> GL_ACCOUNT =
        new SupplierInvoiceItemGLAcctField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SALES_ORDER =
        new SupplierInvoiceItemGLAcctField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales document item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SALES_ORDER_ITEM =
        new SupplierInvoiceItemGLAcctField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> COST_OBJECT =
        new SupplierInvoiceItemGLAcctField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> COST_CTR_ACTIVITY_TYPE =
        new SupplierInvoiceItemGLAcctField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> BUSINESS_PROCESS =
        new SupplierInvoiceItemGLAcctField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> WBS_ELEMENT =
        new SupplierInvoiceItemGLAcctField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> DOCUMENT_CURRENCY =
        new SupplierInvoiceItemGLAcctField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemAmount</b>
     * </p>
     *
     * @return Amount in Document Currency
     */
    @SerializedName( "SupplierInvoiceItemAmount" )
    @JsonProperty( "SupplierInvoiceItemAmount" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItemAmount" )
    private BigDecimal supplierInvoiceItemAmount;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItemAmount</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<BigDecimal> SUPPLIER_INVOICE_ITEM_AMOUNT =
        new SupplierInvoiceItemGLAcctField<BigDecimal>("SupplierInvoiceItemAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> TAX_CODE =
        new SupplierInvoiceItemGLAcctField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> PERSONNEL_NUMBER =
        new SupplierInvoiceItemGLAcctField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @SerializedName( "WorkItem" )
    @JsonProperty( "WorkItem" )
    @Nullable
    @ODataField( odataName = "WorkItem" )
    private String workItem;
    /**
     * Use with available fluent helpers to apply the <b>WorkItem</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> WORK_ITEM =
        new SupplierInvoiceItemGLAcctField<String>("WorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Indicator
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> DEBIT_CREDIT_CODE =
        new SupplierInvoiceItemGLAcctField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> TAX_JURISDICTION =
        new SupplierInvoiceItemGLAcctField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "SupplierInvoiceItemText" )
    @JsonProperty( "SupplierInvoiceItemText" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItemText" )
    private String supplierInvoiceItemText;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItemText</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SUPPLIER_INVOICE_ITEM_TEXT =
        new SupplierInvoiceItemGLAcctField<String>("SupplierInvoiceItemText");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> ASSIGNMENT_REFERENCE =
        new SupplierInvoiceItemGLAcctField<String>("AssignmentReference");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNotCashDiscountLiable</b>
     * </p>
     *
     * @return Indicator: Line Item Not Liable to Cash Discount?
     */
    @SerializedName( "IsNotCashDiscountLiable" )
    @JsonProperty( "IsNotCashDiscountLiable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNotCashDiscountLiable" )
    private Boolean isNotCashDiscountLiable;
    /**
     * Use with available fluent helpers to apply the <b>IsNotCashDiscountLiable</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<Boolean> IS_NOT_CASH_DISCOUNT_LIABLE =
        new SupplierInvoiceItemGLAcctField<Boolean>("IsNotCashDiscountLiable");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "InternalOrder" )
    @JsonProperty( "InternalOrder" )
    @Nullable
    @ODataField( odataName = "InternalOrder" )
    private String internalOrder;
    /**
     * Use with available fluent helpers to apply the <b>InternalOrder</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> INTERNAL_ORDER =
        new SupplierInvoiceItemGLAcctField<String>("InternalOrder");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> PROJECT_NETWORK =
        new SupplierInvoiceItemGLAcctField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivity</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "NetworkActivity" )
    @JsonProperty( "NetworkActivity" )
    @Nullable
    @ODataField( odataName = "NetworkActivity" )
    private String networkActivity;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivity</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> NETWORK_ACTIVITY =
        new SupplierInvoiceItemGLAcctField<String>("NetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> COMMITMENT_ITEM =
        new SupplierInvoiceItemGLAcctField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> FUNDS_CENTER =
        new SupplierInvoiceItemGLAcctField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountInTransCrcy</b>
     * </p>
     *
     * @return Tax Base Amount in Document Currency
     */
    @SerializedName( "TaxBaseAmountInTransCrcy" )
    @JsonProperty( "TaxBaseAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "TaxBaseAmountInTransCrcy" )
    private BigDecimal taxBaseAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxBaseAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<BigDecimal> TAX_BASE_AMOUNT_IN_TRANS_CRCY =
        new SupplierInvoiceItemGLAcctField<BigDecimal>("TaxBaseAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> FUND =
        new SupplierInvoiceItemGLAcctField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> GRANT_ID =
        new SupplierInvoiceItemGLAcctField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> QUANTITY_UNIT =
        new SupplierInvoiceItemGLAcctField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcItmQtyUnitSAPCode</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "SuplrInvcItmQtyUnitSAPCode" )
    @JsonProperty( "SuplrInvcItmQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "SuplrInvcItmQtyUnitSAPCode" )
    private String suplrInvcItmQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcItmQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SUPLR_INVC_ITM_QTY_UNIT_SAP_CODE =
        new SupplierInvoiceItemGLAcctField<String>("SuplrInvcItmQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcItmQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "SuplrInvcItmQtyUnitISOCode" )
    @JsonProperty( "SuplrInvcItmQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "SuplrInvcItmQtyUnitISOCode" )
    private String suplrInvcItmQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcItmQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> SUPLR_INVC_ITM_QTY_UNIT_ISO_CODE =
        new SupplierInvoiceItemGLAcctField<String>("SuplrInvcItmQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<BigDecimal> QUANTITY =
        new SupplierInvoiceItemGLAcctField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Trading partner's business area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> PARTNER_BUSINESS_AREA =
        new SupplierInvoiceItemGLAcctField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Transaction type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> FINANCIAL_TRANSACTION_TYPE =
        new SupplierInvoiceItemGLAcctField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> TAX_COUNTRY =
        new SupplierInvoiceItemGLAcctField<String>("TaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> EARMARKED_FUNDS_DOCUMENT =
        new SupplierInvoiceItemGLAcctField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentItem</b>
     * </p>
     *
     * @return Earmarked Funds: Document Item
     */
    @SerializedName( "EarmarkedFundsDocumentItem" )
    @JsonProperty( "EarmarkedFundsDocumentItem" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocumentItem" )
    private String earmarkedFundsDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocumentItem</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> EARMARKED_FUNDS_DOCUMENT_ITEM =
        new SupplierInvoiceItemGLAcctField<String>("EarmarkedFundsDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static SupplierInvoiceItemGLAcctField<String> BUDGET_PERIOD =
        new SupplierInvoiceItemGLAcctField<String>("BudgetPeriod");

    @Nonnull
    @Override
    public Class<SupplierInvoiceItemGLAcct> getType()
    {
        return SupplierInvoiceItemGLAcct.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItem</b>
     * </p>
     *
     * @param supplierInvoiceItem
     *            Four Character Sequential Number for Coding Block
     */
    public void setSupplierInvoiceItem( @Nullable final String supplierInvoiceItem )
    {
        rememberChangedField("SupplierInvoiceItem", this.supplierInvoiceItem);
        this.supplierInvoiceItem = supplierInvoiceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales and Distribution Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales document item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemAmount</b>
     * </p>
     *
     * @param supplierInvoiceItemAmount
     *            Amount in Document Currency
     */
    public void setSupplierInvoiceItemAmount( @Nullable final BigDecimal supplierInvoiceItemAmount )
    {
        rememberChangedField("SupplierInvoiceItemAmount", this.supplierInvoiceItemAmount);
        this.supplierInvoiceItemAmount = supplierInvoiceItemAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *            Work Item ID
     */
    public void setWorkItem( @Nullable final String workItem )
    {
        rememberChangedField("WorkItem", this.workItem);
        this.workItem = workItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Indicator
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemText</b>
     * </p>
     *
     * @param supplierInvoiceItemText
     *            Item Text
     */
    public void setSupplierInvoiceItemText( @Nullable final String supplierInvoiceItemText )
    {
        rememberChangedField("SupplierInvoiceItemText", this.supplierInvoiceItemText);
        this.supplierInvoiceItemText = supplierInvoiceItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNotCashDiscountLiable</b>
     * </p>
     *
     * @param isNotCashDiscountLiable
     *            Indicator: Line Item Not Liable to Cash Discount?
     */
    public void setIsNotCashDiscountLiable( @Nullable final Boolean isNotCashDiscountLiable )
    {
        rememberChangedField("IsNotCashDiscountLiable", this.isNotCashDiscountLiable);
        this.isNotCashDiscountLiable = isNotCashDiscountLiable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *            Order Number
     */
    public void setInternalOrder( @Nullable final String internalOrder )
    {
        rememberChangedField("InternalOrder", this.internalOrder);
        this.internalOrder = internalOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivity</b>
     * </p>
     *
     * @param networkActivity
     *            Operation/Activity Number
     */
    public void setNetworkActivity( @Nullable final String networkActivity )
    {
        rememberChangedField("NetworkActivity", this.networkActivity);
        this.networkActivity = networkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountInTransCrcy</b>
     * </p>
     *
     * @param taxBaseAmountInTransCrcy
     *            Tax Base Amount in Document Currency
     */
    public void setTaxBaseAmountInTransCrcy( @Nullable final BigDecimal taxBaseAmountInTransCrcy )
    {
        rememberChangedField("TaxBaseAmountInTransCrcy", this.taxBaseAmountInTransCrcy);
        this.taxBaseAmountInTransCrcy = taxBaseAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Base Unit of Measure
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcItmQtyUnitSAPCode</b>
     * </p>
     *
     * @param suplrInvcItmQtyUnitSAPCode
     *            Base Unit of Measure
     */
    public void setSuplrInvcItmQtyUnitSAPCode( @Nullable final String suplrInvcItmQtyUnitSAPCode )
    {
        rememberChangedField("SuplrInvcItmQtyUnitSAPCode", this.suplrInvcItmQtyUnitSAPCode);
        this.suplrInvcItmQtyUnitSAPCode = suplrInvcItmQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcItmQtyUnitISOCode</b>
     * </p>
     *
     * @param suplrInvcItmQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setSuplrInvcItmQtyUnitISOCode( @Nullable final String suplrInvcItmQtyUnitISOCode )
    {
        rememberChangedField("SuplrInvcItmQtyUnitISOCode", this.suplrInvcItmQtyUnitISOCode);
        this.suplrInvcItmQtyUnitISOCode = suplrInvcItmQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Trading partner's business area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Transaction type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentItem</b>
     * </p>
     *
     * @param earmarkedFundsDocumentItem
     *            Earmarked Funds: Document Item
     */
    public void setEarmarkedFundsDocumentItem( @Nullable final String earmarkedFundsDocumentItem )
    {
        rememberChangedField("EarmarkedFundsDocumentItem", this.earmarkedFundsDocumentItem);
        this.earmarkedFundsDocumentItem = earmarkedFundsDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierInvoiceItemGLAcct";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        result.put("SupplierInvoiceItem", getSupplierInvoiceItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("SupplierInvoiceItem", getSupplierInvoiceItem());
        values.put("CompanyCode", getCompanyCode());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("BusinessArea", getBusinessArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("GLAccount", getGLAccount());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("CostObject", getCostObject());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("WBSElement", getWBSElement());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("SupplierInvoiceItemAmount", getSupplierInvoiceItemAmount());
        values.put("TaxCode", getTaxCode());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("WorkItem", getWorkItem());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("SupplierInvoiceItemText", getSupplierInvoiceItemText());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("IsNotCashDiscountLiable", getIsNotCashDiscountLiable());
        values.put("InternalOrder", getInternalOrder());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("NetworkActivity", getNetworkActivity());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("FundsCenter", getFundsCenter());
        values.put("TaxBaseAmountInTransCrcy", getTaxBaseAmountInTransCrcy());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("SuplrInvcItmQtyUnitSAPCode", getSuplrInvcItmQtyUnitSAPCode());
        values.put("SuplrInvcItmQtyUnitISOCode", getSuplrInvcItmQtyUnitISOCode());
        values.put("Quantity", getQuantity());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("TaxCountry", getTaxCountry());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("EarmarkedFundsDocumentItem", getEarmarkedFundsDocumentItem());
        values.put("BudgetPeriod", getBudgetPeriod());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItem") ) {
                final Object value = values.remove("SupplierInvoiceItem");
                if( (value == null) || (!value.equals(getSupplierInvoiceItem())) ) {
                    setSupplierInvoiceItem(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItemAmount") ) {
                final Object value = values.remove("SupplierInvoiceItemAmount");
                if( (value == null) || (!value.equals(getSupplierInvoiceItemAmount())) ) {
                    setSupplierInvoiceItemAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("WorkItem") ) {
                final Object value = values.remove("WorkItem");
                if( (value == null) || (!value.equals(getWorkItem())) ) {
                    setWorkItem(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItemText") ) {
                final Object value = values.remove("SupplierInvoiceItemText");
                if( (value == null) || (!value.equals(getSupplierInvoiceItemText())) ) {
                    setSupplierInvoiceItemText(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("IsNotCashDiscountLiable") ) {
                final Object value = values.remove("IsNotCashDiscountLiable");
                if( (value == null) || (!value.equals(getIsNotCashDiscountLiable())) ) {
                    setIsNotCashDiscountLiable(((Boolean) value));
                }
            }
            if( values.containsKey("InternalOrder") ) {
                final Object value = values.remove("InternalOrder");
                if( (value == null) || (!value.equals(getInternalOrder())) ) {
                    setInternalOrder(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("NetworkActivity") ) {
                final Object value = values.remove("NetworkActivity");
                if( (value == null) || (!value.equals(getNetworkActivity())) ) {
                    setNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("TaxBaseAmountInTransCrcy") ) {
                final Object value = values.remove("TaxBaseAmountInTransCrcy");
                if( (value == null) || (!value.equals(getTaxBaseAmountInTransCrcy())) ) {
                    setTaxBaseAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcItmQtyUnitSAPCode") ) {
                final Object value = values.remove("SuplrInvcItmQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getSuplrInvcItmQtyUnitSAPCode())) ) {
                    setSuplrInvcItmQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcItmQtyUnitISOCode") ) {
                final Object value = values.remove("SuplrInvcItmQtyUnitISOCode");
                if( (value == null) || (!value.equals(getSuplrInvcItmQtyUnitISOCode())) ) {
                    setSuplrInvcItmQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocumentItem") ) {
                final Object value = values.remove("EarmarkedFundsDocumentItem");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocumentItem())) ) {
                    setEarmarkedFundsDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierInvoiceItemGLAcctField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierInvoiceItemGLAcctField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierInvoiceItemGLAcctField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierInvoiceItemGLAcctField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
