/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SupplierInvoiceIntegrationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService
 * SupplierInvoiceIntegrationService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSupplierInvoiceIntegrationServiceBatch
    extends
    BatchFluentHelperBasic<SupplierInvoiceIntegrationServiceBatch, SupplierInvoiceIntegrationServiceBatchChangeSet>
    implements
    SupplierInvoiceIntegrationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSupplierInvoiceIntegrationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierInvoiceIntegrationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSupplierInvoiceIntegrationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierInvoiceIntegrationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSupplierInvoiceIntegrationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierInvoiceIntegrationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSupplierInvoiceIntegrationServiceBatchChangeSet(this, service);
    }

}
