/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice;

/**
 * Implementation of the {@link SupplierInvoiceIntegrationServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService
 * SupplierInvoiceIntegrationService}.
 *
 */
public class DefaultSupplierInvoiceIntegrationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SupplierInvoiceIntegrationServiceBatch, SupplierInvoiceIntegrationServiceBatchChangeSet>
    implements
    SupplierInvoiceIntegrationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService service;

    @SuppressWarnings( "deprecation" )
    DefaultSupplierInvoiceIntegrationServiceBatchChangeSet(
        @Nonnull final DefaultSupplierInvoiceIntegrationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSupplierInvoiceIntegrationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierInvoiceIntegrationServiceBatchChangeSet createSupplierInvoice(
        @Nonnull final SupplierInvoice supplierInvoice )
    {
        return addRequestCreate(service::createSupplierInvoice, supplierInvoice);
    }

    @Nonnull
    @Override
    public SupplierInvoiceIntegrationServiceBatchChangeSet deleteSupplierInvoice(
        @Nonnull final SupplierInvoice supplierInvoice )
    {
        return addRequestDelete(service::deleteSupplierInvoice, supplierInvoice);
    }

}
