/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService
 * SupplierInvoiceIntegrationService}.
 *
 */
public interface SupplierInvoiceIntegrationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SupplierInvoiceIntegrationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SupplierInvoiceIntegrationServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     * SupplierInvoice} entity and save it to the S/4HANA system.
     *
     * @param supplierInvoice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *            SupplierInvoice} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierInvoiceIntegrationServiceBatchChangeSet
        createSupplierInvoice( @Nonnull final SupplierInvoice supplierInvoice );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     * SupplierInvoice} entity in the S/4HANA system.
     *
     * @param supplierInvoice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *            SupplierInvoice} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierInvoiceIntegrationServiceBatchChangeSet
        deleteSupplierInvoice( @Nonnull final SupplierInvoice supplierInvoice );

}
