/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcct;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SupplierInvoiceItemGLAcctSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcct
 * SupplierInvoiceItemGLAcct} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SupplierInvoiceItemGLAcctLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SupplierInvoiceItemGLAcctLink<ObjectT>, SupplierInvoiceItemGLAcct, ObjectT>
    implements
    SupplierInvoiceItemGLAcctSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SupplierInvoiceItemGLAcctLink( final String fieldName )
    {
        super(fieldName);
    }

    private SupplierInvoiceItemGLAcctLink(
        final EntityLink<SupplierInvoiceItemGLAcctLink<ObjectT>, SupplierInvoiceItemGLAcct, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SupplierInvoiceItemGLAcctLink<ObjectT> translateLinkType(
        final EntityLink<SupplierInvoiceItemGLAcctLink<ObjectT>, SupplierInvoiceItemGLAcct, ObjectT> link )
    {
        return new SupplierInvoiceItemGLAcctLink<ObjectT>(link);
    }

}
