/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
 * SuplrInvcItemAcctAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcItemAcctAssgmtField
 * SuplrInvcItemAcctAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SuplrInvcItemAcctAssgmtLink
 * SuplrInvcItemAcctAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#SUPPLIER_INVOICE_ITEM
 * SUPPLIER_INVOICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#ORDINAL_NUMBER
 * ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#SUPLR_INVC_ACCT_ASSIGNMENT_AMOUNT
 * SUPLR_INVC_ACCT_ASSIGNMENT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PURCHASE_ORDER_QUANTITY_UNIT
 * PURCHASE_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PURCHASE_ORDER_QTY_UNIT_SAP_CODE
 * PURCHASE_ORDER_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PURCHASE_ORDER_QTY_UNIT_ISO_CODE
 * PURCHASE_ORDER_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#ACCOUNT_ASSIGNMENT_IS_UNPLANNED
 * ACCOUNT_ASSIGNMENT_IS_UNPLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#WORK_ITEM
 * WORK_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#INTERNAL_ORDER
 * INTERNAL_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PROJECT_NETWORK_INTERNAL_ID
 * PROJECT_NETWORK_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#NETWORK_ACTIVITY_INTERNAL_ID
 * NETWORK_ACTIVITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#NETWORK_ACTIVITY
 * NETWORK_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#COMMITMENT_ITEM
 * COMMITMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#FUNDS_CENTER
 * FUNDS_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#SUPLR_INVC_ACCOUNT_ASSIGNMENT_TEXT
 * SUPLR_INVC_ACCOUNT_ASSIGNMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PURCHASE_ORDER_PRICE_UNIT
 * PURCHASE_ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PURCHASE_ORDER_PRICE_UNIT_SAP_CODE
 * PURCHASE_ORDER_PRICE_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PURCHASE_ORDER_PRICE_UNIT_ISO_CODE
 * PURCHASE_ORDER_PRICE_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#QUANTITY_IN_PURCHASE_ORDER_UNIT
 * QUANTITY_IN_PURCHASE_ORDER_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#TAX_COUNTRY
 * TAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt#TAX_DETERMINATION_DATE
 * TAX_DETERMINATION_DATE}</li>
 * </ul>
 *
 */
public interface SuplrInvcItemAcctAssgmtSelectable extends EntitySelectable<SuplrInvcItemAcctAssgmt>
{

}
