/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef
 * SuplrInvcItemPurOrdRef}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcItemPurOrdRefField
 * SuplrInvcItemPurOrdRefField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SuplrInvcItemPurOrdRefLink
 * SuplrInvcItemPurOrdRefLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPPLIER_INVOICE_ITEM
 * SUPPLIER_INVOICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_ITEM
 * PURCHASE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#REFERENCE_DOCUMENT_FISCAL_YEAR
 * REFERENCE_DOCUMENT_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#REFERENCE_DOCUMENT_ITEM
 * REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#IS_SUBSEQUENT_DEBIT_CREDIT
 * IS_SUBSEQUENT_DEBIT_CREDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPPLIER_INVOICE_ITEM_AMOUNT
 * SUPPLIER_INVOICE_ITEM_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_QUANTITY_UNIT
 * PURCHASE_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_QTY_UNIT_SAP_CODE
 * PURCHASE_ORDER_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_QTY_UNIT_ISO_CODE
 * PURCHASE_ORDER_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#QUANTITY_IN_PURCHASE_ORDER_UNIT
 * QUANTITY_IN_PURCHASE_ORDER_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_PRICE_UNIT
 * PURCHASE_ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_PRICE_UNIT_SAP_CODE
 * PURCHASE_ORDER_PRICE_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASE_ORDER_PRICE_UNIT_ISO_CODE
 * PURCHASE_ORDER_PRICE_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#QTY_IN_PURCHASE_ORDER_PRICE_UNIT
 * QTY_IN_PURCHASE_ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPLR_INVC_DELIVERY_COST_CNDN_TYPE
 * SUPLR_INVC_DELIVERY_COST_CNDN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPLR_INVC_DELIVERY_COST_CNDN_STEP
 * SUPLR_INVC_DELIVERY_COST_CNDN_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPLR_INVC_DELIVERY_COST_CNDN_COUNT
 * SUPLR_INVC_DELIVERY_COST_CNDN_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPPLIER_INVOICE_ITEM_TEXT
 * SUPPLIER_INVOICE_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#FREIGHT_SUPPLIER
 * FREIGHT_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#IS_NOT_CASH_DISCOUNT_LIABLE
 * IS_NOT_CASH_DISCOUNT_LIABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PURCHASING_DOCUMENT_ITEM_CATEGORY
 * PURCHASING_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#PRODUCT_TYPE
 * PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#RETENTION_AMOUNT_IN_DOC_CURRENCY
 * RETENTION_AMOUNT_IN_DOC_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#RETENTION_PERCENTAGE
 * RETENTION_PERCENTAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#RETENTION_DUE_DATE
 * RETENTION_DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SUPLR_INVC_ITM_IS_NOT_RLVT_FOR_RTNTN
 * SUPLR_INVC_ITM_IS_NOT_RLVT_FOR_RTNTN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SERVICE_ENTRY_SHEET
 * SERVICE_ENTRY_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#SERVICE_ENTRY_SHEET_ITEM
 * SERVICE_ENTRY_SHEET_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#TAX_COUNTRY
 * TAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#IS_FINALLY_INVOICED
 * IS_FINALLY_INVOICED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#TAX_DETERMINATION_DATE
 * TAX_DETERMINATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#INHSN_OR_SAC_CODE
 * INHSN_OR_SAC_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#IN_CUSTOM_DUTY_ASSESSABLE_VALUE
 * IN_CUSTOM_DUTY_ASSESSABLE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef#TO_SUPPLIER_INVOICE_ITM_ACCT_ASSGMT
 * TO_SUPPLIER_INVOICE_ITM_ACCT_ASSGMT}</li>
 * </ul>
 *
 */
public interface SuplrInvcItemPurOrdRefSelectable extends EntitySelectable<SuplrInvcItemPurOrdRef>
{

}
