/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote
 * SuplrInvcSeldInbDeliveryNote}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcSeldInbDeliveryNoteField
 * SuplrInvcSeldInbDeliveryNoteField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SuplrInvcSeldInbDeliveryNoteLink
 * SuplrInvcSeldInbDeliveryNoteLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote#INBOUND_DELIVERY_NOTE
 * INBOUND_DELIVERY_NOTE}</li>
 * </ul>
 *
 */
public interface SuplrInvcSeldInbDeliveryNoteSelectable extends EntitySelectable<SuplrInvcSeldInbDeliveryNote>
{

}
