/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
 * SuplrInvcSeldSrvcEntrShtLean}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcSeldSrvcEntrShtLeanField
 * SuplrInvcSeldSrvcEntrShtLeanField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SuplrInvcSeldSrvcEntrShtLeanLink
 * SuplrInvcSeldSrvcEntrShtLeanLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean#SERVICE_ENTRY_SHEET
 * SERVICE_ENTRY_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean#SERVICE_ENTRY_SHEET_ITEM
 * SERVICE_ENTRY_SHEET_ITEM}</li>
 * </ul>
 *
 */
public interface SuplrInvcSeldSrvcEntrShtLeanSelectable extends EntitySelectable<SuplrInvcSeldSrvcEntrShtLean>
{

}
