/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData
 * SuplrInvoiceAdditionalData}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvoiceAdditionalDataField
 * SuplrInvoiceAdditionalDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SuplrInvoiceAdditionalDataLink
 * SuplrInvoiceAdditionalDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#INVOICING_PARTY_NAME1
 * INVOICING_PARTY_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#INVOICING_PARTY_NAME2
 * INVOICING_PARTY_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#INVOICING_PARTY_NAME3
 * INVOICING_PARTY_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#INVOICING_PARTY_NAME4
 * INVOICING_PARTY_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#STREET_ADDRESS_NAME
 * STREET_ADDRESS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#PO_BOX
 * PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#POST_OFFICE_BANK_ACCOUNT
 * POST_OFFICE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#BANK_ACCOUNT
 * BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#BANK
 * BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#BANK_COUNTRY
 * BANK_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#TAX_I_D1
 * TAX_I_D1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#TAX_I_D2
 * TAX_I_D2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#ONE_TME_ACCOUNT_IS_VAT_LIABLE
 * ONE_TME_ACCOUNT_IS_VAT_LIABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#ONE_TME_ACCT_IS_EQUALIZATION_TX_SUBJ
 * ONE_TME_ACCT_IS_EQUALIZATION_TX_SUBJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#BANK_CONTROL_KEY
 * BANK_CONTROL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#DATA_EXCHANGE_INSTRUCTION_KEY
 * DATA_EXCHANGE_INSTRUCTION_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#DATA_MEDIUM_EXCHANGE_INDICATOR
 * DATA_MEDIUM_EXCHANGE_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#LANGUAGE_CODE
 * LANGUAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#IS_ONE_TIME_ACCOUNT
 * IS_ONE_TIME_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#PAYMENT_RECIPIENT
 * PAYMENT_RECIPIENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#ACCOUNT_TAX_TYPE
 * ACCOUNT_TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#TAX_NUMBER_TYPE
 * TAX_NUMBER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#IS_NATURAL_PERSON
 * IS_NATURAL_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#TAX_I_D3
 * TAX_I_D3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#TAX_I_D4
 * TAX_I_D4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#BANK_DETAIL_REFERENCE
 * BANK_DETAIL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#REPRESENTATIVE_NAME
 * REPRESENTATIVE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#BUSINESS_TYPE
 * BUSINESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#INDUSTRY_TYPE
 * INDUSTRY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#FORM_OF_ADDRESS_NAME
 * FORM_OF_ADDRESS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#VAT_REGISTRATION
 * VAT_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#ONE_TIME_ACCT_CNTRY_SPECIFIC_REF1
 * ONE_TIME_ACCT_CNTRY_SPECIFIC_REF1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#IBAN
 * IBAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData#SWIFT_CODE
 * SWIFT_CODE}</li>
 * </ul>
 *
 */
public interface SuplrInvoiceAdditionalDataSelectable extends EntitySelectable<SuplrInvoiceAdditionalData>
{

}
