/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
 * SupplierInvoice}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SupplierInvoiceField
 * SupplierInvoiceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SupplierInvoiceLink
 * SupplierInvoiceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_INVOICE_ID_BY_INVCG_PARTY
 * SUPPLIER_INVOICE_ID_BY_INVCG_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INVOICING_PARTY
 * INVOICING_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INVOICE_GROSS_AMOUNT
 * INVOICE_GROSS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#UNPLANNED_DELIVERY_COST
 * UNPLANNED_DELIVERY_COST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#DOCUMENT_HEADER_TEXT
 * DOCUMENT_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#MANUAL_CASH_DISCOUNT
 * MANUAL_CASH_DISCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#DUE_CALCULATION_BASE_DATE
 * DUE_CALCULATION_BASE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#CASH_DISCOUNT1_PERCENT
 * CASH_DISCOUNT1_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#CASH_DISCOUNT1_DAYS
 * CASH_DISCOUNT1_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#CASH_DISCOUNT2_PERCENT
 * CASH_DISCOUNT2_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#CASH_DISCOUNT2_DAYS
 * CASH_DISCOUNT2_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#NET_PAYMENT_DAYS
 * NET_PAYMENT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYMENT_BLOCKING_REASON
 * PAYMENT_BLOCKING_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#ACCOUNTING_DOCUMENT_TYPE
 * ACCOUNTING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#BP_BANK_ACCOUNT_INTERNAL_ID
 * BP_BANK_ACCOUNT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_INVOICE_STATUS
 * SUPPLIER_INVOICE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INDIRECT_QUOTED_EXCHANGE_RATE
 * INDIRECT_QUOTED_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#DIRECT_QUOTED_EXCHANGE_RATE
 * DIRECT_QUOTED_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#STATE_CENTRAL_BANK_PAYMENT_REASON
 * STATE_CENTRAL_BANK_PAYMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLYING_COUNTRY
 * SUPPLYING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYMENT_METHOD_SUPPLEMENT
 * PAYMENT_METHOD_SUPPLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYMENT_REFERENCE
 * PAYMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INVOICE_REFERENCE
 * INVOICE_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INVOICE_REFERENCE_FISCAL_YEAR
 * INVOICE_REFERENCE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#FIXED_CASH_DISCOUNT
 * FIXED_CASH_DISCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#UNPLANNED_DELIVERY_COST_TAX_CODE
 * UNPLANNED_DELIVERY_COST_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#UNPLND_DELIV_COST_TAX_JURISDICTION
 * UNPLND_DELIV_COST_TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#UNPLND_DELIVERY_COST_TAX_COUNTRY
 * UNPLND_DELIVERY_COST_TAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_POSTING_LINE_ITEM_TEXT
 * SUPPLIER_POSTING_LINE_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TAX_IS_CALCULATED_AUTOMATICALLY
 * TAX_IS_CALCULATED_AUTOMATICALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#BUSINESS_PLACE
 * BUSINESS_PLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#BUSINESS_SECTION_CODE
 * BUSINESS_SECTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPLR_INVC_IS_CAPITAL_GOODS_RELATED
 * SUPLR_INVC_IS_CAPITAL_GOODS_RELATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_INVOICE_IS_CREDIT_MEMO
 * SUPPLIER_INVOICE_IS_CREDIT_MEMO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYT_SLIP_WTH_REF_SUBSCRIBER
 * PAYT_SLIP_WTH_REF_SUBSCRIBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYT_SLIP_WTH_REF_CHECK_DIGIT
 * PAYT_SLIP_WTH_REF_CHECK_DIGIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#PAYT_SLIP_WTH_REF_REFERENCE
 * PAYT_SLIP_WTH_REF_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TAX_DETERMINATION_DATE
 * TAX_DETERMINATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TAX_REPORTING_DATE
 * TAX_REPORTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TAX_FULFILLMENT_DATE
 * TAX_FULFILLMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INVOICE_RECEIPT_DATE
 * INVOICE_RECEIPT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#DELIVERY_OF_GOODS_REPORTING_CNTRY
 * DELIVERY_OF_GOODS_REPORTING_CNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_VAT_REGISTRATION
 * SUPPLIER_VAT_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#IS_EU_TRIANGULAR_DEAL
 * IS_EU_TRIANGULAR_DEAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPLR_INVC_DEBIT_CRDT_CODE_DELIVERY
 * SUPLR_INVC_DEBIT_CRDT_CODE_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPLR_INVC_DEBIT_CRDT_CODE_RETURNS
 * SUPLR_INVC_DEBIT_CRDT_CODE_RETURNS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#RETENTION_DUE_DATE
 * RETENTION_DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#SUPPLIER_INVOICE_ORIGIN
 * SUPPLIER_INVOICE_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#REVERSE_DOCUMENT
 * REVERSE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#REVERSE_DOCUMENT_FISCAL_YEAR
 * REVERSE_DOCUMENT_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#IS_REVERSAL
 * IS_REVERSAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#IS_REVERSED
 * IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INGST_PARTNER
 * INGST_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#INGST_PLACE_OF_SUPPLY
 * INGST_PLACE_OF_SUPPLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#IN_INVOICE_REFERENCE_NUMBER
 * IN_INVOICE_REFERENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_REF1
 * JRNL_ENTRY_CNTRY_SPECIFIC_REF1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_DATE1
 * JRNL_ENTRY_CNTRY_SPECIFIC_DATE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_REF2
 * JRNL_ENTRY_CNTRY_SPECIFIC_REF2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_DATE2
 * JRNL_ENTRY_CNTRY_SPECIFIC_DATE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_REF3
 * JRNL_ENTRY_CNTRY_SPECIFIC_REF3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_DATE3
 * JRNL_ENTRY_CNTRY_SPECIFIC_DATE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_REF4
 * JRNL_ENTRY_CNTRY_SPECIFIC_REF4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_DATE4
 * JRNL_ENTRY_CNTRY_SPECIFIC_DATE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_REF5
 * JRNL_ENTRY_CNTRY_SPECIFIC_REF5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_DATE5
 * JRNL_ENTRY_CNTRY_SPECIFIC_DATE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_B_P1
 * JRNL_ENTRY_CNTRY_SPECIFIC_B_P1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#JRNL_ENTRY_CNTRY_SPECIFIC_B_P2
 * JRNL_ENTRY_CNTRY_SPECIFIC_B_P2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SELECTED_DELIVERY_NOTES
 * TO_SELECTED_DELIVERY_NOTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SELECTED_PURCHASE_ORDERS
 * TO_SELECTED_PURCHASE_ORDERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SELECTED_SERVICE_ENTRY_SHEETS
 * TO_SELECTED_SERVICE_ENTRY_SHEETS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SUPLR_INVC_ITEM_PUR_ORD_REF
 * TO_SUPLR_INVC_ITEM_PUR_ORD_REF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SUPLR_INVOICE_ADDITIONAL_DATA
 * TO_SUPLR_INVOICE_ADDITIONAL_DATA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SUPPLIER_INVOICE_ITEM_GL_ACCT
 * TO_SUPPLIER_INVOICE_ITEM_GL_ACCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SUPPLIER_INVOICE_TAX
 * TO_SUPPLIER_INVOICE_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice#TO_SUPPLIER_INVOICE_WHLDG_TAX
 * TO_SUPPLIER_INVOICE_WHLDG_TAX}</li>
 * </ul>
 *
 */
public interface SupplierInvoiceSelectable extends EntitySelectable<SupplierInvoice>
{

}
