/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax
 * SupplierInvoiceTax}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SupplierInvoiceTaxField
 * SupplierInvoiceTaxField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SupplierInvoiceTaxLink
 * SupplierInvoiceTaxLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#SUPPLIER_INVOICE
 * SUPPLIER_INVOICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#SUPPLIER_INVOICE_TAX_COUNTER
 * SUPPLIER_INVOICE_TAX_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#TAX_AMOUNT
 * TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#TAX_BASE_AMOUNT_IN_TRANS_CRCY
 * TAX_BASE_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax#TAX_COUNTRY
 * TAX_COUNTRY}</li>
 * </ul>
 *
 */
public interface SupplierInvoiceTaxSelectable extends EntitySelectable<SupplierInvoiceTax>
{

}
