/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>CreateExportParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreateExportParameters extends VdmComplex<CreateExportParameters>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *
     * @return Quotation
     */
    @SerializedName( "SupplierQuotation" )
    @JsonProperty( "SupplierQuotation" )
    @Nullable
    @ODataField( odataName = "SupplierQuotation" )
    private String supplierQuotation;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *
     * @return Doc. Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *
     * @return Quotation Type
     */
    @SerializedName( "PurchasingDocumentType" )
    @JsonProperty( "PurchasingDocumentType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentType" )
    private String purchasingDocumentType;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *
     * @return Last Changed
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDateTime;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *
     * @return Currency
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *
     * @return Incoterms
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *
     * @return Incoterms 2
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *
     * @return Inco. Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *
     * @return Inco. Location1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *
     * @return Inco. Location2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *
     * @return Payment Terms
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *
     * @return Days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *
     * @return Days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *
     * @return Disc.percent 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *
     * @return Disc.percent 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *
     * @return Days Net
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *
     * @return Procedure
     */
    @SerializedName( "PricingProcedure" )
    @JsonProperty( "PricingProcedure" )
    @Nullable
    @ODataField( odataName = "PricingProcedure" )
    private String pricingProcedure;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentCondition</b>
     * </p>
     *
     * @param purchasingDocumentCondition
     *
     * @return Doc. Condition
     */
    @SerializedName( "PurchasingDocumentCondition" )
    @JsonProperty( "PurchasingDocumentCondition" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCondition" )
    private String purchasingDocumentCondition;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *
     * @return Purch. Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentOrderDate</b>
     * </p>
     *
     * @param purchasingDocumentOrderDate
     *
     * @return Document Date
     */
    @SerializedName( "PurchasingDocumentOrderDate" )
    @JsonProperty( "PurchasingDocumentOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurchasingDocumentOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purchasingDocumentOrderDate;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *
     * @return Exchange Rate
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private String exchangeRate;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *
     * @return Fixed Exch.Rate
     */
    @SerializedName( "ExchangeRateIsFixed" )
    @JsonProperty( "ExchangeRateIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchangeRateIsFixed" )
    private Boolean exchangeRateIsFixed;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *
     * @return RFQ
     */
    @SerializedName( "RequestForQuotation" )
    @JsonProperty( "RequestForQuotation" )
    @Nullable
    @ODataField( odataName = "RequestForQuotation" )
    private String requestForQuotation;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @param supplierQuotationExternalID
     *
     * @return Quotation
     */
    @SerializedName( "SupplierQuotationExternalID" )
    @JsonProperty( "SupplierQuotationExternalID" )
    @Nullable
    @ODataField( odataName = "SupplierQuotationExternalID" )
    private String supplierQuotationExternalID;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @param quotationSubmissionDate
     *
     * @return Quotation Date
     */
    @SerializedName( "QuotationSubmissionDate" )
    @JsonProperty( "QuotationSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationSubmissionDate;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>QuotationLatestSubmissionDate</b>
     * </p>
     *
     * @param quotationLatestSubmissionDate
     *
     * @return Quot. Deadline
     */
    @SerializedName( "QuotationLatestSubmissionDate" )
    @JsonProperty( "QuotationLatestSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationLatestSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationLatestSubmissionDate;
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>BindingPeriodValidityEndDate</b>
     * </p>
     *
     * @param bindingPeriodValidityEndDate
     *
     * @return Binding Period
     */
    @SerializedName( "BindingPeriodValidityEndDate" )
    @JsonProperty( "BindingPeriodValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BindingPeriodValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bindingPeriodValidityEndDate;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>QTNLifecycleStatus</b>
     * </p>
     *
     * @param qTNLifecycleStatus
     *
     * @return Status
     */
    @SerializedName( "QTNLifecycleStatus" )
    @JsonProperty( "QTNLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "QTNLifecycleStatus" )
    private String qTNLifecycleStatus;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>FollowOnDocumentCategory</b>
     * </p>
     *
     * @param followOnDocumentCategory
     *
     * @return Follow-On Doc. Cat.
     */
    @SerializedName( "FollowOnDocumentCategory" )
    @JsonProperty( "FollowOnDocumentCategory" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentCategory" )
    private String followOnDocumentCategory;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @param followOnDocumentType
     *
     * @return Follow-On Doc. Type
     */
    @SerializedName( "FollowOnDocumentType" )
    @JsonProperty( "FollowOnDocumentType" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentType" )
    private String followOnDocumentType;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *
     * @return Business Purp Compl
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;

    @Nonnull
    @Override
    public Class<CreateExportParameters> getType()
    {
        return CreateExportParameters.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierQuotation", getSupplierQuotation());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentType", getPurchasingDocumentType());
        values.put("Supplier", getSupplier());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Language", getLanguage());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("PricingProcedure", getPricingProcedure());
        values.put("PurchasingDocumentCondition", getPurchasingDocumentCondition());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingDocumentOrderDate", getPurchasingDocumentOrderDate());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("RequestForQuotation", getRequestForQuotation());
        values.put("SupplierQuotationExternalID", getSupplierQuotationExternalID());
        values.put("QuotationSubmissionDate", getQuotationSubmissionDate());
        values.put("QuotationLatestSubmissionDate", getQuotationLatestSubmissionDate());
        values.put("BindingPeriodValidityEndDate", getBindingPeriodValidityEndDate());
        values.put("QTNLifecycleStatus", getQTNLifecycleStatus());
        values.put("FollowOnDocumentCategory", getFollowOnDocumentCategory());
        values.put("FollowOnDocumentType", getFollowOnDocumentType());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierQuotation") ) {
                final Object value = values.remove("SupplierQuotation");
                if( (value == null) || (!value.equals(getSupplierQuotation())) ) {
                    setSupplierQuotation(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentType") ) {
                final Object value = values.remove("PurchasingDocumentType");
                if( (value == null) || (!value.equals(getPurchasingDocumentType())) ) {
                    setPurchasingDocumentType(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PricingProcedure") ) {
                final Object value = values.remove("PricingProcedure");
                if( (value == null) || (!value.equals(getPricingProcedure())) ) {
                    setPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCondition") ) {
                final Object value = values.remove("PurchasingDocumentCondition");
                if( (value == null) || (!value.equals(getPurchasingDocumentCondition())) ) {
                    setPurchasingDocumentCondition(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentOrderDate") ) {
                final Object value = values.remove("PurchasingDocumentOrderDate");
                if( (value == null) || (!value.equals(getPurchasingDocumentOrderDate())) ) {
                    setPurchasingDocumentOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("RequestForQuotation") ) {
                final Object value = values.remove("RequestForQuotation");
                if( (value == null) || (!value.equals(getRequestForQuotation())) ) {
                    setRequestForQuotation(((String) value));
                }
            }
            if( values.containsKey("SupplierQuotationExternalID") ) {
                final Object value = values.remove("SupplierQuotationExternalID");
                if( (value == null) || (!value.equals(getSupplierQuotationExternalID())) ) {
                    setSupplierQuotationExternalID(((String) value));
                }
            }
            if( values.containsKey("QuotationSubmissionDate") ) {
                final Object value = values.remove("QuotationSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationSubmissionDate())) ) {
                    setQuotationSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QuotationLatestSubmissionDate") ) {
                final Object value = values.remove("QuotationLatestSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationLatestSubmissionDate())) ) {
                    setQuotationLatestSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BindingPeriodValidityEndDate") ) {
                final Object value = values.remove("BindingPeriodValidityEndDate");
                if( (value == null) || (!value.equals(getBindingPeriodValidityEndDate())) ) {
                    setBindingPeriodValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QTNLifecycleStatus") ) {
                final Object value = values.remove("QTNLifecycleStatus");
                if( (value == null) || (!value.equals(getQTNLifecycleStatus())) ) {
                    setQTNLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentCategory") ) {
                final Object value = values.remove("FollowOnDocumentCategory");
                if( (value == null) || (!value.equals(getFollowOnDocumentCategory())) ) {
                    setFollowOnDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentType") ) {
                final Object value = values.remove("FollowOnDocumentType");
                if( (value == null) || (!value.equals(getFollowOnDocumentType())) ) {
                    setFollowOnDocumentType(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *            Quotation
     */
    public void setSupplierQuotation( @Nullable final String supplierQuotation )
    {
        rememberChangedField("SupplierQuotation", this.supplierQuotation);
        this.supplierQuotation = supplierQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Doc. Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *            Quotation Type
     */
    public void setPurchasingDocumentType( @Nullable final String purchasingDocumentType )
    {
        rememberChangedField("PurchasingDocumentType", this.purchasingDocumentType);
        this.purchasingDocumentType = purchasingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Changed
     */
    public void setLastChangeDateTime( @Nullable final LocalDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms 2
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Inco. Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Inco. Location1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Inco. Location2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Payment Terms
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Disc.percent 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Disc.percent 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Days Net
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *            Procedure
     */
    public void setPricingProcedure( @Nullable final String pricingProcedure )
    {
        rememberChangedField("PricingProcedure", this.pricingProcedure);
        this.pricingProcedure = pricingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentCondition</b>
     * </p>
     *
     * @param purchasingDocumentCondition
     *            Doc. Condition
     */
    public void setPurchasingDocumentCondition( @Nullable final String purchasingDocumentCondition )
    {
        rememberChangedField("PurchasingDocumentCondition", this.purchasingDocumentCondition);
        this.purchasingDocumentCondition = purchasingDocumentCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purch. Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>PurchasingDocumentOrderDate</b>
     * </p>
     *
     * @param purchasingDocumentOrderDate
     *            Document Date
     */
    public void setPurchasingDocumentOrderDate( @Nullable final LocalDateTime purchasingDocumentOrderDate )
    {
        rememberChangedField("PurchasingDocumentOrderDate", this.purchasingDocumentOrderDate);
        this.purchasingDocumentOrderDate = purchasingDocumentOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            Exchange Rate
     */
    public void setExchangeRate( @Nullable final String exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *            Fixed Exch.Rate
     */
    public void setExchangeRateIsFixed( @Nullable final Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *            RFQ
     */
    public void setRequestForQuotation( @Nullable final String requestForQuotation )
    {
        rememberChangedField("RequestForQuotation", this.requestForQuotation);
        this.requestForQuotation = requestForQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @param supplierQuotationExternalID
     *            Quotation
     */
    public void setSupplierQuotationExternalID( @Nullable final String supplierQuotationExternalID )
    {
        rememberChangedField("SupplierQuotationExternalID", this.supplierQuotationExternalID);
        this.supplierQuotationExternalID = supplierQuotationExternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @param quotationSubmissionDate
     *            Quotation Date
     */
    public void setQuotationSubmissionDate( @Nullable final LocalDateTime quotationSubmissionDate )
    {
        rememberChangedField("QuotationSubmissionDate", this.quotationSubmissionDate);
        this.quotationSubmissionDate = quotationSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>QuotationLatestSubmissionDate</b>
     * </p>
     *
     * @param quotationLatestSubmissionDate
     *            Quot. Deadline
     */
    public void setQuotationLatestSubmissionDate( @Nullable final LocalDateTime quotationLatestSubmissionDate )
    {
        rememberChangedField("QuotationLatestSubmissionDate", this.quotationLatestSubmissionDate);
        this.quotationLatestSubmissionDate = quotationLatestSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property from the Odata EDM: <b>BindingPeriodValidityEndDate</b>
     * </p>
     *
     * @param bindingPeriodValidityEndDate
     *            Binding Period
     */
    public void setBindingPeriodValidityEndDate( @Nullable final LocalDateTime bindingPeriodValidityEndDate )
    {
        rememberChangedField("BindingPeriodValidityEndDate", this.bindingPeriodValidityEndDate);
        this.bindingPeriodValidityEndDate = bindingPeriodValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>QTNLifecycleStatus</b>
     * </p>
     *
     * @param qTNLifecycleStatus
     *            Status
     */
    public void setQTNLifecycleStatus( @Nullable final String qTNLifecycleStatus )
    {
        rememberChangedField("QTNLifecycleStatus", this.qTNLifecycleStatus);
        this.qTNLifecycleStatus = qTNLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>FollowOnDocumentCategory</b>
     * </p>
     *
     * @param followOnDocumentCategory
     *            Follow-On Doc. Cat.
     */
    public void setFollowOnDocumentCategory( @Nullable final String followOnDocumentCategory )
    {
        rememberChangedField("FollowOnDocumentCategory", this.followOnDocumentCategory);
        this.followOnDocumentCategory = followOnDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @param followOnDocumentType
     *            Follow-On Doc. Type
     */
    public void setFollowOnDocumentType( @Nullable final String followOnDocumentType )
    {
        rememberChangedField("FollowOnDocumentType", this.followOnDocumentType);
        this.followOnDocumentType = followOnDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purp Compl
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

}
