/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.field.SupplierQuotationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.link.SupplierQuotationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.selectable.SupplierQuotationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Supplier Quotation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierQuotationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierQuotation extends VdmEntity<SupplierQuotation>
{

    /**
     * Selector for all available fields of SupplierQuotation.
     *
     */
    public final static SupplierQuotationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @return Supplier Quotation Number
     */
    @Key
    @SerializedName( "SupplierQuotation" )
    @JsonProperty( "SupplierQuotation" )
    @Nullable
    @ODataField( odataName = "SupplierQuotation" )
    private String supplierQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotation</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> SUPPLIER_QUOTATION =
        new SupplierQuotationField<String>("SupplierQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> COMPANY_CODE = new SupplierQuotationField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PURCHASING_DOCUMENT_CATEGORY =
        new SupplierQuotationField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @return Supplier Quotation Document Type
     */
    @SerializedName( "PurchasingDocumentType" )
    @JsonProperty( "PurchasingDocumentType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentType" )
    private String purchasingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentType</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PURCHASING_DOCUMENT_TYPE =
        new SupplierQuotationField<String>("PurchasingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> SUPPLIER = new SupplierQuotationField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User of person who created a purchasing document
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> CREATED_BY_USER =
        new SupplierQuotationField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date of Purchasing Document
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<LocalDateTime> CREATION_DATE =
        new SupplierQuotationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Change Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new SupplierQuotationField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> LANGUAGE = new SupplierQuotationField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> DOCUMENT_CURRENCY =
        new SupplierQuotationField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> INCOTERMS_CLASSIFICATION =
        new SupplierQuotationField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> INCOTERMS_TRANSFER_LOCATION =
        new SupplierQuotationField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> INCOTERMS_VERSION =
        new SupplierQuotationField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> INCOTERMS_LOCATION1 =
        new SupplierQuotationField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> INCOTERMS_LOCATION2 =
        new SupplierQuotationField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PAYMENT_TERMS =
        new SupplierQuotationField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new SupplierQuotationField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new SupplierQuotationField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new SupplierQuotationField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new SupplierQuotationField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<BigDecimal> NET_PAYMENT_DAYS =
        new SupplierQuotationField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @SerializedName( "PricingProcedure" )
    @JsonProperty( "PricingProcedure" )
    @Nullable
    @ODataField( odataName = "PricingProcedure" )
    private String pricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedure</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PRICING_PROCEDURE =
        new SupplierQuotationField<String>("PricingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCondition</b>
     * </p>
     *
     * @return Number of the Document Condition
     */
    @SerializedName( "PurchasingDocumentCondition" )
    @JsonProperty( "PurchasingDocumentCondition" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCondition" )
    private String purchasingDocumentCondition;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCondition</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PURCHASING_DOCUMENT_CONDITION =
        new SupplierQuotationField<String>("PurchasingDocumentCondition");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PURCHASING_ORGANIZATION =
        new SupplierQuotationField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> PURCHASING_GROUP =
        new SupplierQuotationField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrderDate</b>
     * </p>
     *
     * @return Purchasing Document Date
     */
    @SerializedName( "PurchasingDocumentOrderDate" )
    @JsonProperty( "PurchasingDocumentOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurchasingDocumentOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purchasingDocumentOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentOrderDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<LocalDateTime> PURCHASING_DOCUMENT_ORDER_DATE =
        new SupplierQuotationField<LocalDateTime>("PurchasingDocumentOrderDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @return The exchangeRate contained in this entity.
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private String exchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRate</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> EXCHANGE_RATE =
        new SupplierQuotationField<String>("ExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @return Indicator for Fixed Exchange Rate
     */
    @SerializedName( "ExchangeRateIsFixed" )
    @JsonProperty( "ExchangeRateIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchangeRateIsFixed" )
    private Boolean exchangeRateIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateIsFixed</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<Boolean> EXCHANGE_RATE_IS_FIXED =
        new SupplierQuotationField<Boolean>("ExchangeRateIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @return Request for Quotation
     */
    @SerializedName( "RequestForQuotation" )
    @JsonProperty( "RequestForQuotation" )
    @Nullable
    @ODataField( odataName = "RequestForQuotation" )
    private String requestForQuotation;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotation</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> REQUEST_FOR_QUOTATION =
        new SupplierQuotationField<String>("RequestForQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @return Quotation Number
     */
    @SerializedName( "SupplierQuotationExternalID" )
    @JsonProperty( "SupplierQuotationExternalID" )
    @Nullable
    @ODataField( odataName = "SupplierQuotationExternalID" )
    private String supplierQuotationExternalID;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotationExternalID</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> SUPPLIER_QUOTATION_EXTERNAL_ID =
        new SupplierQuotationField<String>("SupplierQuotationExternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @return Quotation Submission Date
     */
    @SerializedName( "QuotationSubmissionDate" )
    @JsonProperty( "QuotationSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationSubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationSubmissionDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<LocalDateTime> QUOTATION_SUBMISSION_DATE =
        new SupplierQuotationField<LocalDateTime>("QuotationSubmissionDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationLatestSubmissionDate</b>
     * </p>
     *
     * @return Deadline for Submission of Bid/Quotation
     */
    @SerializedName( "QuotationLatestSubmissionDate" )
    @JsonProperty( "QuotationLatestSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationLatestSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationLatestSubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationLatestSubmissionDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<LocalDateTime> QUOTATION_LATEST_SUBMISSION_DATE =
        new SupplierQuotationField<LocalDateTime>("QuotationLatestSubmissionDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BindingPeriodValidityEndDate</b>
     * </p>
     *
     * @return Binding Period for Quotation
     */
    @SerializedName( "BindingPeriodValidityEndDate" )
    @JsonProperty( "BindingPeriodValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BindingPeriodValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bindingPeriodValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BindingPeriodValidityEndDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<LocalDateTime> BINDING_PERIOD_VALIDITY_END_DATE =
        new SupplierQuotationField<LocalDateTime>("BindingPeriodValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>QTNLifecycleStatus</b>
     * </p>
     *
     * @return Supplier Quotation Lifecycle Status
     */
    @SerializedName( "QTNLifecycleStatus" )
    @JsonProperty( "QTNLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "QTNLifecycleStatus" )
    private String qTNLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>QTNLifecycleStatus</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> QTN_LIFECYCLE_STATUS =
        new SupplierQuotationField<String>("QTNLifecycleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentCategory</b>
     * </p>
     *
     * @return Follow-On Purchasing Document Category
     */
    @SerializedName( "FollowOnDocumentCategory" )
    @JsonProperty( "FollowOnDocumentCategory" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentCategory" )
    private String followOnDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>FollowOnDocumentCategory</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> FOLLOW_ON_DOCUMENT_CATEGORY =
        new SupplierQuotationField<String>("FollowOnDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @return Follow-On Purchasing Document Type
     */
    @SerializedName( "FollowOnDocumentType" )
    @JsonProperty( "FollowOnDocumentType" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentType" )
    private String followOnDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>FollowOnDocumentType</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> FOLLOW_ON_DOCUMENT_TYPE =
        new SupplierQuotationField<String>("FollowOnDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static SupplierQuotationField<String> IS_END_OF_PURPOSE_BLOCKED =
        new SupplierQuotationField<String>("IsEndOfPurposeBlocked");
    /**
     * Navigation property <b>to_SupplierQuotationItem</b> for <b>SupplierQuotation</b> to multiple
     * <b>SupplierQuotationItem</b>.
     *
     */
    @SerializedName( "to_SupplierQuotationItem" )
    @JsonProperty( "to_SupplierQuotationItem" )
    @ODataField( odataName = "to_SupplierQuotationItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplierQuotationItem> toSupplierQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierQuotationItem</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierQuotationLink<SupplierQuotationItem> TO_SUPPLIER_QUOTATION_ITEM =
        new SupplierQuotationLink<SupplierQuotationItem>("to_SupplierQuotationItem");

    @Nonnull
    @Override
    public Class<SupplierQuotation> getType()
    {
        return SupplierQuotation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *            Supplier Quotation Number
     */
    public void setSupplierQuotation( @Nullable final String supplierQuotation )
    {
        rememberChangedField("SupplierQuotation", this.supplierQuotation);
        this.supplierQuotation = supplierQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *            Supplier Quotation Document Type
     */
    public void setPurchasingDocumentType( @Nullable final String purchasingDocumentType )
    {
        rememberChangedField("PurchasingDocumentType", this.purchasingDocumentType);
        this.purchasingDocumentType = purchasingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User of person who created a purchasing document
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date of Purchasing Document
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Change Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setPricingProcedure( @Nullable final String pricingProcedure )
    {
        rememberChangedField("PricingProcedure", this.pricingProcedure);
        this.pricingProcedure = pricingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCondition</b>
     * </p>
     *
     * @param purchasingDocumentCondition
     *            Number of the Document Condition
     */
    public void setPurchasingDocumentCondition( @Nullable final String purchasingDocumentCondition )
    {
        rememberChangedField("PurchasingDocumentCondition", this.purchasingDocumentCondition);
        this.purchasingDocumentCondition = purchasingDocumentCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrderDate</b>
     * </p>
     *
     * @param purchasingDocumentOrderDate
     *            Purchasing Document Date
     */
    public void setPurchasingDocumentOrderDate( @Nullable final LocalDateTime purchasingDocumentOrderDate )
    {
        rememberChangedField("PurchasingDocumentOrderDate", this.purchasingDocumentOrderDate);
        this.purchasingDocumentOrderDate = purchasingDocumentOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            The exchangeRate to set.
     */
    public void setExchangeRate( @Nullable final String exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *            Indicator for Fixed Exchange Rate
     */
    public void setExchangeRateIsFixed( @Nullable final Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *            Request for Quotation
     */
    public void setRequestForQuotation( @Nullable final String requestForQuotation )
    {
        rememberChangedField("RequestForQuotation", this.requestForQuotation);
        this.requestForQuotation = requestForQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @param supplierQuotationExternalID
     *            Quotation Number
     */
    public void setSupplierQuotationExternalID( @Nullable final String supplierQuotationExternalID )
    {
        rememberChangedField("SupplierQuotationExternalID", this.supplierQuotationExternalID);
        this.supplierQuotationExternalID = supplierQuotationExternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @param quotationSubmissionDate
     *            Quotation Submission Date
     */
    public void setQuotationSubmissionDate( @Nullable final LocalDateTime quotationSubmissionDate )
    {
        rememberChangedField("QuotationSubmissionDate", this.quotationSubmissionDate);
        this.quotationSubmissionDate = quotationSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationLatestSubmissionDate</b>
     * </p>
     *
     * @param quotationLatestSubmissionDate
     *            Deadline for Submission of Bid/Quotation
     */
    public void setQuotationLatestSubmissionDate( @Nullable final LocalDateTime quotationLatestSubmissionDate )
    {
        rememberChangedField("QuotationLatestSubmissionDate", this.quotationLatestSubmissionDate);
        this.quotationLatestSubmissionDate = quotationLatestSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BindingPeriodValidityEndDate</b>
     * </p>
     *
     * @param bindingPeriodValidityEndDate
     *            Binding Period for Quotation
     */
    public void setBindingPeriodValidityEndDate( @Nullable final LocalDateTime bindingPeriodValidityEndDate )
    {
        rememberChangedField("BindingPeriodValidityEndDate", this.bindingPeriodValidityEndDate);
        this.bindingPeriodValidityEndDate = bindingPeriodValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>QTNLifecycleStatus</b>
     * </p>
     *
     * @param qTNLifecycleStatus
     *            Supplier Quotation Lifecycle Status
     */
    public void setQTNLifecycleStatus( @Nullable final String qTNLifecycleStatus )
    {
        rememberChangedField("QTNLifecycleStatus", this.qTNLifecycleStatus);
        this.qTNLifecycleStatus = qTNLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentCategory</b>
     * </p>
     *
     * @param followOnDocumentCategory
     *            Follow-On Purchasing Document Category
     */
    public void setFollowOnDocumentCategory( @Nullable final String followOnDocumentCategory )
    {
        rememberChangedField("FollowOnDocumentCategory", this.followOnDocumentCategory);
        this.followOnDocumentCategory = followOnDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @param followOnDocumentType
     *            Follow-On Purchasing Document Type
     */
    public void setFollowOnDocumentType( @Nullable final String followOnDocumentType )
    {
        rememberChangedField("FollowOnDocumentType", this.followOnDocumentType);
        this.followOnDocumentType = followOnDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierQuotation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierQuotation", getSupplierQuotation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierQuotation", getSupplierQuotation());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentType", getPurchasingDocumentType());
        values.put("Supplier", getSupplier());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Language", getLanguage());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("PricingProcedure", getPricingProcedure());
        values.put("PurchasingDocumentCondition", getPurchasingDocumentCondition());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingDocumentOrderDate", getPurchasingDocumentOrderDate());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("RequestForQuotation", getRequestForQuotation());
        values.put("SupplierQuotationExternalID", getSupplierQuotationExternalID());
        values.put("QuotationSubmissionDate", getQuotationSubmissionDate());
        values.put("QuotationLatestSubmissionDate", getQuotationLatestSubmissionDate());
        values.put("BindingPeriodValidityEndDate", getBindingPeriodValidityEndDate());
        values.put("QTNLifecycleStatus", getQTNLifecycleStatus());
        values.put("FollowOnDocumentCategory", getFollowOnDocumentCategory());
        values.put("FollowOnDocumentType", getFollowOnDocumentType());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierQuotation") ) {
                final Object value = values.remove("SupplierQuotation");
                if( (value == null) || (!value.equals(getSupplierQuotation())) ) {
                    setSupplierQuotation(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentType") ) {
                final Object value = values.remove("PurchasingDocumentType");
                if( (value == null) || (!value.equals(getPurchasingDocumentType())) ) {
                    setPurchasingDocumentType(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PricingProcedure") ) {
                final Object value = values.remove("PricingProcedure");
                if( (value == null) || (!value.equals(getPricingProcedure())) ) {
                    setPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCondition") ) {
                final Object value = values.remove("PurchasingDocumentCondition");
                if( (value == null) || (!value.equals(getPurchasingDocumentCondition())) ) {
                    setPurchasingDocumentCondition(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentOrderDate") ) {
                final Object value = values.remove("PurchasingDocumentOrderDate");
                if( (value == null) || (!value.equals(getPurchasingDocumentOrderDate())) ) {
                    setPurchasingDocumentOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("RequestForQuotation") ) {
                final Object value = values.remove("RequestForQuotation");
                if( (value == null) || (!value.equals(getRequestForQuotation())) ) {
                    setRequestForQuotation(((String) value));
                }
            }
            if( values.containsKey("SupplierQuotationExternalID") ) {
                final Object value = values.remove("SupplierQuotationExternalID");
                if( (value == null) || (!value.equals(getSupplierQuotationExternalID())) ) {
                    setSupplierQuotationExternalID(((String) value));
                }
            }
            if( values.containsKey("QuotationSubmissionDate") ) {
                final Object value = values.remove("QuotationSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationSubmissionDate())) ) {
                    setQuotationSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QuotationLatestSubmissionDate") ) {
                final Object value = values.remove("QuotationLatestSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationLatestSubmissionDate())) ) {
                    setQuotationLatestSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BindingPeriodValidityEndDate") ) {
                final Object value = values.remove("BindingPeriodValidityEndDate");
                if( (value == null) || (!value.equals(getBindingPeriodValidityEndDate())) ) {
                    setBindingPeriodValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QTNLifecycleStatus") ) {
                final Object value = values.remove("QTNLifecycleStatus");
                if( (value == null) || (!value.equals(getQTNLifecycleStatus())) ) {
                    setQTNLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentCategory") ) {
                final Object value = values.remove("FollowOnDocumentCategory");
                if( (value == null) || (!value.equals(getFollowOnDocumentCategory())) ) {
                    setFollowOnDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentType") ) {
                final Object value = values.remove("FollowOnDocumentType");
                if( (value == null) || (!value.equals(getFollowOnDocumentType())) ) {
                    setFollowOnDocumentType(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SupplierQuotationItem") ) {
                final Object value = (values).remove("to_SupplierQuotationItem");
                if( value instanceof Iterable ) {
                    if( toSupplierQuotationItem == null ) {
                        toSupplierQuotationItem = Lists.newArrayList();
                    } else {
                        toSupplierQuotationItem = Lists.newArrayList(toSupplierQuotationItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplierQuotationItem entity;
                        if( toSupplierQuotationItem.size() > i ) {
                            entity = toSupplierQuotationItem.get(i);
                        } else {
                            entity = new SupplierQuotationItem();
                            toSupplierQuotationItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierQuotationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierQuotationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierQuotationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierQuotationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSupplierQuotationItem != null ) {
            (values).put("to_SupplierQuotationItem", toSupplierQuotationItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SupplierQuotationItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SupplierQuotationItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SupplierQuotationItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierQuotationItem> fetchSupplierQuotationItem()
    {
        return fetchFieldAsList("to_SupplierQuotationItem", SupplierQuotationItem.class);
    }

    /**
     * Retrieval of associated <b>SupplierQuotationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_SupplierQuotationItem</b> of a queried <b>SupplierQuotation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierQuotationItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierQuotationItem> getSupplierQuotationItemOrFetch()
    {
        if( toSupplierQuotationItem == null ) {
            toSupplierQuotationItem = fetchSupplierQuotationItem();
        }
        return toSupplierQuotationItem;
    }

    /**
     * Retrieval of associated <b>SupplierQuotationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierQuotationItem</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierQuotationItem</b> is already loaded, the result
     *         will contain the <b>SupplierQuotationItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplierQuotationItem>> getSupplierQuotationItemIfPresent()
    {
        return Option.of(toSupplierQuotationItem);
    }

    /**
     * Overwrites the list of associated <b>SupplierQuotationItem</b> entities for the loaded navigation property
     * <b>to_SupplierQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_SupplierQuotationItem</b> of a queried <b>SupplierQuotation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SupplierQuotationItem</b> entities.
     */
    public void setSupplierQuotationItem( @Nonnull final List<SupplierQuotationItem> value )
    {
        if( toSupplierQuotationItem == null ) {
            toSupplierQuotationItem = Lists.newArrayList();
        }
        toSupplierQuotationItem.clear();
        toSupplierQuotationItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplierQuotationItem</b> entities. This corresponds to the OData
     * navigation property <b>to_SupplierQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_SupplierQuotationItem</b> of a queried <b>SupplierQuotation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SupplierQuotationItem</b> entities.
     */
    public void addSupplierQuotationItem( SupplierQuotationItem... entity )
    {
        if( toSupplierQuotationItem == null ) {
            toSupplierQuotationItem = Lists.newArrayList();
        }
        toSupplierQuotationItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SupplierQuotation instances.
     *
     */
    public final static class SupplierQuotationBuilder
    {

        private List<SupplierQuotationItem> toSupplierQuotationItem = Lists.newArrayList();

        private SupplierQuotation.SupplierQuotationBuilder toSupplierQuotationItem(
            final List<SupplierQuotationItem> value )
        {
            toSupplierQuotationItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SupplierQuotationItem</b> for <b>SupplierQuotation</b> to multiple
         * <b>SupplierQuotationItem</b>.
         *
         * @param value
         *            The SupplierQuotationItems to build this SupplierQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierQuotation.SupplierQuotationBuilder supplierQuotationItem( SupplierQuotationItem... value )
        {
            return toSupplierQuotationItem(Lists.newArrayList(value));
        }

    }

}
