/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.field.SupplierQuotationItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.link.SupplierQuotationItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.selectable.SupplierQuotationItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierQuotationItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierQuotationItem extends VdmEntity<SupplierQuotationItem>
{

    /**
     * Selector for all available fields of SupplierQuotationItem.
     *
     */
    public final static SupplierQuotationItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SupplierQuotation" )
    @JsonProperty( "SupplierQuotation" )
    @Nullable
    @ODataField( odataName = "SupplierQuotation" )
    private String supplierQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotation</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> SUPPLIER_QUOTATION =
        new SupplierQuotationItemField<String>("SupplierQuotation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationItem</b>
     * </p>
     *
     * @return Item Number of Supplier Quotation
     */
    @Key
    @SerializedName( "SupplierQuotationItem" )
    @JsonProperty( "SupplierQuotationItem" )
    @Nullable
    @ODataField( odataName = "SupplierQuotationItem" )
    private String supplierQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotationItem</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> SUPPLIER_QUOTATION_ITEM =
        new SupplierQuotationItemField<String>("SupplierQuotationItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PURCHASING_DOCUMENT_CATEGORY =
        new SupplierQuotationItemField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "PurchasingDocumentItemText" )
    @JsonProperty( "PurchasingDocumentItemText" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemText" )
    private String purchasingDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemText</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PURCHASING_DOCUMENT_ITEM_TEXT =
        new SupplierQuotationItemField<String>("PurchasingDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> MATERIAL =
        new SupplierQuotationItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @return Material number
     */
    @SerializedName( "ManufacturerMaterial" )
    @JsonProperty( "ManufacturerMaterial" )
    @Nullable
    @ODataField( odataName = "ManufacturerMaterial" )
    private String manufacturerMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerMaterial</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> MANUFACTURER_MATERIAL =
        new SupplierQuotationItemField<String>("ManufacturerMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> SUPPLIER_MATERIAL_NUMBER =
        new SupplierQuotationItemField<String>("SupplierMaterialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @return Manufacturer Part Number
     */
    @SerializedName( "ManufacturerPartNmbr" )
    @JsonProperty( "ManufacturerPartNmbr" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartNmbr" )
    private String manufacturerPartNmbr;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartNmbr</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> MANUFACTURER_PART_NMBR =
        new SupplierQuotationItemField<String>("ManufacturerPartNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @return Number of a Manufacturer
     */
    @SerializedName( "Manufacturer" )
    @JsonProperty( "Manufacturer" )
    @Nullable
    @ODataField( odataName = "Manufacturer" )
    private String manufacturer;
    /**
     * Use with available fluent helpers to apply the <b>Manufacturer</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> MANUFACTURER =
        new SupplierQuotationItemField<String>("Manufacturer");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> MATERIAL_GROUP =
        new SupplierQuotationItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PLANT = new SupplierQuotationItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> INCOTERMS_CLASSIFICATION =
        new SupplierQuotationItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new SupplierQuotationItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> INCOTERMS_LOCATION1 =
        new SupplierQuotationItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> INCOTERMS_LOCATION2 =
        new SupplierQuotationItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @return Delivery Date
     */
    @SerializedName( "ScheduleLineDeliveryDate" )
    @JsonProperty( "ScheduleLineDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduleLineDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<LocalDateTime> SCHEDULE_LINE_DELIVERY_DATE =
        new SupplierQuotationItemField<LocalDateTime>("ScheduleLineDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Scheduled Quantity
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new SupplierQuotationItemField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AwardedQuantity</b>
     * </p>
     *
     * @return Awarded Quantity
     */
    @SerializedName( "AwardedQuantity" )
    @JsonProperty( "AwardedQuantity" )
    @Nullable
    @ODataField( odataName = "AwardedQuantity" )
    private BigDecimal awardedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>AwardedQuantity</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> AWARDED_QUANTITY =
        new SupplierQuotationItemField<BigDecimal>("AwardedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "OrderPriceUnit" )
    @JsonProperty( "OrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnit" )
    private String orderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnit</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> ORDER_PRICE_UNIT =
        new SupplierQuotationItemField<String>("OrderPriceUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PRODUCT_TYPE =
        new SupplierQuotationItemField<String>("ProductType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @return Start Date for Period of Performance
     */
    @SerializedName( "PerformancePeriodStartDate" )
    @JsonProperty( "PerformancePeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodStartDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<LocalDateTime> PERFORMANCE_PERIOD_START_DATE =
        new SupplierQuotationItemField<LocalDateTime>("PerformancePeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @return End Date for Period of Performance
     */
    @SerializedName( "PerformancePeriodEndDate" )
    @JsonProperty( "PerformancePeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodEndDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<LocalDateTime> PERFORMANCE_PERIOD_END_DATE =
        new SupplierQuotationItemField<LocalDateTime>("PerformancePeriodEndDate");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Price Unit into Order Unit
     */
    @SerializedName( "OrderPriceUnitToOrderUnitNmrtr" )
    @JsonProperty( "OrderPriceUnitToOrderUnitNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnitToOrderUnitNmrtr" )
    private BigDecimal orderPriceUnitToOrderUnitNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnitToOrderUnitNmrtr</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR =
        new SupplierQuotationItemField<BigDecimal>("OrderPriceUnitToOrderUnitNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @return Denominator for Conv. of Order Price Unit into Order Unit
     */
    @SerializedName( "OrdPriceUnitToOrderUnitDnmntr" )
    @JsonProperty( "OrdPriceUnitToOrderUnitDnmntr" )
    @Nullable
    @ODataField( odataName = "OrdPriceUnitToOrderUnitDnmntr" )
    private BigDecimal ordPriceUnitToOrderUnitDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrdPriceUnitToOrderUnitDnmntr</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR =
        new SupplierQuotationItemField<BigDecimal>("OrdPriceUnitToOrderUnitDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> ORDER_QUANTITY_UNIT =
        new SupplierQuotationItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Unit to Base Unit
     */
    @SerializedName( "OrderItemQtyToBaseQtyNmrtr" )
    @JsonProperty( "OrderItemQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderItemQtyToBaseQtyNmrtr" )
    private BigDecimal orderItemQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderItemQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR =
        new SupplierQuotationItemField<BigDecimal>("OrderItemQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Conversion of Order Unit to Base Unit
     */
    @SerializedName( "OrderItemQtyToBaseQtyDnmntr" )
    @JsonProperty( "OrderItemQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OrderItemQtyToBaseQtyDnmntr" )
    private BigDecimal orderItemQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrderItemQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR =
        new SupplierQuotationItemField<BigDecimal>("OrderItemQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocPriceDate</b>
     * </p>
     *
     * @return Date of Price Determination
     */
    @SerializedName( "PurgDocPriceDate" )
    @JsonProperty( "PurgDocPriceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurgDocPriceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purgDocPriceDate;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocPriceDate</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<LocalDateTime> PURG_DOC_PRICE_DATE =
        new SupplierQuotationItemField<LocalDateTime>("PurgDocPriceDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> BASE_UNIT =
        new SupplierQuotationItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Quotation Net Value
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> NET_AMOUNT =
        new SupplierQuotationItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Net Price in Purchasing Document (in Document Currency)
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> NET_PRICE_AMOUNT =
        new SupplierQuotationItemField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @return Price Unit
     */
    @SerializedName( "NetPriceQuantity" )
    @JsonProperty( "NetPriceQuantity" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantity" )
    private BigDecimal netPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantity</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<BigDecimal> NET_PRICE_QUANTITY =
        new SupplierQuotationItemField<BigDecimal>("NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> DOCUMENT_CURRENCY =
        new SupplierQuotationItemField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PURCHASE_REQUISITION =
        new SupplierQuotationItemField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PURCHASE_REQUISITION_ITEM =
        new SupplierQuotationItemField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @return Identifier for Request for Quotation
     */
    @SerializedName( "RequestForQuotation" )
    @JsonProperty( "RequestForQuotation" )
    @Nullable
    @ODataField( odataName = "RequestForQuotation" )
    private String requestForQuotation;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotation</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> REQUEST_FOR_QUOTATION =
        new SupplierQuotationItemField<String>("RequestForQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotationItem</b>
     * </p>
     *
     * @return Item Number for Request for Quotation
     */
    @SerializedName( "RequestForQuotationItem" )
    @JsonProperty( "RequestForQuotationItem" )
    @Nullable
    @ODataField( odataName = "RequestForQuotationItem" )
    private String requestForQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotationItem</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> REQUEST_FOR_QUOTATION_ITEM =
        new SupplierQuotationItemField<String>("RequestForQuotationItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoRecordUpdated</b>
     * </p>
     *
     * @return Indicator for Info Record Update
     */
    @SerializedName( "IsInfoRecordUpdated" )
    @JsonProperty( "IsInfoRecordUpdated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsInfoRecordUpdated" )
    private Boolean isInfoRecordUpdated;
    /**
     * Use with available fluent helpers to apply the <b>IsInfoRecordUpdated</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<Boolean> IS_INFO_RECORD_UPDATED =
        new SupplierQuotationItemField<Boolean>("IsInfoRecordUpdated");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static SupplierQuotationItemField<String> PURCHASING_INFO_RECORD =
        new SupplierQuotationItemField<String>("PurchasingInfoRecord");
    /**
     * Navigation property <b>to_SupplierQuotation</b> for <b>SupplierQuotationItem</b> to single
     * <b>SupplierQuotation</b>.
     *
     */
    @SerializedName( "to_SupplierQuotation" )
    @JsonProperty( "to_SupplierQuotation" )
    @ODataField( odataName = "to_SupplierQuotation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SupplierQuotation toSupplierQuotation;
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierQuotation</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierQuotationItemOneToOneLink<SupplierQuotation> TO_SUPPLIER_QUOTATION =
        new SupplierQuotationItemOneToOneLink<SupplierQuotation>("to_SupplierQuotation");

    @Nonnull
    @Override
    public Class<SupplierQuotationItem> getType()
    {
        return SupplierQuotationItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *            Purchasing Document Number
     */
    public void setSupplierQuotation( @Nullable final String supplierQuotation )
    {
        rememberChangedField("SupplierQuotation", this.supplierQuotation);
        this.supplierQuotation = supplierQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationItem</b>
     * </p>
     *
     * @param supplierQuotationItem
     *            Item Number of Supplier Quotation
     */
    public void setSupplierQuotationItem( @Nullable final String supplierQuotationItem )
    {
        rememberChangedField("SupplierQuotationItem", this.supplierQuotationItem);
        this.supplierQuotationItem = supplierQuotationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemText</b>
     * </p>
     *
     * @param purchasingDocumentItemText
     *            Short Text
     */
    public void setPurchasingDocumentItemText( @Nullable final String purchasingDocumentItemText )
    {
        rememberChangedField("PurchasingDocumentItemText", this.purchasingDocumentItemText);
        this.purchasingDocumentItemText = purchasingDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @param manufacturerMaterial
     *            Material number
     */
    public void setManufacturerMaterial( @Nullable final String manufacturerMaterial )
    {
        rememberChangedField("ManufacturerMaterial", this.manufacturerMaterial);
        this.manufacturerMaterial = manufacturerMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @param manufacturerPartNmbr
     *            Manufacturer Part Number
     */
    public void setManufacturerPartNmbr( @Nullable final String manufacturerPartNmbr )
    {
        rememberChangedField("ManufacturerPartNmbr", this.manufacturerPartNmbr);
        this.manufacturerPartNmbr = manufacturerPartNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @param manufacturer
     *            Number of a Manufacturer
     */
    public void setManufacturer( @Nullable final String manufacturer )
    {
        rememberChangedField("Manufacturer", this.manufacturer);
        this.manufacturer = manufacturer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @param scheduleLineDeliveryDate
     *            Delivery Date
     */
    public void setScheduleLineDeliveryDate( @Nullable final LocalDateTime scheduleLineDeliveryDate )
    {
        rememberChangedField("ScheduleLineDeliveryDate", this.scheduleLineDeliveryDate);
        this.scheduleLineDeliveryDate = scheduleLineDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Scheduled Quantity
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AwardedQuantity</b>
     * </p>
     *
     * @param awardedQuantity
     *            Awarded Quantity
     */
    public void setAwardedQuantity( @Nullable final BigDecimal awardedQuantity )
    {
        rememberChangedField("AwardedQuantity", this.awardedQuantity);
        this.awardedQuantity = awardedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @param orderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setOrderPriceUnit( @Nullable final String orderPriceUnit )
    {
        rememberChangedField("OrderPriceUnit", this.orderPriceUnit);
        this.orderPriceUnit = orderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type Group
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @param performancePeriodStartDate
     *            Start Date for Period of Performance
     */
    public void setPerformancePeriodStartDate( @Nullable final LocalDateTime performancePeriodStartDate )
    {
        rememberChangedField("PerformancePeriodStartDate", this.performancePeriodStartDate);
        this.performancePeriodStartDate = performancePeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @param performancePeriodEndDate
     *            End Date for Period of Performance
     */
    public void setPerformancePeriodEndDate( @Nullable final LocalDateTime performancePeriodEndDate )
    {
        rememberChangedField("PerformancePeriodEndDate", this.performancePeriodEndDate);
        this.performancePeriodEndDate = performancePeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @param orderPriceUnitToOrderUnitNmrtr
     *            Numerator for Conversion of Order Price Unit into Order Unit
     */
    public void setOrderPriceUnitToOrderUnitNmrtr( @Nullable final BigDecimal orderPriceUnitToOrderUnitNmrtr )
    {
        rememberChangedField("OrderPriceUnitToOrderUnitNmrtr", this.orderPriceUnitToOrderUnitNmrtr);
        this.orderPriceUnitToOrderUnitNmrtr = orderPriceUnitToOrderUnitNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @param ordPriceUnitToOrderUnitDnmntr
     *            Denominator for Conv. of Order Price Unit into Order Unit
     */
    public void setOrdPriceUnitToOrderUnitDnmntr( @Nullable final BigDecimal ordPriceUnitToOrderUnitDnmntr )
    {
        rememberChangedField("OrdPriceUnitToOrderUnitDnmntr", this.ordPriceUnitToOrderUnitDnmntr);
        this.ordPriceUnitToOrderUnitDnmntr = ordPriceUnitToOrderUnitDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param orderItemQtyToBaseQtyNmrtr
     *            Numerator for Conversion of Order Unit to Base Unit
     */
    public void setOrderItemQtyToBaseQtyNmrtr( @Nullable final BigDecimal orderItemQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OrderItemQtyToBaseQtyNmrtr", this.orderItemQtyToBaseQtyNmrtr);
        this.orderItemQtyToBaseQtyNmrtr = orderItemQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param orderItemQtyToBaseQtyDnmntr
     *            Denominator for Conversion of Order Unit to Base Unit
     */
    public void setOrderItemQtyToBaseQtyDnmntr( @Nullable final BigDecimal orderItemQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OrderItemQtyToBaseQtyDnmntr", this.orderItemQtyToBaseQtyDnmntr);
        this.orderItemQtyToBaseQtyDnmntr = orderItemQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocPriceDate</b>
     * </p>
     *
     * @param purgDocPriceDate
     *            Date of Price Determination
     */
    public void setPurgDocPriceDate( @Nullable final LocalDateTime purgDocPriceDate )
    {
        rememberChangedField("PurgDocPriceDate", this.purgDocPriceDate);
        this.purgDocPriceDate = purgDocPriceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Quotation Net Value
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Net Price in Purchasing Document (in Document Currency)
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @param netPriceQuantity
     *            Price Unit
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *            Identifier for Request for Quotation
     */
    public void setRequestForQuotation( @Nullable final String requestForQuotation )
    {
        rememberChangedField("RequestForQuotation", this.requestForQuotation);
        this.requestForQuotation = requestForQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotationItem</b>
     * </p>
     *
     * @param requestForQuotationItem
     *            Item Number for Request for Quotation
     */
    public void setRequestForQuotationItem( @Nullable final String requestForQuotationItem )
    {
        rememberChangedField("RequestForQuotationItem", this.requestForQuotationItem);
        this.requestForQuotationItem = requestForQuotationItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoRecordUpdated</b>
     * </p>
     *
     * @param isInfoRecordUpdated
     *            Indicator for Info Record Update
     */
    public void setIsInfoRecordUpdated( @Nullable final Boolean isInfoRecordUpdated )
    {
        rememberChangedField("IsInfoRecordUpdated", this.isInfoRecordUpdated);
        this.isInfoRecordUpdated = isInfoRecordUpdated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierQuotationItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierQuotation", getSupplierQuotation());
        result.put("SupplierQuotationItem", getSupplierQuotationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierQuotation", getSupplierQuotation());
        values.put("SupplierQuotationItem", getSupplierQuotationItem());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentItemText", getPurchasingDocumentItemText());
        values.put("Material", getMaterial());
        values.put("ManufacturerMaterial", getManufacturerMaterial());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("ManufacturerPartNmbr", getManufacturerPartNmbr());
        values.put("Manufacturer", getManufacturer());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Plant", getPlant());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("ScheduleLineDeliveryDate", getScheduleLineDeliveryDate());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("AwardedQuantity", getAwardedQuantity());
        values.put("OrderPriceUnit", getOrderPriceUnit());
        values.put("ProductType", getProductType());
        values.put("PerformancePeriodStartDate", getPerformancePeriodStartDate());
        values.put("PerformancePeriodEndDate", getPerformancePeriodEndDate());
        values.put("OrderPriceUnitToOrderUnitNmrtr", getOrderPriceUnitToOrderUnitNmrtr());
        values.put("OrdPriceUnitToOrderUnitDnmntr", getOrdPriceUnitToOrderUnitDnmntr());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderItemQtyToBaseQtyNmrtr", getOrderItemQtyToBaseQtyNmrtr());
        values.put("OrderItemQtyToBaseQtyDnmntr", getOrderItemQtyToBaseQtyDnmntr());
        values.put("PurgDocPriceDate", getPurgDocPriceDate());
        values.put("BaseUnit", getBaseUnit());
        values.put("NetAmount", getNetAmount());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("RequestForQuotation", getRequestForQuotation());
        values.put("RequestForQuotationItem", getRequestForQuotationItem());
        values.put("IsInfoRecordUpdated", getIsInfoRecordUpdated());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierQuotation") ) {
                final Object value = values.remove("SupplierQuotation");
                if( (value == null) || (!value.equals(getSupplierQuotation())) ) {
                    setSupplierQuotation(((String) value));
                }
            }
            if( values.containsKey("SupplierQuotationItem") ) {
                final Object value = values.remove("SupplierQuotationItem");
                if( (value == null) || (!value.equals(getSupplierQuotationItem())) ) {
                    setSupplierQuotationItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemText") ) {
                final Object value = values.remove("PurchasingDocumentItemText");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemText())) ) {
                    setPurchasingDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ManufacturerMaterial") ) {
                final Object value = values.remove("ManufacturerMaterial");
                if( (value == null) || (!value.equals(getManufacturerMaterial())) ) {
                    setManufacturerMaterial(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartNmbr") ) {
                final Object value = values.remove("ManufacturerPartNmbr");
                if( (value == null) || (!value.equals(getManufacturerPartNmbr())) ) {
                    setManufacturerPartNmbr(((String) value));
                }
            }
            if( values.containsKey("Manufacturer") ) {
                final Object value = values.remove("Manufacturer");
                if( (value == null) || (!value.equals(getManufacturer())) ) {
                    setManufacturer(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryDate") ) {
                final Object value = values.remove("ScheduleLineDeliveryDate");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryDate())) ) {
                    setScheduleLineDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("AwardedQuantity") ) {
                final Object value = values.remove("AwardedQuantity");
                if( (value == null) || (!value.equals(getAwardedQuantity())) ) {
                    setAwardedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderPriceUnit") ) {
                final Object value = values.remove("OrderPriceUnit");
                if( (value == null) || (!value.equals(getOrderPriceUnit())) ) {
                    setOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("PerformancePeriodStartDate") ) {
                final Object value = values.remove("PerformancePeriodStartDate");
                if( (value == null) || (!value.equals(getPerformancePeriodStartDate())) ) {
                    setPerformancePeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodEndDate") ) {
                final Object value = values.remove("PerformancePeriodEndDate");
                if( (value == null) || (!value.equals(getPerformancePeriodEndDate())) ) {
                    setPerformancePeriodEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OrderPriceUnitToOrderUnitNmrtr") ) {
                final Object value = values.remove("OrderPriceUnitToOrderUnitNmrtr");
                if( (value == null) || (!value.equals(getOrderPriceUnitToOrderUnitNmrtr())) ) {
                    setOrderPriceUnitToOrderUnitNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrdPriceUnitToOrderUnitDnmntr") ) {
                final Object value = values.remove("OrdPriceUnitToOrderUnitDnmntr");
                if( (value == null) || (!value.equals(getOrdPriceUnitToOrderUnitDnmntr())) ) {
                    setOrdPriceUnitToOrderUnitDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderItemQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OrderItemQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOrderItemQtyToBaseQtyNmrtr())) ) {
                    setOrderItemQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderItemQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OrderItemQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOrderItemQtyToBaseQtyDnmntr())) ) {
                    setOrderItemQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurgDocPriceDate") ) {
                final Object value = values.remove("PurgDocPriceDate");
                if( (value == null) || (!value.equals(getPurgDocPriceDate())) ) {
                    setPurgDocPriceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("RequestForQuotation") ) {
                final Object value = values.remove("RequestForQuotation");
                if( (value == null) || (!value.equals(getRequestForQuotation())) ) {
                    setRequestForQuotation(((String) value));
                }
            }
            if( values.containsKey("RequestForQuotationItem") ) {
                final Object value = values.remove("RequestForQuotationItem");
                if( (value == null) || (!value.equals(getRequestForQuotationItem())) ) {
                    setRequestForQuotationItem(((String) value));
                }
            }
            if( values.containsKey("IsInfoRecordUpdated") ) {
                final Object value = values.remove("IsInfoRecordUpdated");
                if( (value == null) || (!value.equals(getIsInfoRecordUpdated())) ) {
                    setIsInfoRecordUpdated(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SupplierQuotation") ) {
                final Object value = (values).remove("to_SupplierQuotation");
                if( value instanceof Map ) {
                    if( toSupplierQuotation == null ) {
                        toSupplierQuotation = new SupplierQuotation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSupplierQuotation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierQuotationItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierQuotationItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierQuotationItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierQuotationItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSupplierQuotation != null ) {
            (values).put("to_SupplierQuotation", toSupplierQuotation);
        }
        return values;
    }

    /**
     * Fetches the <b>SupplierQuotation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SupplierQuotation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SupplierQuotation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SupplierQuotation fetchSupplierQuotation()
    {
        return fetchFieldAsSingle("to_SupplierQuotation", SupplierQuotation.class);
    }

    /**
     * Retrieval of associated <b>SupplierQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SupplierQuotation</b>.
     * <p>
     * If the navigation property <b>to_SupplierQuotation</b> of a queried <b>SupplierQuotationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierQuotation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SupplierQuotation getSupplierQuotationOrFetch()
    {
        if( toSupplierQuotation == null ) {
            toSupplierQuotation = fetchSupplierQuotation();
        }
        return toSupplierQuotation;
    }

    /**
     * Retrieval of associated <b>SupplierQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SupplierQuotation</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierQuotationItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierQuotation</b> is already loaded, the result will
     *         contain the <b>SupplierQuotation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SupplierQuotation> getSupplierQuotationIfPresent()
    {
        return Option.of(toSupplierQuotation);
    }

    /**
     * Overwrites the associated <b>SupplierQuotation</b> entity for the loaded navigation property
     * <b>to_SupplierQuotation</b>.
     *
     * @param value
     *            New <b>SupplierQuotation</b> entity.
     */
    public void setSupplierQuotation( final SupplierQuotation value )
    {
        toSupplierQuotation = value;
    }

    /**
     * Helper class to allow for fluent creation of SupplierQuotationItem instances.
     *
     */
    public final static class SupplierQuotationItemBuilder
    {

        private SupplierQuotation toSupplierQuotation;
        private String supplierQuotation = null;

        private SupplierQuotationItem.SupplierQuotationItemBuilder toSupplierQuotation( final SupplierQuotation value )
        {
            toSupplierQuotation = value;
            return this;
        }

        /**
         * Navigation property <b>to_SupplierQuotation</b> for <b>SupplierQuotationItem</b> to single
         * <b>SupplierQuotation</b>.
         *
         * @param value
         *            The SupplierQuotation to build this SupplierQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierQuotationItem.SupplierQuotationItemBuilder supplierQuotation( final SupplierQuotation value )
        {
            return toSupplierQuotation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SupplierQuotation</b>
         * </p>
         *
         * @param value
         *            The supplierQuotation to build this SupplierQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierQuotationItem.SupplierQuotationItemBuilder supplierQuotation( final String value )
        {
            supplierQuotation = value;
            return this;
        }

    }

}
