/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.selectable.SupplierQuotationItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
 * SupplierQuotationItem} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SupplierQuotationItemByKeyFluentHelper
    extends
    FluentHelperByKey<SupplierQuotationItemByKeyFluentHelper, SupplierQuotationItem, SupplierQuotationItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     * SupplierQuotationItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param supplierQuotationItem
     *            Item Number of Supplier Quotation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SupplierQuotationItem}
     * @param supplierQuotation
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SupplierQuotationItem}
     */
    public SupplierQuotationItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplierQuotation,
        final String supplierQuotationItem )
    {
        super(servicePath, entityCollection);
        this.key.put("SupplierQuotation", supplierQuotation);
        this.key.put("SupplierQuotationItem", supplierQuotationItem);
    }

    @Override
    @Nonnull
    protected Class<SupplierQuotationItem> getEntityClass()
    {
        return SupplierQuotationItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
