/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SupplierQuotationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService SupplierQuotationService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSupplierQuotationServiceBatch
    extends
    BatchFluentHelperBasic<SupplierQuotationServiceBatch, SupplierQuotationServiceBatchChangeSet>
    implements
    SupplierQuotationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSupplierQuotationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierQuotationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSupplierQuotationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierQuotationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSupplierQuotationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierQuotationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSupplierQuotationServiceBatchChangeSet(this, service);
    }

}
