/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem;

/**
 * Implementation of the {@link SupplierQuotationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService SupplierQuotationService}.
 *
 */
public class DefaultSupplierQuotationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SupplierQuotationServiceBatch, SupplierQuotationServiceBatchChangeSet>
    implements
    SupplierQuotationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService service;

    @SuppressWarnings( "deprecation" )
    DefaultSupplierQuotationServiceBatchChangeSet(
        @Nonnull final DefaultSupplierQuotationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSupplierQuotationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierQuotationServiceBatchChangeSet createSupplierQuotation(
        @Nonnull final SupplierQuotation supplierQuotation )
    {
        return addRequestCreate(service::createSupplierQuotation, supplierQuotation);
    }

    @Nonnull
    @Override
    public SupplierQuotationServiceBatchChangeSet updateSupplierQuotation(
        @Nonnull final SupplierQuotation supplierQuotation )
    {
        return addRequestUpdate(service::updateSupplierQuotation, supplierQuotation);
    }

    @Nonnull
    @Override
    public SupplierQuotationServiceBatchChangeSet deleteSupplierQuotation(
        @Nonnull final SupplierQuotation supplierQuotation )
    {
        return addRequestDelete(service::deleteSupplierQuotation, supplierQuotation);
    }

    @Nonnull
    @Override
    public SupplierQuotationServiceBatchChangeSet updateSupplierQuotationItem(
        @Nonnull final SupplierQuotationItem supplierQuotationItem )
    {
        return addRequestUpdate(service::updateSupplierQuotationItem, supplierQuotationItem);
    }

}
