/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierQuotationService SupplierQuotationService}.
 *
 */
public interface SupplierQuotationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SupplierQuotationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SupplierQuotationServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     * SupplierQuotation} entity and save it to the S/4HANA system.
     *
     * @param supplierQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *            SupplierQuotation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierQuotationServiceBatchChangeSet
        createSupplierQuotation( @Nonnull final SupplierQuotation supplierQuotation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     * SupplierQuotation} entity and save it to the S/4HANA system.
     *
     * @param supplierQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *            SupplierQuotation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierQuotationServiceBatchChangeSet
        updateSupplierQuotation( @Nonnull final SupplierQuotation supplierQuotation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation SupplierQuotation}
     * entity in the S/4HANA system.
     *
     * @param supplierQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *            SupplierQuotation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierQuotationServiceBatchChangeSet
        deleteSupplierQuotation( @Nonnull final SupplierQuotation supplierQuotation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     * SupplierQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param supplierQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     *            SupplierQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SupplierQuotationServiceBatchChangeSet
        updateSupplierQuotationItem( @Nonnull final SupplierQuotationItem supplierQuotationItem );

}
