/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link TradingPartnerServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.TradingPartnerService TradingPartnerService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultTradingPartnerServiceBatch
    extends
    BatchFluentHelperBasic<TradingPartnerServiceBatch, TradingPartnerServiceBatchChangeSet>
    implements
    TradingPartnerServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TradingPartnerService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultTradingPartnerServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultTradingPartnerServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TradingPartnerService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.TradingPartnerService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultTradingPartnerServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultTradingPartnerServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TradingPartnerService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultTradingPartnerServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public TradingPartnerServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultTradingPartnerServiceBatchChangeSet(this, service);
    }

}
