/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompany;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompany PartnerCompany}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.field.PartnerCompanyField
 * PartnerCompanyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.link.PartnerCompanyLink
 * PartnerCompanyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompany#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompany#COMPANY_NAME
 * COMPANY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.tradingpartner.PartnerCompany#LANGUAGE LANGUAGE}</li>
 * </ul>
 *
 */
public interface PartnerCompanySelectable extends EntitySelectable<PartnerCompany>
{

}
