/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.field.GRTransactionDataParametersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.link.GRTransactionDataParametersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.selectable.GRTransactionDataParametersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>GRTransactionDataParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GRTransactionDataParameters extends VdmEntity<GRTransactionDataParameters>
{

    /**
     * Selector for all available fields of GRTransactionDataParameters.
     *
     */
    public final static GRTransactionDataParametersSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>P_ConsolidationUnitHierId</b>
     * </p>
     *
     * @return Consolidation Unit Hierarchy
     */
    @Key
    @SerializedName( "P_ConsolidationUnitHierId" )
    @JsonProperty( "P_ConsolidationUnitHierId" )
    @Nullable
    @ODataField( odataName = "P_ConsolidationUnitHierId" )
    private String p_ConsolidationUnitHierId;
    /**
     * Use with available fluent helpers to apply the <b>P_ConsolidationUnitHierId</b> field to query operations.
     *
     */
    public final static GRTransactionDataParametersField<String> P_CONSOLIDATION_UNIT_HIER_ID =
        new GRTransactionDataParametersField<String>("P_ConsolidationUnitHierId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>P_ConsolidationPrftCtrHierId</b>
     * </p>
     *
     * @return Profit Center Hierarchy
     */
    @Key
    @SerializedName( "P_ConsolidationPrftCtrHierId" )
    @JsonProperty( "P_ConsolidationPrftCtrHierId" )
    @Nullable
    @ODataField( odataName = "P_ConsolidationPrftCtrHierId" )
    private String p_ConsolidationPrftCtrHierId;
    /**
     * Use with available fluent helpers to apply the <b>P_ConsolidationPrftCtrHierId</b> field to query operations.
     *
     */
    public final static GRTransactionDataParametersField<String> P_CONSOLIDATION_PRFT_CTR_HIER_ID =
        new GRTransactionDataParametersField<String>("P_ConsolidationPrftCtrHierId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>P_ConsolidationSegmentHierId</b>
     * </p>
     *
     * @return Segment Hierarchy
     */
    @Key
    @SerializedName( "P_ConsolidationSegmentHierId" )
    @JsonProperty( "P_ConsolidationSegmentHierId" )
    @Nullable
    @ODataField( odataName = "P_ConsolidationSegmentHierId" )
    private String p_ConsolidationSegmentHierId;
    /**
     * Use with available fluent helpers to apply the <b>P_ConsolidationSegmentHierId</b> field to query operations.
     *
     */
    public final static GRTransactionDataParametersField<String> P_CONSOLIDATION_SEGMENT_HIER_ID =
        new GRTransactionDataParametersField<String>("P_ConsolidationSegmentHierId");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_KeyDate</b>
     * </p>
     *
     * @return Valid To
     */
    @Key
    @SerializedName( "P_KeyDate" )
    @JsonProperty( "P_KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_KeyDate;
    /**
     * Use with available fluent helpers to apply the <b>P_KeyDate</b> field to query operations.
     *
     */
    public final static GRTransactionDataParametersField<LocalDateTime> P_KEY_DATE =
        new GRTransactionDataParametersField<LocalDateTime>("P_KeyDate");
    /**
     * Navigation property <b>Results</b> for <b>GRTransactionDataParameters</b> to multiple
     * <b>GRTransactionDataResult</b>.
     *
     */
    @SerializedName( "Results" )
    @JsonProperty( "Results" )
    @ODataField( odataName = "Results" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GRTransactionDataResult> toResults;
    /**
     * Use with available fluent helpers to apply the <b>Results</b> navigation property to query operations.
     *
     */
    public final static GRTransactionDataParametersLink<GRTransactionDataResult> TO_RESULTS =
        new GRTransactionDataParametersLink<GRTransactionDataResult>("Results");

    @Nonnull
    @Override
    public Class<GRTransactionDataParameters> getType()
    {
        return GRTransactionDataParameters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>P_ConsolidationUnitHierId</b>
     * </p>
     *
     * @param p_ConsolidationUnitHierId
     *            Consolidation Unit Hierarchy
     */
    public void setP_ConsolidationUnitHierId( @Nullable final String p_ConsolidationUnitHierId )
    {
        rememberChangedField("P_ConsolidationUnitHierId", this.p_ConsolidationUnitHierId);
        this.p_ConsolidationUnitHierId = p_ConsolidationUnitHierId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>P_ConsolidationPrftCtrHierId</b>
     * </p>
     *
     * @param p_ConsolidationPrftCtrHierId
     *            Profit Center Hierarchy
     */
    public void setP_ConsolidationPrftCtrHierId( @Nullable final String p_ConsolidationPrftCtrHierId )
    {
        rememberChangedField("P_ConsolidationPrftCtrHierId", this.p_ConsolidationPrftCtrHierId);
        this.p_ConsolidationPrftCtrHierId = p_ConsolidationPrftCtrHierId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>P_ConsolidationSegmentHierId</b>
     * </p>
     *
     * @param p_ConsolidationSegmentHierId
     *            Segment Hierarchy
     */
    public void setP_ConsolidationSegmentHierId( @Nullable final String p_ConsolidationSegmentHierId )
    {
        rememberChangedField("P_ConsolidationSegmentHierId", this.p_ConsolidationSegmentHierId);
        this.p_ConsolidationSegmentHierId = p_ConsolidationSegmentHierId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_KeyDate</b>
     * </p>
     *
     * @param p_KeyDate
     *            Valid To
     */
    public void setP_KeyDate( @Nullable final LocalDateTime p_KeyDate )
    {
        rememberChangedField("P_KeyDate", this.p_KeyDate);
        this.p_KeyDate = p_KeyDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GRTransactionData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_ConsolidationUnitHierId", getP_ConsolidationUnitHierId());
        result.put("P_ConsolidationPrftCtrHierId", getP_ConsolidationPrftCtrHierId());
        result.put("P_ConsolidationSegmentHierId", getP_ConsolidationSegmentHierId());
        result.put("P_KeyDate", getP_KeyDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_ConsolidationUnitHierId", getP_ConsolidationUnitHierId());
        values.put("P_ConsolidationPrftCtrHierId", getP_ConsolidationPrftCtrHierId());
        values.put("P_ConsolidationSegmentHierId", getP_ConsolidationSegmentHierId());
        values.put("P_KeyDate", getP_KeyDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_ConsolidationUnitHierId") ) {
                final Object value = values.remove("P_ConsolidationUnitHierId");
                if( (value == null) || (!value.equals(getP_ConsolidationUnitHierId())) ) {
                    setP_ConsolidationUnitHierId(((String) value));
                }
            }
            if( values.containsKey("P_ConsolidationPrftCtrHierId") ) {
                final Object value = values.remove("P_ConsolidationPrftCtrHierId");
                if( (value == null) || (!value.equals(getP_ConsolidationPrftCtrHierId())) ) {
                    setP_ConsolidationPrftCtrHierId(((String) value));
                }
            }
            if( values.containsKey("P_ConsolidationSegmentHierId") ) {
                final Object value = values.remove("P_ConsolidationSegmentHierId");
                if( (value == null) || (!value.equals(getP_ConsolidationSegmentHierId())) ) {
                    setP_ConsolidationSegmentHierId(((String) value));
                }
            }
            if( values.containsKey("P_KeyDate") ) {
                final Object value = values.remove("P_KeyDate");
                if( (value == null) || (!value.equals(getP_KeyDate())) ) {
                    setP_KeyDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Results") ) {
                final Object value = (values).remove("Results");
                if( value instanceof Iterable ) {
                    if( toResults == null ) {
                        toResults = Lists.newArrayList();
                    } else {
                        toResults = Lists.newArrayList(toResults);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GRTransactionDataResult entity;
                        if( toResults.size() > i ) {
                            entity = toResults.get(i);
                        } else {
                            entity = new GRTransactionDataResult();
                            toResults.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GRTransactionDataParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new GRTransactionDataParametersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GRTransactionDataParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GRTransactionDataParametersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TransactionDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResults != null ) {
            (values).put("Results", toResults);
        }
        return values;
    }

    /**
     * Fetches the <b>GRTransactionDataResult</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>Results</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GRTransactionDataResult</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GRTransactionDataResult> fetchResults()
    {
        return fetchFieldAsList("Results", GRTransactionDataResult.class);
    }

    /**
     * Retrieval of associated <b>GRTransactionDataResult</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>GRTransactionDataParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GRTransactionDataResult</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GRTransactionDataResult> getResultsOrFetch()
    {
        if( toResults == null ) {
            toResults = fetchResults();
        }
        return toResults;
    }

    /**
     * Retrieval of associated <b>GRTransactionDataResult</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property for an entity <b>GRTransactionDataParameters</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Results</b> is already loaded, the result will contain the
     *         <b>GRTransactionDataResult</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GRTransactionDataResult>> getResultsIfPresent()
    {
        return Option.of(toResults);
    }

    /**
     * Overwrites the list of associated <b>GRTransactionDataResult</b> entities for the loaded navigation property
     * <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>GRTransactionDataParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GRTransactionDataResult</b> entities.
     */
    public void setResults( @Nonnull final List<GRTransactionDataResult> value )
    {
        if( toResults == null ) {
            toResults = Lists.newArrayList();
        }
        toResults.clear();
        toResults.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GRTransactionDataResult</b> entities. This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>GRTransactionDataParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GRTransactionDataResult</b> entities.
     */
    public void addResults( GRTransactionDataResult... entity )
    {
        if( toResults == null ) {
            toResults = Lists.newArrayList();
        }
        toResults.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of GRTransactionDataParameters instances.
     *
     */
    public final static class GRTransactionDataParametersBuilder
    {

        private List<GRTransactionDataResult> toResults = Lists.newArrayList();

        private GRTransactionDataParameters.GRTransactionDataParametersBuilder toResults(
            final List<GRTransactionDataResult> value )
        {
            toResults.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>Results</b> for <b>GRTransactionDataParameters</b> to multiple
         * <b>GRTransactionDataResult</b>.
         *
         * @param value
         *            The GRTransactionDataResults to build this GRTransactionDataParameters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GRTransactionDataParameters.GRTransactionDataParametersBuilder results(
            GRTransactionDataResult... value )
        {
            return toResults(Lists.newArrayList(value));
        }

    }

}
