/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.selectable.GRTransactionDataParametersSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters
 * GRTransactionDataParameters} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class GRTransactionDataParametersByKeyFluentHelper
    extends
    FluentHelperByKey<GRTransactionDataParametersByKeyFluentHelper, GRTransactionDataParameters, GRTransactionDataParametersSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters
     * GRTransactionDataParameters} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GRTransactionDataParameters}
     * @param servicePath
     *            Service path to be used to fetch a single {@code GRTransactionDataParameters}
     * @param p_KeyDate
     *            Valid To
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param p_ConsolidationSegmentHierId
     *            Segment Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param p_ConsolidationUnitHierId
     *            Consolidation Unit Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param p_ConsolidationPrftCtrHierId
     *            Profit Center Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     */
    public GRTransactionDataParametersByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String p_ConsolidationUnitHierId,
        final String p_ConsolidationPrftCtrHierId,
        final String p_ConsolidationSegmentHierId,
        final LocalDateTime p_KeyDate )
    {
        super(servicePath, entityCollection);
        this.key.put("P_ConsolidationUnitHierId", p_ConsolidationUnitHierId);
        this.key.put("P_ConsolidationPrftCtrHierId", p_ConsolidationPrftCtrHierId);
        this.key.put("P_ConsolidationSegmentHierId", p_ConsolidationSegmentHierId);
        this.key.put("P_KeyDate", p_KeyDate);
    }

    @Override
    @Nonnull
    protected Class<GRTransactionDataParameters> getEntityClass()
    {
        return GRTransactionDataParameters.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
