/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.field.GRTransactionDataResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.link.GRTransactionDataResultOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.selectable.GRTransactionDataResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation - Transactional Data for Group Reporting
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GRTransactionDataResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GRTransactionDataResult extends VdmEntity<GRTransactionDataResult>
{

    /**
     * Selector for all available fields of GRTransactionDataResult.
     *
     */
    public final static GRTransactionDataResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @return The iD contained in this entity.
     */
    @Key
    @SerializedName( "ID" )
    @JsonProperty( "ID" )
    @Nullable
    @ODataField( odataName = "ID" )
    private String iD;
    /**
     * Use with available fluent helpers to apply the <b>ID</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> ID = new GRTransactionDataResultField<String>("ID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger</b>
     * </p>
     *
     * @return Consolidation Ledger
     */
    @SerializedName( "ConsolidationLedger" )
    @JsonProperty( "ConsolidationLedger" )
    @Nullable
    @ODataField( odataName = "ConsolidationLedger" )
    private String consolidationLedger;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationLedger</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_LEDGER =
        new GRTransactionDataResultField<String>("ConsolidationLedger");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger_Text</b>
     * </p>
     *
     * @return Consolidation Ledger Description
     */
    @SerializedName( "ConsolidationLedger_Text" )
    @JsonProperty( "ConsolidationLedger_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationLedger_Text" )
    private String consolidationLedger_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationLedger_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_LEDGER_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationLedger_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FISCAL_YEAR =
        new GRTransactionDataResultField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentNumber</b>
     * </p>
     *
     * @return Consolidation Document Number
     */
    @SerializedName( "ConsolidationDocumentNumber" )
    @JsonProperty( "ConsolidationDocumentNumber" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentNumber" )
    private String consolidationDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentNumber</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_DOCUMENT_NUMBER =
        new GRTransactionDataResultField<String>("ConsolidationDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostingItem</b>
     * </p>
     *
     * @return Consolidation Document Line Item
     */
    @SerializedName( "ConsolidationPostingItem" )
    @JsonProperty( "ConsolidationPostingItem" )
    @Nullable
    @ODataField( odataName = "ConsolidationPostingItem" )
    private String consolidationPostingItem;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPostingItem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_POSTING_ITEM =
        new GRTransactionDataResultField<String>("ConsolidationPostingItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLRecordType</b>
     * </p>
     *
     * @return G/L Record Type
     */
    @SerializedName( "GLRecordType" )
    @JsonProperty( "GLRecordType" )
    @Nullable
    @ODataField( odataName = "GLRecordType" )
    private String gLRecordType;
    /**
     * Use with available fluent helpers to apply the <b>GLRecordType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> GL_RECORD_TYPE =
        new GRTransactionDataResultField<String>("GLRecordType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>GLRecordType_Text</b>
     * </p>
     *
     * @return G/L Record Type Description
     */
    @SerializedName( "GLRecordType_Text" )
    @JsonProperty( "GLRecordType_Text" )
    @Nullable
    @ODataField( odataName = "GLRecordType_Text" )
    private String gLRecordType_Text;
    /**
     * Use with available fluent helpers to apply the <b>GLRecordType_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> GL_RECORD_TYPE_TEXT =
        new GRTransactionDataResultField<String>("GLRecordType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @return Consolidation Version
     */
    @SerializedName( "ConsolidationVersion" )
    @JsonProperty( "ConsolidationVersion" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion" )
    private String consolidationVersion;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_VERSION =
        new GRTransactionDataResultField<String>("ConsolidationVersion");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion_Text</b>
     * </p>
     *
     * @return Consolidation Version Description
     */
    @SerializedName( "ConsolidationVersion_Text" )
    @JsonProperty( "ConsolidationVersion_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion_Text" )
    private String consolidationVersion_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_VERSION_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationVersion_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> TRANSACTION_CURRENCY =
        new GRTransactionDataResultField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency_Text</b>
     * </p>
     *
     * @return Transaction Currency Description
     */
    @SerializedName( "TransactionCurrency_Text" )
    @JsonProperty( "TransactionCurrency_Text" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency_Text" )
    private String transactionCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> TRANSACTION_CURRENCY_TEXT =
        new GRTransactionDataResultField<String>("TransactionCurrency_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LocalCurrency</b>
     * </p>
     *
     * @return Local Currency
     */
    @SerializedName( "LocalCurrency" )
    @JsonProperty( "LocalCurrency" )
    @Nullable
    @ODataField( odataName = "LocalCurrency" )
    private String localCurrency;
    /**
     * Use with available fluent helpers to apply the <b>LocalCurrency</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> LOCAL_CURRENCY =
        new GRTransactionDataResultField<String>("LocalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LocalCurrency_Text</b>
     * </p>
     *
     * @return Local Currency Description
     */
    @SerializedName( "LocalCurrency_Text" )
    @JsonProperty( "LocalCurrency_Text" )
    @Nullable
    @ODataField( odataName = "LocalCurrency_Text" )
    private String localCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>LocalCurrency_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> LOCAL_CURRENCY_TEXT =
        new GRTransactionDataResultField<String>("LocalCurrency_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency</b>
     * </p>
     *
     * @return Group Currency
     */
    @SerializedName( "GroupCurrency" )
    @JsonProperty( "GroupCurrency" )
    @Nullable
    @ODataField( odataName = "GroupCurrency" )
    private String groupCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GroupCurrency</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> GROUP_CURRENCY =
        new GRTransactionDataResultField<String>("GroupCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency_Text</b>
     * </p>
     *
     * @return Group Currency Description
     */
    @SerializedName( "GroupCurrency_Text" )
    @JsonProperty( "GroupCurrency_Text" )
    @Nullable
    @ODataField( odataName = "GroupCurrency_Text" )
    private String groupCurrency_Text;
    /**
     * Use with available fluent helpers to apply the <b>GroupCurrency_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> GROUP_CURRENCY_TEXT =
        new GRTransactionDataResultField<String>("GroupCurrency_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BASE_UNIT =
        new GRTransactionDataResultField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit_Text</b>
     * </p>
     *
     * @return Base Unit Description
     */
    @SerializedName( "BaseUnit_Text" )
    @JsonProperty( "BaseUnit_Text" )
    @Nullable
    @ODataField( odataName = "BaseUnit_Text" )
    private String baseUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BASE_UNIT_TEXT =
        new GRTransactionDataResultField<String>("BaseUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FISCAL_PERIOD =
        new GRTransactionDataResultField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year Period
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FISCAL_YEAR_PERIOD =
        new GRTransactionDataResultField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FISCAL_YEAR_VARIANT =
        new GRTransactionDataResultField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PeriodMode</b>
     * </p>
     *
     * @return Period Mode
     */
    @SerializedName( "PeriodMode" )
    @JsonProperty( "PeriodMode" )
    @Nullable
    @ODataField( odataName = "PeriodMode" )
    private String periodMode;
    /**
     * Use with available fluent helpers to apply the <b>PeriodMode</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PERIOD_MODE =
        new GRTransactionDataResultField<String>("PeriodMode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "ConsolidationDocumentType" )
    @JsonProperty( "ConsolidationDocumentType" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType" )
    private String consolidationDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_DOCUMENT_TYPE =
        new GRTransactionDataResultField<String>("ConsolidationDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType_Text</b>
     * </p>
     *
     * @return Document Type Description
     */
    @SerializedName( "ConsolidationDocumentType_Text" )
    @JsonProperty( "ConsolidationDocumentType_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocumentType_Text" )
    private String consolidationDocumentType_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocumentType_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_DOCUMENT_TYPE_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationDocumentType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> DEBIT_CREDIT_CODE =
        new GRTransactionDataResultField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode_Text</b>
     * </p>
     *
     * @return Debit/Credit Code Description
     */
    @SerializedName( "DebitCreditCode_Text" )
    @JsonProperty( "DebitCreditCode_Text" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode_Text" )
    private String debitCreditCode_Text;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> DEBIT_CREDIT_CODE_TEXT =
        new GRTransactionDataResultField<String>("DebitCreditCode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @return Company
     */
    @SerializedName( "Company" )
    @JsonProperty( "Company" )
    @Nullable
    @ODataField( odataName = "Company" )
    private String company;
    /**
     * Use with available fluent helpers to apply the <b>Company</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> COMPANY =
        new GRTransactionDataResultField<String>("Company");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_UNIT =
        new GRTransactionDataResultField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @return Consolidation Unit Description
     */
    @SerializedName( "ConsolidationUnit_Text" )
    @JsonProperty( "ConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit_Text" )
    private String consolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_UNIT_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitForElim</b>
     * </p>
     *
     * @return Consolidation Unit for Elimination
     */
    @SerializedName( "ConsolidationUnitForElim" )
    @JsonProperty( "ConsolidationUnitForElim" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitForElim" )
    private String consolidationUnitForElim;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitForElim</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_UNIT_FOR_ELIM =
        new GRTransactionDataResultField<String>("ConsolidationUnitForElim");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitForElim_Text</b>
     * </p>
     *
     * @return Consolidation Unit for Elimination Description
     */
    @SerializedName( "ConsolidationUnitForElim_Text" )
    @JsonProperty( "ConsolidationUnitForElim_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitForElim_Text" )
    private String consolidationUnitForElim_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitForElim_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_UNIT_FOR_ELIM_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationUnitForElim_Text");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new GRTransactionDataResultField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FINANCIAL_STATEMENT_ITEM =
        new GRTransactionDataResultField<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @return Financial Statement Item Description
     */
    @SerializedName( "FinancialStatementItem_Text" )
    @JsonProperty( "FinancialStatementItem_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem_Text" )
    private String financialStatementItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new GRTransactionDataResultField<String>("FinancialStatementItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PartnerConsolidationUnit</b>
     * </p>
     *
     * @return Partner Unit
     */
    @SerializedName( "PartnerConsolidationUnit" )
    @JsonProperty( "PartnerConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "PartnerConsolidationUnit" )
    private String partnerConsolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>PartnerConsolidationUnit</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_CONSOLIDATION_UNIT =
        new GRTransactionDataResultField<String>("PartnerConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerConsolidationUnit_Text</b>
     * </p>
     *
     * @return Partner Unit Description
     */
    @SerializedName( "PartnerConsolidationUnit_Text" )
    @JsonProperty( "PartnerConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "PartnerConsolidationUnit_Text" )
    private String partnerConsolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_CONSOLIDATION_UNIT_TEXT =
        new GRTransactionDataResultField<String>("PartnerConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup</b>
     * </p>
     *
     * @return Consolidation Group
     */
    @SerializedName( "ConsolidationGroup" )
    @JsonProperty( "ConsolidationGroup" )
    @Nullable
    @ODataField( odataName = "ConsolidationGroup" )
    private String consolidationGroup;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationGroup</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_GROUP =
        new GRTransactionDataResultField<String>("ConsolidationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup_Text</b>
     * </p>
     *
     * @return Consolidation Group Description
     */
    @SerializedName( "ConsolidationGroup_Text" )
    @JsonProperty( "ConsolidationGroup_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationGroup_Text" )
    private String consolidationGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationGroup_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_GROUP_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> COMPANY_CODE =
        new GRTransactionDataResultField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode_Text</b>
     * </p>
     *
     * @return Company Code Description
     */
    @SerializedName( "CompanyCode_Text" )
    @JsonProperty( "CompanyCode_Text" )
    @Nullable
    @ODataField( odataName = "CompanyCode_Text" )
    private String companyCode_Text;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> COMPANY_CODE_TEXT =
        new GRTransactionDataResultField<String>("CompanyCode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @return Subitem Category
     */
    @SerializedName( "SubItemCategory" )
    @JsonProperty( "SubItemCategory" )
    @Nullable
    @ODataField( odataName = "SubItemCategory" )
    private String subItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SUB_ITEM_CATEGORY =
        new GRTransactionDataResultField<String>("SubItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @return Subitem Category Description
     */
    @SerializedName( "SubItemCategory_Text" )
    @JsonProperty( "SubItemCategory_Text" )
    @Nullable
    @ODataField( odataName = "SubItemCategory_Text" )
    private String subItemCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SUB_ITEM_CATEGORY_TEXT =
        new GRTransactionDataResultField<String>("SubItemCategory_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubItem</b>
     * </p>
     *
     * @return Subitem
     */
    @SerializedName( "SubItem" )
    @JsonProperty( "SubItem" )
    @Nullable
    @ODataField( odataName = "SubItem" )
    private String subItem;
    /**
     * Use with available fluent helpers to apply the <b>SubItem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SUB_ITEM =
        new GRTransactionDataResultField<String>("SubItem");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItem_Text</b>
     * </p>
     *
     * @return Subitem Description
     */
    @SerializedName( "SubItem_Text" )
    @JsonProperty( "SubItem_Text" )
    @Nullable
    @ODataField( odataName = "SubItem_Text" )
    private String subItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>SubItem_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SUB_ITEM_TEXT =
        new GRTransactionDataResultField<String>("SubItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @return Posting Level
     */
    @SerializedName( "PostingLevel" )
    @JsonProperty( "PostingLevel" )
    @Nullable
    @ODataField( odataName = "PostingLevel" )
    private String postingLevel;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> POSTING_LEVEL =
        new GRTransactionDataResultField<String>("PostingLevel");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel_Text</b>
     * </p>
     *
     * @return Posting Level Description
     */
    @SerializedName( "PostingLevel_Text" )
    @JsonProperty( "PostingLevel_Text" )
    @Nullable
    @ODataField( odataName = "PostingLevel_Text" )
    private String postingLevel_Text;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> POSTING_LEVEL_TEXT =
        new GRTransactionDataResultField<String>("PostingLevel_Text");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationApportionment</b>
     * </p>
     *
     * @return Consolidation Apportionment
     */
    @SerializedName( "ConsolidationApportionment" )
    @JsonProperty( "ConsolidationApportionment" )
    @Nullable
    @ODataField( odataName = "ConsolidationApportionment" )
    private String consolidationApportionment;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationApportionment</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_APPORTIONMENT =
        new GRTransactionDataResultField<String>("ConsolidationApportionment");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyConversionsDiffType</b>
     * </p>
     *
     * @return Currency Translation Indicator
     */
    @SerializedName( "CurrencyConversionsDiffType" )
    @JsonProperty( "CurrencyConversionsDiffType" )
    @Nullable
    @ODataField( odataName = "CurrencyConversionsDiffType" )
    private String currencyConversionsDiffType;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyConversionsDiffType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CURRENCY_CONVERSIONS_DIFF_TYPE =
        new GRTransactionDataResultField<String>("CurrencyConversionsDiffType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyConversionsDiffType_Text</b>
     * </p>
     *
     * @return Currency Translation Indicator Description
     */
    @SerializedName( "CurrencyConversionsDiffType_Text" )
    @JsonProperty( "CurrencyConversionsDiffType_Text" )
    @Nullable
    @ODataField( odataName = "CurrencyConversionsDiffType_Text" )
    private String currencyConversionsDiffType_Text;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyConversionsDiffType_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CURRENCY_CONVERSIONS_DIFF_TYPE_TEXT =
        new GRTransactionDataResultField<String>("CurrencyConversionsDiffType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAcquisitionYear</b>
     * </p>
     *
     * @return Year of Acquisition
     */
    @SerializedName( "ConsolidationAcquisitionYear" )
    @JsonProperty( "ConsolidationAcquisitionYear" )
    @Nullable
    @ODataField( odataName = "ConsolidationAcquisitionYear" )
    private String consolidationAcquisitionYear;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAcquisitionYear</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_ACQUISITION_YEAR =
        new GRTransactionDataResultField<String>("ConsolidationAcquisitionYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAcquisitionPeriod</b>
     * </p>
     *
     * @return Period of Acquisition
     */
    @SerializedName( "ConsolidationAcquisitionPeriod" )
    @JsonProperty( "ConsolidationAcquisitionPeriod" )
    @Nullable
    @ODataField( odataName = "ConsolidationAcquisitionPeriod" )
    private String consolidationAcquisitionPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationAcquisitionPeriod</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_ACQUISITION_PERIOD =
        new GRTransactionDataResultField<String>("ConsolidationAcquisitionPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InvesteeConsolidationUnit</b>
     * </p>
     *
     * @return Investee Unit
     */
    @SerializedName( "InvesteeConsolidationUnit" )
    @JsonProperty( "InvesteeConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "InvesteeConsolidationUnit" )
    private String investeeConsolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>InvesteeConsolidationUnit</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> INVESTEE_CONSOLIDATION_UNIT =
        new GRTransactionDataResultField<String>("InvesteeConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InvesteeConsolidationUnit_Text</b>
     * </p>
     *
     * @return Investee Unit Description
     */
    @SerializedName( "InvesteeConsolidationUnit_Text" )
    @JsonProperty( "InvesteeConsolidationUnit_Text" )
    @Nullable
    @ODataField( odataName = "InvesteeConsolidationUnit_Text" )
    private String investeeConsolidationUnit_Text;
    /**
     * Use with available fluent helpers to apply the <b>InvesteeConsolidationUnit_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> INVESTEE_CONSOLIDATION_UNIT_TEXT =
        new GRTransactionDataResultField<String>("InvesteeConsolidationUnit_Text");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount in Transaction Currency
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new GRTransactionDataResultField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInLocalCurrency</b>
     * </p>
     *
     * @return Amount in Local Currency
     */
    @SerializedName( "AmountInLocalCurrency" )
    @JsonProperty( "AmountInLocalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInLocalCurrency" )
    private BigDecimal amountInLocalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInLocalCurrency</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<BigDecimal> AMOUNT_IN_LOCAL_CURRENCY =
        new GRTransactionDataResultField<BigDecimal>("AmountInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGroupCurrency</b>
     * </p>
     *
     * @return Amount in Group Currency
     */
    @SerializedName( "AmountInGroupCurrency" )
    @JsonProperty( "AmountInGroupCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInGroupCurrency" )
    private BigDecimal amountInGroupCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInGroupCurrency</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<BigDecimal> AMOUNT_IN_GROUP_CURRENCY =
        new GRTransactionDataResultField<BigDecimal>("AmountInGroupCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "QuantityInBaseUnit" )
    @JsonProperty( "QuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInBaseUnit" )
    private BigDecimal quantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<BigDecimal> QUANTITY_IN_BASE_UNIT =
        new GRTransactionDataResultField<BigDecimal>("QuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 29, Scale: 8
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnQuantityInBaseUnit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "CnsldtnQuantityInBaseUnit" )
    @JsonProperty( "CnsldtnQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "CnsldtnQuantityInBaseUnit" )
    private BigDecimal cnsldtnQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<BigDecimal> CNSLDTN_QUANTITY_IN_BASE_UNIT =
        new GRTransactionDataResultField<BigDecimal>("CnsldtnQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Document Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> DOCUMENT_ITEM_TEXT =
        new GRTransactionDataResultField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgItemAutoFlag</b>
     * </p>
     *
     * @return Automatic Posting Indicator
     */
    @SerializedName( "ConsolidationPostgItemAutoFlag" )
    @JsonProperty( "ConsolidationPostgItemAutoFlag" )
    @Nullable
    @ODataField( odataName = "ConsolidationPostgItemAutoFlag" )
    private String consolidationPostgItemAutoFlag;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPostgItemAutoFlag</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_POSTG_ITEM_AUTO_FLAG =
        new GRTransactionDataResultField<String>("ConsolidationPostgItemAutoFlag");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "BusinessTransactionType" )
    @JsonProperty( "BusinessTransactionType" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionType" )
    private String businessTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BUSINESS_TRANSACTION_TYPE =
        new GRTransactionDataResultField<String>("BusinessTransactionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<LocalDateTime> POSTING_DATE =
        new GRTransactionDataResultField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyTranslationDate</b>
     * </p>
     *
     * @return Currency Translation Date
     */
    @SerializedName( "CurrencyTranslationDate" )
    @JsonProperty( "CurrencyTranslationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CurrencyTranslationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime currencyTranslationDate;
    /**
     * Use with available fluent helpers to apply the <b>CurrencyTranslationDate</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<LocalDateTime> CURRENCY_TRANSLATION_DATE =
        new GRTransactionDataResultField<LocalDateTime>("CurrencyTranslationDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RefConsolidationDocumentNumber</b>
     * </p>
     *
     * @return Reference Consolidation Document Number
     */
    @SerializedName( "RefConsolidationDocumentNumber" )
    @JsonProperty( "RefConsolidationDocumentNumber" )
    @Nullable
    @ODataField( odataName = "RefConsolidationDocumentNumber" )
    private String refConsolidationDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>RefConsolidationDocumentNumber</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REF_CONSOLIDATION_DOCUMENT_NUMBER =
        new GRTransactionDataResultField<String>("RefConsolidationDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceFiscalYear</b>
     * </p>
     *
     * @return Reference Fiscal Year
     */
    @SerializedName( "ReferenceFiscalYear" )
    @JsonProperty( "ReferenceFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReferenceFiscalYear" )
    private String referenceFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceFiscalYear</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REFERENCE_FISCAL_YEAR =
        new GRTransactionDataResultField<String>("ReferenceFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RefConsolidationPostingItem</b>
     * </p>
     *
     * @return Reference Consolidation Posting Item
     */
    @SerializedName( "RefConsolidationPostingItem" )
    @JsonProperty( "RefConsolidationPostingItem" )
    @Nullable
    @ODataField( odataName = "RefConsolidationPostingItem" )
    private String refConsolidationPostingItem;
    /**
     * Use with available fluent helpers to apply the <b>RefConsolidationPostingItem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REF_CONSOLIDATION_POSTING_ITEM =
        new GRTransactionDataResultField<String>("RefConsolidationPostingItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RefConsolidationDocumentType</b>
     * </p>
     *
     * @return Reference Document Category
     */
    @SerializedName( "RefConsolidationDocumentType" )
    @JsonProperty( "RefConsolidationDocumentType" )
    @Nullable
    @ODataField( odataName = "RefConsolidationDocumentType" )
    private String refConsolidationDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>RefConsolidationDocumentType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REF_CONSOLIDATION_DOCUMENT_TYPE =
        new GRTransactionDataResultField<String>("RefConsolidationDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RefBusinessTransactionType</b>
     * </p>
     *
     * @return Reference Business Transaction Type
     */
    @SerializedName( "RefBusinessTransactionType" )
    @JsonProperty( "RefBusinessTransactionType" )
    @Nullable
    @ODataField( odataName = "RefBusinessTransactionType" )
    private String refBusinessTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>RefBusinessTransactionType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REF_BUSINESS_TRANSACTION_TYPE =
        new GRTransactionDataResultField<String>("RefBusinessTransactionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<LocalDateTime> CREATION_DATE =
        new GRTransactionDataResultField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Created At
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<LocalTime> CREATION_TIME =
        new GRTransactionDataResultField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @return User ID
     */
    @SerializedName( "UserID" )
    @JsonProperty( "UserID" )
    @Nullable
    @ODataField( odataName = "UserID" )
    private String userID;
    /**
     * Use with available fluent helpers to apply the <b>UserID</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> USER_ID =
        new GRTransactionDataResultField<String>("UserID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @return Reversal Document
     */
    @SerializedName( "ReverseDocument" )
    @JsonProperty( "ReverseDocument" )
    @Nullable
    @ODataField( odataName = "ReverseDocument" )
    private String reverseDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocument</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REVERSE_DOCUMENT =
        new GRTransactionDataResultField<String>("ReverseDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversedDocument</b>
     * </p>
     *
     * @return Reversed Document
     */
    @SerializedName( "ReversedDocument" )
    @JsonProperty( "ReversedDocument" )
    @Nullable
    @ODataField( odataName = "ReversedDocument" )
    private String reversedDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversedDocument</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REVERSED_DOCUMENT =
        new GRTransactionDataResultField<String>("ReversedDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @return Consolidation of Investments Activity
     */
    @SerializedName( "InvestmentActivityType" )
    @JsonProperty( "InvestmentActivityType" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityType" )
    private String investmentActivityType;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> INVESTMENT_ACTIVITY_TYPE =
        new GRTransactionDataResultField<String>("InvestmentActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType_Text</b>
     * </p>
     *
     * @return Cnsldtn of Investments Activity Description
     */
    @SerializedName( "InvestmentActivityType_Text" )
    @JsonProperty( "InvestmentActivityType_Text" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityType_Text" )
    private String investmentActivityType_Text;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityType_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> INVESTMENT_ACTIVITY_TYPE_TEXT =
        new GRTransactionDataResultField<String>("InvestmentActivityType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivity</b>
     * </p>
     *
     * @return Consolidation of Investments Activity Number
     */
    @SerializedName( "InvestmentActivity" )
    @JsonProperty( "InvestmentActivity" )
    @Nullable
    @ODataField( odataName = "InvestmentActivity" )
    private String investmentActivity;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivity</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> INVESTMENT_ACTIVITY =
        new GRTransactionDataResultField<String>("InvestmentActivity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocReversalYear</b>
     * </p>
     *
     * @return Year of Reversal Document
     */
    @SerializedName( "ConsolidationDocReversalYear" )
    @JsonProperty( "ConsolidationDocReversalYear" )
    @Nullable
    @ODataField( odataName = "ConsolidationDocReversalYear" )
    private String consolidationDocReversalYear;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationDocReversalYear</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_DOC_REVERSAL_YEAR =
        new GRTransactionDataResultField<String>("ConsolidationDocReversalYear");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Transaction
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REFERENCE_DOCUMENT_TYPE =
        new GRTransactionDataResultField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @return Reference Organizational Unit
     */
    @SerializedName( "ReferenceDocumentContext" )
    @JsonProperty( "ReferenceDocumentContext" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentContext" )
    private String referenceDocumentContext;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentContext</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> REFERENCE_DOCUMENT_CONTEXT =
        new GRTransactionDataResultField<String>("ReferenceDocumentContext");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> LOGICAL_SYSTEM =
        new GRTransactionDataResultField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return G/L Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CHART_OF_ACCOUNTS =
        new GRTransactionDataResultField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts_Text</b>
     * </p>
     *
     * @return G/L Chart of Accounts Description
     */
    @SerializedName( "ChartOfAccounts_Text" )
    @JsonProperty( "ChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts_Text" )
    private String chartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CHART_OF_ACCOUNTS_TEXT =
        new GRTransactionDataResultField<String>("ChartOfAccounts_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> GL_ACCOUNT =
        new GRTransactionDataResultField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount_Text</b>
     * </p>
     *
     * @return G/L Account Description
     */
    @SerializedName( "GLAccount_Text" )
    @JsonProperty( "GLAccount_Text" )
    @Nullable
    @ODataField( odataName = "GLAccount_Text" )
    private String gLAccount_Text;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> GL_ACCOUNT_TEXT =
        new GRTransactionDataResultField<String>("GLAccount_Text");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Reference Number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> ASSIGNMENT_REFERENCE =
        new GRTransactionDataResultField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> COST_CENTER =
        new GRTransactionDataResultField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter_Text</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "CostCenter_Text" )
    @JsonProperty( "CostCenter_Text" )
    @Nullable
    @ODataField( odataName = "CostCenter_Text" )
    private String costCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> COST_CENTER_TEXT =
        new GRTransactionDataResultField<String>("CostCenter_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PROFIT_CENTER =
        new GRTransactionDataResultField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @return Profit Center Description
     */
    @SerializedName( "ProfitCenter_Text" )
    @JsonProperty( "ProfitCenter_Text" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_Text" )
    private String profitCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PROFIT_CENTER_TEXT =
        new GRTransactionDataResultField<String>("ProfitCenter_Text");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPrftCtrForElim</b>
     * </p>
     *
     * @return Profit Center for Elimination
     */
    @SerializedName( "ConsolidationPrftCtrForElim" )
    @JsonProperty( "ConsolidationPrftCtrForElim" )
    @Nullable
    @ODataField( odataName = "ConsolidationPrftCtrForElim" )
    private String consolidationPrftCtrForElim;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPrftCtrForElim</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_PRFT_CTR_FOR_ELIM =
        new GRTransactionDataResultField<String>("ConsolidationPrftCtrForElim");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPrftCtrForElim_Text</b>
     * </p>
     *
     * @return Profit Center for Elimination Description
     */
    @SerializedName( "ConsolidationPrftCtrForElim_Text" )
    @JsonProperty( "ConsolidationPrftCtrForElim_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationPrftCtrForElim_Text" )
    private String consolidationPrftCtrForElim_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPrftCtrForElim_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_PRFT_CTR_FOR_ELIM_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationPrftCtrForElim_Text");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FUNCTIONAL_AREA =
        new GRTransactionDataResultField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_Text</b>
     * </p>
     *
     * @return Functional Area Description
     */
    @SerializedName( "FunctionalArea_Text" )
    @JsonProperty( "FunctionalArea_Text" )
    @Nullable
    @ODataField( odataName = "FunctionalArea_Text" )
    private String functionalArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FUNCTIONAL_AREA_TEXT =
        new GRTransactionDataResultField<String>("FunctionalArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BUSINESS_AREA =
        new GRTransactionDataResultField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_Text</b>
     * </p>
     *
     * @return Business Area Description
     */
    @SerializedName( "BusinessArea_Text" )
    @JsonProperty( "BusinessArea_Text" )
    @Nullable
    @ODataField( odataName = "BusinessArea_Text" )
    private String businessArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BUSINESS_AREA_TEXT =
        new GRTransactionDataResultField<String>("BusinessArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONTROLLING_AREA =
        new GRTransactionDataResultField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_Text</b>
     * </p>
     *
     * @return Controlling Area Description
     */
    @SerializedName( "ControllingArea_Text" )
    @JsonProperty( "ControllingArea_Text" )
    @Nullable
    @ODataField( odataName = "ControllingArea_Text" )
    private String controllingArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONTROLLING_AREA_TEXT =
        new GRTransactionDataResultField<String>("ControllingArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SEGMENT =
        new GRTransactionDataResultField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @return Segment Description
     */
    @SerializedName( "Segment_Text" )
    @JsonProperty( "Segment_Text" )
    @Nullable
    @ODataField( odataName = "Segment_Text" )
    private String segment_Text;
    /**
     * Use with available fluent helpers to apply the <b>Segment_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SEGMENT_TEXT =
        new GRTransactionDataResultField<String>("Segment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSegmentForElim</b>
     * </p>
     *
     * @return Segment for Elimination
     */
    @SerializedName( "ConsolidationSegmentForElim" )
    @JsonProperty( "ConsolidationSegmentForElim" )
    @Nullable
    @ODataField( odataName = "ConsolidationSegmentForElim" )
    private String consolidationSegmentForElim;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationSegmentForElim</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_SEGMENT_FOR_ELIM =
        new GRTransactionDataResultField<String>("ConsolidationSegmentForElim");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSegmentForElim_Text</b>
     * </p>
     *
     * @return Segment for Elimination Description
     */
    @SerializedName( "ConsolidationSegmentForElim_Text" )
    @JsonProperty( "ConsolidationSegmentForElim_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationSegmentForElim_Text" )
    private String consolidationSegmentForElim_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationSegmentForElim_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CONSOLIDATION_SEGMENT_FOR_ELIM_TEXT =
        new GRTransactionDataResultField<String>("ConsolidationSegmentForElim_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "PartnerCostCenter" )
    @JsonProperty( "PartnerCostCenter" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter" )
    private String partnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_COST_CENTER =
        new GRTransactionDataResultField<String>("PartnerCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter_Text</b>
     * </p>
     *
     * @return Partner Cost Center Description
     */
    @SerializedName( "PartnerCostCenter_Text" )
    @JsonProperty( "PartnerCostCenter_Text" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter_Text" )
    private String partnerCostCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_COST_CENTER_TEXT =
        new GRTransactionDataResultField<String>("PartnerCostCenter_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenter" )
    @JsonProperty( "PartnerProfitCenter" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter" )
    private String partnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_PROFIT_CENTER =
        new GRTransactionDataResultField<String>("PartnerProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter_Text</b>
     * </p>
     *
     * @return Partner Profit Center Description
     */
    @SerializedName( "PartnerProfitCenter_Text" )
    @JsonProperty( "PartnerProfitCenter_Text" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter_Text" )
    private String partnerProfitCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_PROFIT_CENTER_TEXT =
        new GRTransactionDataResultField<String>("PartnerProfitCenter_Text");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_FUNCTIONAL_AREA =
        new GRTransactionDataResultField<String>("PartnerFunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea_Text</b>
     * </p>
     *
     * @return Partner Functional Area Description
     */
    @SerializedName( "PartnerFunctionalArea_Text" )
    @JsonProperty( "PartnerFunctionalArea_Text" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea_Text" )
    private String partnerFunctionalArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_FUNCTIONAL_AREA_TEXT =
        new GRTransactionDataResultField<String>("PartnerFunctionalArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_BUSINESS_AREA =
        new GRTransactionDataResultField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea_Text</b>
     * </p>
     *
     * @return Partner Business Area Description
     */
    @SerializedName( "PartnerBusinessArea_Text" )
    @JsonProperty( "PartnerBusinessArea_Text" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea_Text" )
    private String partnerBusinessArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_BUSINESS_AREA_TEXT =
        new GRTransactionDataResultField<String>("PartnerBusinessArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Partner Company
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_COMPANY =
        new GRTransactionDataResultField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany_Text</b>
     * </p>
     *
     * @return Partner Company Description
     */
    @SerializedName( "PartnerCompany_Text" )
    @JsonProperty( "PartnerCompany_Text" )
    @Nullable
    @ODataField( odataName = "PartnerCompany_Text" )
    private String partnerCompany_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_COMPANY_TEXT =
        new GRTransactionDataResultField<String>("PartnerCompany_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @return Partner Segment
     */
    @SerializedName( "PartnerSegment" )
    @JsonProperty( "PartnerSegment" )
    @Nullable
    @ODataField( odataName = "PartnerSegment" )
    private String partnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_SEGMENT =
        new GRTransactionDataResultField<String>("PartnerSegment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment_Text</b>
     * </p>
     *
     * @return Partner Segment Description
     */
    @SerializedName( "PartnerSegment_Text" )
    @JsonProperty( "PartnerSegment_Text" )
    @Nullable
    @ODataField( odataName = "PartnerSegment_Text" )
    private String partnerSegment_Text;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PARTNER_SEGMENT_TEXT =
        new GRTransactionDataResultField<String>("PartnerSegment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> ORDER_ID =
        new GRTransactionDataResultField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrderID_Text</b>
     * </p>
     *
     * @return Order ID Description
     */
    @SerializedName( "OrderID_Text" )
    @JsonProperty( "OrderID_Text" )
    @Nullable
    @ODataField( odataName = "OrderID_Text" )
    private String orderID_Text;
    /**
     * Use with available fluent helpers to apply the <b>OrderID_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> ORDER_ID_TEXT =
        new GRTransactionDataResultField<String>("OrderID_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER =
        new GRTransactionDataResultField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @return Customer Description
     */
    @SerializedName( "Customer_Text" )
    @JsonProperty( "Customer_Text" )
    @Nullable
    @ODataField( odataName = "Customer_Text" )
    private String customer_Text;
    /**
     * Use with available fluent helpers to apply the <b>Customer_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_TEXT =
        new GRTransactionDataResultField<String>("Customer_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SUPPLIER =
        new GRTransactionDataResultField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Supplier_Text</b>
     * </p>
     *
     * @return Supplier Description
     */
    @SerializedName( "Supplier_Text" )
    @JsonProperty( "Supplier_Text" )
    @Nullable
    @ODataField( odataName = "Supplier_Text" )
    private String supplier_Text;
    /**
     * Use with available fluent helpers to apply the <b>Supplier_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SUPPLIER_TEXT =
        new GRTransactionDataResultField<String>("Supplier_Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> MATERIAL =
        new GRTransactionDataResultField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_Text</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "Material_Text" )
    @JsonProperty( "Material_Text" )
    @Nullable
    @ODataField( odataName = "Material_Text" )
    private String material_Text;
    /**
     * Use with available fluent helpers to apply the <b>Material_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> MATERIAL_TEXT =
        new GRTransactionDataResultField<String>("Material_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PLANT = new GRTransactionDataResultField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Plant_Text</b>
     * </p>
     *
     * @return Plant Description
     */
    @SerializedName( "Plant_Text" )
    @JsonProperty( "Plant_Text" )
    @Nullable
    @ODataField( odataName = "Plant_Text" )
    private String plant_Text;
    /**
     * Use with available fluent helpers to apply the <b>Plant_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PLANT_TEXT =
        new GRTransactionDataResultField<String>("Plant_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FINANCIAL_TRANSACTION_TYPE =
        new GRTransactionDataResultField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_Text</b>
     * </p>
     *
     * @return Financial Transaction Type Description
     */
    @SerializedName( "FinancialTransactionType_Text" )
    @JsonProperty( "FinancialTransactionType_Text" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType_Text" )
    private String financialTransactionType_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> FINANCIAL_TRANSACTION_TYPE_TEXT =
        new GRTransactionDataResultField<String>("FinancialTransactionType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> WBS_ELEMENT_INTERNAL_ID =
        new GRTransactionDataResultField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @return WBS Element Internal ID Description
     */
    @SerializedName( "WBSDescription" )
    @JsonProperty( "WBSDescription" )
    @Nullable
    @ODataField( odataName = "WBSDescription" )
    private String wBSDescription;
    /**
     * Use with available fluent helpers to apply the <b>WBSDescription</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> WBS_DESCRIPTION =
        new GRTransactionDataResultField<String>("WBSDescription");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> WBS_ELEMENT_EXTERNAL_ID =
        new GRTransactionDataResultField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID_Text</b>
     * </p>
     *
     * @return WBS Element External ID Description
     */
    @SerializedName( "WBSElementExternalID_Text" )
    @JsonProperty( "WBSElementExternalID_Text" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID_Text" )
    private String wBSElementExternalID_Text;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> WBS_ELEMENT_EXTERNAL_ID_TEXT =
        new GRTransactionDataResultField<String>("WBSElementExternalID_Text");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PROJECT =
        new GRTransactionDataResultField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Project_Text</b>
     * </p>
     *
     * @return Project Definition Description
     */
    @SerializedName( "Project_Text" )
    @JsonProperty( "Project_Text" )
    @Nullable
    @ODataField( odataName = "Project_Text" )
    private String project_Text;
    /**
     * Use with available fluent helpers to apply the <b>Project_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> PROJECT_TEXT =
        new GRTransactionDataResultField<String>("Project_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Document Type
     */
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BILLING_DOCUMENT_TYPE =
        new GRTransactionDataResultField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType_Text</b>
     * </p>
     *
     * @return Billing Document Type Description
     */
    @SerializedName( "BillingDocumentType_Text" )
    @JsonProperty( "BillingDocumentType_Text" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType_Text" )
    private String billingDocumentType_Text;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BILLING_DOCUMENT_TYPE_TEXT =
        new GRTransactionDataResultField<String>("BillingDocumentType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SALES_ORGANIZATION =
        new GRTransactionDataResultField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization_Text</b>
     * </p>
     *
     * @return Sales Organization Description
     */
    @SerializedName( "SalesOrganization_Text" )
    @JsonProperty( "SalesOrganization_Text" )
    @Nullable
    @ODataField( odataName = "SalesOrganization_Text" )
    private String salesOrganization_Text;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SALES_ORGANIZATION_TEXT =
        new GRTransactionDataResultField<String>("SalesOrganization_Text");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> DISTRIBUTION_CHANNEL =
        new GRTransactionDataResultField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel_Text</b>
     * </p>
     *
     * @return Distribution Channel Description
     */
    @SerializedName( "DistributionChannel_Text" )
    @JsonProperty( "DistributionChannel_Text" )
    @Nullable
    @ODataField( odataName = "DistributionChannel_Text" )
    private String distributionChannel_Text;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> DISTRIBUTION_CHANNEL_TEXT =
        new GRTransactionDataResultField<String>("DistributionChannel_Text");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> ORGANIZATION_DIVISION =
        new GRTransactionDataResultField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision_Text</b>
     * </p>
     *
     * @return Division Description
     */
    @SerializedName( "OrganizationDivision_Text" )
    @JsonProperty( "OrganizationDivision_Text" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision_Text" )
    private String organizationDivision_Text;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> ORGANIZATION_DIVISION_TEXT =
        new GRTransactionDataResultField<String>("OrganizationDivision_Text");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> MATERIAL_GROUP =
        new GRTransactionDataResultField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @return Material Group Description
     */
    @SerializedName( "MaterialGroup_Text" )
    @JsonProperty( "MaterialGroup_Text" )
    @Nullable
    @ODataField( odataName = "MaterialGroup_Text" )
    private String materialGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> MATERIAL_GROUP_TEXT =
        new GRTransactionDataResultField<String>("MaterialGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @return Product Sold
     */
    @SerializedName( "SoldProduct" )
    @JsonProperty( "SoldProduct" )
    @Nullable
    @ODataField( odataName = "SoldProduct" )
    private String soldProduct;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SOLD_PRODUCT =
        new GRTransactionDataResultField<String>("SoldProduct");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct_Text</b>
     * </p>
     *
     * @return Product Sold Description
     */
    @SerializedName( "SoldProduct_Text" )
    @JsonProperty( "SoldProduct_Text" )
    @Nullable
    @ODataField( odataName = "SoldProduct_Text" )
    private String soldProduct_Text;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SOLD_PRODUCT_TEXT =
        new GRTransactionDataResultField<String>("SoldProduct_Text");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "SoldProductGroup" )
    @JsonProperty( "SoldProductGroup" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup" )
    private String soldProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SOLD_PRODUCT_GROUP =
        new GRTransactionDataResultField<String>("SoldProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup_Text</b>
     * </p>
     *
     * @return Product Sold Group Description
     */
    @SerializedName( "SoldProductGroup_Text" )
    @JsonProperty( "SoldProductGroup_Text" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup_Text" )
    private String soldProductGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SOLD_PRODUCT_GROUP_TEXT =
        new GRTransactionDataResultField<String>("SoldProductGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_GROUP =
        new GRTransactionDataResultField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup_Text</b>
     * </p>
     *
     * @return Customer Group Description
     */
    @SerializedName( "CustomerGroup_Text" )
    @JsonProperty( "CustomerGroup_Text" )
    @Nullable
    @ODataField( odataName = "CustomerGroup_Text" )
    private String customerGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_GROUP_TEXT =
        new GRTransactionDataResultField<String>("CustomerGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region
     */
    @SerializedName( "CustomerSupplierCountry" )
    @JsonProperty( "CustomerSupplierCountry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCountry" )
    private String customerSupplierCountry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCountry</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_SUPPLIER_COUNTRY =
        new GRTransactionDataResultField<String>("CustomerSupplierCountry");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry_Text</b>
     * </p>
     *
     * @return Customer/Supplier Country/Region Description
     */
    @SerializedName( "CustomerSupplierCountry_Text" )
    @JsonProperty( "CustomerSupplierCountry_Text" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCountry_Text" )
    private String customerSupplierCountry_Text;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCountry_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_SUPPLIER_COUNTRY_TEXT =
        new GRTransactionDataResultField<String>("CustomerSupplierCountry_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @return Customer/Supplier Industry
     */
    @SerializedName( "CustomerSupplierIndustry" )
    @JsonProperty( "CustomerSupplierIndustry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierIndustry" )
    private String customerSupplierIndustry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierIndustry</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_SUPPLIER_INDUSTRY =
        new GRTransactionDataResultField<String>("CustomerSupplierIndustry");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry_Text</b>
     * </p>
     *
     * @return Customer/Supplier Industry Description
     */
    @SerializedName( "CustomerSupplierIndustry_Text" )
    @JsonProperty( "CustomerSupplierIndustry_Text" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierIndustry_Text" )
    private String customerSupplierIndustry_Text;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierIndustry_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_SUPPLIER_INDUSTRY_TEXT =
        new GRTransactionDataResultField<String>("CustomerSupplierIndustry_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SALES_DISTRICT =
        new GRTransactionDataResultField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict_Text</b>
     * </p>
     *
     * @return Sales District Description
     */
    @SerializedName( "SalesDistrict_Text" )
    @JsonProperty( "SalesDistrict_Text" )
    @Nullable
    @ODataField( odataName = "SalesDistrict_Text" )
    private String salesDistrict_Text;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SALES_DISTRICT_TEXT =
        new GRTransactionDataResultField<String>("SalesDistrict_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BILL_TO_PARTY =
        new GRTransactionDataResultField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty_Text</b>
     * </p>
     *
     * @return Bill-To Party Description
     */
    @SerializedName( "BillToParty_Text" )
    @JsonProperty( "BillToParty_Text" )
    @Nullable
    @ODataField( odataName = "BillToParty_Text" )
    private String billToParty_Text;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> BILL_TO_PARTY_TEXT =
        new GRTransactionDataResultField<String>("BillToParty_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SHIP_TO_PARTY =
        new GRTransactionDataResultField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty_Text</b>
     * </p>
     *
     * @return Ship-To Party Description
     */
    @SerializedName( "ShipToParty_Text" )
    @JsonProperty( "ShipToParty_Text" )
    @Nullable
    @ODataField( odataName = "ShipToParty_Text" )
    private String shipToParty_Text;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty_Text</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> SHIP_TO_PARTY_TEXT =
        new GRTransactionDataResultField<String>("ShipToParty_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCorporateGroup</b>
     * </p>
     *
     * @return Customer/Supplier Corporate Group
     */
    @SerializedName( "CustomerSupplierCorporateGroup" )
    @JsonProperty( "CustomerSupplierCorporateGroup" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCorporateGroup" )
    private String customerSupplierCorporateGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCorporateGroup</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CUSTOMER_SUPPLIER_CORPORATE_GROUP =
        new GRTransactionDataResultField<String>("CustomerSupplierCorporateGroup");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocItem</b>
     * </p>
     *
     * @return Ad Hoc Item
     */
    @SerializedName( "CnsldtnAdhocItem" )
    @JsonProperty( "CnsldtnAdhocItem" )
    @Nullable
    @ODataField( odataName = "CnsldtnAdhocItem" )
    private String cnsldtnAdhocItem;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnAdhocItem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CNSLDTN_ADHOC_ITEM =
        new GRTransactionDataResultField<String>("CnsldtnAdhocItem");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocItemText</b>
     * </p>
     *
     * @return Ad Hoc Item Description
     */
    @SerializedName( "CnsldtnAdhocItemText" )
    @JsonProperty( "CnsldtnAdhocItemText" )
    @Nullable
    @ODataField( odataName = "CnsldtnAdhocItemText" )
    private String cnsldtnAdhocItemText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnAdhocItemText</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CNSLDTN_ADHOC_ITEM_TEXT =
        new GRTransactionDataResultField<String>("CnsldtnAdhocItemText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSet</b>
     * </p>
     *
     * @return Ad Hoc Set
     */
    @SerializedName( "CnsldtnAdhocSet" )
    @JsonProperty( "CnsldtnAdhocSet" )
    @Nullable
    @ODataField( odataName = "CnsldtnAdhocSet" )
    private String cnsldtnAdhocSet;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnAdhocSet</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CNSLDTN_ADHOC_SET =
        new GRTransactionDataResultField<String>("CnsldtnAdhocSet");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSetText</b>
     * </p>
     *
     * @return Ad Hoc Set Description
     */
    @SerializedName( "CnsldtnAdhocSetText" )
    @JsonProperty( "CnsldtnAdhocSetText" )
    @Nullable
    @ODataField( odataName = "CnsldtnAdhocSetText" )
    private String cnsldtnAdhocSetText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnAdhocSetText</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CNSLDTN_ADHOC_SET_TEXT =
        new GRTransactionDataResultField<String>("CnsldtnAdhocSetText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSetItem</b>
     * </p>
     *
     * @return Ad Hoc Set Item
     */
    @SerializedName( "CnsldtnAdhocSetItem" )
    @JsonProperty( "CnsldtnAdhocSetItem" )
    @Nullable
    @ODataField( odataName = "CnsldtnAdhocSetItem" )
    private String cnsldtnAdhocSetItem;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnAdhocSetItem</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CNSLDTN_ADHOC_SET_ITEM =
        new GRTransactionDataResultField<String>("CnsldtnAdhocSetItem");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSetItemText</b>
     * </p>
     *
     * @return Ad Hoc Set Item Description
     */
    @SerializedName( "CnsldtnAdhocSetItemText" )
    @JsonProperty( "CnsldtnAdhocSetItemText" )
    @Nullable
    @ODataField( odataName = "CnsldtnAdhocSetItemText" )
    private String cnsldtnAdhocSetItemText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnAdhocSetItemText</b> field to query operations.
     *
     */
    public final static GRTransactionDataResultField<String> CNSLDTN_ADHOC_SET_ITEM_TEXT =
        new GRTransactionDataResultField<String>("CnsldtnAdhocSetItemText");
    /**
     * Navigation property <b>Parameters</b> for <b>GRTransactionDataResult</b> to single
     * <b>GRTransactionDataParameters</b>.
     *
     */
    @SerializedName( "Parameters" )
    @JsonProperty( "Parameters" )
    @ODataField( odataName = "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GRTransactionDataParameters toParameters;
    /**
     * Use with available fluent helpers to apply the <b>Parameters</b> navigation property to query operations.
     *
     */
    public final static GRTransactionDataResultOneToOneLink<GRTransactionDataParameters> TO_PARAMETERS =
        new GRTransactionDataResultOneToOneLink<GRTransactionDataParameters>("Parameters");

    @Nonnull
    @Override
    public Class<GRTransactionDataResult> getType()
    {
        return GRTransactionDataResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @param iD
     *            The iD to set.
     */
    public void setID( @Nullable final String iD )
    {
        rememberChangedField("ID", this.iD);
        this.iD = iD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger</b>
     * </p>
     *
     * @param consolidationLedger
     *            Consolidation Ledger
     */
    public void setConsolidationLedger( @Nullable final String consolidationLedger )
    {
        rememberChangedField("ConsolidationLedger", this.consolidationLedger);
        this.consolidationLedger = consolidationLedger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationLedger_Text</b>
     * </p>
     *
     * @param consolidationLedger_Text
     *            Consolidation Ledger Description
     */
    public void setConsolidationLedger_Text( @Nullable final String consolidationLedger_Text )
    {
        rememberChangedField("ConsolidationLedger_Text", this.consolidationLedger_Text);
        this.consolidationLedger_Text = consolidationLedger_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentNumber</b>
     * </p>
     *
     * @param consolidationDocumentNumber
     *            Consolidation Document Number
     */
    public void setConsolidationDocumentNumber( @Nullable final String consolidationDocumentNumber )
    {
        rememberChangedField("ConsolidationDocumentNumber", this.consolidationDocumentNumber);
        this.consolidationDocumentNumber = consolidationDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostingItem</b>
     * </p>
     *
     * @param consolidationPostingItem
     *            Consolidation Document Line Item
     */
    public void setConsolidationPostingItem( @Nullable final String consolidationPostingItem )
    {
        rememberChangedField("ConsolidationPostingItem", this.consolidationPostingItem);
        this.consolidationPostingItem = consolidationPostingItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLRecordType</b>
     * </p>
     *
     * @param gLRecordType
     *            G/L Record Type
     */
    public void setGLRecordType( @Nullable final String gLRecordType )
    {
        rememberChangedField("GLRecordType", this.gLRecordType);
        this.gLRecordType = gLRecordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>GLRecordType_Text</b>
     * </p>
     *
     * @param gLRecordType_Text
     *            G/L Record Type Description
     */
    public void setGLRecordType_Text( @Nullable final String gLRecordType_Text )
    {
        rememberChangedField("GLRecordType_Text", this.gLRecordType_Text);
        this.gLRecordType_Text = gLRecordType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @param consolidationVersion
     *            Consolidation Version
     */
    public void setConsolidationVersion( @Nullable final String consolidationVersion )
    {
        rememberChangedField("ConsolidationVersion", this.consolidationVersion);
        this.consolidationVersion = consolidationVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion_Text</b>
     * </p>
     *
     * @param consolidationVersion_Text
     *            Consolidation Version Description
     */
    public void setConsolidationVersion_Text( @Nullable final String consolidationVersion_Text )
    {
        rememberChangedField("ConsolidationVersion_Text", this.consolidationVersion_Text);
        this.consolidationVersion_Text = consolidationVersion_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency_Text</b>
     * </p>
     *
     * @param transactionCurrency_Text
     *            Transaction Currency Description
     */
    public void setTransactionCurrency_Text( @Nullable final String transactionCurrency_Text )
    {
        rememberChangedField("TransactionCurrency_Text", this.transactionCurrency_Text);
        this.transactionCurrency_Text = transactionCurrency_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LocalCurrency</b>
     * </p>
     *
     * @param localCurrency
     *            Local Currency
     */
    public void setLocalCurrency( @Nullable final String localCurrency )
    {
        rememberChangedField("LocalCurrency", this.localCurrency);
        this.localCurrency = localCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LocalCurrency_Text</b>
     * </p>
     *
     * @param localCurrency_Text
     *            Local Currency Description
     */
    public void setLocalCurrency_Text( @Nullable final String localCurrency_Text )
    {
        rememberChangedField("LocalCurrency_Text", this.localCurrency_Text);
        this.localCurrency_Text = localCurrency_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency</b>
     * </p>
     *
     * @param groupCurrency
     *            Group Currency
     */
    public void setGroupCurrency( @Nullable final String groupCurrency )
    {
        rememberChangedField("GroupCurrency", this.groupCurrency);
        this.groupCurrency = groupCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupCurrency_Text</b>
     * </p>
     *
     * @param groupCurrency_Text
     *            Group Currency Description
     */
    public void setGroupCurrency_Text( @Nullable final String groupCurrency_Text )
    {
        rememberChangedField("GroupCurrency_Text", this.groupCurrency_Text);
        this.groupCurrency_Text = groupCurrency_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit_Text</b>
     * </p>
     *
     * @param baseUnit_Text
     *            Base Unit Description
     */
    public void setBaseUnit_Text( @Nullable final String baseUnit_Text )
    {
        rememberChangedField("BaseUnit_Text", this.baseUnit_Text);
        this.baseUnit_Text = baseUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            Fiscal Year Period
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PeriodMode</b>
     * </p>
     *
     * @param periodMode
     *            Period Mode
     */
    public void setPeriodMode( @Nullable final String periodMode )
    {
        rememberChangedField("PeriodMode", this.periodMode);
        this.periodMode = periodMode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType</b>
     * </p>
     *
     * @param consolidationDocumentType
     *            Document Type
     */
    public void setConsolidationDocumentType( @Nullable final String consolidationDocumentType )
    {
        rememberChangedField("ConsolidationDocumentType", this.consolidationDocumentType);
        this.consolidationDocumentType = consolidationDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocumentType_Text</b>
     * </p>
     *
     * @param consolidationDocumentType_Text
     *            Document Type Description
     */
    public void setConsolidationDocumentType_Text( @Nullable final String consolidationDocumentType_Text )
    {
        rememberChangedField("ConsolidationDocumentType_Text", this.consolidationDocumentType_Text);
        this.consolidationDocumentType_Text = consolidationDocumentType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode_Text</b>
     * </p>
     *
     * @param debitCreditCode_Text
     *            Debit/Credit Code Description
     */
    public void setDebitCreditCode_Text( @Nullable final String debitCreditCode_Text )
    {
        rememberChangedField("DebitCreditCode_Text", this.debitCreditCode_Text);
        this.debitCreditCode_Text = debitCreditCode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @param company
     *            Company
     */
    public void setCompany( @Nullable final String company )
    {
        rememberChangedField("Company", this.company);
        this.company = company;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit_Text</b>
     * </p>
     *
     * @param consolidationUnit_Text
     *            Consolidation Unit Description
     */
    public void setConsolidationUnit_Text( @Nullable final String consolidationUnit_Text )
    {
        rememberChangedField("ConsolidationUnit_Text", this.consolidationUnit_Text);
        this.consolidationUnit_Text = consolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitForElim</b>
     * </p>
     *
     * @param consolidationUnitForElim
     *            Consolidation Unit for Elimination
     */
    public void setConsolidationUnitForElim( @Nullable final String consolidationUnitForElim )
    {
        rememberChangedField("ConsolidationUnitForElim", this.consolidationUnitForElim);
        this.consolidationUnitForElim = consolidationUnitForElim;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitForElim_Text</b>
     * </p>
     *
     * @param consolidationUnitForElim_Text
     *            Consolidation Unit for Elimination Description
     */
    public void setConsolidationUnitForElim_Text( @Nullable final String consolidationUnitForElim_Text )
    {
        rememberChangedField("ConsolidationUnitForElim_Text", this.consolidationUnitForElim_Text);
        this.consolidationUnitForElim_Text = consolidationUnitForElim_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @param financialStatementItem_Text
     *            Financial Statement Item Description
     */
    public void setFinancialStatementItem_Text( @Nullable final String financialStatementItem_Text )
    {
        rememberChangedField("FinancialStatementItem_Text", this.financialStatementItem_Text);
        this.financialStatementItem_Text = financialStatementItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PartnerConsolidationUnit</b>
     * </p>
     *
     * @param partnerConsolidationUnit
     *            Partner Unit
     */
    public void setPartnerConsolidationUnit( @Nullable final String partnerConsolidationUnit )
    {
        rememberChangedField("PartnerConsolidationUnit", this.partnerConsolidationUnit);
        this.partnerConsolidationUnit = partnerConsolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerConsolidationUnit_Text</b>
     * </p>
     *
     * @param partnerConsolidationUnit_Text
     *            Partner Unit Description
     */
    public void setPartnerConsolidationUnit_Text( @Nullable final String partnerConsolidationUnit_Text )
    {
        rememberChangedField("PartnerConsolidationUnit_Text", this.partnerConsolidationUnit_Text);
        this.partnerConsolidationUnit_Text = partnerConsolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup</b>
     * </p>
     *
     * @param consolidationGroup
     *            Consolidation Group
     */
    public void setConsolidationGroup( @Nullable final String consolidationGroup )
    {
        rememberChangedField("ConsolidationGroup", this.consolidationGroup);
        this.consolidationGroup = consolidationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationGroup_Text</b>
     * </p>
     *
     * @param consolidationGroup_Text
     *            Consolidation Group Description
     */
    public void setConsolidationGroup_Text( @Nullable final String consolidationGroup_Text )
    {
        rememberChangedField("ConsolidationGroup_Text", this.consolidationGroup_Text);
        this.consolidationGroup_Text = consolidationGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode_Text</b>
     * </p>
     *
     * @param companyCode_Text
     *            Company Code Description
     */
    public void setCompanyCode_Text( @Nullable final String companyCode_Text )
    {
        rememberChangedField("CompanyCode_Text", this.companyCode_Text);
        this.companyCode_Text = companyCode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @param subItemCategory
     *            Subitem Category
     */
    public void setSubItemCategory( @Nullable final String subItemCategory )
    {
        rememberChangedField("SubItemCategory", this.subItemCategory);
        this.subItemCategory = subItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @param subItemCategory_Text
     *            Subitem Category Description
     */
    public void setSubItemCategory_Text( @Nullable final String subItemCategory_Text )
    {
        rememberChangedField("SubItemCategory_Text", this.subItemCategory_Text);
        this.subItemCategory_Text = subItemCategory_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubItem</b>
     * </p>
     *
     * @param subItem
     *            Subitem
     */
    public void setSubItem( @Nullable final String subItem )
    {
        rememberChangedField("SubItem", this.subItem);
        this.subItem = subItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItem_Text</b>
     * </p>
     *
     * @param subItem_Text
     *            Subitem Description
     */
    public void setSubItem_Text( @Nullable final String subItem_Text )
    {
        rememberChangedField("SubItem_Text", this.subItem_Text);
        this.subItem_Text = subItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @param postingLevel
     *            Posting Level
     */
    public void setPostingLevel( @Nullable final String postingLevel )
    {
        rememberChangedField("PostingLevel", this.postingLevel);
        this.postingLevel = postingLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel_Text</b>
     * </p>
     *
     * @param postingLevel_Text
     *            Posting Level Description
     */
    public void setPostingLevel_Text( @Nullable final String postingLevel_Text )
    {
        rememberChangedField("PostingLevel_Text", this.postingLevel_Text);
        this.postingLevel_Text = postingLevel_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationApportionment</b>
     * </p>
     *
     * @param consolidationApportionment
     *            Consolidation Apportionment
     */
    public void setConsolidationApportionment( @Nullable final String consolidationApportionment )
    {
        rememberChangedField("ConsolidationApportionment", this.consolidationApportionment);
        this.consolidationApportionment = consolidationApportionment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyConversionsDiffType</b>
     * </p>
     *
     * @param currencyConversionsDiffType
     *            Currency Translation Indicator
     */
    public void setCurrencyConversionsDiffType( @Nullable final String currencyConversionsDiffType )
    {
        rememberChangedField("CurrencyConversionsDiffType", this.currencyConversionsDiffType);
        this.currencyConversionsDiffType = currencyConversionsDiffType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyConversionsDiffType_Text</b>
     * </p>
     *
     * @param currencyConversionsDiffType_Text
     *            Currency Translation Indicator Description
     */
    public void setCurrencyConversionsDiffType_Text( @Nullable final String currencyConversionsDiffType_Text )
    {
        rememberChangedField("CurrencyConversionsDiffType_Text", this.currencyConversionsDiffType_Text);
        this.currencyConversionsDiffType_Text = currencyConversionsDiffType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAcquisitionYear</b>
     * </p>
     *
     * @param consolidationAcquisitionYear
     *            Year of Acquisition
     */
    public void setConsolidationAcquisitionYear( @Nullable final String consolidationAcquisitionYear )
    {
        rememberChangedField("ConsolidationAcquisitionYear", this.consolidationAcquisitionYear);
        this.consolidationAcquisitionYear = consolidationAcquisitionYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationAcquisitionPeriod</b>
     * </p>
     *
     * @param consolidationAcquisitionPeriod
     *            Period of Acquisition
     */
    public void setConsolidationAcquisitionPeriod( @Nullable final String consolidationAcquisitionPeriod )
    {
        rememberChangedField("ConsolidationAcquisitionPeriod", this.consolidationAcquisitionPeriod);
        this.consolidationAcquisitionPeriod = consolidationAcquisitionPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InvesteeConsolidationUnit</b>
     * </p>
     *
     * @param investeeConsolidationUnit
     *            Investee Unit
     */
    public void setInvesteeConsolidationUnit( @Nullable final String investeeConsolidationUnit )
    {
        rememberChangedField("InvesteeConsolidationUnit", this.investeeConsolidationUnit);
        this.investeeConsolidationUnit = investeeConsolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InvesteeConsolidationUnit_Text</b>
     * </p>
     *
     * @param investeeConsolidationUnit_Text
     *            Investee Unit Description
     */
    public void setInvesteeConsolidationUnit_Text( @Nullable final String investeeConsolidationUnit_Text )
    {
        rememberChangedField("InvesteeConsolidationUnit_Text", this.investeeConsolidationUnit_Text);
        this.investeeConsolidationUnit_Text = investeeConsolidationUnit_Text;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount in Transaction Currency
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInLocalCurrency</b>
     * </p>
     *
     * @param amountInLocalCurrency
     *            Amount in Local Currency
     */
    public void setAmountInLocalCurrency( @Nullable final BigDecimal amountInLocalCurrency )
    {
        rememberChangedField("AmountInLocalCurrency", this.amountInLocalCurrency);
        this.amountInLocalCurrency = amountInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGroupCurrency</b>
     * </p>
     *
     * @param amountInGroupCurrency
     *            Amount in Group Currency
     */
    public void setAmountInGroupCurrency( @Nullable final BigDecimal amountInGroupCurrency )
    {
        rememberChangedField("AmountInGroupCurrency", this.amountInGroupCurrency);
        this.amountInGroupCurrency = amountInGroupCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @param quantityInBaseUnit
     *            Quantity
     */
    public void setQuantityInBaseUnit( @Nullable final BigDecimal quantityInBaseUnit )
    {
        rememberChangedField("QuantityInBaseUnit", this.quantityInBaseUnit);
        this.quantityInBaseUnit = quantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 29, Scale: 8
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnQuantityInBaseUnit</b>
     * </p>
     *
     * @param cnsldtnQuantityInBaseUnit
     *            Quantity
     */
    public void setCnsldtnQuantityInBaseUnit( @Nullable final BigDecimal cnsldtnQuantityInBaseUnit )
    {
        rememberChangedField("CnsldtnQuantityInBaseUnit", this.cnsldtnQuantityInBaseUnit);
        this.cnsldtnQuantityInBaseUnit = cnsldtnQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Document Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgItemAutoFlag</b>
     * </p>
     *
     * @param consolidationPostgItemAutoFlag
     *            Automatic Posting Indicator
     */
    public void setConsolidationPostgItemAutoFlag( @Nullable final String consolidationPostgItemAutoFlag )
    {
        rememberChangedField("ConsolidationPostgItemAutoFlag", this.consolidationPostgItemAutoFlag);
        this.consolidationPostgItemAutoFlag = consolidationPostgItemAutoFlag;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @param businessTransactionType
     *            Business Transaction Type
     */
    public void setBusinessTransactionType( @Nullable final String businessTransactionType )
    {
        rememberChangedField("BusinessTransactionType", this.businessTransactionType);
        this.businessTransactionType = businessTransactionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CurrencyTranslationDate</b>
     * </p>
     *
     * @param currencyTranslationDate
     *            Currency Translation Date
     */
    public void setCurrencyTranslationDate( @Nullable final LocalDateTime currencyTranslationDate )
    {
        rememberChangedField("CurrencyTranslationDate", this.currencyTranslationDate);
        this.currencyTranslationDate = currencyTranslationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RefConsolidationDocumentNumber</b>
     * </p>
     *
     * @param refConsolidationDocumentNumber
     *            Reference Consolidation Document Number
     */
    public void setRefConsolidationDocumentNumber( @Nullable final String refConsolidationDocumentNumber )
    {
        rememberChangedField("RefConsolidationDocumentNumber", this.refConsolidationDocumentNumber);
        this.refConsolidationDocumentNumber = refConsolidationDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceFiscalYear</b>
     * </p>
     *
     * @param referenceFiscalYear
     *            Reference Fiscal Year
     */
    public void setReferenceFiscalYear( @Nullable final String referenceFiscalYear )
    {
        rememberChangedField("ReferenceFiscalYear", this.referenceFiscalYear);
        this.referenceFiscalYear = referenceFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RefConsolidationPostingItem</b>
     * </p>
     *
     * @param refConsolidationPostingItem
     *            Reference Consolidation Posting Item
     */
    public void setRefConsolidationPostingItem( @Nullable final String refConsolidationPostingItem )
    {
        rememberChangedField("RefConsolidationPostingItem", this.refConsolidationPostingItem);
        this.refConsolidationPostingItem = refConsolidationPostingItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RefConsolidationDocumentType</b>
     * </p>
     *
     * @param refConsolidationDocumentType
     *            Reference Document Category
     */
    public void setRefConsolidationDocumentType( @Nullable final String refConsolidationDocumentType )
    {
        rememberChangedField("RefConsolidationDocumentType", this.refConsolidationDocumentType);
        this.refConsolidationDocumentType = refConsolidationDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RefBusinessTransactionType</b>
     * </p>
     *
     * @param refBusinessTransactionType
     *            Reference Business Transaction Type
     */
    public void setRefBusinessTransactionType( @Nullable final String refBusinessTransactionType )
    {
        rememberChangedField("RefBusinessTransactionType", this.refBusinessTransactionType);
        this.refBusinessTransactionType = refBusinessTransactionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Created At
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @param userID
     *            User ID
     */
    public void setUserID( @Nullable final String userID )
    {
        rememberChangedField("UserID", this.userID);
        this.userID = userID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *            Reversal Document
     */
    public void setReverseDocument( @Nullable final String reverseDocument )
    {
        rememberChangedField("ReverseDocument", this.reverseDocument);
        this.reverseDocument = reverseDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversedDocument</b>
     * </p>
     *
     * @param reversedDocument
     *            Reversed Document
     */
    public void setReversedDocument( @Nullable final String reversedDocument )
    {
        rememberChangedField("ReversedDocument", this.reversedDocument);
        this.reversedDocument = reversedDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @param investmentActivityType
     *            Consolidation of Investments Activity
     */
    public void setInvestmentActivityType( @Nullable final String investmentActivityType )
    {
        rememberChangedField("InvestmentActivityType", this.investmentActivityType);
        this.investmentActivityType = investmentActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType_Text</b>
     * </p>
     *
     * @param investmentActivityType_Text
     *            Cnsldtn of Investments Activity Description
     */
    public void setInvestmentActivityType_Text( @Nullable final String investmentActivityType_Text )
    {
        rememberChangedField("InvestmentActivityType_Text", this.investmentActivityType_Text);
        this.investmentActivityType_Text = investmentActivityType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivity</b>
     * </p>
     *
     * @param investmentActivity
     *            Consolidation of Investments Activity Number
     */
    public void setInvestmentActivity( @Nullable final String investmentActivity )
    {
        rememberChangedField("InvestmentActivity", this.investmentActivity);
        this.investmentActivity = investmentActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationDocReversalYear</b>
     * </p>
     *
     * @param consolidationDocReversalYear
     *            Year of Reversal Document
     */
    public void setConsolidationDocReversalYear( @Nullable final String consolidationDocReversalYear )
    {
        rememberChangedField("ConsolidationDocReversalYear", this.consolidationDocReversalYear);
        this.consolidationDocReversalYear = consolidationDocReversalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Transaction
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @param referenceDocumentContext
     *            Reference Organizational Unit
     */
    public void setReferenceDocumentContext( @Nullable final String referenceDocumentContext )
    {
        rememberChangedField("ReferenceDocumentContext", this.referenceDocumentContext);
        this.referenceDocumentContext = referenceDocumentContext;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            G/L Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts_Text</b>
     * </p>
     *
     * @param chartOfAccounts_Text
     *            G/L Chart of Accounts Description
     */
    public void setChartOfAccounts_Text( @Nullable final String chartOfAccounts_Text )
    {
        rememberChangedField("ChartOfAccounts_Text", this.chartOfAccounts_Text);
        this.chartOfAccounts_Text = chartOfAccounts_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount_Text</b>
     * </p>
     *
     * @param gLAccount_Text
     *            G/L Account Description
     */
    public void setGLAccount_Text( @Nullable final String gLAccount_Text )
    {
        rememberChangedField("GLAccount_Text", this.gLAccount_Text);
        this.gLAccount_Text = gLAccount_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Reference Number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter_Text</b>
     * </p>
     *
     * @param costCenter_Text
     *            Description
     */
    public void setCostCenter_Text( @Nullable final String costCenter_Text )
    {
        rememberChangedField("CostCenter_Text", this.costCenter_Text);
        this.costCenter_Text = costCenter_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @param profitCenter_Text
     *            Profit Center Description
     */
    public void setProfitCenter_Text( @Nullable final String profitCenter_Text )
    {
        rememberChangedField("ProfitCenter_Text", this.profitCenter_Text);
        this.profitCenter_Text = profitCenter_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPrftCtrForElim</b>
     * </p>
     *
     * @param consolidationPrftCtrForElim
     *            Profit Center for Elimination
     */
    public void setConsolidationPrftCtrForElim( @Nullable final String consolidationPrftCtrForElim )
    {
        rememberChangedField("ConsolidationPrftCtrForElim", this.consolidationPrftCtrForElim);
        this.consolidationPrftCtrForElim = consolidationPrftCtrForElim;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPrftCtrForElim_Text</b>
     * </p>
     *
     * @param consolidationPrftCtrForElim_Text
     *            Profit Center for Elimination Description
     */
    public void setConsolidationPrftCtrForElim_Text( @Nullable final String consolidationPrftCtrForElim_Text )
    {
        rememberChangedField("ConsolidationPrftCtrForElim_Text", this.consolidationPrftCtrForElim_Text);
        this.consolidationPrftCtrForElim_Text = consolidationPrftCtrForElim_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_Text</b>
     * </p>
     *
     * @param functionalArea_Text
     *            Functional Area Description
     */
    public void setFunctionalArea_Text( @Nullable final String functionalArea_Text )
    {
        rememberChangedField("FunctionalArea_Text", this.functionalArea_Text);
        this.functionalArea_Text = functionalArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_Text</b>
     * </p>
     *
     * @param businessArea_Text
     *            Business Area Description
     */
    public void setBusinessArea_Text( @Nullable final String businessArea_Text )
    {
        rememberChangedField("BusinessArea_Text", this.businessArea_Text);
        this.businessArea_Text = businessArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_Text</b>
     * </p>
     *
     * @param controllingArea_Text
     *            Controlling Area Description
     */
    public void setControllingArea_Text( @Nullable final String controllingArea_Text )
    {
        rememberChangedField("ControllingArea_Text", this.controllingArea_Text);
        this.controllingArea_Text = controllingArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @param segment_Text
     *            Segment Description
     */
    public void setSegment_Text( @Nullable final String segment_Text )
    {
        rememberChangedField("Segment_Text", this.segment_Text);
        this.segment_Text = segment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSegmentForElim</b>
     * </p>
     *
     * @param consolidationSegmentForElim
     *            Segment for Elimination
     */
    public void setConsolidationSegmentForElim( @Nullable final String consolidationSegmentForElim )
    {
        rememberChangedField("ConsolidationSegmentForElim", this.consolidationSegmentForElim);
        this.consolidationSegmentForElim = consolidationSegmentForElim;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSegmentForElim_Text</b>
     * </p>
     *
     * @param consolidationSegmentForElim_Text
     *            Segment for Elimination Description
     */
    public void setConsolidationSegmentForElim_Text( @Nullable final String consolidationSegmentForElim_Text )
    {
        rememberChangedField("ConsolidationSegmentForElim_Text", this.consolidationSegmentForElim_Text);
        this.consolidationSegmentForElim_Text = consolidationSegmentForElim_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @param partnerCostCenter
     *            Partner Cost Center
     */
    public void setPartnerCostCenter( @Nullable final String partnerCostCenter )
    {
        rememberChangedField("PartnerCostCenter", this.partnerCostCenter);
        this.partnerCostCenter = partnerCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter_Text</b>
     * </p>
     *
     * @param partnerCostCenter_Text
     *            Partner Cost Center Description
     */
    public void setPartnerCostCenter_Text( @Nullable final String partnerCostCenter_Text )
    {
        rememberChangedField("PartnerCostCenter_Text", this.partnerCostCenter_Text);
        this.partnerCostCenter_Text = partnerCostCenter_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @param partnerProfitCenter
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter( @Nullable final String partnerProfitCenter )
    {
        rememberChangedField("PartnerProfitCenter", this.partnerProfitCenter);
        this.partnerProfitCenter = partnerProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter_Text</b>
     * </p>
     *
     * @param partnerProfitCenter_Text
     *            Partner Profit Center Description
     */
    public void setPartnerProfitCenter_Text( @Nullable final String partnerProfitCenter_Text )
    {
        rememberChangedField("PartnerProfitCenter_Text", this.partnerProfitCenter_Text);
        this.partnerProfitCenter_Text = partnerProfitCenter_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Partner Functional Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea_Text</b>
     * </p>
     *
     * @param partnerFunctionalArea_Text
     *            Partner Functional Area Description
     */
    public void setPartnerFunctionalArea_Text( @Nullable final String partnerFunctionalArea_Text )
    {
        rememberChangedField("PartnerFunctionalArea_Text", this.partnerFunctionalArea_Text);
        this.partnerFunctionalArea_Text = partnerFunctionalArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Partner Business Area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea_Text</b>
     * </p>
     *
     * @param partnerBusinessArea_Text
     *            Partner Business Area Description
     */
    public void setPartnerBusinessArea_Text( @Nullable final String partnerBusinessArea_Text )
    {
        rememberChangedField("PartnerBusinessArea_Text", this.partnerBusinessArea_Text);
        this.partnerBusinessArea_Text = partnerBusinessArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Partner Company
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany_Text</b>
     * </p>
     *
     * @param partnerCompany_Text
     *            Partner Company Description
     */
    public void setPartnerCompany_Text( @Nullable final String partnerCompany_Text )
    {
        rememberChangedField("PartnerCompany_Text", this.partnerCompany_Text);
        this.partnerCompany_Text = partnerCompany_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @param partnerSegment
     *            Partner Segment
     */
    public void setPartnerSegment( @Nullable final String partnerSegment )
    {
        rememberChangedField("PartnerSegment", this.partnerSegment);
        this.partnerSegment = partnerSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment_Text</b>
     * </p>
     *
     * @param partnerSegment_Text
     *            Partner Segment Description
     */
    public void setPartnerSegment_Text( @Nullable final String partnerSegment_Text )
    {
        rememberChangedField("PartnerSegment_Text", this.partnerSegment_Text);
        this.partnerSegment_Text = partnerSegment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrderID_Text</b>
     * </p>
     *
     * @param orderID_Text
     *            Order ID Description
     */
    public void setOrderID_Text( @Nullable final String orderID_Text )
    {
        rememberChangedField("OrderID_Text", this.orderID_Text);
        this.orderID_Text = orderID_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @param customer_Text
     *            Customer Description
     */
    public void setCustomer_Text( @Nullable final String customer_Text )
    {
        rememberChangedField("Customer_Text", this.customer_Text);
        this.customer_Text = customer_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Supplier_Text</b>
     * </p>
     *
     * @param supplier_Text
     *            Supplier Description
     */
    public void setSupplier_Text( @Nullable final String supplier_Text )
    {
        rememberChangedField("Supplier_Text", this.supplier_Text);
        this.supplier_Text = supplier_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_Text</b>
     * </p>
     *
     * @param material_Text
     *            Material Description
     */
    public void setMaterial_Text( @Nullable final String material_Text )
    {
        rememberChangedField("Material_Text", this.material_Text);
        this.material_Text = material_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Plant_Text</b>
     * </p>
     *
     * @param plant_Text
     *            Plant Description
     */
    public void setPlant_Text( @Nullable final String plant_Text )
    {
        rememberChangedField("Plant_Text", this.plant_Text);
        this.plant_Text = plant_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_Text</b>
     * </p>
     *
     * @param financialTransactionType_Text
     *            Financial Transaction Type Description
     */
    public void setFinancialTransactionType_Text( @Nullable final String financialTransactionType_Text )
    {
        rememberChangedField("FinancialTransactionType_Text", this.financialTransactionType_Text);
        this.financialTransactionType_Text = financialTransactionType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @param wBSDescription
     *            WBS Element Internal ID Description
     */
    public void setWBSDescription( @Nullable final String wBSDescription )
    {
        rememberChangedField("WBSDescription", this.wBSDescription);
        this.wBSDescription = wBSDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID_Text</b>
     * </p>
     *
     * @param wBSElementExternalID_Text
     *            WBS Element External ID Description
     */
    public void setWBSElementExternalID_Text( @Nullable final String wBSElementExternalID_Text )
    {
        rememberChangedField("WBSElementExternalID_Text", this.wBSElementExternalID_Text);
        this.wBSElementExternalID_Text = wBSElementExternalID_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Project_Text</b>
     * </p>
     *
     * @param project_Text
     *            Project Definition Description
     */
    public void setProject_Text( @Nullable final String project_Text )
    {
        rememberChangedField("Project_Text", this.project_Text);
        this.project_Text = project_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Document Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType_Text</b>
     * </p>
     *
     * @param billingDocumentType_Text
     *            Billing Document Type Description
     */
    public void setBillingDocumentType_Text( @Nullable final String billingDocumentType_Text )
    {
        rememberChangedField("BillingDocumentType_Text", this.billingDocumentType_Text);
        this.billingDocumentType_Text = billingDocumentType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization_Text</b>
     * </p>
     *
     * @param salesOrganization_Text
     *            Sales Organization Description
     */
    public void setSalesOrganization_Text( @Nullable final String salesOrganization_Text )
    {
        rememberChangedField("SalesOrganization_Text", this.salesOrganization_Text);
        this.salesOrganization_Text = salesOrganization_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel_Text</b>
     * </p>
     *
     * @param distributionChannel_Text
     *            Distribution Channel Description
     */
    public void setDistributionChannel_Text( @Nullable final String distributionChannel_Text )
    {
        rememberChangedField("DistributionChannel_Text", this.distributionChannel_Text);
        this.distributionChannel_Text = distributionChannel_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision_Text</b>
     * </p>
     *
     * @param organizationDivision_Text
     *            Division Description
     */
    public void setOrganizationDivision_Text( @Nullable final String organizationDivision_Text )
    {
        rememberChangedField("OrganizationDivision_Text", this.organizationDivision_Text);
        this.organizationDivision_Text = organizationDivision_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @param materialGroup_Text
     *            Material Group Description
     */
    public void setMaterialGroup_Text( @Nullable final String materialGroup_Text )
    {
        rememberChangedField("MaterialGroup_Text", this.materialGroup_Text);
        this.materialGroup_Text = materialGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @param soldProduct
     *            Product Sold
     */
    public void setSoldProduct( @Nullable final String soldProduct )
    {
        rememberChangedField("SoldProduct", this.soldProduct);
        this.soldProduct = soldProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct_Text</b>
     * </p>
     *
     * @param soldProduct_Text
     *            Product Sold Description
     */
    public void setSoldProduct_Text( @Nullable final String soldProduct_Text )
    {
        rememberChangedField("SoldProduct_Text", this.soldProduct_Text);
        this.soldProduct_Text = soldProduct_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @param soldProductGroup
     *            Product Sold Group
     */
    public void setSoldProductGroup( @Nullable final String soldProductGroup )
    {
        rememberChangedField("SoldProductGroup", this.soldProductGroup);
        this.soldProductGroup = soldProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup_Text</b>
     * </p>
     *
     * @param soldProductGroup_Text
     *            Product Sold Group Description
     */
    public void setSoldProductGroup_Text( @Nullable final String soldProductGroup_Text )
    {
        rememberChangedField("SoldProductGroup_Text", this.soldProductGroup_Text);
        this.soldProductGroup_Text = soldProductGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup_Text</b>
     * </p>
     *
     * @param customerGroup_Text
     *            Customer Group Description
     */
    public void setCustomerGroup_Text( @Nullable final String customerGroup_Text )
    {
        rememberChangedField("CustomerGroup_Text", this.customerGroup_Text);
        this.customerGroup_Text = customerGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @param customerSupplierCountry
     *            Customer/Supplier Country/Region
     */
    public void setCustomerSupplierCountry( @Nullable final String customerSupplierCountry )
    {
        rememberChangedField("CustomerSupplierCountry", this.customerSupplierCountry);
        this.customerSupplierCountry = customerSupplierCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry_Text</b>
     * </p>
     *
     * @param customerSupplierCountry_Text
     *            Customer/Supplier Country/Region Description
     */
    public void setCustomerSupplierCountry_Text( @Nullable final String customerSupplierCountry_Text )
    {
        rememberChangedField("CustomerSupplierCountry_Text", this.customerSupplierCountry_Text);
        this.customerSupplierCountry_Text = customerSupplierCountry_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @param customerSupplierIndustry
     *            Customer/Supplier Industry
     */
    public void setCustomerSupplierIndustry( @Nullable final String customerSupplierIndustry )
    {
        rememberChangedField("CustomerSupplierIndustry", this.customerSupplierIndustry);
        this.customerSupplierIndustry = customerSupplierIndustry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry_Text</b>
     * </p>
     *
     * @param customerSupplierIndustry_Text
     *            Customer/Supplier Industry Description
     */
    public void setCustomerSupplierIndustry_Text( @Nullable final String customerSupplierIndustry_Text )
    {
        rememberChangedField("CustomerSupplierIndustry_Text", this.customerSupplierIndustry_Text);
        this.customerSupplierIndustry_Text = customerSupplierIndustry_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict_Text</b>
     * </p>
     *
     * @param salesDistrict_Text
     *            Sales District Description
     */
    public void setSalesDistrict_Text( @Nullable final String salesDistrict_Text )
    {
        rememberChangedField("SalesDistrict_Text", this.salesDistrict_Text);
        this.salesDistrict_Text = salesDistrict_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty_Text</b>
     * </p>
     *
     * @param billToParty_Text
     *            Bill-To Party Description
     */
    public void setBillToParty_Text( @Nullable final String billToParty_Text )
    {
        rememberChangedField("BillToParty_Text", this.billToParty_Text);
        this.billToParty_Text = billToParty_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty_Text</b>
     * </p>
     *
     * @param shipToParty_Text
     *            Ship-To Party Description
     */
    public void setShipToParty_Text( @Nullable final String shipToParty_Text )
    {
        rememberChangedField("ShipToParty_Text", this.shipToParty_Text);
        this.shipToParty_Text = shipToParty_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCorporateGroup</b>
     * </p>
     *
     * @param customerSupplierCorporateGroup
     *            Customer/Supplier Corporate Group
     */
    public void setCustomerSupplierCorporateGroup( @Nullable final String customerSupplierCorporateGroup )
    {
        rememberChangedField("CustomerSupplierCorporateGroup", this.customerSupplierCorporateGroup);
        this.customerSupplierCorporateGroup = customerSupplierCorporateGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocItem</b>
     * </p>
     *
     * @param cnsldtnAdhocItem
     *            Ad Hoc Item
     */
    public void setCnsldtnAdhocItem( @Nullable final String cnsldtnAdhocItem )
    {
        rememberChangedField("CnsldtnAdhocItem", this.cnsldtnAdhocItem);
        this.cnsldtnAdhocItem = cnsldtnAdhocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocItemText</b>
     * </p>
     *
     * @param cnsldtnAdhocItemText
     *            Ad Hoc Item Description
     */
    public void setCnsldtnAdhocItemText( @Nullable final String cnsldtnAdhocItemText )
    {
        rememberChangedField("CnsldtnAdhocItemText", this.cnsldtnAdhocItemText);
        this.cnsldtnAdhocItemText = cnsldtnAdhocItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSet</b>
     * </p>
     *
     * @param cnsldtnAdhocSet
     *            Ad Hoc Set
     */
    public void setCnsldtnAdhocSet( @Nullable final String cnsldtnAdhocSet )
    {
        rememberChangedField("CnsldtnAdhocSet", this.cnsldtnAdhocSet);
        this.cnsldtnAdhocSet = cnsldtnAdhocSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSetText</b>
     * </p>
     *
     * @param cnsldtnAdhocSetText
     *            Ad Hoc Set Description
     */
    public void setCnsldtnAdhocSetText( @Nullable final String cnsldtnAdhocSetText )
    {
        rememberChangedField("CnsldtnAdhocSetText", this.cnsldtnAdhocSetText);
        this.cnsldtnAdhocSetText = cnsldtnAdhocSetText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSetItem</b>
     * </p>
     *
     * @param cnsldtnAdhocSetItem
     *            Ad Hoc Set Item
     */
    public void setCnsldtnAdhocSetItem( @Nullable final String cnsldtnAdhocSetItem )
    {
        rememberChangedField("CnsldtnAdhocSetItem", this.cnsldtnAdhocSetItem);
        this.cnsldtnAdhocSetItem = cnsldtnAdhocSetItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnAdhocSetItemText</b>
     * </p>
     *
     * @param cnsldtnAdhocSetItemText
     *            Ad Hoc Set Item Description
     */
    public void setCnsldtnAdhocSetItemText( @Nullable final String cnsldtnAdhocSetItemText )
    {
        rememberChangedField("CnsldtnAdhocSetItemText", this.cnsldtnAdhocSetItemText);
        this.cnsldtnAdhocSetItemText = cnsldtnAdhocSetItemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GRTransactionDataResults";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ID", getID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ID", getID());
        values.put("ConsolidationLedger", getConsolidationLedger());
        values.put("ConsolidationLedger_Text", getConsolidationLedger_Text());
        values.put("FiscalYear", getFiscalYear());
        values.put("ConsolidationDocumentNumber", getConsolidationDocumentNumber());
        values.put("ConsolidationPostingItem", getConsolidationPostingItem());
        values.put("GLRecordType", getGLRecordType());
        values.put("GLRecordType_Text", getGLRecordType_Text());
        values.put("ConsolidationVersion", getConsolidationVersion());
        values.put("ConsolidationVersion_Text", getConsolidationVersion_Text());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("TransactionCurrency_Text", getTransactionCurrency_Text());
        values.put("LocalCurrency", getLocalCurrency());
        values.put("LocalCurrency_Text", getLocalCurrency_Text());
        values.put("GroupCurrency", getGroupCurrency());
        values.put("GroupCurrency_Text", getGroupCurrency_Text());
        values.put("BaseUnit", getBaseUnit());
        values.put("BaseUnit_Text", getBaseUnit_Text());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("PeriodMode", getPeriodMode());
        values.put("ConsolidationDocumentType", getConsolidationDocumentType());
        values.put("ConsolidationDocumentType_Text", getConsolidationDocumentType_Text());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("DebitCreditCode_Text", getDebitCreditCode_Text());
        values.put("Company", getCompany());
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationUnit_Text", getConsolidationUnit_Text());
        values.put("ConsolidationUnitForElim", getConsolidationUnitForElim());
        values.put("ConsolidationUnitForElim_Text", getConsolidationUnitForElim_Text());
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItem_Text", getFinancialStatementItem_Text());
        values.put("PartnerConsolidationUnit", getPartnerConsolidationUnit());
        values.put("PartnerConsolidationUnit_Text", getPartnerConsolidationUnit_Text());
        values.put("ConsolidationGroup", getConsolidationGroup());
        values.put("ConsolidationGroup_Text", getConsolidationGroup_Text());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCode_Text", getCompanyCode_Text());
        values.put("SubItemCategory", getSubItemCategory());
        values.put("SubItemCategory_Text", getSubItemCategory_Text());
        values.put("SubItem", getSubItem());
        values.put("SubItem_Text", getSubItem_Text());
        values.put("PostingLevel", getPostingLevel());
        values.put("PostingLevel_Text", getPostingLevel_Text());
        values.put("ConsolidationApportionment", getConsolidationApportionment());
        values.put("CurrencyConversionsDiffType", getCurrencyConversionsDiffType());
        values.put("CurrencyConversionsDiffType_Text", getCurrencyConversionsDiffType_Text());
        values.put("ConsolidationAcquisitionYear", getConsolidationAcquisitionYear());
        values.put("ConsolidationAcquisitionPeriod", getConsolidationAcquisitionPeriod());
        values.put("InvesteeConsolidationUnit", getInvesteeConsolidationUnit());
        values.put("InvesteeConsolidationUnit_Text", getInvesteeConsolidationUnit_Text());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("AmountInLocalCurrency", getAmountInLocalCurrency());
        values.put("AmountInGroupCurrency", getAmountInGroupCurrency());
        values.put("QuantityInBaseUnit", getQuantityInBaseUnit());
        values.put("CnsldtnQuantityInBaseUnit", getCnsldtnQuantityInBaseUnit());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("ConsolidationPostgItemAutoFlag", getConsolidationPostgItemAutoFlag());
        values.put("BusinessTransactionType", getBusinessTransactionType());
        values.put("PostingDate", getPostingDate());
        values.put("CurrencyTranslationDate", getCurrencyTranslationDate());
        values.put("RefConsolidationDocumentNumber", getRefConsolidationDocumentNumber());
        values.put("ReferenceFiscalYear", getReferenceFiscalYear());
        values.put("RefConsolidationPostingItem", getRefConsolidationPostingItem());
        values.put("RefConsolidationDocumentType", getRefConsolidationDocumentType());
        values.put("RefBusinessTransactionType", getRefBusinessTransactionType());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("UserID", getUserID());
        values.put("ReverseDocument", getReverseDocument());
        values.put("ReversedDocument", getReversedDocument());
        values.put("InvestmentActivityType", getInvestmentActivityType());
        values.put("InvestmentActivityType_Text", getInvestmentActivityType_Text());
        values.put("InvestmentActivity", getInvestmentActivity());
        values.put("ConsolidationDocReversalYear", getConsolidationDocReversalYear());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("ReferenceDocumentContext", getReferenceDocumentContext());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("ChartOfAccounts_Text", getChartOfAccounts_Text());
        values.put("GLAccount", getGLAccount());
        values.put("GLAccount_Text", getGLAccount_Text());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("CostCenter", getCostCenter());
        values.put("CostCenter_Text", getCostCenter_Text());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenter_Text", getProfitCenter_Text());
        values.put("ConsolidationPrftCtrForElim", getConsolidationPrftCtrForElim());
        values.put("ConsolidationPrftCtrForElim_Text", getConsolidationPrftCtrForElim_Text());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalArea_Text", getFunctionalArea_Text());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessArea_Text", getBusinessArea_Text());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingArea_Text", getControllingArea_Text());
        values.put("Segment", getSegment());
        values.put("Segment_Text", getSegment_Text());
        values.put("ConsolidationSegmentForElim", getConsolidationSegmentForElim());
        values.put("ConsolidationSegmentForElim_Text", getConsolidationSegmentForElim_Text());
        values.put("PartnerCostCenter", getPartnerCostCenter());
        values.put("PartnerCostCenter_Text", getPartnerCostCenter_Text());
        values.put("PartnerProfitCenter", getPartnerProfitCenter());
        values.put("PartnerProfitCenter_Text", getPartnerProfitCenter_Text());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("PartnerFunctionalArea_Text", getPartnerFunctionalArea_Text());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("PartnerBusinessArea_Text", getPartnerBusinessArea_Text());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("PartnerCompany_Text", getPartnerCompany_Text());
        values.put("PartnerSegment", getPartnerSegment());
        values.put("PartnerSegment_Text", getPartnerSegment_Text());
        values.put("OrderID", getOrderID());
        values.put("OrderID_Text", getOrderID_Text());
        values.put("Customer", getCustomer());
        values.put("Customer_Text", getCustomer_Text());
        values.put("Supplier", getSupplier());
        values.put("Supplier_Text", getSupplier_Text());
        values.put("Material", getMaterial());
        values.put("Material_Text", getMaterial_Text());
        values.put("Plant", getPlant());
        values.put("Plant_Text", getPlant_Text());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("FinancialTransactionType_Text", getFinancialTransactionType_Text());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSDescription", getWBSDescription());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("WBSElementExternalID_Text", getWBSElementExternalID_Text());
        values.put("Project", getProject());
        values.put("Project_Text", getProject_Text());
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("BillingDocumentType_Text", getBillingDocumentType_Text());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOrganization_Text", getSalesOrganization_Text());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("DistributionChannel_Text", getDistributionChannel_Text());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("OrganizationDivision_Text", getOrganizationDivision_Text());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroup_Text", getMaterialGroup_Text());
        values.put("SoldProduct", getSoldProduct());
        values.put("SoldProduct_Text", getSoldProduct_Text());
        values.put("SoldProductGroup", getSoldProductGroup());
        values.put("SoldProductGroup_Text", getSoldProductGroup_Text());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerGroup_Text", getCustomerGroup_Text());
        values.put("CustomerSupplierCountry", getCustomerSupplierCountry());
        values.put("CustomerSupplierCountry_Text", getCustomerSupplierCountry_Text());
        values.put("CustomerSupplierIndustry", getCustomerSupplierIndustry());
        values.put("CustomerSupplierIndustry_Text", getCustomerSupplierIndustry_Text());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SalesDistrict_Text", getSalesDistrict_Text());
        values.put("BillToParty", getBillToParty());
        values.put("BillToParty_Text", getBillToParty_Text());
        values.put("ShipToParty", getShipToParty());
        values.put("ShipToParty_Text", getShipToParty_Text());
        values.put("CustomerSupplierCorporateGroup", getCustomerSupplierCorporateGroup());
        values.put("CnsldtnAdhocItem", getCnsldtnAdhocItem());
        values.put("CnsldtnAdhocItemText", getCnsldtnAdhocItemText());
        values.put("CnsldtnAdhocSet", getCnsldtnAdhocSet());
        values.put("CnsldtnAdhocSetText", getCnsldtnAdhocSetText());
        values.put("CnsldtnAdhocSetItem", getCnsldtnAdhocSetItem());
        values.put("CnsldtnAdhocSetItemText", getCnsldtnAdhocSetItemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ID") ) {
                final Object value = values.remove("ID");
                if( (value == null) || (!value.equals(getID())) ) {
                    setID(((String) value));
                }
            }
            if( values.containsKey("ConsolidationLedger") ) {
                final Object value = values.remove("ConsolidationLedger");
                if( (value == null) || (!value.equals(getConsolidationLedger())) ) {
                    setConsolidationLedger(((String) value));
                }
            }
            if( values.containsKey("ConsolidationLedger_Text") ) {
                final Object value = values.remove("ConsolidationLedger_Text");
                if( (value == null) || (!value.equals(getConsolidationLedger_Text())) ) {
                    setConsolidationLedger_Text(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentNumber") ) {
                final Object value = values.remove("ConsolidationDocumentNumber");
                if( (value == null) || (!value.equals(getConsolidationDocumentNumber())) ) {
                    setConsolidationDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("ConsolidationPostingItem") ) {
                final Object value = values.remove("ConsolidationPostingItem");
                if( (value == null) || (!value.equals(getConsolidationPostingItem())) ) {
                    setConsolidationPostingItem(((String) value));
                }
            }
            if( values.containsKey("GLRecordType") ) {
                final Object value = values.remove("GLRecordType");
                if( (value == null) || (!value.equals(getGLRecordType())) ) {
                    setGLRecordType(((String) value));
                }
            }
            if( values.containsKey("GLRecordType_Text") ) {
                final Object value = values.remove("GLRecordType_Text");
                if( (value == null) || (!value.equals(getGLRecordType_Text())) ) {
                    setGLRecordType_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersion") ) {
                final Object value = values.remove("ConsolidationVersion");
                if( (value == null) || (!value.equals(getConsolidationVersion())) ) {
                    setConsolidationVersion(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersion_Text") ) {
                final Object value = values.remove("ConsolidationVersion_Text");
                if( (value == null) || (!value.equals(getConsolidationVersion_Text())) ) {
                    setConsolidationVersion_Text(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency_Text") ) {
                final Object value = values.remove("TransactionCurrency_Text");
                if( (value == null) || (!value.equals(getTransactionCurrency_Text())) ) {
                    setTransactionCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("LocalCurrency") ) {
                final Object value = values.remove("LocalCurrency");
                if( (value == null) || (!value.equals(getLocalCurrency())) ) {
                    setLocalCurrency(((String) value));
                }
            }
            if( values.containsKey("LocalCurrency_Text") ) {
                final Object value = values.remove("LocalCurrency_Text");
                if( (value == null) || (!value.equals(getLocalCurrency_Text())) ) {
                    setLocalCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("GroupCurrency") ) {
                final Object value = values.remove("GroupCurrency");
                if( (value == null) || (!value.equals(getGroupCurrency())) ) {
                    setGroupCurrency(((String) value));
                }
            }
            if( values.containsKey("GroupCurrency_Text") ) {
                final Object value = values.remove("GroupCurrency_Text");
                if( (value == null) || (!value.equals(getGroupCurrency_Text())) ) {
                    setGroupCurrency_Text(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BaseUnit_Text") ) {
                final Object value = values.remove("BaseUnit_Text");
                if( (value == null) || (!value.equals(getBaseUnit_Text())) ) {
                    setBaseUnit_Text(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("PeriodMode") ) {
                final Object value = values.remove("PeriodMode");
                if( (value == null) || (!value.equals(getPeriodMode())) ) {
                    setPeriodMode(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentType") ) {
                final Object value = values.remove("ConsolidationDocumentType");
                if( (value == null) || (!value.equals(getConsolidationDocumentType())) ) {
                    setConsolidationDocumentType(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocumentType_Text") ) {
                final Object value = values.remove("ConsolidationDocumentType_Text");
                if( (value == null) || (!value.equals(getConsolidationDocumentType_Text())) ) {
                    setConsolidationDocumentType_Text(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode_Text") ) {
                final Object value = values.remove("DebitCreditCode_Text");
                if( (value == null) || (!value.equals(getDebitCreditCode_Text())) ) {
                    setDebitCreditCode_Text(((String) value));
                }
            }
            if( values.containsKey("Company") ) {
                final Object value = values.remove("Company");
                if( (value == null) || (!value.equals(getCompany())) ) {
                    setCompany(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnit_Text") ) {
                final Object value = values.remove("ConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getConsolidationUnit_Text())) ) {
                    setConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitForElim") ) {
                final Object value = values.remove("ConsolidationUnitForElim");
                if( (value == null) || (!value.equals(getConsolidationUnitForElim())) ) {
                    setConsolidationUnitForElim(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitForElim_Text") ) {
                final Object value = values.remove("ConsolidationUnitForElim_Text");
                if( (value == null) || (!value.equals(getConsolidationUnitForElim_Text())) ) {
                    setConsolidationUnitForElim_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem_Text") ) {
                final Object value = values.remove("FinancialStatementItem_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItem_Text())) ) {
                    setFinancialStatementItem_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerConsolidationUnit") ) {
                final Object value = values.remove("PartnerConsolidationUnit");
                if( (value == null) || (!value.equals(getPartnerConsolidationUnit())) ) {
                    setPartnerConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("PartnerConsolidationUnit_Text") ) {
                final Object value = values.remove("PartnerConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getPartnerConsolidationUnit_Text())) ) {
                    setPartnerConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationGroup") ) {
                final Object value = values.remove("ConsolidationGroup");
                if( (value == null) || (!value.equals(getConsolidationGroup())) ) {
                    setConsolidationGroup(((String) value));
                }
            }
            if( values.containsKey("ConsolidationGroup_Text") ) {
                final Object value = values.remove("ConsolidationGroup_Text");
                if( (value == null) || (!value.equals(getConsolidationGroup_Text())) ) {
                    setConsolidationGroup_Text(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCode_Text") ) {
                final Object value = values.remove("CompanyCode_Text");
                if( (value == null) || (!value.equals(getCompanyCode_Text())) ) {
                    setCompanyCode_Text(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory") ) {
                final Object value = values.remove("SubItemCategory");
                if( (value == null) || (!value.equals(getSubItemCategory())) ) {
                    setSubItemCategory(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory_Text") ) {
                final Object value = values.remove("SubItemCategory_Text");
                if( (value == null) || (!value.equals(getSubItemCategory_Text())) ) {
                    setSubItemCategory_Text(((String) value));
                }
            }
            if( values.containsKey("SubItem") ) {
                final Object value = values.remove("SubItem");
                if( (value == null) || (!value.equals(getSubItem())) ) {
                    setSubItem(((String) value));
                }
            }
            if( values.containsKey("SubItem_Text") ) {
                final Object value = values.remove("SubItem_Text");
                if( (value == null) || (!value.equals(getSubItem_Text())) ) {
                    setSubItem_Text(((String) value));
                }
            }
            if( values.containsKey("PostingLevel") ) {
                final Object value = values.remove("PostingLevel");
                if( (value == null) || (!value.equals(getPostingLevel())) ) {
                    setPostingLevel(((String) value));
                }
            }
            if( values.containsKey("PostingLevel_Text") ) {
                final Object value = values.remove("PostingLevel_Text");
                if( (value == null) || (!value.equals(getPostingLevel_Text())) ) {
                    setPostingLevel_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationApportionment") ) {
                final Object value = values.remove("ConsolidationApportionment");
                if( (value == null) || (!value.equals(getConsolidationApportionment())) ) {
                    setConsolidationApportionment(((String) value));
                }
            }
            if( values.containsKey("CurrencyConversionsDiffType") ) {
                final Object value = values.remove("CurrencyConversionsDiffType");
                if( (value == null) || (!value.equals(getCurrencyConversionsDiffType())) ) {
                    setCurrencyConversionsDiffType(((String) value));
                }
            }
            if( values.containsKey("CurrencyConversionsDiffType_Text") ) {
                final Object value = values.remove("CurrencyConversionsDiffType_Text");
                if( (value == null) || (!value.equals(getCurrencyConversionsDiffType_Text())) ) {
                    setCurrencyConversionsDiffType_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAcquisitionYear") ) {
                final Object value = values.remove("ConsolidationAcquisitionYear");
                if( (value == null) || (!value.equals(getConsolidationAcquisitionYear())) ) {
                    setConsolidationAcquisitionYear(((String) value));
                }
            }
            if( values.containsKey("ConsolidationAcquisitionPeriod") ) {
                final Object value = values.remove("ConsolidationAcquisitionPeriod");
                if( (value == null) || (!value.equals(getConsolidationAcquisitionPeriod())) ) {
                    setConsolidationAcquisitionPeriod(((String) value));
                }
            }
            if( values.containsKey("InvesteeConsolidationUnit") ) {
                final Object value = values.remove("InvesteeConsolidationUnit");
                if( (value == null) || (!value.equals(getInvesteeConsolidationUnit())) ) {
                    setInvesteeConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("InvesteeConsolidationUnit_Text") ) {
                final Object value = values.remove("InvesteeConsolidationUnit_Text");
                if( (value == null) || (!value.equals(getInvesteeConsolidationUnit_Text())) ) {
                    setInvesteeConsolidationUnit_Text(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("AmountInLocalCurrency") ) {
                final Object value = values.remove("AmountInLocalCurrency");
                if( (value == null) || (!value.equals(getAmountInLocalCurrency())) ) {
                    setAmountInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("AmountInGroupCurrency") ) {
                final Object value = values.remove("AmountInGroupCurrency");
                if( (value == null) || (!value.equals(getAmountInGroupCurrency())) ) {
                    setAmountInGroupCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityInBaseUnit") ) {
                final Object value = values.remove("QuantityInBaseUnit");
                if( (value == null) || (!value.equals(getQuantityInBaseUnit())) ) {
                    setQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("CnsldtnQuantityInBaseUnit") ) {
                final Object value = values.remove("CnsldtnQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getCnsldtnQuantityInBaseUnit())) ) {
                    setCnsldtnQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("ConsolidationPostgItemAutoFlag") ) {
                final Object value = values.remove("ConsolidationPostgItemAutoFlag");
                if( (value == null) || (!value.equals(getConsolidationPostgItemAutoFlag())) ) {
                    setConsolidationPostgItemAutoFlag(((String) value));
                }
            }
            if( values.containsKey("BusinessTransactionType") ) {
                final Object value = values.remove("BusinessTransactionType");
                if( (value == null) || (!value.equals(getBusinessTransactionType())) ) {
                    setBusinessTransactionType(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CurrencyTranslationDate") ) {
                final Object value = values.remove("CurrencyTranslationDate");
                if( (value == null) || (!value.equals(getCurrencyTranslationDate())) ) {
                    setCurrencyTranslationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RefConsolidationDocumentNumber") ) {
                final Object value = values.remove("RefConsolidationDocumentNumber");
                if( (value == null) || (!value.equals(getRefConsolidationDocumentNumber())) ) {
                    setRefConsolidationDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("ReferenceFiscalYear") ) {
                final Object value = values.remove("ReferenceFiscalYear");
                if( (value == null) || (!value.equals(getReferenceFiscalYear())) ) {
                    setReferenceFiscalYear(((String) value));
                }
            }
            if( values.containsKey("RefConsolidationPostingItem") ) {
                final Object value = values.remove("RefConsolidationPostingItem");
                if( (value == null) || (!value.equals(getRefConsolidationPostingItem())) ) {
                    setRefConsolidationPostingItem(((String) value));
                }
            }
            if( values.containsKey("RefConsolidationDocumentType") ) {
                final Object value = values.remove("RefConsolidationDocumentType");
                if( (value == null) || (!value.equals(getRefConsolidationDocumentType())) ) {
                    setRefConsolidationDocumentType(((String) value));
                }
            }
            if( values.containsKey("RefBusinessTransactionType") ) {
                final Object value = values.remove("RefBusinessTransactionType");
                if( (value == null) || (!value.equals(getRefBusinessTransactionType())) ) {
                    setRefBusinessTransactionType(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("UserID") ) {
                final Object value = values.remove("UserID");
                if( (value == null) || (!value.equals(getUserID())) ) {
                    setUserID(((String) value));
                }
            }
            if( values.containsKey("ReverseDocument") ) {
                final Object value = values.remove("ReverseDocument");
                if( (value == null) || (!value.equals(getReverseDocument())) ) {
                    setReverseDocument(((String) value));
                }
            }
            if( values.containsKey("ReversedDocument") ) {
                final Object value = values.remove("ReversedDocument");
                if( (value == null) || (!value.equals(getReversedDocument())) ) {
                    setReversedDocument(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityType") ) {
                final Object value = values.remove("InvestmentActivityType");
                if( (value == null) || (!value.equals(getInvestmentActivityType())) ) {
                    setInvestmentActivityType(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityType_Text") ) {
                final Object value = values.remove("InvestmentActivityType_Text");
                if( (value == null) || (!value.equals(getInvestmentActivityType_Text())) ) {
                    setInvestmentActivityType_Text(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivity") ) {
                final Object value = values.remove("InvestmentActivity");
                if( (value == null) || (!value.equals(getInvestmentActivity())) ) {
                    setInvestmentActivity(((String) value));
                }
            }
            if( values.containsKey("ConsolidationDocReversalYear") ) {
                final Object value = values.remove("ConsolidationDocReversalYear");
                if( (value == null) || (!value.equals(getConsolidationDocReversalYear())) ) {
                    setConsolidationDocReversalYear(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentContext") ) {
                final Object value = values.remove("ReferenceDocumentContext");
                if( (value == null) || (!value.equals(getReferenceDocumentContext())) ) {
                    setReferenceDocumentContext(((String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts_Text") ) {
                final Object value = values.remove("ChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getChartOfAccounts_Text())) ) {
                    setChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("GLAccount_Text") ) {
                final Object value = values.remove("GLAccount_Text");
                if( (value == null) || (!value.equals(getGLAccount_Text())) ) {
                    setGLAccount_Text(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenter_Text") ) {
                final Object value = values.remove("CostCenter_Text");
                if( (value == null) || (!value.equals(getCostCenter_Text())) ) {
                    setCostCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter_Text") ) {
                final Object value = values.remove("ProfitCenter_Text");
                if( (value == null) || (!value.equals(getProfitCenter_Text())) ) {
                    setProfitCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationPrftCtrForElim") ) {
                final Object value = values.remove("ConsolidationPrftCtrForElim");
                if( (value == null) || (!value.equals(getConsolidationPrftCtrForElim())) ) {
                    setConsolidationPrftCtrForElim(((String) value));
                }
            }
            if( values.containsKey("ConsolidationPrftCtrForElim_Text") ) {
                final Object value = values.remove("ConsolidationPrftCtrForElim_Text");
                if( (value == null) || (!value.equals(getConsolidationPrftCtrForElim_Text())) ) {
                    setConsolidationPrftCtrForElim_Text(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea_Text") ) {
                final Object value = values.remove("FunctionalArea_Text");
                if( (value == null) || (!value.equals(getFunctionalArea_Text())) ) {
                    setFunctionalArea_Text(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea_Text") ) {
                final Object value = values.remove("BusinessArea_Text");
                if( (value == null) || (!value.equals(getBusinessArea_Text())) ) {
                    setBusinessArea_Text(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingArea_Text") ) {
                final Object value = values.remove("ControllingArea_Text");
                if( (value == null) || (!value.equals(getControllingArea_Text())) ) {
                    setControllingArea_Text(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("Segment_Text") ) {
                final Object value = values.remove("Segment_Text");
                if( (value == null) || (!value.equals(getSegment_Text())) ) {
                    setSegment_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationSegmentForElim") ) {
                final Object value = values.remove("ConsolidationSegmentForElim");
                if( (value == null) || (!value.equals(getConsolidationSegmentForElim())) ) {
                    setConsolidationSegmentForElim(((String) value));
                }
            }
            if( values.containsKey("ConsolidationSegmentForElim_Text") ) {
                final Object value = values.remove("ConsolidationSegmentForElim_Text");
                if( (value == null) || (!value.equals(getConsolidationSegmentForElim_Text())) ) {
                    setConsolidationSegmentForElim_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter") ) {
                final Object value = values.remove("PartnerCostCenter");
                if( (value == null) || (!value.equals(getPartnerCostCenter())) ) {
                    setPartnerCostCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter_Text") ) {
                final Object value = values.remove("PartnerCostCenter_Text");
                if( (value == null) || (!value.equals(getPartnerCostCenter_Text())) ) {
                    setPartnerCostCenter_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter") ) {
                final Object value = values.remove("PartnerProfitCenter");
                if( (value == null) || (!value.equals(getPartnerProfitCenter())) ) {
                    setPartnerProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter_Text") ) {
                final Object value = values.remove("PartnerProfitCenter_Text");
                if( (value == null) || (!value.equals(getPartnerProfitCenter_Text())) ) {
                    setPartnerProfitCenter_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea_Text") ) {
                final Object value = values.remove("PartnerFunctionalArea_Text");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea_Text())) ) {
                    setPartnerFunctionalArea_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea_Text") ) {
                final Object value = values.remove("PartnerBusinessArea_Text");
                if( (value == null) || (!value.equals(getPartnerBusinessArea_Text())) ) {
                    setPartnerBusinessArea_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany_Text") ) {
                final Object value = values.remove("PartnerCompany_Text");
                if( (value == null) || (!value.equals(getPartnerCompany_Text())) ) {
                    setPartnerCompany_Text(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment") ) {
                final Object value = values.remove("PartnerSegment");
                if( (value == null) || (!value.equals(getPartnerSegment())) ) {
                    setPartnerSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment_Text") ) {
                final Object value = values.remove("PartnerSegment_Text");
                if( (value == null) || (!value.equals(getPartnerSegment_Text())) ) {
                    setPartnerSegment_Text(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderID_Text") ) {
                final Object value = values.remove("OrderID_Text");
                if( (value == null) || (!value.equals(getOrderID_Text())) ) {
                    setOrderID_Text(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Customer_Text") ) {
                final Object value = values.remove("Customer_Text");
                if( (value == null) || (!value.equals(getCustomer_Text())) ) {
                    setCustomer_Text(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Supplier_Text") ) {
                final Object value = values.remove("Supplier_Text");
                if( (value == null) || (!value.equals(getSupplier_Text())) ) {
                    setSupplier_Text(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Material_Text") ) {
                final Object value = values.remove("Material_Text");
                if( (value == null) || (!value.equals(getMaterial_Text())) ) {
                    setMaterial_Text(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Plant_Text") ) {
                final Object value = values.remove("Plant_Text");
                if( (value == null) || (!value.equals(getPlant_Text())) ) {
                    setPlant_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType_Text") ) {
                final Object value = values.remove("FinancialTransactionType_Text");
                if( (value == null) || (!value.equals(getFinancialTransactionType_Text())) ) {
                    setFinancialTransactionType_Text(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSDescription") ) {
                final Object value = values.remove("WBSDescription");
                if( (value == null) || (!value.equals(getWBSDescription())) ) {
                    setWBSDescription(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID_Text") ) {
                final Object value = values.remove("WBSElementExternalID_Text");
                if( (value == null) || (!value.equals(getWBSElementExternalID_Text())) ) {
                    setWBSElementExternalID_Text(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("Project_Text") ) {
                final Object value = values.remove("Project_Text");
                if( (value == null) || (!value.equals(getProject_Text())) ) {
                    setProject_Text(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType_Text") ) {
                final Object value = values.remove("BillingDocumentType_Text");
                if( (value == null) || (!value.equals(getBillingDocumentType_Text())) ) {
                    setBillingDocumentType_Text(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization_Text") ) {
                final Object value = values.remove("SalesOrganization_Text");
                if( (value == null) || (!value.equals(getSalesOrganization_Text())) ) {
                    setSalesOrganization_Text(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel_Text") ) {
                final Object value = values.remove("DistributionChannel_Text");
                if( (value == null) || (!value.equals(getDistributionChannel_Text())) ) {
                    setDistributionChannel_Text(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision_Text") ) {
                final Object value = values.remove("OrganizationDivision_Text");
                if( (value == null) || (!value.equals(getOrganizationDivision_Text())) ) {
                    setOrganizationDivision_Text(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup_Text") ) {
                final Object value = values.remove("MaterialGroup_Text");
                if( (value == null) || (!value.equals(getMaterialGroup_Text())) ) {
                    setMaterialGroup_Text(((String) value));
                }
            }
            if( values.containsKey("SoldProduct") ) {
                final Object value = values.remove("SoldProduct");
                if( (value == null) || (!value.equals(getSoldProduct())) ) {
                    setSoldProduct(((String) value));
                }
            }
            if( values.containsKey("SoldProduct_Text") ) {
                final Object value = values.remove("SoldProduct_Text");
                if( (value == null) || (!value.equals(getSoldProduct_Text())) ) {
                    setSoldProduct_Text(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroup") ) {
                final Object value = values.remove("SoldProductGroup");
                if( (value == null) || (!value.equals(getSoldProductGroup())) ) {
                    setSoldProductGroup(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroup_Text") ) {
                final Object value = values.remove("SoldProductGroup_Text");
                if( (value == null) || (!value.equals(getSoldProductGroup_Text())) ) {
                    setSoldProductGroup_Text(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup_Text") ) {
                final Object value = values.remove("CustomerGroup_Text");
                if( (value == null) || (!value.equals(getCustomerGroup_Text())) ) {
                    setCustomerGroup_Text(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCountry") ) {
                final Object value = values.remove("CustomerSupplierCountry");
                if( (value == null) || (!value.equals(getCustomerSupplierCountry())) ) {
                    setCustomerSupplierCountry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCountry_Text") ) {
                final Object value = values.remove("CustomerSupplierCountry_Text");
                if( (value == null) || (!value.equals(getCustomerSupplierCountry_Text())) ) {
                    setCustomerSupplierCountry_Text(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierIndustry") ) {
                final Object value = values.remove("CustomerSupplierIndustry");
                if( (value == null) || (!value.equals(getCustomerSupplierIndustry())) ) {
                    setCustomerSupplierIndustry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierIndustry_Text") ) {
                final Object value = values.remove("CustomerSupplierIndustry_Text");
                if( (value == null) || (!value.equals(getCustomerSupplierIndustry_Text())) ) {
                    setCustomerSupplierIndustry_Text(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict_Text") ) {
                final Object value = values.remove("SalesDistrict_Text");
                if( (value == null) || (!value.equals(getSalesDistrict_Text())) ) {
                    setSalesDistrict_Text(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty_Text") ) {
                final Object value = values.remove("BillToParty_Text");
                if( (value == null) || (!value.equals(getBillToParty_Text())) ) {
                    setBillToParty_Text(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty_Text") ) {
                final Object value = values.remove("ShipToParty_Text");
                if( (value == null) || (!value.equals(getShipToParty_Text())) ) {
                    setShipToParty_Text(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCorporateGroup") ) {
                final Object value = values.remove("CustomerSupplierCorporateGroup");
                if( (value == null) || (!value.equals(getCustomerSupplierCorporateGroup())) ) {
                    setCustomerSupplierCorporateGroup(((String) value));
                }
            }
            if( values.containsKey("CnsldtnAdhocItem") ) {
                final Object value = values.remove("CnsldtnAdhocItem");
                if( (value == null) || (!value.equals(getCnsldtnAdhocItem())) ) {
                    setCnsldtnAdhocItem(((String) value));
                }
            }
            if( values.containsKey("CnsldtnAdhocItemText") ) {
                final Object value = values.remove("CnsldtnAdhocItemText");
                if( (value == null) || (!value.equals(getCnsldtnAdhocItemText())) ) {
                    setCnsldtnAdhocItemText(((String) value));
                }
            }
            if( values.containsKey("CnsldtnAdhocSet") ) {
                final Object value = values.remove("CnsldtnAdhocSet");
                if( (value == null) || (!value.equals(getCnsldtnAdhocSet())) ) {
                    setCnsldtnAdhocSet(((String) value));
                }
            }
            if( values.containsKey("CnsldtnAdhocSetText") ) {
                final Object value = values.remove("CnsldtnAdhocSetText");
                if( (value == null) || (!value.equals(getCnsldtnAdhocSetText())) ) {
                    setCnsldtnAdhocSetText(((String) value));
                }
            }
            if( values.containsKey("CnsldtnAdhocSetItem") ) {
                final Object value = values.remove("CnsldtnAdhocSetItem");
                if( (value == null) || (!value.equals(getCnsldtnAdhocSetItem())) ) {
                    setCnsldtnAdhocSetItem(((String) value));
                }
            }
            if( values.containsKey("CnsldtnAdhocSetItemText") ) {
                final Object value = values.remove("CnsldtnAdhocSetItemText");
                if( (value == null) || (!value.equals(getCnsldtnAdhocSetItemText())) ) {
                    setCnsldtnAdhocSetItemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new GRTransactionDataParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GRTransactionDataResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GRTransactionDataResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GRTransactionDataResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GRTransactionDataResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TransactionDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Fetches the <b>GRTransactionDataParameters</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>Parameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GRTransactionDataParameters</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GRTransactionDataParameters fetchParameters()
    {
        return fetchFieldAsSingle("Parameters", GRTransactionDataParameters.class);
    }

    /**
     * Retrieval of associated <b>GRTransactionDataParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property <b>Parameters</b> of a queried <b>GRTransactionDataResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GRTransactionDataParameters</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GRTransactionDataParameters getParametersOrFetch()
    {
        if( toParameters == null ) {
            toParameters = fetchParameters();
        }
        return toParameters;
    }

    /**
     * Retrieval of associated <b>GRTransactionDataParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>GRTransactionDataResult</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>GRTransactionDataParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<GRTransactionDataParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>GRTransactionDataParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     *
     * @param value
     *            New <b>GRTransactionDataParameters</b> entity.
     */
    public void setParameters( final GRTransactionDataParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of GRTransactionDataResult instances.
     *
     */
    public final static class GRTransactionDataResultBuilder
    {

        private GRTransactionDataParameters toParameters;

        private GRTransactionDataResult.GRTransactionDataResultBuilder toParameters(
            final GRTransactionDataParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>GRTransactionDataResult</b> to single
         * <b>GRTransactionDataParameters</b>.
         *
         * @param value
         *            The GRTransactionDataParameters to build this GRTransactionDataResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GRTransactionDataResult.GRTransactionDataResultBuilder parameters(
            final GRTransactionDataParameters value )
        {
            return toParameters(value);
        }

    }

}
