/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link TransactionDataForGroupReportingServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.TransactionDataForGroupReportingService
 * TransactionDataForGroupReportingService}.
 *
 */
public class DefaultTransactionDataForGroupReportingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<TransactionDataForGroupReportingServiceBatch, TransactionDataForGroupReportingServiceBatchChangeSet>
    implements
    TransactionDataForGroupReportingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TransactionDataForGroupReportingService service;

    @SuppressWarnings( "deprecation" )
    DefaultTransactionDataForGroupReportingServiceBatchChangeSet(
        @Nonnull final DefaultTransactionDataForGroupReportingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TransactionDataForGroupReportingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultTransactionDataForGroupReportingServiceBatchChangeSet getThis()
    {
        return this;
    }

}
