/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters
 * GRTransactionDataParameters}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.field.GRTransactionDataParametersField
 * GRTransactionDataParametersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.link.GRTransactionDataParametersLink
 * GRTransactionDataParametersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters#P_CONSOLIDATION_UNIT_HIER_ID
 * P_CONSOLIDATION_UNIT_HIER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters#P_CONSOLIDATION_PRFT_CTR_HIER_ID
 * P_CONSOLIDATION_PRFT_CTR_HIER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters#P_CONSOLIDATION_SEGMENT_HIER_ID
 * P_CONSOLIDATION_SEGMENT_HIER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters#P_KEY_DATE
 * P_KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataParameters#TO_RESULTS
 * TO_RESULTS}</li>
 * </ul>
 *
 */
public interface GRTransactionDataParametersSelectable extends EntitySelectable<GRTransactionDataParameters>
{

}
