/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult
 * GRTransactionDataResult}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.field.GRTransactionDataResultField
 * GRTransactionDataResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.link.GRTransactionDataResultLink
 * GRTransactionDataResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#ID
 * ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_LEDGER
 * CONSOLIDATION_LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_LEDGER_TEXT
 * CONSOLIDATION_LEDGER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_DOCUMENT_NUMBER
 * CONSOLIDATION_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_POSTING_ITEM
 * CONSOLIDATION_POSTING_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#GL_RECORD_TYPE
 * GL_RECORD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#GL_RECORD_TYPE_TEXT
 * GL_RECORD_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_VERSION
 * CONSOLIDATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_VERSION_TEXT
 * CONSOLIDATION_VERSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#TRANSACTION_CURRENCY_TEXT
 * TRANSACTION_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#LOCAL_CURRENCY
 * LOCAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#LOCAL_CURRENCY_TEXT
 * LOCAL_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#GROUP_CURRENCY
 * GROUP_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#GROUP_CURRENCY_TEXT
 * GROUP_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BASE_UNIT_TEXT
 * BASE_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PERIOD_MODE
 * PERIOD_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_DOCUMENT_TYPE
 * CONSOLIDATION_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_DOCUMENT_TYPE_TEXT
 * CONSOLIDATION_DOCUMENT_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#DEBIT_CREDIT_CODE_TEXT
 * DEBIT_CREDIT_CODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#COMPANY
 * COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_UNIT_TEXT
 * CONSOLIDATION_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_UNIT_FOR_ELIM
 * CONSOLIDATION_UNIT_FOR_ELIM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_UNIT_FOR_ELIM_TEXT
 * CONSOLIDATION_UNIT_FOR_ELIM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FINANCIAL_STATEMENT_ITEM
 * FINANCIAL_STATEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FINANCIAL_STATEMENT_ITEM_TEXT
 * FINANCIAL_STATEMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_CONSOLIDATION_UNIT
 * PARTNER_CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_CONSOLIDATION_UNIT_TEXT
 * PARTNER_CONSOLIDATION_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_GROUP
 * CONSOLIDATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_GROUP_TEXT
 * CONSOLIDATION_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#COMPANY_CODE_TEXT
 * COMPANY_CODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SUB_ITEM_CATEGORY
 * SUB_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SUB_ITEM_CATEGORY_TEXT
 * SUB_ITEM_CATEGORY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SUB_ITEM
 * SUB_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SUB_ITEM_TEXT
 * SUB_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#POSTING_LEVEL
 * POSTING_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#POSTING_LEVEL_TEXT
 * POSTING_LEVEL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_APPORTIONMENT
 * CONSOLIDATION_APPORTIONMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CURRENCY_CONVERSIONS_DIFF_TYPE
 * CURRENCY_CONVERSIONS_DIFF_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CURRENCY_CONVERSIONS_DIFF_TYPE_TEXT
 * CURRENCY_CONVERSIONS_DIFF_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_ACQUISITION_YEAR
 * CONSOLIDATION_ACQUISITION_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_ACQUISITION_PERIOD
 * CONSOLIDATION_ACQUISITION_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#INVESTEE_CONSOLIDATION_UNIT
 * INVESTEE_CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#INVESTEE_CONSOLIDATION_UNIT_TEXT
 * INVESTEE_CONSOLIDATION_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#AMOUNT_IN_LOCAL_CURRENCY
 * AMOUNT_IN_LOCAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#AMOUNT_IN_GROUP_CURRENCY
 * AMOUNT_IN_GROUP_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#QUANTITY_IN_BASE_UNIT
 * QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_QUANTITY_IN_BASE_UNIT
 * CNSLDTN_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_POSTG_ITEM_AUTO_FLAG
 * CONSOLIDATION_POSTG_ITEM_AUTO_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BUSINESS_TRANSACTION_TYPE
 * BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CURRENCY_TRANSLATION_DATE
 * CURRENCY_TRANSLATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REF_CONSOLIDATION_DOCUMENT_NUMBER
 * REF_CONSOLIDATION_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REFERENCE_FISCAL_YEAR
 * REFERENCE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REF_CONSOLIDATION_POSTING_ITEM
 * REF_CONSOLIDATION_POSTING_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REF_CONSOLIDATION_DOCUMENT_TYPE
 * REF_CONSOLIDATION_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REF_BUSINESS_TRANSACTION_TYPE
 * REF_BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#USER_ID
 * USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REVERSE_DOCUMENT
 * REVERSE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REVERSED_DOCUMENT
 * REVERSED_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#INVESTMENT_ACTIVITY_TYPE
 * INVESTMENT_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#INVESTMENT_ACTIVITY_TYPE_TEXT
 * INVESTMENT_ACTIVITY_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#INVESTMENT_ACTIVITY
 * INVESTMENT_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_DOC_REVERSAL_YEAR
 * CONSOLIDATION_DOC_REVERSAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#REFERENCE_DOCUMENT_CONTEXT
 * REFERENCE_DOCUMENT_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CHART_OF_ACCOUNTS_TEXT
 * CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#GL_ACCOUNT_TEXT
 * GL_ACCOUNT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#COST_CENTER_TEXT
 * COST_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PROFIT_CENTER_TEXT
 * PROFIT_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_PRFT_CTR_FOR_ELIM
 * CONSOLIDATION_PRFT_CTR_FOR_ELIM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_PRFT_CTR_FOR_ELIM_TEXT
 * CONSOLIDATION_PRFT_CTR_FOR_ELIM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FUNCTIONAL_AREA_TEXT
 * FUNCTIONAL_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BUSINESS_AREA_TEXT
 * BUSINESS_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONTROLLING_AREA_TEXT
 * CONTROLLING_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SEGMENT_TEXT
 * SEGMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_SEGMENT_FOR_ELIM
 * CONSOLIDATION_SEGMENT_FOR_ELIM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CONSOLIDATION_SEGMENT_FOR_ELIM_TEXT
 * CONSOLIDATION_SEGMENT_FOR_ELIM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_COST_CENTER_TEXT
 * PARTNER_COST_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_PROFIT_CENTER_TEXT
 * PARTNER_PROFIT_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_FUNCTIONAL_AREA_TEXT
 * PARTNER_FUNCTIONAL_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_BUSINESS_AREA_TEXT
 * PARTNER_BUSINESS_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_COMPANY_TEXT
 * PARTNER_COMPANY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PARTNER_SEGMENT_TEXT
 * PARTNER_SEGMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#ORDER_ID_TEXT
 * ORDER_ID_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_TEXT
 * CUSTOMER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SUPPLIER_TEXT
 * SUPPLIER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#MATERIAL_TEXT
 * MATERIAL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PLANT_TEXT
 * PLANT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#FINANCIAL_TRANSACTION_TYPE_TEXT
 * FINANCIAL_TRANSACTION_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#WBS_DESCRIPTION
 * WBS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#WBS_ELEMENT_EXTERNAL_ID_TEXT
 * WBS_ELEMENT_EXTERNAL_ID_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PROJECT
 * PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#PROJECT_TEXT
 * PROJECT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BILLING_DOCUMENT_TYPE
 * BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BILLING_DOCUMENT_TYPE_TEXT
 * BILLING_DOCUMENT_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SALES_ORGANIZATION_TEXT
 * SALES_ORGANIZATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#DISTRIBUTION_CHANNEL_TEXT
 * DISTRIBUTION_CHANNEL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#ORGANIZATION_DIVISION_TEXT
 * ORGANIZATION_DIVISION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#MATERIAL_GROUP_TEXT
 * MATERIAL_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SOLD_PRODUCT
 * SOLD_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SOLD_PRODUCT_TEXT
 * SOLD_PRODUCT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SOLD_PRODUCT_GROUP
 * SOLD_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SOLD_PRODUCT_GROUP_TEXT
 * SOLD_PRODUCT_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_GROUP_TEXT
 * CUSTOMER_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_SUPPLIER_COUNTRY_TEXT
 * CUSTOMER_SUPPLIER_COUNTRY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_SUPPLIER_INDUSTRY_TEXT
 * CUSTOMER_SUPPLIER_INDUSTRY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SALES_DISTRICT_TEXT
 * SALES_DISTRICT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#BILL_TO_PARTY_TEXT
 * BILL_TO_PARTY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#SHIP_TO_PARTY_TEXT
 * SHIP_TO_PARTY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CUSTOMER_SUPPLIER_CORPORATE_GROUP
 * CUSTOMER_SUPPLIER_CORPORATE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_ADHOC_ITEM
 * CNSLDTN_ADHOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_ADHOC_ITEM_TEXT
 * CNSLDTN_ADHOC_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_ADHOC_SET
 * CNSLDTN_ADHOC_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_ADHOC_SET_TEXT
 * CNSLDTN_ADHOC_SET_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_ADHOC_SET_ITEM
 * CNSLDTN_ADHOC_SET_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#CNSLDTN_ADHOC_SET_ITEM_TEXT
 * CNSLDTN_ADHOC_SET_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult#TO_PARAMETERS
 * TO_PARAMETERS}</li>
 * </ul>
 *
 */
public interface GRTransactionDataResultSelectable extends EntitySelectable<GRTransactionDataResult>
{

}
