/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.field.TrsyPosFlowField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.selectable.TrsyPosFlowSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Treasury Position Flow
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_TrsyPosFlowType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TrsyPosFlow extends VdmEntity<TrsyPosFlow>
{

    /**
     * Selector for all available fields of TrsyPosFlow.
     *
     */
    public final static TrsyPosFlowSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryTransactionFlow</b>
     * </p>
     *
     * @return Number of TRL Flow
     */
    @Key
    @SerializedName( "TreasuryTransactionFlow" )
    @JsonProperty( "TreasuryTransactionFlow" )
    @Nullable
    @ODataField( odataName = "TreasuryTransactionFlow" )
    private Integer treasuryTransactionFlow;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryTransactionFlow</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<Integer> TREASURY_TRANSACTION_FLOW =
        new TrsyPosFlowField<Integer>("TreasuryTransactionFlow");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionDocUUID</b>
     * </p>
     *
     * @return Business Transaction (GUID)
     */
    @Key
    @SerializedName( "BusinessTransactionDocUUID" )
    @JsonProperty( "BusinessTransactionDocUUID" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionDocUUID" )
    private UUID businessTransactionDocUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionDocUUID</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<UUID> BUSINESS_TRANSACTION_DOC_UUID =
        new TrsyPosFlowField<UUID>("BusinessTransactionDocUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPosition</b>
     * </p>
     *
     * @return Treasury Position UUID
     */
    @SerializedName( "TreasuryPosition" )
    @JsonProperty( "TreasuryPosition" )
    @Nullable
    @ODataField( odataName = "TreasuryPosition" )
    private UUID treasuryPosition;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPosition</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<UUID> TREASURY_POSITION = new TrsyPosFlowField<UUID>("TreasuryPosition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransaction</b>
     * </p>
     *
     * @return Identifier of the Distributor Business Transaction
     */
    @SerializedName( "TreasuryBusinessTransaction" )
    @JsonProperty( "TreasuryBusinessTransaction" )
    @Nullable
    @ODataField( odataName = "TreasuryBusinessTransaction" )
    private UUID treasuryBusinessTransaction;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusinessTransaction</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<UUID> TREASURY_BUSINESS_TRANSACTION =
        new TrsyPosFlowField<UUID>("TreasuryBusinessTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateTypeName</b>
     * </p>
     *
     * @return Name of the Update Type
     */
    @SerializedName( "TreasuryUpdateTypeName" )
    @JsonProperty( "TreasuryUpdateTypeName" )
    @Nullable
    @ODataField( odataName = "TreasuryUpdateTypeName" )
    private String treasuryUpdateTypeName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryUpdateTypeName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_UPDATE_TYPE_NAME =
        new TrsyPosFlowField<String>("TreasuryUpdateTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateType</b>
     * </p>
     *
     * @return Update Type
     */
    @SerializedName( "TreasuryUpdateType" )
    @JsonProperty( "TreasuryUpdateType" )
    @Nullable
    @ODataField( odataName = "TreasuryUpdateType" )
    private String treasuryUpdateType;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryUpdateType</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_UPDATE_TYPE =
        new TrsyPosFlowField<String>("TreasuryUpdateType");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInPositionCurrency</b>
     * </p>
     *
     * @return Amount in Position Currency
     */
    @SerializedName( "AmountInPositionCurrency" )
    @JsonProperty( "AmountInPositionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInPositionCurrency" )
    private BigDecimal amountInPositionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInPositionCurrency</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> AMOUNT_IN_POSITION_CURRENCY =
        new TrsyPosFlowField<BigDecimal>("AmountInPositionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PositionCurrency</b>
     * </p>
     *
     * @return Position Currency
     */
    @SerializedName( "PositionCurrency" )
    @JsonProperty( "PositionCurrency" )
    @Nullable
    @ODataField( odataName = "PositionCurrency" )
    private String positionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PositionCurrency</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> POSITION_CURRENCY = new TrsyPosFlowField<String>("PositionCurrency");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInValuationCurrency</b>
     * </p>
     *
     * @return Amount in Valuation Currency
     */
    @SerializedName( "AmountInValuationCurrency" )
    @JsonProperty( "AmountInValuationCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInValuationCurrency" )
    private BigDecimal amountInValuationCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInValuationCurrency</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> AMOUNT_IN_VALUATION_CURRENCY =
        new TrsyPosFlowField<BigDecimal>("AmountInValuationCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ValuationCurrency</b>
     * </p>
     *
     * @return Valuation Currency
     */
    @SerializedName( "ValuationCurrency" )
    @JsonProperty( "ValuationCurrency" )
    @Nullable
    @ODataField( odataName = "ValuationCurrency" )
    private String valuationCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ValuationCurrency</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> VALUATION_CURRENCY = new TrsyPosFlowField<String>("ValuationCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLedgerDate</b>
     * </p>
     *
     * @return Treasury Ledger Date
     */
    @SerializedName( "TreasuryPositionLedgerDate" )
    @JsonProperty( "TreasuryPositionLedgerDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TreasuryPositionLedgerDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime treasuryPositionLedgerDate;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionLedgerDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> TREASURY_POSITION_LEDGER_DATE =
        new TrsyPosFlowField<LocalDateTime>("TreasuryPositionLedgerDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionTransferGroup</b>
     * </p>
     *
     * @return Position Transfer Group
     */
    @SerializedName( "TreasuryPositionTransferGroup" )
    @JsonProperty( "TreasuryPositionTransferGroup" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionTransferGroup" )
    private String treasuryPositionTransferGroup;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionTransferGroup</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_POSITION_TRANSFER_GROUP =
        new TrsyPosFlowField<String>("TreasuryPositionTransferGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionTransferFactor</b>
     * </p>
     *
     * @return Position Transfer Coefficient
     */
    @SerializedName( "TreasuryPositionTransferFactor" )
    @JsonProperty( "TreasuryPositionTransferFactor" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionTransferFactor" )
    private Double treasuryPositionTransferFactor;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionTransferFactor</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<Double> TREASURY_POSITION_TRANSFER_FACTOR =
        new TrsyPosFlowField<Double>("TreasuryPositionTransferFactor");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosQuantityChangeCategory</b>
     * </p>
     *
     * @return Position Change Category (Quantity)
     */
    @SerializedName( "TrsyPosQuantityChangeCategory" )
    @JsonProperty( "TrsyPosQuantityChangeCategory" )
    @Nullable
    @ODataField( odataName = "TrsyPosQuantityChangeCategory" )
    private String trsyPosQuantityChangeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosQuantityChangeCategory</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_QUANTITY_CHANGE_CATEGORY =
        new TrsyPosFlowField<String>("TrsyPosQuantityChangeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosAmountChangeCategory</b>
     * </p>
     *
     * @return Position Change Category (Amount)
     */
    @SerializedName( "TrsyPosAmountChangeCategory" )
    @JsonProperty( "TrsyPosAmountChangeCategory" )
    @Nullable
    @ODataField( odataName = "TrsyPosAmountChangeCategory" )
    private String trsyPosAmountChangeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosAmountChangeCategory</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_AMOUNT_CHANGE_CATEGORY =
        new TrsyPosFlowField<String>("TrsyPosAmountChangeCategory");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInPieces</b>
     * </p>
     *
     * @return Units (Short)
     */
    @SerializedName( "QuantityInPieces" )
    @JsonProperty( "QuantityInPieces" )
    @Nullable
    @ODataField( odataName = "QuantityInPieces" )
    private BigDecimal quantityInPieces;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInPieces</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> QUANTITY_IN_PIECES =
        new TrsyPosFlowField<BigDecimal>("QuantityInPieces");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>IndexCleanAmountInPositionCrcy</b>
     * </p>
     *
     * @return Index Clean Amount in Position Currency
     */
    @SerializedName( "IndexCleanAmountInPositionCrcy" )
    @JsonProperty( "IndexCleanAmountInPositionCrcy" )
    @Nullable
    @ODataField( odataName = "IndexCleanAmountInPositionCrcy" )
    private BigDecimal indexCleanAmountInPositionCrcy;
    /**
     * Use with available fluent helpers to apply the <b>IndexCleanAmountInPositionCrcy</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> INDEX_CLEAN_AMOUNT_IN_POSITION_CRCY =
        new TrsyPosFlowField<BigDecimal>("IndexCleanAmountInPositionCrcy");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NominalAmountInNominalCurrency</b>
     * </p>
     *
     * @return Nominal Amount
     */
    @SerializedName( "NominalAmountInNominalCurrency" )
    @JsonProperty( "NominalAmountInNominalCurrency" )
    @Nullable
    @ODataField( odataName = "NominalAmountInNominalCurrency" )
    private BigDecimal nominalAmountInNominalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>NominalAmountInNominalCurrency</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> NOMINAL_AMOUNT_IN_NOMINAL_CURRENCY =
        new TrsyPosFlowField<BigDecimal>("NominalAmountInNominalCurrency");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OriglNominalAmtInNominalCrcy</b>
     * </p>
     *
     * @return Original Nominal Amount
     */
    @SerializedName( "OriglNominalAmtInNominalCrcy" )
    @JsonProperty( "OriglNominalAmtInNominalCrcy" )
    @Nullable
    @ODataField( odataName = "OriglNominalAmtInNominalCrcy" )
    private BigDecimal origlNominalAmtInNominalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>OriglNominalAmtInNominalCrcy</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> ORIGL_NOMINAL_AMT_IN_NOMINAL_CRCY =
        new TrsyPosFlowField<BigDecimal>("OriglNominalAmtInNominalCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>NominalCurrency</b>
     * </p>
     *
     * @return Nominal Currency
     */
    @SerializedName( "NominalCurrency" )
    @JsonProperty( "NominalCurrency" )
    @Nullable
    @ODataField( odataName = "NominalCurrency" )
    private String nominalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>NominalCurrency</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> NOMINAL_CURRENCY = new TrsyPosFlowField<String>("NominalCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CalculationDate</b>
     * </p>
     *
     * @return Key Date of Last Interest Calculation
     */
    @SerializedName( "CalculationDate" )
    @JsonProperty( "CalculationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CalculationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime calculationDate;
    /**
     * Use with available fluent helpers to apply the <b>CalculationDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> CALCULATION_DATE =
        new TrsyPosFlowField<LocalDateTime>("CalculationDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalcDateIsAsEndDateInclusive</b>
     * </p>
     *
     * @return Incl./Excl. Indicator for Beginning and End of a Period
     */
    @SerializedName( "CalcDateIsAsEndDateInclusive" )
    @JsonProperty( "CalcDateIsAsEndDateInclusive" )
    @Nullable
    @ODataField( odataName = "CalcDateIsAsEndDateInclusive" )
    private String calcDateIsAsEndDateInclusive;
    /**
     * Use with available fluent helpers to apply the <b>CalcDateIsAsEndDateInclusive</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> CALC_DATE_IS_AS_END_DATE_INCLUSIVE =
        new TrsyPosFlowField<String>("CalcDateIsAsEndDateInclusive");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueDate</b>
     * </p>
     *
     * @return Due Date
     */
    @SerializedName( "DueDate" )
    @JsonProperty( "DueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime dueDate;
    /**
     * Use with available fluent helpers to apply the <b>DueDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> DUE_DATE = new TrsyPosFlowField<LocalDateTime>("DueDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CalculationPeriodStartDate</b>
     * </p>
     *
     * @return Start of Calculation Period
     */
    @SerializedName( "CalculationPeriodStartDate" )
    @JsonProperty( "CalculationPeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CalculationPeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime calculationPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>CalculationPeriodStartDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> CALCULATION_PERIOD_START_DATE =
        new TrsyPosFlowField<LocalDateTime>("CalculationPeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CalculationPeriodEndDate</b>
     * </p>
     *
     * @return End of Calculation Period
     */
    @SerializedName( "CalculationPeriodEndDate" )
    @JsonProperty( "CalculationPeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CalculationPeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime calculationPeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>CalculationPeriodEndDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> CALCULATION_PERIOD_END_DATE =
        new TrsyPosFlowField<LocalDateTime>("CalculationPeriodEndDate");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 7
     * <p>
     * Original property name from the Odata EDM: <b>EffectiveInterestRate</b>
     * </p>
     *
     * @return For Calculation of Amortization Amts (SAC) for Used EffInR
     */
    @SerializedName( "EffectiveInterestRate" )
    @JsonProperty( "EffectiveInterestRate" )
    @Nullable
    @ODataField( odataName = "EffectiveInterestRate" )
    private BigDecimal effectiveInterestRate;
    /**
     * Use with available fluent helpers to apply the <b>EffectiveInterestRate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> EFFECTIVE_INTEREST_RATE =
        new TrsyPosFlowField<BigDecimal>("EffectiveInterestRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EffctvIntrstRateRdmptnSched</b>
     * </p>
     *
     * @return Redemption Schedule that Explains Effective Interest Rate
     */
    @SerializedName( "EffctvIntrstRateRdmptnSched" )
    @JsonProperty( "EffctvIntrstRateRdmptnSched" )
    @Nullable
    @ODataField( odataName = "EffctvIntrstRateRdmptnSched" )
    private Integer effctvIntrstRateRdmptnSched;
    /**
     * Use with available fluent helpers to apply the <b>EffctvIntrstRateRdmptnSched</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<Integer> EFFCTV_INTRST_RATE_RDMPTN_SCHED =
        new TrsyPosFlowField<Integer>("EffctvIntrstRateRdmptnSched");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 7
     * <p>
     * Original property name from the Odata EDM: <b>NextEffectiveInterestRate</b>
     * </p>
     *
     * @return Valid Effective Interest Rate for the Next Amortization
     */
    @SerializedName( "NextEffectiveInterestRate" )
    @JsonProperty( "NextEffectiveInterestRate" )
    @Nullable
    @ODataField( odataName = "NextEffectiveInterestRate" )
    private BigDecimal nextEffectiveInterestRate;
    /**
     * Use with available fluent helpers to apply the <b>NextEffectiveInterestRate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> NEXT_EFFECTIVE_INTEREST_RATE =
        new TrsyPosFlowField<BigDecimal>("NextEffectiveInterestRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FixedRedemptionSchedule</b>
     * </p>
     *
     * @return Fixed Redemption Schedule
     */
    @SerializedName( "FixedRedemptionSchedule" )
    @JsonProperty( "FixedRedemptionSchedule" )
    @Nullable
    @ODataField( odataName = "FixedRedemptionSchedule" )
    private Integer fixedRedemptionSchedule;
    /**
     * Use with available fluent helpers to apply the <b>FixedRedemptionSchedule</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<Integer> FIXED_REDEMPTION_SCHEDULE =
        new TrsyPosFlowField<Integer>("FixedRedemptionSchedule");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalculationBasis</b>
     * </p>
     *
     * @return Calculation Base Amount
     */
    @SerializedName( "CalculationBasis" )
    @JsonProperty( "CalculationBasis" )
    @Nullable
    @ODataField( odataName = "CalculationBasis" )
    private BigDecimal calculationBasis;
    /**
     * Use with available fluent helpers to apply the <b>CalculationBasis</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<BigDecimal> CALCULATION_BASIS =
        new TrsyPosFlowField<BigDecimal>("CalculationBasis");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinInstrProductGroup</b>
     * </p>
     *
     * @return Financial Instrument Product Group
     */
    @SerializedName( "FinInstrProductGroup" )
    @JsonProperty( "FinInstrProductGroup" )
    @Nullable
    @ODataField( odataName = "FinInstrProductGroup" )
    private String finInstrProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>FinInstrProductGroup</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FIN_INSTR_PRODUCT_GROUP =
        new TrsyPosFlowField<String>("FinInstrProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransStatus</b>
     * </p>
     *
     * @return Posting Status Treasury Ledger Business Transaction
     */
    @SerializedName( "TreasuryBusinessTransStatus" )
    @JsonProperty( "TreasuryBusinessTransStatus" )
    @Nullable
    @ODataField( odataName = "TreasuryBusinessTransStatus" )
    private String treasuryBusinessTransStatus;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusinessTransStatus</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_BUSINESS_TRANS_STATUS =
        new TrsyPosFlowField<String>("TreasuryBusinessTransStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TrsyIntragroupTransacStatus</b>
     * </p>
     *
     * @return Intragroup Transaction Status
     */
    @SerializedName( "TrsyIntragroupTransacStatus" )
    @JsonProperty( "TrsyIntragroupTransacStatus" )
    @Nullable
    @ODataField( odataName = "TrsyIntragroupTransacStatus" )
    private String trsyIntragroupTransacStatus;
    /**
     * Use with available fluent helpers to apply the <b>TrsyIntragroupTransacStatus</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_INTRAGROUP_TRANSAC_STATUS =
        new TrsyPosFlowField<String>("TrsyIntragroupTransacStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransCategory</b>
     * </p>
     *
     * @return Business Transaction Category
     */
    @SerializedName( "TreasuryBusinessTransCategory" )
    @JsonProperty( "TreasuryBusinessTransCategory" )
    @Nullable
    @ODataField( odataName = "TreasuryBusinessTransCategory" )
    private String treasuryBusinessTransCategory;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusinessTransCategory</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_BUSINESS_TRANS_CATEGORY =
        new TrsyPosFlowField<String>("TreasuryBusinessTransCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OriglTrsyBusinessTransaction</b>
     * </p>
     *
     * @return Original Business Transaction
     */
    @SerializedName( "OriglTrsyBusinessTransaction" )
    @JsonProperty( "OriglTrsyBusinessTransaction" )
    @Nullable
    @ODataField( odataName = "OriglTrsyBusinessTransaction" )
    private UUID origlTrsyBusinessTransaction;
    /**
     * Use with available fluent helpers to apply the <b>OriglTrsyBusinessTransaction</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<UUID> ORIGL_TRSY_BUSINESS_TRANSACTION =
        new TrsyPosFlowField<UUID>("OriglTrsyBusinessTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TrsyDerivedBusTransacIsUpdated</b>
     * </p>
     *
     * @return Status of Treasury Ledger Business Transaction
     */
    @SerializedName( "TrsyDerivedBusTransacIsUpdated" )
    @JsonProperty( "TrsyDerivedBusTransacIsUpdated" )
    @Nullable
    @ODataField( odataName = "TrsyDerivedBusTransacIsUpdated" )
    private String trsyDerivedBusTransacIsUpdated;
    /**
     * Use with available fluent helpers to apply the <b>TrsyDerivedBusTransacIsUpdated</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_DERIVED_BUS_TRANSAC_IS_UPDATED =
        new TrsyPosFlowField<String>("TrsyDerivedBusTransacIsUpdated");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPosAssetLiabilityCode</b>
     * </p>
     *
     * @return Assets/Liabilities Position
     */
    @SerializedName( "TreasuryPosAssetLiabilityCode" )
    @JsonProperty( "TreasuryPosAssetLiabilityCode" )
    @Nullable
    @ODataField( odataName = "TreasuryPosAssetLiabilityCode" )
    private String treasuryPosAssetLiabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPosAssetLiabilityCode</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_POS_ASSET_LIABILITY_CODE =
        new TrsyPosFlowField<String>("TreasuryPosAssetLiabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosTransfSourceTargetCode</b>
     * </p>
     *
     * @return Position Transfer
     */
    @SerializedName( "TrsyPosTransfSourceTargetCode" )
    @JsonProperty( "TrsyPosTransfSourceTargetCode" )
    @Nullable
    @ODataField( odataName = "TrsyPosTransfSourceTargetCode" )
    private String trsyPosTransfSourceTargetCode;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosTransfSourceTargetCode</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_TRANSF_SOURCE_TARGET_CODE =
        new TrsyPosFlowField<String>("TrsyPosTransfSourceTargetCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationArea</b>
     * </p>
     *
     * @return Treasury Valuation Area
     */
    @SerializedName( "TreasuryValuationArea" )
    @JsonProperty( "TreasuryValuationArea" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationArea" )
    private String treasuryValuationArea;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationArea</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_VALUATION_AREA =
        new TrsyPosFlowField<String>("TreasuryValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationAreaName</b>
     * </p>
     *
     * @return Name of the Valuation Area
     */
    @SerializedName( "TreasuryValuationAreaName" )
    @JsonProperty( "TreasuryValuationAreaName" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationAreaName" )
    private String treasuryValuationAreaName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationAreaName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_VALUATION_AREA_NAME =
        new TrsyPosFlowField<String>("TreasuryValuationAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClass</b>
     * </p>
     *
     * @return Valuation Class
     */
    @SerializedName( "TreasuryValuationClass" )
    @JsonProperty( "TreasuryValuationClass" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationClass" )
    private String treasuryValuationClass;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationClass</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_VALUATION_CLASS =
        new TrsyPosFlowField<String>("TreasuryValuationClass");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClassName</b>
     * </p>
     *
     * @return Name of the Valuation Class
     */
    @SerializedName( "TreasuryValuationClassName" )
    @JsonProperty( "TreasuryValuationClassName" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationClassName" )
    private String treasuryValuationClassName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationClassName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_VALUATION_CLASS_NAME =
        new TrsyPosFlowField<String>("TreasuryValuationClassName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> COMPANY_CODE = new TrsyPosFlowField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentProductType</b>
     * </p>
     *
     * @return Product Type
     */
    @SerializedName( "FinancialInstrumentProductType" )
    @JsonProperty( "FinancialInstrumentProductType" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentProductType" )
    private String financialInstrumentProductType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentProductType</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTRUMENT_PRODUCT_TYPE =
        new TrsyPosFlowField<String>("FinancialInstrumentProductType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccount</b>
     * </p>
     *
     * @return Security Account
     */
    @SerializedName( "SecurityAccount" )
    @JsonProperty( "SecurityAccount" )
    @Nullable
    @ODataField( odataName = "SecurityAccount" )
    private String securityAccount;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccount</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_ACCOUNT = new TrsyPosFlowField<String>("SecurityAccount");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClass</b>
     * </p>
     *
     * @return Security Class
     */
    @SerializedName( "SecurityClass" )
    @JsonProperty( "SecurityClass" )
    @Nullable
    @ODataField( odataName = "SecurityClass" )
    private String securityClass;
    /**
     * Use with available fluent helpers to apply the <b>SecurityClass</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_CLASS = new TrsyPosFlowField<String>("SecurityClass");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassName</b>
     * </p>
     *
     * @return Name of the Security Class
     */
    @SerializedName( "SecurityClassName" )
    @JsonProperty( "SecurityClassName" )
    @Nullable
    @ODataField( odataName = "SecurityClassName" )
    private String securityClassName;
    /**
     * Use with available fluent helpers to apply the <b>SecurityClassName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_CLASS_NAME =
        new TrsyPosFlowField<String>("SecurityClassName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassDescription</b>
     * </p>
     *
     * @return Description of the Security Class
     */
    @SerializedName( "SecurityClassDescription" )
    @JsonProperty( "SecurityClassDescription" )
    @Nullable
    @ODataField( odataName = "SecurityClassDescription" )
    private String securityClassDescription;
    /**
     * Use with available fluent helpers to apply the <b>SecurityClassDescription</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_CLASS_DESCRIPTION =
        new TrsyPosFlowField<String>("SecurityClassDescription");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrValClassName</b>
     * </p>
     *
     * @return Name of the Financial Instrument Valuation Class
     */
    @SerializedName( "FinancialInstrValClassName" )
    @JsonProperty( "FinancialInstrValClassName" )
    @Nullable
    @ODataField( odataName = "FinancialInstrValClassName" )
    private String financialInstrValClassName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrValClassName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTR_VAL_CLASS_NAME =
        new TrsyPosFlowField<String>("FinancialInstrValClassName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLot</b>
     * </p>
     *
     * @return Identifier of the Lot
     */
    @SerializedName( "TreasuryPositionLot" )
    @JsonProperty( "TreasuryPositionLot" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionLot" )
    private UUID treasuryPositionLot;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionLot</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<UUID> TREASURY_POSITION_LOT =
        new TrsyPosFlowField<UUID>("TreasuryPositionLot");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroup</b>
     * </p>
     *
     * @return Securities Account Group
     */
    @SerializedName( "SecurityAccountGroup" )
    @JsonProperty( "SecurityAccountGroup" )
    @Nullable
    @ODataField( odataName = "SecurityAccountGroup" )
    private String securityAccountGroup;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccountGroup</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_ACCOUNT_GROUP =
        new TrsyPosFlowField<String>("SecurityAccountGroup");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>LoanContract</b>
     * </p>
     *
     * @return Loan Contract Number
     */
    @SerializedName( "LoanContract" )
    @JsonProperty( "LoanContract" )
    @Nullable
    @ODataField( odataName = "LoanContract" )
    private String loanContract;
    /**
     * Use with available fluent helpers to apply the <b>LoanContract</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> LOAN_CONTRACT = new TrsyPosFlowField<String>("LoanContract");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>LoanContractName</b>
     * </p>
     *
     * @return Name of the Loan Contract
     */
    @SerializedName( "LoanContractName" )
    @JsonProperty( "LoanContractName" )
    @Nullable
    @ODataField( odataName = "LoanContractName" )
    private String loanContractName;
    /**
     * Use with available fluent helpers to apply the <b>LoanContractName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> LOAN_CONTRACT_NAME = new TrsyPosFlowField<String>("LoanContractName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionAccount</b>
     * </p>
     *
     * @return Futures Account for Listed Options and Futures
     */
    @SerializedName( "TreasuryPositionAccount" )
    @JsonProperty( "TreasuryPositionAccount" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionAccount" )
    private String treasuryPositionAccount;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionAccount</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_POSITION_ACCOUNT =
        new TrsyPosFlowField<String>("TreasuryPositionAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLongShortCode</b>
     * </p>
     *
     * @return Code: Long or Short Position
     */
    @SerializedName( "TreasuryPositionLongShortCode" )
    @JsonProperty( "TreasuryPositionLongShortCode" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionLongShortCode" )
    private String treasuryPositionLongShortCode;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionLongShortCode</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_POSITION_LONG_SHORT_CODE =
        new TrsyPosFlowField<String>("TreasuryPositionLongShortCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FUND = new TrsyPosFlowField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> GRANT_ID = new TrsyPosFlowField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> COST_CENTER = new TrsyPosFlowField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> PROFIT_CENTER = new TrsyPosFlowField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> WBS_ELEMENT_EXTERNAL_ID =
        new TrsyPosFlowField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @return WBS Element Name
     */
    @SerializedName( "WBSDescription" )
    @JsonProperty( "WBSDescription" )
    @Nullable
    @ODataField( odataName = "WBSDescription" )
    private String wBSDescription;
    /**
     * Use with available fluent helpers to apply the <b>WBSDescription</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> WBS_DESCRIPTION = new TrsyPosFlowField<String>("WBSDescription");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FUNCTIONAL_AREA = new TrsyPosFlowField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1</b>
     * </p>
     *
     * @return Custom Differentiation Term 1 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm1" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm1" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm1" )
    private String trsyPosCustomDiffntnTerm1;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm1</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM1 =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm1");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 1 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm1Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm1Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm1Name" )
    private String trsyPosCustomDiffntnTerm1Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm1Name</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM1_NAME =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm1Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2</b>
     * </p>
     *
     * @return Custom Differentiation Term 2 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm2" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm2" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm2" )
    private String trsyPosCustomDiffntnTerm2;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm2</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM2 =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm2");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 2 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm2Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm2Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm2Name" )
    private String trsyPosCustomDiffntnTerm2Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm2Name</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM2_NAME =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm2Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3</b>
     * </p>
     *
     * @return Custom Differentiation Term 3 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm3" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm3" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm3" )
    private String trsyPosCustomDiffntnTerm3;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm3</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM3 =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm3");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 3 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm3Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm3Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm3Name" )
    private String trsyPosCustomDiffntnTerm3Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm3Name</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM3_NAME =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm3Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4</b>
     * </p>
     *
     * @return Custom Differentiation Term 4 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm4" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm4" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm4" )
    private String trsyPosCustomDiffntnTerm4;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm4</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM4 =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm4");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 4 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm4Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm4Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm4Name" )
    private String trsyPosCustomDiffntnTerm4Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm4Name</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM4_NAME =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm4Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5</b>
     * </p>
     *
     * @return Custom Differentiation Term 5 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm5" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm5" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm5" )
    private String trsyPosCustomDiffntnTerm5;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm5</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM5 =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm5");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 5 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm5Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm5Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm5Name" )
    private String trsyPosCustomDiffntnTerm5Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm5Name</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM5_NAME =
        new TrsyPosFlowField<String>("TrsyPosCustomDiffntnTerm5Name");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccount</b>
     * </p>
     *
     * @return Central Clearing Account
     */
    @SerializedName( "CentralClearingAccount" )
    @JsonProperty( "CentralClearingAccount" )
    @Nullable
    @ODataField( odataName = "CentralClearingAccount" )
    private String centralClearingAccount;
    /**
     * Use with available fluent helpers to apply the <b>CentralClearingAccount</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> CENTRAL_CLEARING_ACCOUNT =
        new TrsyPosFlowField<String>("CentralClearingAccount");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccountName</b>
     * </p>
     *
     * @return Name of the Central Clearing Account
     */
    @SerializedName( "CentralClearingAccountName" )
    @JsonProperty( "CentralClearingAccountName" )
    @Nullable
    @ODataField( odataName = "CentralClearingAccountName" )
    private String centralClearingAccountName;
    /**
     * Use with available fluent helpers to apply the <b>CentralClearingAccountName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> CENTRAL_CLEARING_ACCOUNT_NAME =
        new TrsyPosFlowField<String>("CentralClearingAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Name of Company Code or Company
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> COMPANY_CODE_NAME = new TrsyPosFlowField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountName</b>
     * </p>
     *
     * @return Name of the Security Account
     */
    @SerializedName( "SecurityAccountName" )
    @JsonProperty( "SecurityAccountName" )
    @Nullable
    @ODataField( odataName = "SecurityAccountName" )
    private String securityAccountName;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccountName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_ACCOUNT_NAME =
        new TrsyPosFlowField<String>("SecurityAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroupName</b>
     * </p>
     *
     * @return Name of Securities Account Group
     */
    @SerializedName( "SecurityAccountGroupName" )
    @JsonProperty( "SecurityAccountGroupName" )
    @Nullable
    @ODataField( odataName = "SecurityAccountGroupName" )
    private String securityAccountGroupName;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccountGroupName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> SECURITY_ACCOUNT_GROUP_NAME =
        new TrsyPosFlowField<String>("SecurityAccountGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>ActivityFinancialTransaction</b>
     * </p>
     *
     * @return Activity-Triggering Financial Transaction
     */
    @SerializedName( "ActivityFinancialTransaction" )
    @JsonProperty( "ActivityFinancialTransaction" )
    @Nullable
    @ODataField( odataName = "ActivityFinancialTransaction" )
    private String activityFinancialTransaction;
    /**
     * Use with available fluent helpers to apply the <b>ActivityFinancialTransaction</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> ACTIVITY_FINANCIAL_TRANSACTION =
        new TrsyPosFlowField<String>("ActivityFinancialTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrTransactionType</b>
     * </p>
     *
     * @return Financial Instrument Transaction Type
     */
    @SerializedName( "FinancialInstrTransactionType" )
    @JsonProperty( "FinancialInstrTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialInstrTransactionType" )
    private String financialInstrTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrTransactionType</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTR_TRANSACTION_TYPE =
        new TrsyPosFlowField<String>("FinancialInstrTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryFacilityCompanyCode</b>
     * </p>
     *
     * @return Company Code of Facility
     */
    @SerializedName( "TreasuryFacilityCompanyCode" )
    @JsonProperty( "TreasuryFacilityCompanyCode" )
    @Nullable
    @ODataField( odataName = "TreasuryFacilityCompanyCode" )
    private String treasuryFacilityCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryFacilityCompanyCode</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_FACILITY_COMPANY_CODE =
        new TrsyPosFlowField<String>("TreasuryFacilityCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryFacility</b>
     * </p>
     *
     * @return Transaction Number of Facility
     */
    @SerializedName( "TreasuryFacility" )
    @JsonProperty( "TreasuryFacility" )
    @Nullable
    @ODataField( odataName = "TreasuryFacility" )
    private String treasuryFacility;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryFacility</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_FACILITY = new TrsyPosFlowField<String>("TreasuryFacility");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryMasterAgreement</b>
     * </p>
     *
     * @return The treasuryMasterAgreement contained in this entity.
     */
    @SerializedName( "TreasuryMasterAgreement" )
    @JsonProperty( "TreasuryMasterAgreement" )
    @Nullable
    @ODataField( odataName = "TreasuryMasterAgreement" )
    private String treasuryMasterAgreement;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryMasterAgreement</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_MASTER_AGREEMENT =
        new TrsyPosFlowField<String>("TreasuryMasterAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryFinanceProject</b>
     * </p>
     *
     * @return Finance Project
     */
    @SerializedName( "TreasuryFinanceProject" )
    @JsonProperty( "TreasuryFinanceProject" )
    @Nullable
    @ODataField( odataName = "TreasuryFinanceProject" )
    private String treasuryFinanceProject;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryFinanceProject</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_FINANCE_PROJECT =
        new TrsyPosFlowField<String>("TreasuryFinanceProject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Counterparty</b>
     * </p>
     *
     * @return Counterparty Number
     */
    @SerializedName( "Counterparty" )
    @JsonProperty( "Counterparty" )
    @Nullable
    @ODataField( odataName = "Counterparty" )
    private String counterparty;
    /**
     * Use with available fluent helpers to apply the <b>Counterparty</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> COUNTERPARTY = new TrsyPosFlowField<String>("Counterparty");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>LetterOfCredit</b>
     * </p>
     *
     * @return Letter of Credit Number
     */
    @SerializedName( "LetterOfCredit" )
    @JsonProperty( "LetterOfCredit" )
    @Nullable
    @ODataField( odataName = "LetterOfCredit" )
    private String letterOfCredit;
    /**
     * Use with available fluent helpers to apply the <b>LetterOfCredit</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> LETTER_OF_CREDIT = new TrsyPosFlowField<String>("LetterOfCredit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentStatus</b>
     * </p>
     *
     * @return Active Status of Transaction or Activity
     */
    @SerializedName( "FinancialInstrumentStatus" )
    @JsonProperty( "FinancialInstrumentStatus" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentStatus" )
    private String financialInstrumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentStatus</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTRUMENT_STATUS =
        new TrsyPosFlowField<String>("FinancialInstrumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Portfolio</b>
     * </p>
     *
     * @return Portfolio
     */
    @SerializedName( "Portfolio" )
    @JsonProperty( "Portfolio" )
    @Nullable
    @ODataField( odataName = "Portfolio" )
    private String portfolio;
    /**
     * Use with available fluent helpers to apply the <b>Portfolio</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> PORTFOLIO = new TrsyPosFlowField<String>("Portfolio");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PortfolioName</b>
     * </p>
     *
     * @return Name of the Portfolio
     */
    @SerializedName( "PortfolioName" )
    @JsonProperty( "PortfolioName" )
    @Nullable
    @ODataField( odataName = "PortfolioName" )
    private String portfolioName;
    /**
     * Use with available fluent helpers to apply the <b>PortfolioName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> PORTFOLIO_NAME = new TrsyPosFlowField<String>("PortfolioName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Issuer</b>
     * </p>
     *
     * @return Issuer Identity Key
     */
    @SerializedName( "Issuer" )
    @JsonProperty( "Issuer" )
    @Nullable
    @ODataField( odataName = "Issuer" )
    private String issuer;
    /**
     * Use with available fluent helpers to apply the <b>Issuer</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> ISSUER = new TrsyPosFlowField<String>("Issuer");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosQtyChangeCategoryName</b>
     * </p>
     *
     * @return Position Change Category: Quantity (Text)
     */
    @SerializedName( "TrsyPosQtyChangeCategoryName" )
    @JsonProperty( "TrsyPosQtyChangeCategoryName" )
    @Nullable
    @ODataField( odataName = "TrsyPosQtyChangeCategoryName" )
    private String trsyPosQtyChangeCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosQtyChangeCategoryName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TRSY_POS_QTY_CHANGE_CATEGORY_NAME =
        new TrsyPosFlowField<String>("TrsyPosQtyChangeCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPosChangeCategoryName</b>
     * </p>
     *
     * @return Name of the Position Change Category
     */
    @SerializedName( "TreasuryPosChangeCategoryName" )
    @JsonProperty( "TreasuryPosChangeCategoryName" )
    @Nullable
    @ODataField( odataName = "TreasuryPosChangeCategoryName" )
    private String treasuryPosChangeCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPosChangeCategoryName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_POS_CHANGE_CATEGORY_NAME =
        new TrsyPosFlowField<String>("TreasuryPosChangeCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolio</b>
     * </p>
     *
     * @return Portfolio as Differentiation Characteristic
     */
    @SerializedName( "DifferentiationPortfolio" )
    @JsonProperty( "DifferentiationPortfolio" )
    @Nullable
    @ODataField( odataName = "DifferentiationPortfolio" )
    private String differentiationPortfolio;
    /**
     * Use with available fluent helpers to apply the <b>DifferentiationPortfolio</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> DIFFERENTIATION_PORTFOLIO =
        new TrsyPosFlowField<String>("DifferentiationPortfolio");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolioName</b>
     * </p>
     *
     * @return Name of the Portfolio as Differentiation Characteristic
     */
    @SerializedName( "DifferentiationPortfolioName" )
    @JsonProperty( "DifferentiationPortfolioName" )
    @Nullable
    @ODataField( odataName = "DifferentiationPortfolioName" )
    private String differentiationPortfolioName;
    /**
     * Use with available fluent helpers to apply the <b>DifferentiationPortfolioName</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> DIFFERENTIATION_PORTFOLIO_NAME =
        new TrsyPosFlowField<String>("DifferentiationPortfolioName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransaction</b>
     * </p>
     *
     * @return Financial Transaction
     */
    @SerializedName( "FinancialTransaction" )
    @JsonProperty( "FinancialTransaction" )
    @Nullable
    @ODataField( odataName = "FinancialTransaction" )
    private String financialTransaction;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransaction</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_TRANSACTION =
        new TrsyPosFlowField<String>("FinancialTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrActivityCategory</b>
     * </p>
     *
     * @return Transaction Activity Category
     */
    @SerializedName( "FinancialInstrActivityCategory" )
    @JsonProperty( "FinancialInstrActivityCategory" )
    @Nullable
    @ODataField( odataName = "FinancialInstrActivityCategory" )
    private String financialInstrActivityCategory;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrActivityCategory</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTR_ACTIVITY_CATEGORY =
        new TrsyPosFlowField<String>("FinancialInstrActivityCategory");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrCharacteristic</b>
     * </p>
     *
     * @return Free Characteristic of Financial Transaction
     */
    @SerializedName( "FinancialInstrCharacteristic" )
    @JsonProperty( "FinancialInstrCharacteristic" )
    @Nullable
    @ODataField( odataName = "FinancialInstrCharacteristic" )
    private String financialInstrCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrCharacteristic</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTR_CHARACTERISTIC =
        new TrsyPosFlowField<String>("FinancialInstrCharacteristic");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentReference</b>
     * </p>
     *
     * @return Free Internal Reference of Financial Transaction
     */
    @SerializedName( "FinancialInstrumentReference" )
    @JsonProperty( "FinancialInstrumentReference" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentReference" )
    private String financialInstrumentReference;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentReference</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTRUMENT_REFERENCE =
        new TrsyPosFlowField<String>("FinancialInstrumentReference");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentAssignment</b>
     * </p>
     *
     * @return Free Assignment of Financial Transaction
     */
    @SerializedName( "FinancialInstrumentAssignment" )
    @JsonProperty( "FinancialInstrumentAssignment" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentAssignment" )
    private String financialInstrumentAssignment;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentAssignment</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_INSTRUMENT_ASSIGNMENT =
        new TrsyPosFlowField<String>("FinancialInstrumentAssignment");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionItemValidityStartDate</b>
     * </p>
     *
     * @return Condition Item Effective From
     */
    @SerializedName( "ConditionItemValidityStartDate" )
    @JsonProperty( "ConditionItemValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionItemValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionItemValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionItemValidityStartDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> CONDITION_ITEM_VALIDITY_START_DATE =
        new TrsyPosFlowField<LocalDateTime>("ConditionItemValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalcPeriodEndDateIsInclusive</b>
     * </p>
     *
     * @return Inclusive Indicator for the End of a Calculation Period
     */
    @SerializedName( "CalcPeriodEndDateIsInclusive" )
    @JsonProperty( "CalcPeriodEndDateIsInclusive" )
    @Nullable
    @ODataField( odataName = "CalcPeriodEndDateIsInclusive" )
    private String calcPeriodEndDateIsInclusive;
    /**
     * Use with available fluent helpers to apply the <b>CalcPeriodEndDateIsInclusive</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> CALC_PERIOD_END_DATE_IS_INCLUSIVE =
        new TrsyPosFlowField<String>("CalcPeriodEndDateIsInclusive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InterestCalculationMethod</b>
     * </p>
     *
     * @return Interest Calculation Method
     */
    @SerializedName( "InterestCalculationMethod" )
    @JsonProperty( "InterestCalculationMethod" )
    @Nullable
    @ODataField( odataName = "InterestCalculationMethod" )
    private String interestCalculationMethod;
    /**
     * Use with available fluent helpers to apply the <b>InterestCalculationMethod</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> INTEREST_CALCULATION_METHOD =
        new TrsyPosFlowField<String>("InterestCalculationMethod");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitGLAccount</b>
     * </p>
     *
     * @return G/L Account Number (Debit)
     */
    @SerializedName( "DebitGLAccount" )
    @JsonProperty( "DebitGLAccount" )
    @Nullable
    @ODataField( odataName = "DebitGLAccount" )
    private String debitGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>DebitGLAccount</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> DEBIT_GL_ACCOUNT = new TrsyPosFlowField<String>("DebitGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditGLAccount</b>
     * </p>
     *
     * @return G/L Account Number (Credit)
     */
    @SerializedName( "CreditGLAccount" )
    @JsonProperty( "CreditGLAccount" )
    @Nullable
    @ODataField( odataName = "CreditGLAccount" )
    private String creditGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>CreditGLAccount</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> CREDIT_GL_ACCOUNT = new TrsyPosFlowField<String>("CreditGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitCustomer</b>
     * </p>
     *
     * @return Customer (Debit)
     */
    @SerializedName( "DebitCustomer" )
    @JsonProperty( "DebitCustomer" )
    @Nullable
    @ODataField( odataName = "DebitCustomer" )
    private String debitCustomer;
    /**
     * Use with available fluent helpers to apply the <b>DebitCustomer</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> DEBIT_CUSTOMER = new TrsyPosFlowField<String>("DebitCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditCustomer</b>
     * </p>
     *
     * @return Customer (Credit)
     */
    @SerializedName( "CreditCustomer" )
    @JsonProperty( "CreditCustomer" )
    @Nullable
    @ODataField( odataName = "CreditCustomer" )
    private String creditCustomer;
    /**
     * Use with available fluent helpers to apply the <b>CreditCustomer</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> CREDIT_CUSTOMER = new TrsyPosFlowField<String>("CreditCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FISCAL_YEAR = new TrsyPosFlowField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FISCAL_PERIOD = new TrsyPosFlowField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> POSTING_DATE =
        new TrsyPosFlowField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountAssignmentRef</b>
     * </p>
     *
     * @return Account Assignment Reference of Position Management
     */
    @SerializedName( "TreasuryGLAccountAssignmentRef" )
    @JsonProperty( "TreasuryGLAccountAssignmentRef" )
    @Nullable
    @ODataField( odataName = "TreasuryGLAccountAssignmentRef" )
    private String treasuryGLAccountAssignmentRef;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryGLAccountAssignmentRef</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> TREASURY_GL_ACCOUNT_ASSIGNMENT_REF =
        new TrsyPosFlowField<String>("TreasuryGLAccountAssignmentRef");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference document number
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REFERENCE_DOCUMENT = new TrsyPosFlowField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @return Reference Organizational Units
     */
    @SerializedName( "ReferenceDocumentContext" )
    @JsonProperty( "ReferenceDocumentContext" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentContext" )
    private String referenceDocumentContext;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentContext</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REFERENCE_DOCUMENT_CONTEXT =
        new TrsyPosFlowField<String>("ReferenceDocumentContext");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @return Reverse Document Fiscal Year
     */
    @SerializedName( "ReverseDocumentFiscalYear" )
    @JsonProperty( "ReverseDocumentFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReverseDocumentFiscalYear" )
    private String reverseDocumentFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentFiscalYear</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REVERSE_DOCUMENT_FISCAL_YEAR =
        new TrsyPosFlowField<String>("ReverseDocumentFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalPeriod</b>
     * </p>
     *
     * @return Reverse Document Fiscal Period
     */
    @SerializedName( "ReverseDocumentFiscalPeriod" )
    @JsonProperty( "ReverseDocumentFiscalPeriod" )
    @Nullable
    @ODataField( odataName = "ReverseDocumentFiscalPeriod" )
    private String reverseDocumentFiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentFiscalPeriod</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REVERSE_DOCUMENT_FISCAL_PERIOD =
        new TrsyPosFlowField<String>("ReverseDocumentFiscalPeriod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentPostingDate</b>
     * </p>
     *
     * @return Reverse Document Posting Date
     */
    @SerializedName( "ReverseDocumentPostingDate" )
    @JsonProperty( "ReverseDocumentPostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ReverseDocumentPostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime reverseDocumentPostingDate;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentPostingDate</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<LocalDateTime> REVERSE_DOCUMENT_POSTING_DATE =
        new TrsyPosFlowField<LocalDateTime>("ReverseDocumentPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @return Reversal: Reference Document No. of Document to Be Reversed
     */
    @SerializedName( "ReversalReferenceDocument" )
    @JsonProperty( "ReversalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocument" )
    private String reversalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocument</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REVERSAL_REFERENCE_DOCUMENT =
        new TrsyPosFlowField<String>("ReversalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocumentCntxt</b>
     * </p>
     *
     * @return Reversal: Reference Organizations of Document to Be Reversed
     */
    @SerializedName( "ReversalReferenceDocumentCntxt" )
    @JsonProperty( "ReversalReferenceDocumentCntxt" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocumentCntxt" )
    private String reversalReferenceDocumentCntxt;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocumentCntxt</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REVERSAL_REFERENCE_DOCUMENT_CNTXT =
        new TrsyPosFlowField<String>("ReversalReferenceDocumentCntxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> ACCOUNTING_DOCUMENT =
        new TrsyPosFlowField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @return Reverse Document Number
     */
    @SerializedName( "ReverseDocument" )
    @JsonProperty( "ReverseDocument" )
    @Nullable
    @ODataField( odataName = "ReverseDocument" )
    private String reverseDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocument</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> REVERSE_DOCUMENT = new TrsyPosFlowField<String>("ReverseDocument");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureItem</b>
     * </p>
     *
     * @return Exposure Item ID
     */
    @SerializedName( "FinancialExposureItem" )
    @JsonProperty( "FinancialExposureItem" )
    @Nullable
    @ODataField( odataName = "FinancialExposureItem" )
    private String financialExposureItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialExposureItem</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_EXPOSURE_ITEM =
        new TrsyPosFlowField<String>("FinancialExposureItem");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureSubItem</b>
     * </p>
     *
     * @return Exposure Subitem ID
     */
    @SerializedName( "FinancialExposureSubItem" )
    @JsonProperty( "FinancialExposureSubItem" )
    @Nullable
    @ODataField( odataName = "FinancialExposureSubItem" )
    private String financialExposureSubItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialExposureSubItem</b> field to query operations.
     *
     */
    public final static TrsyPosFlowField<String> FINANCIAL_EXPOSURE_SUB_ITEM =
        new TrsyPosFlowField<String>("FinancialExposureSubItem");

    @Nonnull
    @Override
    public Class<TrsyPosFlow> getType()
    {
        return TrsyPosFlow.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryTransactionFlow</b>
     * </p>
     *
     * @param treasuryTransactionFlow
     *            Number of TRL Flow
     */
    public void setTreasuryTransactionFlow( @Nullable final Integer treasuryTransactionFlow )
    {
        rememberChangedField("TreasuryTransactionFlow", this.treasuryTransactionFlow);
        this.treasuryTransactionFlow = treasuryTransactionFlow;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionDocUUID</b>
     * </p>
     *
     * @param businessTransactionDocUUID
     *            Business Transaction (GUID)
     */
    public void setBusinessTransactionDocUUID( @Nullable final UUID businessTransactionDocUUID )
    {
        rememberChangedField("BusinessTransactionDocUUID", this.businessTransactionDocUUID);
        this.businessTransactionDocUUID = businessTransactionDocUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPosition</b>
     * </p>
     *
     * @param treasuryPosition
     *            Treasury Position UUID
     */
    public void setTreasuryPosition( @Nullable final UUID treasuryPosition )
    {
        rememberChangedField("TreasuryPosition", this.treasuryPosition);
        this.treasuryPosition = treasuryPosition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransaction</b>
     * </p>
     *
     * @param treasuryBusinessTransaction
     *            Identifier of the Distributor Business Transaction
     */
    public void setTreasuryBusinessTransaction( @Nullable final UUID treasuryBusinessTransaction )
    {
        rememberChangedField("TreasuryBusinessTransaction", this.treasuryBusinessTransaction);
        this.treasuryBusinessTransaction = treasuryBusinessTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateTypeName</b>
     * </p>
     *
     * @param treasuryUpdateTypeName
     *            Name of the Update Type
     */
    public void setTreasuryUpdateTypeName( @Nullable final String treasuryUpdateTypeName )
    {
        rememberChangedField("TreasuryUpdateTypeName", this.treasuryUpdateTypeName);
        this.treasuryUpdateTypeName = treasuryUpdateTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateType</b>
     * </p>
     *
     * @param treasuryUpdateType
     *            Update Type
     */
    public void setTreasuryUpdateType( @Nullable final String treasuryUpdateType )
    {
        rememberChangedField("TreasuryUpdateType", this.treasuryUpdateType);
        this.treasuryUpdateType = treasuryUpdateType;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInPositionCurrency</b>
     * </p>
     *
     * @param amountInPositionCurrency
     *            Amount in Position Currency
     */
    public void setAmountInPositionCurrency( @Nullable final BigDecimal amountInPositionCurrency )
    {
        rememberChangedField("AmountInPositionCurrency", this.amountInPositionCurrency);
        this.amountInPositionCurrency = amountInPositionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PositionCurrency</b>
     * </p>
     *
     * @param positionCurrency
     *            Position Currency
     */
    public void setPositionCurrency( @Nullable final String positionCurrency )
    {
        rememberChangedField("PositionCurrency", this.positionCurrency);
        this.positionCurrency = positionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInValuationCurrency</b>
     * </p>
     *
     * @param amountInValuationCurrency
     *            Amount in Valuation Currency
     */
    public void setAmountInValuationCurrency( @Nullable final BigDecimal amountInValuationCurrency )
    {
        rememberChangedField("AmountInValuationCurrency", this.amountInValuationCurrency);
        this.amountInValuationCurrency = amountInValuationCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ValuationCurrency</b>
     * </p>
     *
     * @param valuationCurrency
     *            Valuation Currency
     */
    public void setValuationCurrency( @Nullable final String valuationCurrency )
    {
        rememberChangedField("ValuationCurrency", this.valuationCurrency);
        this.valuationCurrency = valuationCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLedgerDate</b>
     * </p>
     *
     * @param treasuryPositionLedgerDate
     *            Treasury Ledger Date
     */
    public void setTreasuryPositionLedgerDate( @Nullable final LocalDateTime treasuryPositionLedgerDate )
    {
        rememberChangedField("TreasuryPositionLedgerDate", this.treasuryPositionLedgerDate);
        this.treasuryPositionLedgerDate = treasuryPositionLedgerDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionTransferGroup</b>
     * </p>
     *
     * @param treasuryPositionTransferGroup
     *            Position Transfer Group
     */
    public void setTreasuryPositionTransferGroup( @Nullable final String treasuryPositionTransferGroup )
    {
        rememberChangedField("TreasuryPositionTransferGroup", this.treasuryPositionTransferGroup);
        this.treasuryPositionTransferGroup = treasuryPositionTransferGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionTransferFactor</b>
     * </p>
     *
     * @param treasuryPositionTransferFactor
     *            Position Transfer Coefficient
     */
    public void setTreasuryPositionTransferFactor( @Nullable final Double treasuryPositionTransferFactor )
    {
        rememberChangedField("TreasuryPositionTransferFactor", this.treasuryPositionTransferFactor);
        this.treasuryPositionTransferFactor = treasuryPositionTransferFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosQuantityChangeCategory</b>
     * </p>
     *
     * @param trsyPosQuantityChangeCategory
     *            Position Change Category (Quantity)
     */
    public void setTrsyPosQuantityChangeCategory( @Nullable final String trsyPosQuantityChangeCategory )
    {
        rememberChangedField("TrsyPosQuantityChangeCategory", this.trsyPosQuantityChangeCategory);
        this.trsyPosQuantityChangeCategory = trsyPosQuantityChangeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosAmountChangeCategory</b>
     * </p>
     *
     * @param trsyPosAmountChangeCategory
     *            Position Change Category (Amount)
     */
    public void setTrsyPosAmountChangeCategory( @Nullable final String trsyPosAmountChangeCategory )
    {
        rememberChangedField("TrsyPosAmountChangeCategory", this.trsyPosAmountChangeCategory);
        this.trsyPosAmountChangeCategory = trsyPosAmountChangeCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInPieces</b>
     * </p>
     *
     * @param quantityInPieces
     *            Units (Short)
     */
    public void setQuantityInPieces( @Nullable final BigDecimal quantityInPieces )
    {
        rememberChangedField("QuantityInPieces", this.quantityInPieces);
        this.quantityInPieces = quantityInPieces;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>IndexCleanAmountInPositionCrcy</b>
     * </p>
     *
     * @param indexCleanAmountInPositionCrcy
     *            Index Clean Amount in Position Currency
     */
    public void setIndexCleanAmountInPositionCrcy( @Nullable final BigDecimal indexCleanAmountInPositionCrcy )
    {
        rememberChangedField("IndexCleanAmountInPositionCrcy", this.indexCleanAmountInPositionCrcy);
        this.indexCleanAmountInPositionCrcy = indexCleanAmountInPositionCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NominalAmountInNominalCurrency</b>
     * </p>
     *
     * @param nominalAmountInNominalCurrency
     *            Nominal Amount
     */
    public void setNominalAmountInNominalCurrency( @Nullable final BigDecimal nominalAmountInNominalCurrency )
    {
        rememberChangedField("NominalAmountInNominalCurrency", this.nominalAmountInNominalCurrency);
        this.nominalAmountInNominalCurrency = nominalAmountInNominalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OriglNominalAmtInNominalCrcy</b>
     * </p>
     *
     * @param origlNominalAmtInNominalCrcy
     *            Original Nominal Amount
     */
    public void setOriglNominalAmtInNominalCrcy( @Nullable final BigDecimal origlNominalAmtInNominalCrcy )
    {
        rememberChangedField("OriglNominalAmtInNominalCrcy", this.origlNominalAmtInNominalCrcy);
        this.origlNominalAmtInNominalCrcy = origlNominalAmtInNominalCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>NominalCurrency</b>
     * </p>
     *
     * @param nominalCurrency
     *            Nominal Currency
     */
    public void setNominalCurrency( @Nullable final String nominalCurrency )
    {
        rememberChangedField("NominalCurrency", this.nominalCurrency);
        this.nominalCurrency = nominalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CalculationDate</b>
     * </p>
     *
     * @param calculationDate
     *            Key Date of Last Interest Calculation
     */
    public void setCalculationDate( @Nullable final LocalDateTime calculationDate )
    {
        rememberChangedField("CalculationDate", this.calculationDate);
        this.calculationDate = calculationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalcDateIsAsEndDateInclusive</b>
     * </p>
     *
     * @param calcDateIsAsEndDateInclusive
     *            Incl./Excl. Indicator for Beginning and End of a Period
     */
    public void setCalcDateIsAsEndDateInclusive( @Nullable final String calcDateIsAsEndDateInclusive )
    {
        rememberChangedField("CalcDateIsAsEndDateInclusive", this.calcDateIsAsEndDateInclusive);
        this.calcDateIsAsEndDateInclusive = calcDateIsAsEndDateInclusive;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueDate</b>
     * </p>
     *
     * @param dueDate
     *            Due Date
     */
    public void setDueDate( @Nullable final LocalDateTime dueDate )
    {
        rememberChangedField("DueDate", this.dueDate);
        this.dueDate = dueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CalculationPeriodStartDate</b>
     * </p>
     *
     * @param calculationPeriodStartDate
     *            Start of Calculation Period
     */
    public void setCalculationPeriodStartDate( @Nullable final LocalDateTime calculationPeriodStartDate )
    {
        rememberChangedField("CalculationPeriodStartDate", this.calculationPeriodStartDate);
        this.calculationPeriodStartDate = calculationPeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CalculationPeriodEndDate</b>
     * </p>
     *
     * @param calculationPeriodEndDate
     *            End of Calculation Period
     */
    public void setCalculationPeriodEndDate( @Nullable final LocalDateTime calculationPeriodEndDate )
    {
        rememberChangedField("CalculationPeriodEndDate", this.calculationPeriodEndDate);
        this.calculationPeriodEndDate = calculationPeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 7
     * <p>
     * Original property name from the Odata EDM: <b>EffectiveInterestRate</b>
     * </p>
     *
     * @param effectiveInterestRate
     *            For Calculation of Amortization Amts (SAC) for Used EffInR
     */
    public void setEffectiveInterestRate( @Nullable final BigDecimal effectiveInterestRate )
    {
        rememberChangedField("EffectiveInterestRate", this.effectiveInterestRate);
        this.effectiveInterestRate = effectiveInterestRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EffctvIntrstRateRdmptnSched</b>
     * </p>
     *
     * @param effctvIntrstRateRdmptnSched
     *            Redemption Schedule that Explains Effective Interest Rate
     */
    public void setEffctvIntrstRateRdmptnSched( @Nullable final Integer effctvIntrstRateRdmptnSched )
    {
        rememberChangedField("EffctvIntrstRateRdmptnSched", this.effctvIntrstRateRdmptnSched);
        this.effctvIntrstRateRdmptnSched = effctvIntrstRateRdmptnSched;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 7
     * <p>
     * Original property name from the Odata EDM: <b>NextEffectiveInterestRate</b>
     * </p>
     *
     * @param nextEffectiveInterestRate
     *            Valid Effective Interest Rate for the Next Amortization
     */
    public void setNextEffectiveInterestRate( @Nullable final BigDecimal nextEffectiveInterestRate )
    {
        rememberChangedField("NextEffectiveInterestRate", this.nextEffectiveInterestRate);
        this.nextEffectiveInterestRate = nextEffectiveInterestRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FixedRedemptionSchedule</b>
     * </p>
     *
     * @param fixedRedemptionSchedule
     *            Fixed Redemption Schedule
     */
    public void setFixedRedemptionSchedule( @Nullable final Integer fixedRedemptionSchedule )
    {
        rememberChangedField("FixedRedemptionSchedule", this.fixedRedemptionSchedule);
        this.fixedRedemptionSchedule = fixedRedemptionSchedule;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalculationBasis</b>
     * </p>
     *
     * @param calculationBasis
     *            Calculation Base Amount
     */
    public void setCalculationBasis( @Nullable final BigDecimal calculationBasis )
    {
        rememberChangedField("CalculationBasis", this.calculationBasis);
        this.calculationBasis = calculationBasis;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinInstrProductGroup</b>
     * </p>
     *
     * @param finInstrProductGroup
     *            Financial Instrument Product Group
     */
    public void setFinInstrProductGroup( @Nullable final String finInstrProductGroup )
    {
        rememberChangedField("FinInstrProductGroup", this.finInstrProductGroup);
        this.finInstrProductGroup = finInstrProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransStatus</b>
     * </p>
     *
     * @param treasuryBusinessTransStatus
     *            Posting Status Treasury Ledger Business Transaction
     */
    public void setTreasuryBusinessTransStatus( @Nullable final String treasuryBusinessTransStatus )
    {
        rememberChangedField("TreasuryBusinessTransStatus", this.treasuryBusinessTransStatus);
        this.treasuryBusinessTransStatus = treasuryBusinessTransStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TrsyIntragroupTransacStatus</b>
     * </p>
     *
     * @param trsyIntragroupTransacStatus
     *            Intragroup Transaction Status
     */
    public void setTrsyIntragroupTransacStatus( @Nullable final String trsyIntragroupTransacStatus )
    {
        rememberChangedField("TrsyIntragroupTransacStatus", this.trsyIntragroupTransacStatus);
        this.trsyIntragroupTransacStatus = trsyIntragroupTransacStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransCategory</b>
     * </p>
     *
     * @param treasuryBusinessTransCategory
     *            Business Transaction Category
     */
    public void setTreasuryBusinessTransCategory( @Nullable final String treasuryBusinessTransCategory )
    {
        rememberChangedField("TreasuryBusinessTransCategory", this.treasuryBusinessTransCategory);
        this.treasuryBusinessTransCategory = treasuryBusinessTransCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OriglTrsyBusinessTransaction</b>
     * </p>
     *
     * @param origlTrsyBusinessTransaction
     *            Original Business Transaction
     */
    public void setOriglTrsyBusinessTransaction( @Nullable final UUID origlTrsyBusinessTransaction )
    {
        rememberChangedField("OriglTrsyBusinessTransaction", this.origlTrsyBusinessTransaction);
        this.origlTrsyBusinessTransaction = origlTrsyBusinessTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TrsyDerivedBusTransacIsUpdated</b>
     * </p>
     *
     * @param trsyDerivedBusTransacIsUpdated
     *            Status of Treasury Ledger Business Transaction
     */
    public void setTrsyDerivedBusTransacIsUpdated( @Nullable final String trsyDerivedBusTransacIsUpdated )
    {
        rememberChangedField("TrsyDerivedBusTransacIsUpdated", this.trsyDerivedBusTransacIsUpdated);
        this.trsyDerivedBusTransacIsUpdated = trsyDerivedBusTransacIsUpdated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPosAssetLiabilityCode</b>
     * </p>
     *
     * @param treasuryPosAssetLiabilityCode
     *            Assets/Liabilities Position
     */
    public void setTreasuryPosAssetLiabilityCode( @Nullable final String treasuryPosAssetLiabilityCode )
    {
        rememberChangedField("TreasuryPosAssetLiabilityCode", this.treasuryPosAssetLiabilityCode);
        this.treasuryPosAssetLiabilityCode = treasuryPosAssetLiabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosTransfSourceTargetCode</b>
     * </p>
     *
     * @param trsyPosTransfSourceTargetCode
     *            Position Transfer
     */
    public void setTrsyPosTransfSourceTargetCode( @Nullable final String trsyPosTransfSourceTargetCode )
    {
        rememberChangedField("TrsyPosTransfSourceTargetCode", this.trsyPosTransfSourceTargetCode);
        this.trsyPosTransfSourceTargetCode = trsyPosTransfSourceTargetCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationArea</b>
     * </p>
     *
     * @param treasuryValuationArea
     *            Treasury Valuation Area
     */
    public void setTreasuryValuationArea( @Nullable final String treasuryValuationArea )
    {
        rememberChangedField("TreasuryValuationArea", this.treasuryValuationArea);
        this.treasuryValuationArea = treasuryValuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationAreaName</b>
     * </p>
     *
     * @param treasuryValuationAreaName
     *            Name of the Valuation Area
     */
    public void setTreasuryValuationAreaName( @Nullable final String treasuryValuationAreaName )
    {
        rememberChangedField("TreasuryValuationAreaName", this.treasuryValuationAreaName);
        this.treasuryValuationAreaName = treasuryValuationAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClass</b>
     * </p>
     *
     * @param treasuryValuationClass
     *            Valuation Class
     */
    public void setTreasuryValuationClass( @Nullable final String treasuryValuationClass )
    {
        rememberChangedField("TreasuryValuationClass", this.treasuryValuationClass);
        this.treasuryValuationClass = treasuryValuationClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClassName</b>
     * </p>
     *
     * @param treasuryValuationClassName
     *            Name of the Valuation Class
     */
    public void setTreasuryValuationClassName( @Nullable final String treasuryValuationClassName )
    {
        rememberChangedField("TreasuryValuationClassName", this.treasuryValuationClassName);
        this.treasuryValuationClassName = treasuryValuationClassName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentProductType</b>
     * </p>
     *
     * @param financialInstrumentProductType
     *            Product Type
     */
    public void setFinancialInstrumentProductType( @Nullable final String financialInstrumentProductType )
    {
        rememberChangedField("FinancialInstrumentProductType", this.financialInstrumentProductType);
        this.financialInstrumentProductType = financialInstrumentProductType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccount</b>
     * </p>
     *
     * @param securityAccount
     *            Security Account
     */
    public void setSecurityAccount( @Nullable final String securityAccount )
    {
        rememberChangedField("SecurityAccount", this.securityAccount);
        this.securityAccount = securityAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClass</b>
     * </p>
     *
     * @param securityClass
     *            Security Class
     */
    public void setSecurityClass( @Nullable final String securityClass )
    {
        rememberChangedField("SecurityClass", this.securityClass);
        this.securityClass = securityClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassName</b>
     * </p>
     *
     * @param securityClassName
     *            Name of the Security Class
     */
    public void setSecurityClassName( @Nullable final String securityClassName )
    {
        rememberChangedField("SecurityClassName", this.securityClassName);
        this.securityClassName = securityClassName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassDescription</b>
     * </p>
     *
     * @param securityClassDescription
     *            Description of the Security Class
     */
    public void setSecurityClassDescription( @Nullable final String securityClassDescription )
    {
        rememberChangedField("SecurityClassDescription", this.securityClassDescription);
        this.securityClassDescription = securityClassDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrValClassName</b>
     * </p>
     *
     * @param financialInstrValClassName
     *            Name of the Financial Instrument Valuation Class
     */
    public void setFinancialInstrValClassName( @Nullable final String financialInstrValClassName )
    {
        rememberChangedField("FinancialInstrValClassName", this.financialInstrValClassName);
        this.financialInstrValClassName = financialInstrValClassName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLot</b>
     * </p>
     *
     * @param treasuryPositionLot
     *            Identifier of the Lot
     */
    public void setTreasuryPositionLot( @Nullable final UUID treasuryPositionLot )
    {
        rememberChangedField("TreasuryPositionLot", this.treasuryPositionLot);
        this.treasuryPositionLot = treasuryPositionLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroup</b>
     * </p>
     *
     * @param securityAccountGroup
     *            Securities Account Group
     */
    public void setSecurityAccountGroup( @Nullable final String securityAccountGroup )
    {
        rememberChangedField("SecurityAccountGroup", this.securityAccountGroup);
        this.securityAccountGroup = securityAccountGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>LoanContract</b>
     * </p>
     *
     * @param loanContract
     *            Loan Contract Number
     */
    public void setLoanContract( @Nullable final String loanContract )
    {
        rememberChangedField("LoanContract", this.loanContract);
        this.loanContract = loanContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>LoanContractName</b>
     * </p>
     *
     * @param loanContractName
     *            Name of the Loan Contract
     */
    public void setLoanContractName( @Nullable final String loanContractName )
    {
        rememberChangedField("LoanContractName", this.loanContractName);
        this.loanContractName = loanContractName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionAccount</b>
     * </p>
     *
     * @param treasuryPositionAccount
     *            Futures Account for Listed Options and Futures
     */
    public void setTreasuryPositionAccount( @Nullable final String treasuryPositionAccount )
    {
        rememberChangedField("TreasuryPositionAccount", this.treasuryPositionAccount);
        this.treasuryPositionAccount = treasuryPositionAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLongShortCode</b>
     * </p>
     *
     * @param treasuryPositionLongShortCode
     *            Code: Long or Short Position
     */
    public void setTreasuryPositionLongShortCode( @Nullable final String treasuryPositionLongShortCode )
    {
        rememberChangedField("TreasuryPositionLongShortCode", this.treasuryPositionLongShortCode);
        this.treasuryPositionLongShortCode = treasuryPositionLongShortCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @param wBSDescription
     *            WBS Element Name
     */
    public void setWBSDescription( @Nullable final String wBSDescription )
    {
        rememberChangedField("WBSDescription", this.wBSDescription);
        this.wBSDescription = wBSDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm1
     *            Custom Differentiation Term 1 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm1( @Nullable final String trsyPosCustomDiffntnTerm1 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm1", this.trsyPosCustomDiffntnTerm1);
        this.trsyPosCustomDiffntnTerm1 = trsyPosCustomDiffntnTerm1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm1Name
     *            Custom Differentiation Term 1 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm1Name( @Nullable final String trsyPosCustomDiffntnTerm1Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm1Name", this.trsyPosCustomDiffntnTerm1Name);
        this.trsyPosCustomDiffntnTerm1Name = trsyPosCustomDiffntnTerm1Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm2
     *            Custom Differentiation Term 2 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm2( @Nullable final String trsyPosCustomDiffntnTerm2 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm2", this.trsyPosCustomDiffntnTerm2);
        this.trsyPosCustomDiffntnTerm2 = trsyPosCustomDiffntnTerm2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm2Name
     *            Custom Differentiation Term 2 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm2Name( @Nullable final String trsyPosCustomDiffntnTerm2Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm2Name", this.trsyPosCustomDiffntnTerm2Name);
        this.trsyPosCustomDiffntnTerm2Name = trsyPosCustomDiffntnTerm2Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm3
     *            Custom Differentiation Term 3 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm3( @Nullable final String trsyPosCustomDiffntnTerm3 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm3", this.trsyPosCustomDiffntnTerm3);
        this.trsyPosCustomDiffntnTerm3 = trsyPosCustomDiffntnTerm3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm3Name
     *            Custom Differentiation Term 3 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm3Name( @Nullable final String trsyPosCustomDiffntnTerm3Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm3Name", this.trsyPosCustomDiffntnTerm3Name);
        this.trsyPosCustomDiffntnTerm3Name = trsyPosCustomDiffntnTerm3Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm4
     *            Custom Differentiation Term 4 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm4( @Nullable final String trsyPosCustomDiffntnTerm4 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm4", this.trsyPosCustomDiffntnTerm4);
        this.trsyPosCustomDiffntnTerm4 = trsyPosCustomDiffntnTerm4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm4Name
     *            Custom Differentiation Term 4 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm4Name( @Nullable final String trsyPosCustomDiffntnTerm4Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm4Name", this.trsyPosCustomDiffntnTerm4Name);
        this.trsyPosCustomDiffntnTerm4Name = trsyPosCustomDiffntnTerm4Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm5
     *            Custom Differentiation Term 5 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm5( @Nullable final String trsyPosCustomDiffntnTerm5 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm5", this.trsyPosCustomDiffntnTerm5);
        this.trsyPosCustomDiffntnTerm5 = trsyPosCustomDiffntnTerm5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm5Name
     *            Custom Differentiation Term 5 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm5Name( @Nullable final String trsyPosCustomDiffntnTerm5Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm5Name", this.trsyPosCustomDiffntnTerm5Name);
        this.trsyPosCustomDiffntnTerm5Name = trsyPosCustomDiffntnTerm5Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccount</b>
     * </p>
     *
     * @param centralClearingAccount
     *            Central Clearing Account
     */
    public void setCentralClearingAccount( @Nullable final String centralClearingAccount )
    {
        rememberChangedField("CentralClearingAccount", this.centralClearingAccount);
        this.centralClearingAccount = centralClearingAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccountName</b>
     * </p>
     *
     * @param centralClearingAccountName
     *            Name of the Central Clearing Account
     */
    public void setCentralClearingAccountName( @Nullable final String centralClearingAccountName )
    {
        rememberChangedField("CentralClearingAccountName", this.centralClearingAccountName);
        this.centralClearingAccountName = centralClearingAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountName</b>
     * </p>
     *
     * @param securityAccountName
     *            Name of the Security Account
     */
    public void setSecurityAccountName( @Nullable final String securityAccountName )
    {
        rememberChangedField("SecurityAccountName", this.securityAccountName);
        this.securityAccountName = securityAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroupName</b>
     * </p>
     *
     * @param securityAccountGroupName
     *            Name of Securities Account Group
     */
    public void setSecurityAccountGroupName( @Nullable final String securityAccountGroupName )
    {
        rememberChangedField("SecurityAccountGroupName", this.securityAccountGroupName);
        this.securityAccountGroupName = securityAccountGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>ActivityFinancialTransaction</b>
     * </p>
     *
     * @param activityFinancialTransaction
     *            Activity-Triggering Financial Transaction
     */
    public void setActivityFinancialTransaction( @Nullable final String activityFinancialTransaction )
    {
        rememberChangedField("ActivityFinancialTransaction", this.activityFinancialTransaction);
        this.activityFinancialTransaction = activityFinancialTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrTransactionType</b>
     * </p>
     *
     * @param financialInstrTransactionType
     *            Financial Instrument Transaction Type
     */
    public void setFinancialInstrTransactionType( @Nullable final String financialInstrTransactionType )
    {
        rememberChangedField("FinancialInstrTransactionType", this.financialInstrTransactionType);
        this.financialInstrTransactionType = financialInstrTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryFacilityCompanyCode</b>
     * </p>
     *
     * @param treasuryFacilityCompanyCode
     *            Company Code of Facility
     */
    public void setTreasuryFacilityCompanyCode( @Nullable final String treasuryFacilityCompanyCode )
    {
        rememberChangedField("TreasuryFacilityCompanyCode", this.treasuryFacilityCompanyCode);
        this.treasuryFacilityCompanyCode = treasuryFacilityCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryFacility</b>
     * </p>
     *
     * @param treasuryFacility
     *            Transaction Number of Facility
     */
    public void setTreasuryFacility( @Nullable final String treasuryFacility )
    {
        rememberChangedField("TreasuryFacility", this.treasuryFacility);
        this.treasuryFacility = treasuryFacility;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryMasterAgreement</b>
     * </p>
     *
     * @param treasuryMasterAgreement
     *            The treasuryMasterAgreement to set.
     */
    public void setTreasuryMasterAgreement( @Nullable final String treasuryMasterAgreement )
    {
        rememberChangedField("TreasuryMasterAgreement", this.treasuryMasterAgreement);
        this.treasuryMasterAgreement = treasuryMasterAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryFinanceProject</b>
     * </p>
     *
     * @param treasuryFinanceProject
     *            Finance Project
     */
    public void setTreasuryFinanceProject( @Nullable final String treasuryFinanceProject )
    {
        rememberChangedField("TreasuryFinanceProject", this.treasuryFinanceProject);
        this.treasuryFinanceProject = treasuryFinanceProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Counterparty</b>
     * </p>
     *
     * @param counterparty
     *            Counterparty Number
     */
    public void setCounterparty( @Nullable final String counterparty )
    {
        rememberChangedField("Counterparty", this.counterparty);
        this.counterparty = counterparty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>LetterOfCredit</b>
     * </p>
     *
     * @param letterOfCredit
     *            Letter of Credit Number
     */
    public void setLetterOfCredit( @Nullable final String letterOfCredit )
    {
        rememberChangedField("LetterOfCredit", this.letterOfCredit);
        this.letterOfCredit = letterOfCredit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentStatus</b>
     * </p>
     *
     * @param financialInstrumentStatus
     *            Active Status of Transaction or Activity
     */
    public void setFinancialInstrumentStatus( @Nullable final String financialInstrumentStatus )
    {
        rememberChangedField("FinancialInstrumentStatus", this.financialInstrumentStatus);
        this.financialInstrumentStatus = financialInstrumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Portfolio</b>
     * </p>
     *
     * @param portfolio
     *            Portfolio
     */
    public void setPortfolio( @Nullable final String portfolio )
    {
        rememberChangedField("Portfolio", this.portfolio);
        this.portfolio = portfolio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PortfolioName</b>
     * </p>
     *
     * @param portfolioName
     *            Name of the Portfolio
     */
    public void setPortfolioName( @Nullable final String portfolioName )
    {
        rememberChangedField("PortfolioName", this.portfolioName);
        this.portfolioName = portfolioName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Issuer</b>
     * </p>
     *
     * @param issuer
     *            Issuer Identity Key
     */
    public void setIssuer( @Nullable final String issuer )
    {
        rememberChangedField("Issuer", this.issuer);
        this.issuer = issuer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosQtyChangeCategoryName</b>
     * </p>
     *
     * @param trsyPosQtyChangeCategoryName
     *            Position Change Category: Quantity (Text)
     */
    public void setTrsyPosQtyChangeCategoryName( @Nullable final String trsyPosQtyChangeCategoryName )
    {
        rememberChangedField("TrsyPosQtyChangeCategoryName", this.trsyPosQtyChangeCategoryName);
        this.trsyPosQtyChangeCategoryName = trsyPosQtyChangeCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPosChangeCategoryName</b>
     * </p>
     *
     * @param treasuryPosChangeCategoryName
     *            Name of the Position Change Category
     */
    public void setTreasuryPosChangeCategoryName( @Nullable final String treasuryPosChangeCategoryName )
    {
        rememberChangedField("TreasuryPosChangeCategoryName", this.treasuryPosChangeCategoryName);
        this.treasuryPosChangeCategoryName = treasuryPosChangeCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolio</b>
     * </p>
     *
     * @param differentiationPortfolio
     *            Portfolio as Differentiation Characteristic
     */
    public void setDifferentiationPortfolio( @Nullable final String differentiationPortfolio )
    {
        rememberChangedField("DifferentiationPortfolio", this.differentiationPortfolio);
        this.differentiationPortfolio = differentiationPortfolio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolioName</b>
     * </p>
     *
     * @param differentiationPortfolioName
     *            Name of the Portfolio as Differentiation Characteristic
     */
    public void setDifferentiationPortfolioName( @Nullable final String differentiationPortfolioName )
    {
        rememberChangedField("DifferentiationPortfolioName", this.differentiationPortfolioName);
        this.differentiationPortfolioName = differentiationPortfolioName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransaction</b>
     * </p>
     *
     * @param financialTransaction
     *            Financial Transaction
     */
    public void setFinancialTransaction( @Nullable final String financialTransaction )
    {
        rememberChangedField("FinancialTransaction", this.financialTransaction);
        this.financialTransaction = financialTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrActivityCategory</b>
     * </p>
     *
     * @param financialInstrActivityCategory
     *            Transaction Activity Category
     */
    public void setFinancialInstrActivityCategory( @Nullable final String financialInstrActivityCategory )
    {
        rememberChangedField("FinancialInstrActivityCategory", this.financialInstrActivityCategory);
        this.financialInstrActivityCategory = financialInstrActivityCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrCharacteristic</b>
     * </p>
     *
     * @param financialInstrCharacteristic
     *            Free Characteristic of Financial Transaction
     */
    public void setFinancialInstrCharacteristic( @Nullable final String financialInstrCharacteristic )
    {
        rememberChangedField("FinancialInstrCharacteristic", this.financialInstrCharacteristic);
        this.financialInstrCharacteristic = financialInstrCharacteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentReference</b>
     * </p>
     *
     * @param financialInstrumentReference
     *            Free Internal Reference of Financial Transaction
     */
    public void setFinancialInstrumentReference( @Nullable final String financialInstrumentReference )
    {
        rememberChangedField("FinancialInstrumentReference", this.financialInstrumentReference);
        this.financialInstrumentReference = financialInstrumentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentAssignment</b>
     * </p>
     *
     * @param financialInstrumentAssignment
     *            Free Assignment of Financial Transaction
     */
    public void setFinancialInstrumentAssignment( @Nullable final String financialInstrumentAssignment )
    {
        rememberChangedField("FinancialInstrumentAssignment", this.financialInstrumentAssignment);
        this.financialInstrumentAssignment = financialInstrumentAssignment;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionItemValidityStartDate</b>
     * </p>
     *
     * @param conditionItemValidityStartDate
     *            Condition Item Effective From
     */
    public void setConditionItemValidityStartDate( @Nullable final LocalDateTime conditionItemValidityStartDate )
    {
        rememberChangedField("ConditionItemValidityStartDate", this.conditionItemValidityStartDate);
        this.conditionItemValidityStartDate = conditionItemValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalcPeriodEndDateIsInclusive</b>
     * </p>
     *
     * @param calcPeriodEndDateIsInclusive
     *            Inclusive Indicator for the End of a Calculation Period
     */
    public void setCalcPeriodEndDateIsInclusive( @Nullable final String calcPeriodEndDateIsInclusive )
    {
        rememberChangedField("CalcPeriodEndDateIsInclusive", this.calcPeriodEndDateIsInclusive);
        this.calcPeriodEndDateIsInclusive = calcPeriodEndDateIsInclusive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InterestCalculationMethod</b>
     * </p>
     *
     * @param interestCalculationMethod
     *            Interest Calculation Method
     */
    public void setInterestCalculationMethod( @Nullable final String interestCalculationMethod )
    {
        rememberChangedField("InterestCalculationMethod", this.interestCalculationMethod);
        this.interestCalculationMethod = interestCalculationMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitGLAccount</b>
     * </p>
     *
     * @param debitGLAccount
     *            G/L Account Number (Debit)
     */
    public void setDebitGLAccount( @Nullable final String debitGLAccount )
    {
        rememberChangedField("DebitGLAccount", this.debitGLAccount);
        this.debitGLAccount = debitGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditGLAccount</b>
     * </p>
     *
     * @param creditGLAccount
     *            G/L Account Number (Credit)
     */
    public void setCreditGLAccount( @Nullable final String creditGLAccount )
    {
        rememberChangedField("CreditGLAccount", this.creditGLAccount);
        this.creditGLAccount = creditGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitCustomer</b>
     * </p>
     *
     * @param debitCustomer
     *            Customer (Debit)
     */
    public void setDebitCustomer( @Nullable final String debitCustomer )
    {
        rememberChangedField("DebitCustomer", this.debitCustomer);
        this.debitCustomer = debitCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditCustomer</b>
     * </p>
     *
     * @param creditCustomer
     *            Customer (Credit)
     */
    public void setCreditCustomer( @Nullable final String creditCustomer )
    {
        rememberChangedField("CreditCustomer", this.creditCustomer);
        this.creditCustomer = creditCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountAssignmentRef</b>
     * </p>
     *
     * @param treasuryGLAccountAssignmentRef
     *            Account Assignment Reference of Position Management
     */
    public void setTreasuryGLAccountAssignmentRef( @Nullable final String treasuryGLAccountAssignmentRef )
    {
        rememberChangedField("TreasuryGLAccountAssignmentRef", this.treasuryGLAccountAssignmentRef);
        this.treasuryGLAccountAssignmentRef = treasuryGLAccountAssignmentRef;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference document number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @param referenceDocumentContext
     *            Reference Organizational Units
     */
    public void setReferenceDocumentContext( @Nullable final String referenceDocumentContext )
    {
        rememberChangedField("ReferenceDocumentContext", this.referenceDocumentContext);
        this.referenceDocumentContext = referenceDocumentContext;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @param reverseDocumentFiscalYear
     *            Reverse Document Fiscal Year
     */
    public void setReverseDocumentFiscalYear( @Nullable final String reverseDocumentFiscalYear )
    {
        rememberChangedField("ReverseDocumentFiscalYear", this.reverseDocumentFiscalYear);
        this.reverseDocumentFiscalYear = reverseDocumentFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalPeriod</b>
     * </p>
     *
     * @param reverseDocumentFiscalPeriod
     *            Reverse Document Fiscal Period
     */
    public void setReverseDocumentFiscalPeriod( @Nullable final String reverseDocumentFiscalPeriod )
    {
        rememberChangedField("ReverseDocumentFiscalPeriod", this.reverseDocumentFiscalPeriod);
        this.reverseDocumentFiscalPeriod = reverseDocumentFiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentPostingDate</b>
     * </p>
     *
     * @param reverseDocumentPostingDate
     *            Reverse Document Posting Date
     */
    public void setReverseDocumentPostingDate( @Nullable final LocalDateTime reverseDocumentPostingDate )
    {
        rememberChangedField("ReverseDocumentPostingDate", this.reverseDocumentPostingDate);
        this.reverseDocumentPostingDate = reverseDocumentPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @param reversalReferenceDocument
     *            Reversal: Reference Document No. of Document to Be Reversed
     */
    public void setReversalReferenceDocument( @Nullable final String reversalReferenceDocument )
    {
        rememberChangedField("ReversalReferenceDocument", this.reversalReferenceDocument);
        this.reversalReferenceDocument = reversalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocumentCntxt</b>
     * </p>
     *
     * @param reversalReferenceDocumentCntxt
     *            Reversal: Reference Organizations of Document to Be Reversed
     */
    public void setReversalReferenceDocumentCntxt( @Nullable final String reversalReferenceDocumentCntxt )
    {
        rememberChangedField("ReversalReferenceDocumentCntxt", this.reversalReferenceDocumentCntxt);
        this.reversalReferenceDocumentCntxt = reversalReferenceDocumentCntxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Document Number of an Accounting Document
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *            Reverse Document Number
     */
    public void setReverseDocument( @Nullable final String reverseDocument )
    {
        rememberChangedField("ReverseDocument", this.reverseDocument);
        this.reverseDocument = reverseDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureItem</b>
     * </p>
     *
     * @param financialExposureItem
     *            Exposure Item ID
     */
    public void setFinancialExposureItem( @Nullable final String financialExposureItem )
    {
        rememberChangedField("FinancialExposureItem", this.financialExposureItem);
        this.financialExposureItem = financialExposureItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureSubItem</b>
     * </p>
     *
     * @param financialExposureSubItem
     *            Exposure Subitem ID
     */
    public void setFinancialExposureSubItem( @Nullable final String financialExposureSubItem )
    {
        rememberChangedField("FinancialExposureSubItem", this.financialExposureSubItem);
        this.financialExposureSubItem = financialExposureSubItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_TrsyPosFlow";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("TreasuryTransactionFlow", getTreasuryTransactionFlow());
        result.put("BusinessTransactionDocUUID", getBusinessTransactionDocUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("TreasuryTransactionFlow", getTreasuryTransactionFlow());
        values.put("BusinessTransactionDocUUID", getBusinessTransactionDocUUID());
        values.put("TreasuryPosition", getTreasuryPosition());
        values.put("TreasuryBusinessTransaction", getTreasuryBusinessTransaction());
        values.put("TreasuryUpdateTypeName", getTreasuryUpdateTypeName());
        values.put("TreasuryUpdateType", getTreasuryUpdateType());
        values.put("AmountInPositionCurrency", getAmountInPositionCurrency());
        values.put("PositionCurrency", getPositionCurrency());
        values.put("AmountInValuationCurrency", getAmountInValuationCurrency());
        values.put("ValuationCurrency", getValuationCurrency());
        values.put("TreasuryPositionLedgerDate", getTreasuryPositionLedgerDate());
        values.put("TreasuryPositionTransferGroup", getTreasuryPositionTransferGroup());
        values.put("TreasuryPositionTransferFactor", getTreasuryPositionTransferFactor());
        values.put("TrsyPosQuantityChangeCategory", getTrsyPosQuantityChangeCategory());
        values.put("TrsyPosAmountChangeCategory", getTrsyPosAmountChangeCategory());
        values.put("QuantityInPieces", getQuantityInPieces());
        values.put("IndexCleanAmountInPositionCrcy", getIndexCleanAmountInPositionCrcy());
        values.put("NominalAmountInNominalCurrency", getNominalAmountInNominalCurrency());
        values.put("OriglNominalAmtInNominalCrcy", getOriglNominalAmtInNominalCrcy());
        values.put("NominalCurrency", getNominalCurrency());
        values.put("CalculationDate", getCalculationDate());
        values.put("CalcDateIsAsEndDateInclusive", getCalcDateIsAsEndDateInclusive());
        values.put("DueDate", getDueDate());
        values.put("CalculationPeriodStartDate", getCalculationPeriodStartDate());
        values.put("CalculationPeriodEndDate", getCalculationPeriodEndDate());
        values.put("EffectiveInterestRate", getEffectiveInterestRate());
        values.put("EffctvIntrstRateRdmptnSched", getEffctvIntrstRateRdmptnSched());
        values.put("NextEffectiveInterestRate", getNextEffectiveInterestRate());
        values.put("FixedRedemptionSchedule", getFixedRedemptionSchedule());
        values.put("CalculationBasis", getCalculationBasis());
        values.put("FinInstrProductGroup", getFinInstrProductGroup());
        values.put("TreasuryBusinessTransStatus", getTreasuryBusinessTransStatus());
        values.put("TrsyIntragroupTransacStatus", getTrsyIntragroupTransacStatus());
        values.put("TreasuryBusinessTransCategory", getTreasuryBusinessTransCategory());
        values.put("OriglTrsyBusinessTransaction", getOriglTrsyBusinessTransaction());
        values.put("TrsyDerivedBusTransacIsUpdated", getTrsyDerivedBusTransacIsUpdated());
        values.put("TreasuryPosAssetLiabilityCode", getTreasuryPosAssetLiabilityCode());
        values.put("TrsyPosTransfSourceTargetCode", getTrsyPosTransfSourceTargetCode());
        values.put("TreasuryValuationArea", getTreasuryValuationArea());
        values.put("TreasuryValuationAreaName", getTreasuryValuationAreaName());
        values.put("TreasuryValuationClass", getTreasuryValuationClass());
        values.put("TreasuryValuationClassName", getTreasuryValuationClassName());
        values.put("CompanyCode", getCompanyCode());
        values.put("FinancialInstrumentProductType", getFinancialInstrumentProductType());
        values.put("SecurityAccount", getSecurityAccount());
        values.put("SecurityClass", getSecurityClass());
        values.put("SecurityClassName", getSecurityClassName());
        values.put("SecurityClassDescription", getSecurityClassDescription());
        values.put("FinancialInstrValClassName", getFinancialInstrValClassName());
        values.put("TreasuryPositionLot", getTreasuryPositionLot());
        values.put("SecurityAccountGroup", getSecurityAccountGroup());
        values.put("LoanContract", getLoanContract());
        values.put("LoanContractName", getLoanContractName());
        values.put("TreasuryPositionAccount", getTreasuryPositionAccount());
        values.put("TreasuryPositionLongShortCode", getTreasuryPositionLongShortCode());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("CostCenter", getCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("WBSDescription", getWBSDescription());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("TrsyPosCustomDiffntnTerm1", getTrsyPosCustomDiffntnTerm1());
        values.put("TrsyPosCustomDiffntnTerm1Name", getTrsyPosCustomDiffntnTerm1Name());
        values.put("TrsyPosCustomDiffntnTerm2", getTrsyPosCustomDiffntnTerm2());
        values.put("TrsyPosCustomDiffntnTerm2Name", getTrsyPosCustomDiffntnTerm2Name());
        values.put("TrsyPosCustomDiffntnTerm3", getTrsyPosCustomDiffntnTerm3());
        values.put("TrsyPosCustomDiffntnTerm3Name", getTrsyPosCustomDiffntnTerm3Name());
        values.put("TrsyPosCustomDiffntnTerm4", getTrsyPosCustomDiffntnTerm4());
        values.put("TrsyPosCustomDiffntnTerm4Name", getTrsyPosCustomDiffntnTerm4Name());
        values.put("TrsyPosCustomDiffntnTerm5", getTrsyPosCustomDiffntnTerm5());
        values.put("TrsyPosCustomDiffntnTerm5Name", getTrsyPosCustomDiffntnTerm5Name());
        values.put("CentralClearingAccount", getCentralClearingAccount());
        values.put("CentralClearingAccountName", getCentralClearingAccountName());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("SecurityAccountName", getSecurityAccountName());
        values.put("SecurityAccountGroupName", getSecurityAccountGroupName());
        values.put("ActivityFinancialTransaction", getActivityFinancialTransaction());
        values.put("FinancialInstrTransactionType", getFinancialInstrTransactionType());
        values.put("TreasuryFacilityCompanyCode", getTreasuryFacilityCompanyCode());
        values.put("TreasuryFacility", getTreasuryFacility());
        values.put("TreasuryMasterAgreement", getTreasuryMasterAgreement());
        values.put("TreasuryFinanceProject", getTreasuryFinanceProject());
        values.put("Counterparty", getCounterparty());
        values.put("LetterOfCredit", getLetterOfCredit());
        values.put("FinancialInstrumentStatus", getFinancialInstrumentStatus());
        values.put("Portfolio", getPortfolio());
        values.put("PortfolioName", getPortfolioName());
        values.put("Issuer", getIssuer());
        values.put("TrsyPosQtyChangeCategoryName", getTrsyPosQtyChangeCategoryName());
        values.put("TreasuryPosChangeCategoryName", getTreasuryPosChangeCategoryName());
        values.put("DifferentiationPortfolio", getDifferentiationPortfolio());
        values.put("DifferentiationPortfolioName", getDifferentiationPortfolioName());
        values.put("FinancialTransaction", getFinancialTransaction());
        values.put("FinancialInstrActivityCategory", getFinancialInstrActivityCategory());
        values.put("FinancialInstrCharacteristic", getFinancialInstrCharacteristic());
        values.put("FinancialInstrumentReference", getFinancialInstrumentReference());
        values.put("FinancialInstrumentAssignment", getFinancialInstrumentAssignment());
        values.put("ConditionItemValidityStartDate", getConditionItemValidityStartDate());
        values.put("CalcPeriodEndDateIsInclusive", getCalcPeriodEndDateIsInclusive());
        values.put("InterestCalculationMethod", getInterestCalculationMethod());
        values.put("DebitGLAccount", getDebitGLAccount());
        values.put("CreditGLAccount", getCreditGLAccount());
        values.put("DebitCustomer", getDebitCustomer());
        values.put("CreditCustomer", getCreditCustomer());
        values.put("FiscalYear", getFiscalYear());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("PostingDate", getPostingDate());
        values.put("TreasuryGLAccountAssignmentRef", getTreasuryGLAccountAssignmentRef());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentContext", getReferenceDocumentContext());
        values.put("ReverseDocumentFiscalYear", getReverseDocumentFiscalYear());
        values.put("ReverseDocumentFiscalPeriod", getReverseDocumentFiscalPeriod());
        values.put("ReverseDocumentPostingDate", getReverseDocumentPostingDate());
        values.put("ReversalReferenceDocument", getReversalReferenceDocument());
        values.put("ReversalReferenceDocumentCntxt", getReversalReferenceDocumentCntxt());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("ReverseDocument", getReverseDocument());
        values.put("FinancialExposureItem", getFinancialExposureItem());
        values.put("FinancialExposureSubItem", getFinancialExposureSubItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TreasuryTransactionFlow") ) {
                final Object value = values.remove("TreasuryTransactionFlow");
                if( (value == null) || (!value.equals(getTreasuryTransactionFlow())) ) {
                    setTreasuryTransactionFlow(((Integer) value));
                }
            }
            if( values.containsKey("BusinessTransactionDocUUID") ) {
                final Object value = values.remove("BusinessTransactionDocUUID");
                if( (value == null) || (!value.equals(getBusinessTransactionDocUUID())) ) {
                    setBusinessTransactionDocUUID(((UUID) value));
                }
            }
            if( values.containsKey("TreasuryPosition") ) {
                final Object value = values.remove("TreasuryPosition");
                if( (value == null) || (!value.equals(getTreasuryPosition())) ) {
                    setTreasuryPosition(((UUID) value));
                }
            }
            if( values.containsKey("TreasuryBusinessTransaction") ) {
                final Object value = values.remove("TreasuryBusinessTransaction");
                if( (value == null) || (!value.equals(getTreasuryBusinessTransaction())) ) {
                    setTreasuryBusinessTransaction(((UUID) value));
                }
            }
            if( values.containsKey("TreasuryUpdateTypeName") ) {
                final Object value = values.remove("TreasuryUpdateTypeName");
                if( (value == null) || (!value.equals(getTreasuryUpdateTypeName())) ) {
                    setTreasuryUpdateTypeName(((String) value));
                }
            }
            if( values.containsKey("TreasuryUpdateType") ) {
                final Object value = values.remove("TreasuryUpdateType");
                if( (value == null) || (!value.equals(getTreasuryUpdateType())) ) {
                    setTreasuryUpdateType(((String) value));
                }
            }
            if( values.containsKey("AmountInPositionCurrency") ) {
                final Object value = values.remove("AmountInPositionCurrency");
                if( (value == null) || (!value.equals(getAmountInPositionCurrency())) ) {
                    setAmountInPositionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("PositionCurrency") ) {
                final Object value = values.remove("PositionCurrency");
                if( (value == null) || (!value.equals(getPositionCurrency())) ) {
                    setPositionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInValuationCurrency") ) {
                final Object value = values.remove("AmountInValuationCurrency");
                if( (value == null) || (!value.equals(getAmountInValuationCurrency())) ) {
                    setAmountInValuationCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationCurrency") ) {
                final Object value = values.remove("ValuationCurrency");
                if( (value == null) || (!value.equals(getValuationCurrency())) ) {
                    setValuationCurrency(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionLedgerDate") ) {
                final Object value = values.remove("TreasuryPositionLedgerDate");
                if( (value == null) || (!value.equals(getTreasuryPositionLedgerDate())) ) {
                    setTreasuryPositionLedgerDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TreasuryPositionTransferGroup") ) {
                final Object value = values.remove("TreasuryPositionTransferGroup");
                if( (value == null) || (!value.equals(getTreasuryPositionTransferGroup())) ) {
                    setTreasuryPositionTransferGroup(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionTransferFactor") ) {
                final Object value = values.remove("TreasuryPositionTransferFactor");
                if( (value == null) || (!value.equals(getTreasuryPositionTransferFactor())) ) {
                    setTreasuryPositionTransferFactor(((Double) value));
                }
            }
            if( values.containsKey("TrsyPosQuantityChangeCategory") ) {
                final Object value = values.remove("TrsyPosQuantityChangeCategory");
                if( (value == null) || (!value.equals(getTrsyPosQuantityChangeCategory())) ) {
                    setTrsyPosQuantityChangeCategory(((String) value));
                }
            }
            if( values.containsKey("TrsyPosAmountChangeCategory") ) {
                final Object value = values.remove("TrsyPosAmountChangeCategory");
                if( (value == null) || (!value.equals(getTrsyPosAmountChangeCategory())) ) {
                    setTrsyPosAmountChangeCategory(((String) value));
                }
            }
            if( values.containsKey("QuantityInPieces") ) {
                final Object value = values.remove("QuantityInPieces");
                if( (value == null) || (!value.equals(getQuantityInPieces())) ) {
                    setQuantityInPieces(((BigDecimal) value));
                }
            }
            if( values.containsKey("IndexCleanAmountInPositionCrcy") ) {
                final Object value = values.remove("IndexCleanAmountInPositionCrcy");
                if( (value == null) || (!value.equals(getIndexCleanAmountInPositionCrcy())) ) {
                    setIndexCleanAmountInPositionCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("NominalAmountInNominalCurrency") ) {
                final Object value = values.remove("NominalAmountInNominalCurrency");
                if( (value == null) || (!value.equals(getNominalAmountInNominalCurrency())) ) {
                    setNominalAmountInNominalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("OriglNominalAmtInNominalCrcy") ) {
                final Object value = values.remove("OriglNominalAmtInNominalCrcy");
                if( (value == null) || (!value.equals(getOriglNominalAmtInNominalCrcy())) ) {
                    setOriglNominalAmtInNominalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("NominalCurrency") ) {
                final Object value = values.remove("NominalCurrency");
                if( (value == null) || (!value.equals(getNominalCurrency())) ) {
                    setNominalCurrency(((String) value));
                }
            }
            if( values.containsKey("CalculationDate") ) {
                final Object value = values.remove("CalculationDate");
                if( (value == null) || (!value.equals(getCalculationDate())) ) {
                    setCalculationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CalcDateIsAsEndDateInclusive") ) {
                final Object value = values.remove("CalcDateIsAsEndDateInclusive");
                if( (value == null) || (!value.equals(getCalcDateIsAsEndDateInclusive())) ) {
                    setCalcDateIsAsEndDateInclusive(((String) value));
                }
            }
            if( values.containsKey("DueDate") ) {
                final Object value = values.remove("DueDate");
                if( (value == null) || (!value.equals(getDueDate())) ) {
                    setDueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CalculationPeriodStartDate") ) {
                final Object value = values.remove("CalculationPeriodStartDate");
                if( (value == null) || (!value.equals(getCalculationPeriodStartDate())) ) {
                    setCalculationPeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CalculationPeriodEndDate") ) {
                final Object value = values.remove("CalculationPeriodEndDate");
                if( (value == null) || (!value.equals(getCalculationPeriodEndDate())) ) {
                    setCalculationPeriodEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EffectiveInterestRate") ) {
                final Object value = values.remove("EffectiveInterestRate");
                if( (value == null) || (!value.equals(getEffectiveInterestRate())) ) {
                    setEffectiveInterestRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("EffctvIntrstRateRdmptnSched") ) {
                final Object value = values.remove("EffctvIntrstRateRdmptnSched");
                if( (value == null) || (!value.equals(getEffctvIntrstRateRdmptnSched())) ) {
                    setEffctvIntrstRateRdmptnSched(((Integer) value));
                }
            }
            if( values.containsKey("NextEffectiveInterestRate") ) {
                final Object value = values.remove("NextEffectiveInterestRate");
                if( (value == null) || (!value.equals(getNextEffectiveInterestRate())) ) {
                    setNextEffectiveInterestRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedRedemptionSchedule") ) {
                final Object value = values.remove("FixedRedemptionSchedule");
                if( (value == null) || (!value.equals(getFixedRedemptionSchedule())) ) {
                    setFixedRedemptionSchedule(((Integer) value));
                }
            }
            if( values.containsKey("CalculationBasis") ) {
                final Object value = values.remove("CalculationBasis");
                if( (value == null) || (!value.equals(getCalculationBasis())) ) {
                    setCalculationBasis(((BigDecimal) value));
                }
            }
            if( values.containsKey("FinInstrProductGroup") ) {
                final Object value = values.remove("FinInstrProductGroup");
                if( (value == null) || (!value.equals(getFinInstrProductGroup())) ) {
                    setFinInstrProductGroup(((String) value));
                }
            }
            if( values.containsKey("TreasuryBusinessTransStatus") ) {
                final Object value = values.remove("TreasuryBusinessTransStatus");
                if( (value == null) || (!value.equals(getTreasuryBusinessTransStatus())) ) {
                    setTreasuryBusinessTransStatus(((String) value));
                }
            }
            if( values.containsKey("TrsyIntragroupTransacStatus") ) {
                final Object value = values.remove("TrsyIntragroupTransacStatus");
                if( (value == null) || (!value.equals(getTrsyIntragroupTransacStatus())) ) {
                    setTrsyIntragroupTransacStatus(((String) value));
                }
            }
            if( values.containsKey("TreasuryBusinessTransCategory") ) {
                final Object value = values.remove("TreasuryBusinessTransCategory");
                if( (value == null) || (!value.equals(getTreasuryBusinessTransCategory())) ) {
                    setTreasuryBusinessTransCategory(((String) value));
                }
            }
            if( values.containsKey("OriglTrsyBusinessTransaction") ) {
                final Object value = values.remove("OriglTrsyBusinessTransaction");
                if( (value == null) || (!value.equals(getOriglTrsyBusinessTransaction())) ) {
                    setOriglTrsyBusinessTransaction(((UUID) value));
                }
            }
            if( values.containsKey("TrsyDerivedBusTransacIsUpdated") ) {
                final Object value = values.remove("TrsyDerivedBusTransacIsUpdated");
                if( (value == null) || (!value.equals(getTrsyDerivedBusTransacIsUpdated())) ) {
                    setTrsyDerivedBusTransacIsUpdated(((String) value));
                }
            }
            if( values.containsKey("TreasuryPosAssetLiabilityCode") ) {
                final Object value = values.remove("TreasuryPosAssetLiabilityCode");
                if( (value == null) || (!value.equals(getTreasuryPosAssetLiabilityCode())) ) {
                    setTreasuryPosAssetLiabilityCode(((String) value));
                }
            }
            if( values.containsKey("TrsyPosTransfSourceTargetCode") ) {
                final Object value = values.remove("TrsyPosTransfSourceTargetCode");
                if( (value == null) || (!value.equals(getTrsyPosTransfSourceTargetCode())) ) {
                    setTrsyPosTransfSourceTargetCode(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationArea") ) {
                final Object value = values.remove("TreasuryValuationArea");
                if( (value == null) || (!value.equals(getTreasuryValuationArea())) ) {
                    setTreasuryValuationArea(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationAreaName") ) {
                final Object value = values.remove("TreasuryValuationAreaName");
                if( (value == null) || (!value.equals(getTreasuryValuationAreaName())) ) {
                    setTreasuryValuationAreaName(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationClass") ) {
                final Object value = values.remove("TreasuryValuationClass");
                if( (value == null) || (!value.equals(getTreasuryValuationClass())) ) {
                    setTreasuryValuationClass(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationClassName") ) {
                final Object value = values.remove("TreasuryValuationClassName");
                if( (value == null) || (!value.equals(getTreasuryValuationClassName())) ) {
                    setTreasuryValuationClassName(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentProductType") ) {
                final Object value = values.remove("FinancialInstrumentProductType");
                if( (value == null) || (!value.equals(getFinancialInstrumentProductType())) ) {
                    setFinancialInstrumentProductType(((String) value));
                }
            }
            if( values.containsKey("SecurityAccount") ) {
                final Object value = values.remove("SecurityAccount");
                if( (value == null) || (!value.equals(getSecurityAccount())) ) {
                    setSecurityAccount(((String) value));
                }
            }
            if( values.containsKey("SecurityClass") ) {
                final Object value = values.remove("SecurityClass");
                if( (value == null) || (!value.equals(getSecurityClass())) ) {
                    setSecurityClass(((String) value));
                }
            }
            if( values.containsKey("SecurityClassName") ) {
                final Object value = values.remove("SecurityClassName");
                if( (value == null) || (!value.equals(getSecurityClassName())) ) {
                    setSecurityClassName(((String) value));
                }
            }
            if( values.containsKey("SecurityClassDescription") ) {
                final Object value = values.remove("SecurityClassDescription");
                if( (value == null) || (!value.equals(getSecurityClassDescription())) ) {
                    setSecurityClassDescription(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrValClassName") ) {
                final Object value = values.remove("FinancialInstrValClassName");
                if( (value == null) || (!value.equals(getFinancialInstrValClassName())) ) {
                    setFinancialInstrValClassName(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionLot") ) {
                final Object value = values.remove("TreasuryPositionLot");
                if( (value == null) || (!value.equals(getTreasuryPositionLot())) ) {
                    setTreasuryPositionLot(((UUID) value));
                }
            }
            if( values.containsKey("SecurityAccountGroup") ) {
                final Object value = values.remove("SecurityAccountGroup");
                if( (value == null) || (!value.equals(getSecurityAccountGroup())) ) {
                    setSecurityAccountGroup(((String) value));
                }
            }
            if( values.containsKey("LoanContract") ) {
                final Object value = values.remove("LoanContract");
                if( (value == null) || (!value.equals(getLoanContract())) ) {
                    setLoanContract(((String) value));
                }
            }
            if( values.containsKey("LoanContractName") ) {
                final Object value = values.remove("LoanContractName");
                if( (value == null) || (!value.equals(getLoanContractName())) ) {
                    setLoanContractName(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionAccount") ) {
                final Object value = values.remove("TreasuryPositionAccount");
                if( (value == null) || (!value.equals(getTreasuryPositionAccount())) ) {
                    setTreasuryPositionAccount(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionLongShortCode") ) {
                final Object value = values.remove("TreasuryPositionLongShortCode");
                if( (value == null) || (!value.equals(getTreasuryPositionLongShortCode())) ) {
                    setTreasuryPositionLongShortCode(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("WBSDescription") ) {
                final Object value = values.remove("WBSDescription");
                if( (value == null) || (!value.equals(getWBSDescription())) ) {
                    setWBSDescription(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm1") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm1");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm1())) ) {
                    setTrsyPosCustomDiffntnTerm1(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm1Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm1Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm1Name())) ) {
                    setTrsyPosCustomDiffntnTerm1Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm2") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm2");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm2())) ) {
                    setTrsyPosCustomDiffntnTerm2(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm2Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm2Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm2Name())) ) {
                    setTrsyPosCustomDiffntnTerm2Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm3") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm3");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm3())) ) {
                    setTrsyPosCustomDiffntnTerm3(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm3Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm3Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm3Name())) ) {
                    setTrsyPosCustomDiffntnTerm3Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm4") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm4");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm4())) ) {
                    setTrsyPosCustomDiffntnTerm4(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm4Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm4Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm4Name())) ) {
                    setTrsyPosCustomDiffntnTerm4Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm5") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm5");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm5())) ) {
                    setTrsyPosCustomDiffntnTerm5(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm5Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm5Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm5Name())) ) {
                    setTrsyPosCustomDiffntnTerm5Name(((String) value));
                }
            }
            if( values.containsKey("CentralClearingAccount") ) {
                final Object value = values.remove("CentralClearingAccount");
                if( (value == null) || (!value.equals(getCentralClearingAccount())) ) {
                    setCentralClearingAccount(((String) value));
                }
            }
            if( values.containsKey("CentralClearingAccountName") ) {
                final Object value = values.remove("CentralClearingAccountName");
                if( (value == null) || (!value.equals(getCentralClearingAccountName())) ) {
                    setCentralClearingAccountName(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("SecurityAccountName") ) {
                final Object value = values.remove("SecurityAccountName");
                if( (value == null) || (!value.equals(getSecurityAccountName())) ) {
                    setSecurityAccountName(((String) value));
                }
            }
            if( values.containsKey("SecurityAccountGroupName") ) {
                final Object value = values.remove("SecurityAccountGroupName");
                if( (value == null) || (!value.equals(getSecurityAccountGroupName())) ) {
                    setSecurityAccountGroupName(((String) value));
                }
            }
            if( values.containsKey("ActivityFinancialTransaction") ) {
                final Object value = values.remove("ActivityFinancialTransaction");
                if( (value == null) || (!value.equals(getActivityFinancialTransaction())) ) {
                    setActivityFinancialTransaction(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrTransactionType") ) {
                final Object value = values.remove("FinancialInstrTransactionType");
                if( (value == null) || (!value.equals(getFinancialInstrTransactionType())) ) {
                    setFinancialInstrTransactionType(((String) value));
                }
            }
            if( values.containsKey("TreasuryFacilityCompanyCode") ) {
                final Object value = values.remove("TreasuryFacilityCompanyCode");
                if( (value == null) || (!value.equals(getTreasuryFacilityCompanyCode())) ) {
                    setTreasuryFacilityCompanyCode(((String) value));
                }
            }
            if( values.containsKey("TreasuryFacility") ) {
                final Object value = values.remove("TreasuryFacility");
                if( (value == null) || (!value.equals(getTreasuryFacility())) ) {
                    setTreasuryFacility(((String) value));
                }
            }
            if( values.containsKey("TreasuryMasterAgreement") ) {
                final Object value = values.remove("TreasuryMasterAgreement");
                if( (value == null) || (!value.equals(getTreasuryMasterAgreement())) ) {
                    setTreasuryMasterAgreement(((String) value));
                }
            }
            if( values.containsKey("TreasuryFinanceProject") ) {
                final Object value = values.remove("TreasuryFinanceProject");
                if( (value == null) || (!value.equals(getTreasuryFinanceProject())) ) {
                    setTreasuryFinanceProject(((String) value));
                }
            }
            if( values.containsKey("Counterparty") ) {
                final Object value = values.remove("Counterparty");
                if( (value == null) || (!value.equals(getCounterparty())) ) {
                    setCounterparty(((String) value));
                }
            }
            if( values.containsKey("LetterOfCredit") ) {
                final Object value = values.remove("LetterOfCredit");
                if( (value == null) || (!value.equals(getLetterOfCredit())) ) {
                    setLetterOfCredit(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentStatus") ) {
                final Object value = values.remove("FinancialInstrumentStatus");
                if( (value == null) || (!value.equals(getFinancialInstrumentStatus())) ) {
                    setFinancialInstrumentStatus(((String) value));
                }
            }
            if( values.containsKey("Portfolio") ) {
                final Object value = values.remove("Portfolio");
                if( (value == null) || (!value.equals(getPortfolio())) ) {
                    setPortfolio(((String) value));
                }
            }
            if( values.containsKey("PortfolioName") ) {
                final Object value = values.remove("PortfolioName");
                if( (value == null) || (!value.equals(getPortfolioName())) ) {
                    setPortfolioName(((String) value));
                }
            }
            if( values.containsKey("Issuer") ) {
                final Object value = values.remove("Issuer");
                if( (value == null) || (!value.equals(getIssuer())) ) {
                    setIssuer(((String) value));
                }
            }
            if( values.containsKey("TrsyPosQtyChangeCategoryName") ) {
                final Object value = values.remove("TrsyPosQtyChangeCategoryName");
                if( (value == null) || (!value.equals(getTrsyPosQtyChangeCategoryName())) ) {
                    setTrsyPosQtyChangeCategoryName(((String) value));
                }
            }
            if( values.containsKey("TreasuryPosChangeCategoryName") ) {
                final Object value = values.remove("TreasuryPosChangeCategoryName");
                if( (value == null) || (!value.equals(getTreasuryPosChangeCategoryName())) ) {
                    setTreasuryPosChangeCategoryName(((String) value));
                }
            }
            if( values.containsKey("DifferentiationPortfolio") ) {
                final Object value = values.remove("DifferentiationPortfolio");
                if( (value == null) || (!value.equals(getDifferentiationPortfolio())) ) {
                    setDifferentiationPortfolio(((String) value));
                }
            }
            if( values.containsKey("DifferentiationPortfolioName") ) {
                final Object value = values.remove("DifferentiationPortfolioName");
                if( (value == null) || (!value.equals(getDifferentiationPortfolioName())) ) {
                    setDifferentiationPortfolioName(((String) value));
                }
            }
            if( values.containsKey("FinancialTransaction") ) {
                final Object value = values.remove("FinancialTransaction");
                if( (value == null) || (!value.equals(getFinancialTransaction())) ) {
                    setFinancialTransaction(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrActivityCategory") ) {
                final Object value = values.remove("FinancialInstrActivityCategory");
                if( (value == null) || (!value.equals(getFinancialInstrActivityCategory())) ) {
                    setFinancialInstrActivityCategory(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrCharacteristic") ) {
                final Object value = values.remove("FinancialInstrCharacteristic");
                if( (value == null) || (!value.equals(getFinancialInstrCharacteristic())) ) {
                    setFinancialInstrCharacteristic(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentReference") ) {
                final Object value = values.remove("FinancialInstrumentReference");
                if( (value == null) || (!value.equals(getFinancialInstrumentReference())) ) {
                    setFinancialInstrumentReference(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentAssignment") ) {
                final Object value = values.remove("FinancialInstrumentAssignment");
                if( (value == null) || (!value.equals(getFinancialInstrumentAssignment())) ) {
                    setFinancialInstrumentAssignment(((String) value));
                }
            }
            if( values.containsKey("ConditionItemValidityStartDate") ) {
                final Object value = values.remove("ConditionItemValidityStartDate");
                if( (value == null) || (!value.equals(getConditionItemValidityStartDate())) ) {
                    setConditionItemValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CalcPeriodEndDateIsInclusive") ) {
                final Object value = values.remove("CalcPeriodEndDateIsInclusive");
                if( (value == null) || (!value.equals(getCalcPeriodEndDateIsInclusive())) ) {
                    setCalcPeriodEndDateIsInclusive(((String) value));
                }
            }
            if( values.containsKey("InterestCalculationMethod") ) {
                final Object value = values.remove("InterestCalculationMethod");
                if( (value == null) || (!value.equals(getInterestCalculationMethod())) ) {
                    setInterestCalculationMethod(((String) value));
                }
            }
            if( values.containsKey("DebitGLAccount") ) {
                final Object value = values.remove("DebitGLAccount");
                if( (value == null) || (!value.equals(getDebitGLAccount())) ) {
                    setDebitGLAccount(((String) value));
                }
            }
            if( values.containsKey("CreditGLAccount") ) {
                final Object value = values.remove("CreditGLAccount");
                if( (value == null) || (!value.equals(getCreditGLAccount())) ) {
                    setCreditGLAccount(((String) value));
                }
            }
            if( values.containsKey("DebitCustomer") ) {
                final Object value = values.remove("DebitCustomer");
                if( (value == null) || (!value.equals(getDebitCustomer())) ) {
                    setDebitCustomer(((String) value));
                }
            }
            if( values.containsKey("CreditCustomer") ) {
                final Object value = values.remove("CreditCustomer");
                if( (value == null) || (!value.equals(getCreditCustomer())) ) {
                    setCreditCustomer(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TreasuryGLAccountAssignmentRef") ) {
                final Object value = values.remove("TreasuryGLAccountAssignmentRef");
                if( (value == null) || (!value.equals(getTreasuryGLAccountAssignmentRef())) ) {
                    setTreasuryGLAccountAssignmentRef(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentContext") ) {
                final Object value = values.remove("ReferenceDocumentContext");
                if( (value == null) || (!value.equals(getReferenceDocumentContext())) ) {
                    setReferenceDocumentContext(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentFiscalYear") ) {
                final Object value = values.remove("ReverseDocumentFiscalYear");
                if( (value == null) || (!value.equals(getReverseDocumentFiscalYear())) ) {
                    setReverseDocumentFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentFiscalPeriod") ) {
                final Object value = values.remove("ReverseDocumentFiscalPeriod");
                if( (value == null) || (!value.equals(getReverseDocumentFiscalPeriod())) ) {
                    setReverseDocumentFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentPostingDate") ) {
                final Object value = values.remove("ReverseDocumentPostingDate");
                if( (value == null) || (!value.equals(getReverseDocumentPostingDate())) ) {
                    setReverseDocumentPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocument") ) {
                final Object value = values.remove("ReversalReferenceDocument");
                if( (value == null) || (!value.equals(getReversalReferenceDocument())) ) {
                    setReversalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocumentCntxt") ) {
                final Object value = values.remove("ReversalReferenceDocumentCntxt");
                if( (value == null) || (!value.equals(getReversalReferenceDocumentCntxt())) ) {
                    setReversalReferenceDocumentCntxt(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("ReverseDocument") ) {
                final Object value = values.remove("ReverseDocument");
                if( (value == null) || (!value.equals(getReverseDocument())) ) {
                    setReverseDocument(((String) value));
                }
            }
            if( values.containsKey("FinancialExposureItem") ) {
                final Object value = values.remove("FinancialExposureItem");
                if( (value == null) || (!value.equals(getFinancialExposureItem())) ) {
                    setFinancialExposureItem(((String) value));
                }
            }
            if( values.containsKey("FinancialExposureSubItem") ) {
                final Object value = values.remove("FinancialExposureSubItem");
                if( (value == null) || (!value.equals(getFinancialExposureSubItem())) ) {
                    setFinancialExposureSubItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> TrsyPosFlowField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TrsyPosFlowField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TrsyPosFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TrsyPosFlowField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService.DEFAULT_SERVICE_PATH);
    }

}
