/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.selectable.TrsyPosFlowSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow TrsyPosFlow} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class TrsyPosFlowByKeyFluentHelper
    extends
    FluentHelperByKey<TrsyPosFlowByKeyFluentHelper, TrsyPosFlow, TrsyPosFlowSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow TrsyPosFlow} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code TrsyPosFlow}
     * @param businessTransactionDocUUID
     *            Business Transaction (GUID)
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code TrsyPosFlow}
     * @param treasuryTransactionFlow
     *            Number of TRL Flow
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public TrsyPosFlowByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final Integer treasuryTransactionFlow,
        final UUID businessTransactionDocUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("TreasuryTransactionFlow", treasuryTransactionFlow);
        this.key.put("BusinessTransactionDocUUID", businessTransactionDocUUID);
    }

    @Override
    @Nonnull
    protected Class<TrsyPosFlow> getEntityClass()
    {
        return TrsyPosFlow.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
