/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link TreasuryPositionFlowServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService TreasuryPositionFlowService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultTreasuryPositionFlowServiceBatch
    extends
    BatchFluentHelperBasic<TreasuryPositionFlowServiceBatch, TreasuryPositionFlowServiceBatchChangeSet>
    implements
    TreasuryPositionFlowServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultTreasuryPositionFlowServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultTreasuryPositionFlowServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultTreasuryPositionFlowServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultTreasuryPositionFlowServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultTreasuryPositionFlowServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public TreasuryPositionFlowServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultTreasuryPositionFlowServiceBatchChangeSet(this, service);
    }

}
