/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link TreasuryPositionFlowServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService TreasuryPositionFlowService}.
 *
 */
public class DefaultTreasuryPositionFlowServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<TreasuryPositionFlowServiceBatch, TreasuryPositionFlowServiceBatchChangeSet>
    implements
    TreasuryPositionFlowServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService service;

    @SuppressWarnings( "deprecation" )
    DefaultTreasuryPositionFlowServiceBatchChangeSet(
        @Nonnull final DefaultTreasuryPositionFlowServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TreasuryPositionFlowService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultTreasuryPositionFlowServiceBatchChangeSet getThis()
    {
        return this;
    }

}
