/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow TrsyPosFlow}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.field.TrsyPosFlowField
 * TrsyPosFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.link.TrsyPosFlowLink
 * TrsyPosFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_TRANSACTION_FLOW
 * TREASURY_TRANSACTION_FLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#BUSINESS_TRANSACTION_DOC_UUID
 * BUSINESS_TRANSACTION_DOC_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION
 * TREASURY_POSITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_BUSINESS_TRANSACTION
 * TREASURY_BUSINESS_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_UPDATE_TYPE_NAME
 * TREASURY_UPDATE_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_UPDATE_TYPE
 * TREASURY_UPDATE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#AMOUNT_IN_POSITION_CURRENCY
 * AMOUNT_IN_POSITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#POSITION_CURRENCY
 * POSITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#AMOUNT_IN_VALUATION_CURRENCY
 * AMOUNT_IN_VALUATION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#VALUATION_CURRENCY
 * VALUATION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION_LEDGER_DATE
 * TREASURY_POSITION_LEDGER_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION_TRANSFER_GROUP
 * TREASURY_POSITION_TRANSFER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION_TRANSFER_FACTOR
 * TREASURY_POSITION_TRANSFER_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_QUANTITY_CHANGE_CATEGORY
 * TRSY_POS_QUANTITY_CHANGE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_AMOUNT_CHANGE_CATEGORY
 * TRSY_POS_AMOUNT_CHANGE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#QUANTITY_IN_PIECES
 * QUANTITY_IN_PIECES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#INDEX_CLEAN_AMOUNT_IN_POSITION_CRCY
 * INDEX_CLEAN_AMOUNT_IN_POSITION_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#NOMINAL_AMOUNT_IN_NOMINAL_CURRENCY
 * NOMINAL_AMOUNT_IN_NOMINAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#ORIGL_NOMINAL_AMT_IN_NOMINAL_CRCY
 * ORIGL_NOMINAL_AMT_IN_NOMINAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#NOMINAL_CURRENCY
 * NOMINAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CALCULATION_DATE
 * CALCULATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CALC_DATE_IS_AS_END_DATE_INCLUSIVE
 * CALC_DATE_IS_AS_END_DATE_INCLUSIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#DUE_DATE
 * DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CALCULATION_PERIOD_START_DATE
 * CALCULATION_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CALCULATION_PERIOD_END_DATE
 * CALCULATION_PERIOD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#EFFECTIVE_INTEREST_RATE
 * EFFECTIVE_INTEREST_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#EFFCTV_INTRST_RATE_RDMPTN_SCHED
 * EFFCTV_INTRST_RATE_RDMPTN_SCHED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#NEXT_EFFECTIVE_INTEREST_RATE
 * NEXT_EFFECTIVE_INTEREST_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FIXED_REDEMPTION_SCHEDULE
 * FIXED_REDEMPTION_SCHEDULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CALCULATION_BASIS
 * CALCULATION_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FIN_INSTR_PRODUCT_GROUP
 * FIN_INSTR_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_BUSINESS_TRANS_STATUS
 * TREASURY_BUSINESS_TRANS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_INTRAGROUP_TRANSAC_STATUS
 * TRSY_INTRAGROUP_TRANSAC_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_BUSINESS_TRANS_CATEGORY
 * TREASURY_BUSINESS_TRANS_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#ORIGL_TRSY_BUSINESS_TRANSACTION
 * ORIGL_TRSY_BUSINESS_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_DERIVED_BUS_TRANSAC_IS_UPDATED
 * TRSY_DERIVED_BUS_TRANSAC_IS_UPDATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POS_ASSET_LIABILITY_CODE
 * TREASURY_POS_ASSET_LIABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_TRANSF_SOURCE_TARGET_CODE
 * TRSY_POS_TRANSF_SOURCE_TARGET_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_VALUATION_AREA
 * TREASURY_VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_VALUATION_AREA_NAME
 * TREASURY_VALUATION_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_VALUATION_CLASS
 * TREASURY_VALUATION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_VALUATION_CLASS_NAME
 * TREASURY_VALUATION_CLASS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTRUMENT_PRODUCT_TYPE
 * FINANCIAL_INSTRUMENT_PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_ACCOUNT
 * SECURITY_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_CLASS
 * SECURITY_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_CLASS_NAME
 * SECURITY_CLASS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_CLASS_DESCRIPTION
 * SECURITY_CLASS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTR_VAL_CLASS_NAME
 * FINANCIAL_INSTR_VAL_CLASS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION_LOT
 * TREASURY_POSITION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_ACCOUNT_GROUP
 * SECURITY_ACCOUNT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#LOAN_CONTRACT
 * LOAN_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#LOAN_CONTRACT_NAME
 * LOAN_CONTRACT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION_ACCOUNT
 * TREASURY_POSITION_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POSITION_LONG_SHORT_CODE
 * TREASURY_POSITION_LONG_SHORT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#WBS_DESCRIPTION
 * WBS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM1
 * TRSY_POS_CUSTOM_DIFFNTN_TERM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM1_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM1_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM2
 * TRSY_POS_CUSTOM_DIFFNTN_TERM2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM2_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM2_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM3
 * TRSY_POS_CUSTOM_DIFFNTN_TERM3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM3_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM3_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM4
 * TRSY_POS_CUSTOM_DIFFNTN_TERM4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM4_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM4_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM5
 * TRSY_POS_CUSTOM_DIFFNTN_TERM5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_CUSTOM_DIFFNTN_TERM5_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM5_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CENTRAL_CLEARING_ACCOUNT
 * CENTRAL_CLEARING_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CENTRAL_CLEARING_ACCOUNT_NAME
 * CENTRAL_CLEARING_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_ACCOUNT_NAME
 * SECURITY_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#SECURITY_ACCOUNT_GROUP_NAME
 * SECURITY_ACCOUNT_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#ACTIVITY_FINANCIAL_TRANSACTION
 * ACTIVITY_FINANCIAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTR_TRANSACTION_TYPE
 * FINANCIAL_INSTR_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_FACILITY_COMPANY_CODE
 * TREASURY_FACILITY_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_FACILITY
 * TREASURY_FACILITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_MASTER_AGREEMENT
 * TREASURY_MASTER_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_FINANCE_PROJECT
 * TREASURY_FINANCE_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#COUNTERPARTY
 * COUNTERPARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#LETTER_OF_CREDIT
 * LETTER_OF_CREDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTRUMENT_STATUS
 * FINANCIAL_INSTRUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#PORTFOLIO
 * PORTFOLIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#PORTFOLIO_NAME
 * PORTFOLIO_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#ISSUER ISSUER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TRSY_POS_QTY_CHANGE_CATEGORY_NAME
 * TRSY_POS_QTY_CHANGE_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_POS_CHANGE_CATEGORY_NAME
 * TREASURY_POS_CHANGE_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#DIFFERENTIATION_PORTFOLIO
 * DIFFERENTIATION_PORTFOLIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#DIFFERENTIATION_PORTFOLIO_NAME
 * DIFFERENTIATION_PORTFOLIO_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_TRANSACTION
 * FINANCIAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTR_ACTIVITY_CATEGORY
 * FINANCIAL_INSTR_ACTIVITY_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTR_CHARACTERISTIC
 * FINANCIAL_INSTR_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTRUMENT_REFERENCE
 * FINANCIAL_INSTRUMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_INSTRUMENT_ASSIGNMENT
 * FINANCIAL_INSTRUMENT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CONDITION_ITEM_VALIDITY_START_DATE
 * CONDITION_ITEM_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CALC_PERIOD_END_DATE_IS_INCLUSIVE
 * CALC_PERIOD_END_DATE_IS_INCLUSIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#INTEREST_CALCULATION_METHOD
 * INTEREST_CALCULATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#DEBIT_GL_ACCOUNT
 * DEBIT_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CREDIT_GL_ACCOUNT
 * CREDIT_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#DEBIT_CUSTOMER
 * DEBIT_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#CREDIT_CUSTOMER
 * CREDIT_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#TREASURY_GL_ACCOUNT_ASSIGNMENT_REF
 * TREASURY_GL_ACCOUNT_ASSIGNMENT_REF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REFERENCE_DOCUMENT_CONTEXT
 * REFERENCE_DOCUMENT_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REVERSE_DOCUMENT_FISCAL_YEAR
 * REVERSE_DOCUMENT_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REVERSE_DOCUMENT_FISCAL_PERIOD
 * REVERSE_DOCUMENT_FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REVERSE_DOCUMENT_POSTING_DATE
 * REVERSE_DOCUMENT_POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REVERSAL_REFERENCE_DOCUMENT
 * REVERSAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REVERSAL_REFERENCE_DOCUMENT_CNTXT
 * REVERSAL_REFERENCE_DOCUMENT_CNTXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#REVERSE_DOCUMENT
 * REVERSE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_EXPOSURE_ITEM
 * FINANCIAL_EXPOSURE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow#FINANCIAL_EXPOSURE_SUB_ITEM
 * FINANCIAL_EXPOSURE_SUB_ITEM}</li>
 * </ul>
 *
 */
public interface TrsyPosFlowSelectable extends EntitySelectable<TrsyPosFlow>
{

}
