/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AccountingDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.AccountingDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Journal Entry Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AccountingDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AccountingDocument extends VdmEntity<AccountingDocument>
{

    /**
     * Selector for all available fields of AccountingDocument.
     *
     */
    public final static AccountingDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType_ID</b>
     * </p>
     *
     * @return Journal Entry Type
     */
    @Key
    @SerializedName( "AccountingDocumentType_ID" )
    @JsonProperty( "AccountingDocumentType_ID" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType_ID" )
    private String accountingDocumentType_ID;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType_ID</b> field to query operations.
     *
     */
    public final static AccountingDocumentField<String> ACCOUNTING_DOCUMENT_TYPE_ID =
        new AccountingDocumentField<String>("AccountingDocumentType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeText</b>
     * </p>
     *
     * @return Journal Entry Type (Description)
     */
    @SerializedName( "AccountingDocumentTypeText" )
    @JsonProperty( "AccountingDocumentTypeText" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentTypeText" )
    private String accountingDocumentTypeText;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentTypeText</b> field to query operations.
     *
     */
    public final static AccountingDocumentField<String> ACCOUNTING_DOCUMENT_TYPE_TEXT =
        new AccountingDocumentField<String>("AccountingDocumentTypeText");

    @Nonnull
    @Override
    public Class<AccountingDocument> getType()
    {
        return AccountingDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType_ID</b>
     * </p>
     *
     * @param accountingDocumentType_ID
     *            Journal Entry Type
     */
    public void setAccountingDocumentType_ID( @Nullable final String accountingDocumentType_ID )
    {
        rememberChangedField("AccountingDocumentType_ID", this.accountingDocumentType_ID);
        this.accountingDocumentType_ID = accountingDocumentType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeText</b>
     * </p>
     *
     * @param accountingDocumentTypeText
     *            Journal Entry Type (Description)
     */
    public void setAccountingDocumentTypeText( @Nullable final String accountingDocumentTypeText )
    {
        rememberChangedField("AccountingDocumentTypeText", this.accountingDocumentTypeText);
        this.accountingDocumentTypeText = accountingDocumentTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AccountingDocumentType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AccountingDocumentType_ID", getAccountingDocumentType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AccountingDocumentType_ID", getAccountingDocumentType_ID());
        values.put("AccountingDocumentTypeText", getAccountingDocumentTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AccountingDocumentType_ID") ) {
                final Object value = values.remove("AccountingDocumentType_ID");
                if( (value == null) || (!value.equals(getAccountingDocumentType_ID())) ) {
                    setAccountingDocumentType_ID(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentTypeText") ) {
                final Object value = values.remove("AccountingDocumentTypeText");
                if( (value == null) || (!value.equals(getAccountingDocumentTypeText())) ) {
                    setAccountingDocumentTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> AccountingDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AccountingDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AccountingDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AccountingDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
