/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AccountingDocumentCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.AccountingDocumentCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Journal Entry Category (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AccountingDocumentCategory</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AccountingDocumentCategory extends VdmEntity<AccountingDocumentCategory>
{

    /**
     * Selector for all available fields of AccountingDocumentCategory.
     *
     */
    public final static AccountingDocumentCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory_ID</b>
     * </p>
     *
     * @return Journal Entry Category
     */
    @Key
    @SerializedName( "AccountingDocumentCategory_ID" )
    @JsonProperty( "AccountingDocumentCategory_ID" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategory_ID" )
    private String accountingDocumentCategory_ID;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategory_ID</b> field to query operations.
     *
     */
    public final static AccountingDocumentCategoryField<String> ACCOUNTING_DOCUMENT_CATEGORY_ID =
        new AccountingDocumentCategoryField<String>("AccountingDocumentCategory_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategoryText</b>
     * </p>
     *
     * @return Journal Entry Category (Description)
     */
    @SerializedName( "AccountingDocumentCategoryText" )
    @JsonProperty( "AccountingDocumentCategoryText" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategoryText" )
    private String accountingDocumentCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategoryText</b> field to query operations.
     *
     */
    public final static AccountingDocumentCategoryField<String> ACCOUNTING_DOCUMENT_CATEGORY_TEXT =
        new AccountingDocumentCategoryField<String>("AccountingDocumentCategoryText");

    @Nonnull
    @Override
    public Class<AccountingDocumentCategory> getType()
    {
        return AccountingDocumentCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory_ID</b>
     * </p>
     *
     * @param accountingDocumentCategory_ID
     *            Journal Entry Category
     */
    public void setAccountingDocumentCategory_ID( @Nullable final String accountingDocumentCategory_ID )
    {
        rememberChangedField("AccountingDocumentCategory_ID", this.accountingDocumentCategory_ID);
        this.accountingDocumentCategory_ID = accountingDocumentCategory_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategoryText</b>
     * </p>
     *
     * @param accountingDocumentCategoryText
     *            Journal Entry Category (Description)
     */
    public void setAccountingDocumentCategoryText( @Nullable final String accountingDocumentCategoryText )
    {
        rememberChangedField("AccountingDocumentCategoryText", this.accountingDocumentCategoryText);
        this.accountingDocumentCategoryText = accountingDocumentCategoryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AccountingDocumentCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AccountingDocumentCategory_ID", getAccountingDocumentCategory_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AccountingDocumentCategory_ID", getAccountingDocumentCategory_ID());
        values.put("AccountingDocumentCategoryText", getAccountingDocumentCategoryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AccountingDocumentCategory_ID") ) {
                final Object value = values.remove("AccountingDocumentCategory_ID");
                if( (value == null) || (!value.equals(getAccountingDocumentCategory_ID())) ) {
                    setAccountingDocumentCategory_ID(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCategoryText") ) {
                final Object value = values.remove("AccountingDocumentCategoryText");
                if( (value == null) || (!value.equals(getAccountingDocumentCategoryText())) ) {
                    setAccountingDocumentCategoryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> AccountingDocumentCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new AccountingDocumentCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AccountingDocumentCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AccountingDocumentCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
