/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AlternativeGLAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.AlternativeGLAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Alternative G/L Account (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AlternativeGLAccount</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AlternativeGLAccount extends VdmEntity<AlternativeGLAccount>
{

    /**
     * Selector for all available fields of AlternativeGLAccount.
     *
     */
    public final static AlternativeGLAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount_ID</b>
     * </p>
     *
     * @return Alternative G/L Account
     */
    @Key
    @SerializedName( "AlternativeGLAccount_ID" )
    @JsonProperty( "AlternativeGLAccount_ID" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount_ID" )
    private String alternativeGLAccount_ID;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount_ID</b> field to query operations.
     *
     */
    public final static AlternativeGLAccountField<String> ALTERNATIVE_GL_ACCOUNT_ID =
        new AlternativeGLAccountField<String>("AlternativeGLAccount_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccountText</b>
     * </p>
     *
     * @return Alternative G/L Account (Description)
     */
    @SerializedName( "AlternativeGLAccountText" )
    @JsonProperty( "AlternativeGLAccountText" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccountText" )
    private String alternativeGLAccountText;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccountText</b> field to query operations.
     *
     */
    public final static AlternativeGLAccountField<String> ALTERNATIVE_GL_ACCOUNT_TEXT =
        new AlternativeGLAccountField<String>("AlternativeGLAccountText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @return Alternative G/L Account (Alternative Chart of Accounts)
     */
    @Key
    @SerializedName( "CountryChartOfAccounts" )
    @JsonProperty( "CountryChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccounts" )
    private String countryChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccounts</b> field to query operations.
     *
     */
    public final static AlternativeGLAccountField<String> COUNTRY_CHART_OF_ACCOUNTS =
        new AlternativeGLAccountField<String>("CountryChartOfAccounts");

    @Nonnull
    @Override
    public Class<AlternativeGLAccount> getType()
    {
        return AlternativeGLAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount_ID</b>
     * </p>
     *
     * @param alternativeGLAccount_ID
     *            Alternative G/L Account
     */
    public void setAlternativeGLAccount_ID( @Nullable final String alternativeGLAccount_ID )
    {
        rememberChangedField("AlternativeGLAccount_ID", this.alternativeGLAccount_ID);
        this.alternativeGLAccount_ID = alternativeGLAccount_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccountText</b>
     * </p>
     *
     * @param alternativeGLAccountText
     *            Alternative G/L Account (Description)
     */
    public void setAlternativeGLAccountText( @Nullable final String alternativeGLAccountText )
    {
        rememberChangedField("AlternativeGLAccountText", this.alternativeGLAccountText);
        this.alternativeGLAccountText = alternativeGLAccountText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @param countryChartOfAccounts
     *            Alternative G/L Account (Alternative Chart of Accounts)
     */
    public void setCountryChartOfAccounts( @Nullable final String countryChartOfAccounts )
    {
        rememberChangedField("CountryChartOfAccounts", this.countryChartOfAccounts);
        this.countryChartOfAccounts = countryChartOfAccounts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AlternativeGLAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AlternativeGLAccount_ID", getAlternativeGLAccount_ID());
        result.put("CountryChartOfAccounts", getCountryChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AlternativeGLAccount_ID", getAlternativeGLAccount_ID());
        values.put("AlternativeGLAccountText", getAlternativeGLAccountText());
        values.put("CountryChartOfAccounts", getCountryChartOfAccounts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AlternativeGLAccount_ID") ) {
                final Object value = values.remove("AlternativeGLAccount_ID");
                if( (value == null) || (!value.equals(getAlternativeGLAccount_ID())) ) {
                    setAlternativeGLAccount_ID(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccountText") ) {
                final Object value = values.remove("AlternativeGLAccountText");
                if( (value == null) || (!value.equals(getAlternativeGLAccountText())) ) {
                    setAlternativeGLAccountText(((String) value));
                }
            }
            if( values.containsKey("CountryChartOfAccounts") ) {
                final Object value = values.remove("CountryChartOfAccounts");
                if( (value == null) || (!value.equals(getCountryChartOfAccounts())) ) {
                    setCountryChartOfAccounts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> AlternativeGLAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AlternativeGLAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AlternativeGLAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AlternativeGLAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
