/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AssetTransactionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.AssetTransactionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Ast Transaction Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AssetTransactionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AssetTransaction extends VdmEntity<AssetTransaction>
{

    /**
     * Selector for all available fields of AssetTransaction.
     *
     */
    public final static AssetTransactionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType_ID</b>
     * </p>
     *
     * @return Ast Transaction Type
     */
    @Key
    @SerializedName( "AssetTransactionType_ID" )
    @JsonProperty( "AssetTransactionType_ID" )
    @Nullable
    @ODataField( odataName = "AssetTransactionType_ID" )
    private String assetTransactionType_ID;
    /**
     * Use with available fluent helpers to apply the <b>AssetTransactionType_ID</b> field to query operations.
     *
     */
    public final static AssetTransactionField<String> ASSET_TRANSACTION_TYPE_ID =
        new AssetTransactionField<String>("AssetTransactionType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionTypeText</b>
     * </p>
     *
     * @return Ast Transaction Type (Description)
     */
    @SerializedName( "AssetTransactionTypeText" )
    @JsonProperty( "AssetTransactionTypeText" )
    @Nullable
    @ODataField( odataName = "AssetTransactionTypeText" )
    private String assetTransactionTypeText;
    /**
     * Use with available fluent helpers to apply the <b>AssetTransactionTypeText</b> field to query operations.
     *
     */
    public final static AssetTransactionField<String> ASSET_TRANSACTION_TYPE_TEXT =
        new AssetTransactionField<String>("AssetTransactionTypeText");

    @Nonnull
    @Override
    public Class<AssetTransaction> getType()
    {
        return AssetTransaction.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType_ID</b>
     * </p>
     *
     * @param assetTransactionType_ID
     *            Ast Transaction Type
     */
    public void setAssetTransactionType_ID( @Nullable final String assetTransactionType_ID )
    {
        rememberChangedField("AssetTransactionType_ID", this.assetTransactionType_ID);
        this.assetTransactionType_ID = assetTransactionType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionTypeText</b>
     * </p>
     *
     * @param assetTransactionTypeText
     *            Ast Transaction Type (Description)
     */
    public void setAssetTransactionTypeText( @Nullable final String assetTransactionTypeText )
    {
        rememberChangedField("AssetTransactionTypeText", this.assetTransactionTypeText);
        this.assetTransactionTypeText = assetTransactionTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AssetTransactionType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AssetTransactionType_ID", getAssetTransactionType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AssetTransactionType_ID", getAssetTransactionType_ID());
        values.put("AssetTransactionTypeText", getAssetTransactionTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AssetTransactionType_ID") ) {
                final Object value = values.remove("AssetTransactionType_ID");
                if( (value == null) || (!value.equals(getAssetTransactionType_ID())) ) {
                    setAssetTransactionType_ID(((String) value));
                }
            }
            if( values.containsKey("AssetTransactionTypeText") ) {
                final Object value = values.remove("AssetTransactionTypeText");
                if( (value == null) || (!value.equals(getAssetTransactionTypeText())) ) {
                    setAssetTransactionTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> AssetTransactionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AssetTransactionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AssetTransactionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AssetTransactionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
