/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BalanceTransactionCurrencyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.BalanceTransactionCurrencySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Balance Transaction Currency (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BalanceTransactionCurrency</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BalanceTransactionCurrency extends VdmEntity<BalanceTransactionCurrency>
{

    /**
     * Selector for all available fields of BalanceTransactionCurrency.
     *
     */
    public final static BalanceTransactionCurrencySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency_ID</b>
     * </p>
     *
     * @return Balance Transaction Currency
     */
    @Key
    @SerializedName( "BalanceTransactionCurrency_ID" )
    @JsonProperty( "BalanceTransactionCurrency_ID" )
    @Nullable
    @ODataField( odataName = "BalanceTransactionCurrency_ID" )
    private String balanceTransactionCurrency_ID;
    /**
     * Use with available fluent helpers to apply the <b>BalanceTransactionCurrency_ID</b> field to query operations.
     *
     */
    public final static BalanceTransactionCurrencyField<String> BALANCE_TRANSACTION_CURRENCY_ID =
        new BalanceTransactionCurrencyField<String>("BalanceTransactionCurrency_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrencyText</b>
     * </p>
     *
     * @return Balance Transaction Currency (Description)
     */
    @SerializedName( "BalanceTransactionCurrencyText" )
    @JsonProperty( "BalanceTransactionCurrencyText" )
    @Nullable
    @ODataField( odataName = "BalanceTransactionCurrencyText" )
    private String balanceTransactionCurrencyText;
    /**
     * Use with available fluent helpers to apply the <b>BalanceTransactionCurrencyText</b> field to query operations.
     *
     */
    public final static BalanceTransactionCurrencyField<String> BALANCE_TRANSACTION_CURRENCY_TEXT =
        new BalanceTransactionCurrencyField<String>("BalanceTransactionCurrencyText");

    @Nonnull
    @Override
    public Class<BalanceTransactionCurrency> getType()
    {
        return BalanceTransactionCurrency.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency_ID</b>
     * </p>
     *
     * @param balanceTransactionCurrency_ID
     *            Balance Transaction Currency
     */
    public void setBalanceTransactionCurrency_ID( @Nullable final String balanceTransactionCurrency_ID )
    {
        rememberChangedField("BalanceTransactionCurrency_ID", this.balanceTransactionCurrency_ID);
        this.balanceTransactionCurrency_ID = balanceTransactionCurrency_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrencyText</b>
     * </p>
     *
     * @param balanceTransactionCurrencyText
     *            Balance Transaction Currency (Description)
     */
    public void setBalanceTransactionCurrencyText( @Nullable final String balanceTransactionCurrencyText )
    {
        rememberChangedField("BalanceTransactionCurrencyText", this.balanceTransactionCurrencyText);
        this.balanceTransactionCurrencyText = balanceTransactionCurrencyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BalanceTransactionCurrency";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BalanceTransactionCurrency_ID", getBalanceTransactionCurrency_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BalanceTransactionCurrency_ID", getBalanceTransactionCurrency_ID());
        values.put("BalanceTransactionCurrencyText", getBalanceTransactionCurrencyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BalanceTransactionCurrency_ID") ) {
                final Object value = values.remove("BalanceTransactionCurrency_ID");
                if( (value == null) || (!value.equals(getBalanceTransactionCurrency_ID())) ) {
                    setBalanceTransactionCurrency_ID(((String) value));
                }
            }
            if( values.containsKey("BalanceTransactionCurrencyText") ) {
                final Object value = values.remove("BalanceTransactionCurrencyText");
                if( (value == null) || (!value.equals(getBalanceTransactionCurrencyText())) ) {
                    setBalanceTransactionCurrencyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BalanceTransactionCurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BalanceTransactionCurrencyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BalanceTransactionCurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BalanceTransactionCurrencyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
