/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BudgetPeriodField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.BudgetPeriodSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Budget Period
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetPeriod</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetPeriod extends VdmEntity<BudgetPeriod>
{

    /**
     * Selector for all available fields of BudgetPeriod.
     *
     */
    public final static BudgetPeriodSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @Key
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<String> BUDGET_PERIOD = new BudgetPeriodField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodText</b>
     * </p>
     *
     * @return Budget Period (Description)
     */
    @SerializedName( "BudgetPeriodText" )
    @JsonProperty( "BudgetPeriodText" )
    @Nullable
    @ODataField( odataName = "BudgetPeriodText" )
    private String budgetPeriodText;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodText</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<String> BUDGET_PERIOD_TEXT =
        new BudgetPeriodField<String>("BudgetPeriodText");

    @Nonnull
    @Override
    public Class<BudgetPeriod> getType()
    {
        return BudgetPeriod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodText</b>
     * </p>
     *
     * @param budgetPeriodText
     *            Budget Period (Description)
     */
    public void setBudgetPeriodText( @Nullable final String budgetPeriodText )
    {
        rememberChangedField("BudgetPeriodText", this.budgetPeriodText);
        this.budgetPeriodText = budgetPeriodText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetPeriod";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BudgetPeriod", getBudgetPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("BudgetPeriodText", getBudgetPeriodText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriodText") ) {
                final Object value = values.remove("BudgetPeriodText");
                if( (value == null) || (!value.equals(getBudgetPeriodText())) ) {
                    setBudgetPeriodText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BudgetPeriodField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BudgetPeriodField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetPeriodField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetPeriodField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
