/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BusinessAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.BusinessAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Business Area (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusinessArea</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessArea extends VdmEntity<BusinessArea>
{

    /**
     * Selector for all available fields of BusinessArea.
     *
     */
    public final static BusinessAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_ID</b>
     * </p>
     *
     * @return Business Area
     */
    @Key
    @SerializedName( "BusinessArea_ID" )
    @JsonProperty( "BusinessArea_ID" )
    @Nullable
    @ODataField( odataName = "BusinessArea_ID" )
    private String businessArea_ID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea_ID</b> field to query operations.
     *
     */
    public final static BusinessAreaField<String> BUSINESS_AREA_ID = new BusinessAreaField<String>("BusinessArea_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaText</b>
     * </p>
     *
     * @return Business Area (Description)
     */
    @SerializedName( "BusinessAreaText" )
    @JsonProperty( "BusinessAreaText" )
    @Nullable
    @ODataField( odataName = "BusinessAreaText" )
    private String businessAreaText;
    /**
     * Use with available fluent helpers to apply the <b>BusinessAreaText</b> field to query operations.
     *
     */
    public final static BusinessAreaField<String> BUSINESS_AREA_TEXT =
        new BusinessAreaField<String>("BusinessAreaText");

    @Nonnull
    @Override
    public Class<BusinessArea> getType()
    {
        return BusinessArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_ID</b>
     * </p>
     *
     * @param businessArea_ID
     *            Business Area
     */
    public void setBusinessArea_ID( @Nullable final String businessArea_ID )
    {
        rememberChangedField("BusinessArea_ID", this.businessArea_ID);
        this.businessArea_ID = businessArea_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaText</b>
     * </p>
     *
     * @param businessAreaText
     *            Business Area (Description)
     */
    public void setBusinessAreaText( @Nullable final String businessAreaText )
    {
        rememberChangedField("BusinessAreaText", this.businessAreaText);
        this.businessAreaText = businessAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusinessArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessArea_ID", getBusinessArea_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessArea_ID", getBusinessArea_ID());
        values.put("BusinessAreaText", getBusinessAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessArea_ID") ) {
                final Object value = values.remove("BusinessArea_ID");
                if( (value == null) || (!value.equals(getBusinessArea_ID())) ) {
                    setBusinessArea_ID(((String) value));
                }
            }
            if( values.containsKey("BusinessAreaText") ) {
                final Object value = values.remove("BusinessAreaText");
                if( (value == null) || (!value.equals(getBusinessAreaText())) ) {
                    setBusinessAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusinessAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
