/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BusinessTransactionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.BusinessTransactionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Business Transaction Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusinessTransactionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessTransaction extends VdmEntity<BusinessTransaction>
{

    /**
     * Selector for all available fields of BusinessTransaction.
     *
     */
    public final static BusinessTransactionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType_ID</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @Key
    @SerializedName( "BusinessTransactionType_ID" )
    @JsonProperty( "BusinessTransactionType_ID" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionType_ID" )
    private String businessTransactionType_ID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionType_ID</b> field to query operations.
     *
     */
    public final static BusinessTransactionField<String> BUSINESS_TRANSACTION_TYPE_ID =
        new BusinessTransactionField<String>("BusinessTransactionType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionTypeText</b>
     * </p>
     *
     * @return Business Transaction Type (Description)
     */
    @SerializedName( "BusinessTransactionTypeText" )
    @JsonProperty( "BusinessTransactionTypeText" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionTypeText" )
    private String businessTransactionTypeText;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionTypeText</b> field to query operations.
     *
     */
    public final static BusinessTransactionField<String> BUSINESS_TRANSACTION_TYPE_TEXT =
        new BusinessTransactionField<String>("BusinessTransactionTypeText");

    @Nonnull
    @Override
    public Class<BusinessTransaction> getType()
    {
        return BusinessTransaction.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType_ID</b>
     * </p>
     *
     * @param businessTransactionType_ID
     *            Business Transaction Type
     */
    public void setBusinessTransactionType_ID( @Nullable final String businessTransactionType_ID )
    {
        rememberChangedField("BusinessTransactionType_ID", this.businessTransactionType_ID);
        this.businessTransactionType_ID = businessTransactionType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionTypeText</b>
     * </p>
     *
     * @param businessTransactionTypeText
     *            Business Transaction Type (Description)
     */
    public void setBusinessTransactionTypeText( @Nullable final String businessTransactionTypeText )
    {
        rememberChangedField("BusinessTransactionTypeText", this.businessTransactionTypeText);
        this.businessTransactionTypeText = businessTransactionTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusinessTransactionType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessTransactionType_ID", getBusinessTransactionType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessTransactionType_ID", getBusinessTransactionType_ID());
        values.put("BusinessTransactionTypeText", getBusinessTransactionTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessTransactionType_ID") ) {
                final Object value = values.remove("BusinessTransactionType_ID");
                if( (value == null) || (!value.equals(getBusinessTransactionType_ID())) ) {
                    setBusinessTransactionType_ID(((String) value));
                }
            }
            if( values.containsKey("BusinessTransactionTypeText") ) {
                final Object value = values.remove("BusinessTransactionTypeText");
                if( (value == null) || (!value.equals(getBusinessTransactionTypeText())) ) {
                    setBusinessTransactionTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusinessTransactionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessTransactionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessTransactionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessTransactionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
