/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CalendarMonthField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CalendarMonthSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Calendar Month (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CalendarMonth</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CalendarMonth extends VdmEntity<CalendarMonth>
{

    /**
     * Selector for all available fields of CalendarMonth.
     *
     */
    public final static CalendarMonthSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth_ID</b>
     * </p>
     *
     * @return Calendar Month
     */
    @Key
    @SerializedName( "CalendarMonth_ID" )
    @JsonProperty( "CalendarMonth_ID" )
    @Nullable
    @ODataField( odataName = "CalendarMonth_ID" )
    private String calendarMonth_ID;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonth_ID</b> field to query operations.
     *
     */
    public final static CalendarMonthField<String> CALENDAR_MONTH_ID =
        new CalendarMonthField<String>("CalendarMonth_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonthText</b>
     * </p>
     *
     * @return Calendar Month (Description)
     */
    @SerializedName( "CalendarMonthText" )
    @JsonProperty( "CalendarMonthText" )
    @Nullable
    @ODataField( odataName = "CalendarMonthText" )
    private String calendarMonthText;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonthText</b> field to query operations.
     *
     */
    public final static CalendarMonthField<String> CALENDAR_MONTH_TEXT =
        new CalendarMonthField<String>("CalendarMonthText");

    @Nonnull
    @Override
    public Class<CalendarMonth> getType()
    {
        return CalendarMonth.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth_ID</b>
     * </p>
     *
     * @param calendarMonth_ID
     *            Calendar Month
     */
    public void setCalendarMonth_ID( @Nullable final String calendarMonth_ID )
    {
        rememberChangedField("CalendarMonth_ID", this.calendarMonth_ID);
        this.calendarMonth_ID = calendarMonth_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonthText</b>
     * </p>
     *
     * @param calendarMonthText
     *            Calendar Month (Description)
     */
    public void setCalendarMonthText( @Nullable final String calendarMonthText )
    {
        rememberChangedField("CalendarMonthText", this.calendarMonthText);
        this.calendarMonthText = calendarMonthText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CalendarMonth";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CalendarMonth_ID", getCalendarMonth_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CalendarMonth_ID", getCalendarMonth_ID());
        values.put("CalendarMonthText", getCalendarMonthText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CalendarMonth_ID") ) {
                final Object value = values.remove("CalendarMonth_ID");
                if( (value == null) || (!value.equals(getCalendarMonth_ID())) ) {
                    setCalendarMonth_ID(((String) value));
                }
            }
            if( values.containsKey("CalendarMonthText") ) {
                final Object value = values.remove("CalendarMonthText");
                if( (value == null) || (!value.equals(getCalendarMonthText())) ) {
                    setCalendarMonthText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CalendarMonthField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CalendarMonthField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CalendarMonthField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CalendarMonthField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
