/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CalendarYearMonthField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CalendarYearMonthSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Year Month (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CalendarYearMonth</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CalendarYearMonth extends VdmEntity<CalendarYearMonth>
{

    /**
     * Selector for all available fields of CalendarYearMonth.
     *
     */
    public final static CalendarYearMonthSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearMonth_ID</b>
     * </p>
     *
     * @return Year Month
     */
    @Key
    @SerializedName( "CalendarYearMonth_ID" )
    @JsonProperty( "CalendarYearMonth_ID" )
    @Nullable
    @ODataField( odataName = "CalendarYearMonth_ID" )
    private String calendarYearMonth_ID;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearMonth_ID</b> field to query operations.
     *
     */
    public final static CalendarYearMonthField<String> CALENDAR_YEAR_MONTH_ID =
        new CalendarYearMonthField<String>("CalendarYearMonth_ID");

    @Nonnull
    @Override
    public Class<CalendarYearMonth> getType()
    {
        return CalendarYearMonth.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearMonth_ID</b>
     * </p>
     *
     * @param calendarYearMonth_ID
     *            Year Month
     */
    public void setCalendarYearMonth_ID( @Nullable final String calendarYearMonth_ID )
    {
        rememberChangedField("CalendarYearMonth_ID", this.calendarYearMonth_ID);
        this.calendarYearMonth_ID = calendarYearMonth_ID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CalendarYearMonth";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CalendarYearMonth_ID", getCalendarYearMonth_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CalendarYearMonth_ID", getCalendarYearMonth_ID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CalendarYearMonth_ID") ) {
                final Object value = values.remove("CalendarYearMonth_ID");
                if( (value == null) || (!value.equals(getCalendarYearMonth_ID())) ) {
                    setCalendarYearMonth_ID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CalendarYearMonthField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CalendarYearMonthField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CalendarYearMonthField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CalendarYearMonthField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
