/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ChartOfAccountsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ChartOfAccountsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Chart of Accounts (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ChartOfAccounts</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChartOfAccounts extends VdmEntity<ChartOfAccounts>
{

    /**
     * Selector for all available fields of ChartOfAccounts.
     *
     */
    public final static ChartOfAccountsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts_ID</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts_ID" )
    @JsonProperty( "ChartOfAccounts_ID" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts_ID" )
    private String chartOfAccounts_ID;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts_ID</b> field to query operations.
     *
     */
    public final static ChartOfAccountsField<String> CHART_OF_ACCOUNTS_ID =
        new ChartOfAccountsField<String>("ChartOfAccounts_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccountsText</b>
     * </p>
     *
     * @return Chart of Accounts (Description)
     */
    @SerializedName( "ChartOfAccountsText" )
    @JsonProperty( "ChartOfAccountsText" )
    @Nullable
    @ODataField( odataName = "ChartOfAccountsText" )
    private String chartOfAccountsText;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccountsText</b> field to query operations.
     *
     */
    public final static ChartOfAccountsField<String> CHART_OF_ACCOUNTS_TEXT =
        new ChartOfAccountsField<String>("ChartOfAccountsText");

    @Nonnull
    @Override
    public Class<ChartOfAccounts> getType()
    {
        return ChartOfAccounts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts_ID</b>
     * </p>
     *
     * @param chartOfAccounts_ID
     *            Chart of Accounts
     */
    public void setChartOfAccounts_ID( @Nullable final String chartOfAccounts_ID )
    {
        rememberChangedField("ChartOfAccounts_ID", this.chartOfAccounts_ID);
        this.chartOfAccounts_ID = chartOfAccounts_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccountsText</b>
     * </p>
     *
     * @param chartOfAccountsText
     *            Chart of Accounts (Description)
     */
    public void setChartOfAccountsText( @Nullable final String chartOfAccountsText )
    {
        rememberChangedField("ChartOfAccountsText", this.chartOfAccountsText);
        this.chartOfAccountsText = chartOfAccountsText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ChartOfAccounts";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChartOfAccounts_ID", getChartOfAccounts_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChartOfAccounts_ID", getChartOfAccounts_ID());
        values.put("ChartOfAccountsText", getChartOfAccountsText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChartOfAccounts_ID") ) {
                final Object value = values.remove("ChartOfAccounts_ID");
                if( (value == null) || (!value.equals(getChartOfAccounts_ID())) ) {
                    setChartOfAccounts_ID(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccountsText") ) {
                final Object value = values.remove("ChartOfAccountsText");
                if( (value == null) || (!value.equals(getChartOfAccountsText())) ) {
                    setChartOfAccountsText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChartOfAccountsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChartOfAccountsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChartOfAccountsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
