/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ClearingAccountingDocumentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
 * ClearingAccountingDocument} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ClearingAccountingDocumentByKeyFluentHelper
    extends
    FluentHelperByKey<ClearingAccountingDocumentByKeyFluentHelper, ClearingAccountingDocument, ClearingAccountingDocumentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
     * ClearingAccountingDocument} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param companyCode
     *            Clearing Journal Entry (Deprecated) (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ClearingAccountingDocument}
     * @param clearingAccountingDocument_ID
     *            Clearing Journal Entry (Deprecated)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ClearingAccountingDocument}
     * @param fiscalYear
     *            Clearing Journal Entry (Deprecated) (Fiscal Year)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public ClearingAccountingDocumentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String clearingAccountingDocument_ID,
        final String companyCode,
        final String fiscalYear )
    {
        super(servicePath, entityCollection);
        this.key.put("ClearingAccountingDocument_ID", clearingAccountingDocument_ID);
        this.key.put("CompanyCode", companyCode);
        this.key.put("FiscalYear", fiscalYear);
    }

    @Override
    @Nonnull
    protected Class<ClearingAccountingDocument> getEntityClass()
    {
        return ClearingAccountingDocument.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
