/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ClearingJournalEntryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ClearingJournalEntrySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Clearing Journal Entry (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ClearingJournalEntry</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClearingJournalEntry extends VdmEntity<ClearingJournalEntry>
{

    /**
     * Selector for all available fields of ClearingJournalEntry.
     *
     */
    public final static ClearingJournalEntrySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntry_ID</b>
     * </p>
     *
     * @return Clearing Journal Entry
     */
    @Key
    @SerializedName( "ClearingJournalEntry_ID" )
    @JsonProperty( "ClearingJournalEntry_ID" )
    @Nullable
    @ODataField( odataName = "ClearingJournalEntry_ID" )
    private String clearingJournalEntry_ID;
    /**
     * Use with available fluent helpers to apply the <b>ClearingJournalEntry_ID</b> field to query operations.
     *
     */
    public final static ClearingJournalEntryField<String> CLEARING_JOURNAL_ENTRY_ID =
        new ClearingJournalEntryField<String>("ClearingJournalEntry_ID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Clearing Journal Entry (Company Code)
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static ClearingJournalEntryField<String> COMPANY_CODE =
        new ClearingJournalEntryField<String>("CompanyCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code (Description) (Parent Description)
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static ClearingJournalEntryField<String> COMPANY_CODE_NAME =
        new ClearingJournalEntryField<String>("CompanyCodeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntryFiscalYear</b>
     * </p>
     *
     * @return Clearing Journal Entry (Fiscal Year of Clearing Journal Entry)
     */
    @Key
    @SerializedName( "ClearingJournalEntryFiscalYear" )
    @JsonProperty( "ClearingJournalEntryFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingJournalEntryFiscalYear" )
    private String clearingJournalEntryFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingJournalEntryFiscalYear</b> field to query operations.
     *
     */
    public final static ClearingJournalEntryField<String> CLEARING_JOURNAL_ENTRY_FISCAL_YEAR =
        new ClearingJournalEntryField<String>("ClearingJournalEntryFiscalYear");

    @Nonnull
    @Override
    public Class<ClearingJournalEntry> getType()
    {
        return ClearingJournalEntry.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntry_ID</b>
     * </p>
     *
     * @param clearingJournalEntry_ID
     *            Clearing Journal Entry
     */
    public void setClearingJournalEntry_ID( @Nullable final String clearingJournalEntry_ID )
    {
        rememberChangedField("ClearingJournalEntry_ID", this.clearingJournalEntry_ID);
        this.clearingJournalEntry_ID = clearingJournalEntry_ID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Clearing Journal Entry (Company Code)
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code (Description) (Parent Description)
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntryFiscalYear</b>
     * </p>
     *
     * @param clearingJournalEntryFiscalYear
     *            Clearing Journal Entry (Fiscal Year of Clearing Journal Entry)
     */
    public void setClearingJournalEntryFiscalYear( @Nullable final String clearingJournalEntryFiscalYear )
    {
        rememberChangedField("ClearingJournalEntryFiscalYear", this.clearingJournalEntryFiscalYear);
        this.clearingJournalEntryFiscalYear = clearingJournalEntryFiscalYear;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ClearingJournalEntry";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ClearingJournalEntry_ID", getClearingJournalEntry_ID());
        result.put("CompanyCode", getCompanyCode());
        result.put("ClearingJournalEntryFiscalYear", getClearingJournalEntryFiscalYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ClearingJournalEntry_ID", getClearingJournalEntry_ID());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("ClearingJournalEntryFiscalYear", getClearingJournalEntryFiscalYear());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ClearingJournalEntry_ID") ) {
                final Object value = values.remove("ClearingJournalEntry_ID");
                if( (value == null) || (!value.equals(getClearingJournalEntry_ID())) ) {
                    setClearingJournalEntry_ID(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("ClearingJournalEntryFiscalYear") ) {
                final Object value = values.remove("ClearingJournalEntryFiscalYear");
                if( (value == null) || (!value.equals(getClearingJournalEntryFiscalYear())) ) {
                    setClearingJournalEntryFiscalYear(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ClearingJournalEntryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ClearingJournalEntryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClearingJournalEntryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClearingJournalEntryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
