/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ClearingJournalEntrySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry ClearingJournalEntry}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ClearingJournalEntryByKeyFluentHelper
    extends
    FluentHelperByKey<ClearingJournalEntryByKeyFluentHelper, ClearingJournalEntry, ClearingJournalEntrySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry
     * ClearingJournalEntry} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param companyCode
     *            Clearing Journal Entry (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ClearingJournalEntry}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ClearingJournalEntry}
     * @param clearingJournalEntry_ID
     *            Clearing Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param clearingJournalEntryFiscalYear
     *            Clearing Journal Entry (Fiscal Year of Clearing Journal Entry)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public ClearingJournalEntryByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String clearingJournalEntry_ID,
        final String companyCode,
        final String clearingJournalEntryFiscalYear )
    {
        super(servicePath, entityCollection);
        this.key.put("ClearingJournalEntry_ID", clearingJournalEntry_ID);
        this.key.put("CompanyCode", companyCode);
        this.key.put("ClearingJournalEntryFiscalYear", clearingJournalEntryFiscalYear);
    }

    @Override
    @Nonnull
    protected Class<ClearingJournalEntry> getEntityClass()
    {
        return ClearingJournalEntry.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
