/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ClearingJournalEntryFiscalYearSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
 * ClearingJournalEntryFiscalYear} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class ClearingJournalEntryFiscalYearByKeyFluentHelper
    extends
    FluentHelperByKey<ClearingJournalEntryFiscalYearByKeyFluentHelper, ClearingJournalEntryFiscalYear, ClearingJournalEntryFiscalYearSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
     * ClearingJournalEntryFiscalYear} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param companyCode
     *            Fiscal Year of Clearing Journal Entry (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ClearingJournalEntryFiscalYear}
     * @param clearingJournalEntryFiscalYear_ID
     *            Fiscal Year of Clearing Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ClearingJournalEntryFiscalYear}
     */
    public ClearingJournalEntryFiscalYearByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String clearingJournalEntryFiscalYear_ID,
        final String companyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("ClearingJournalEntryFiscalYear_ID", clearingJournalEntryFiscalYear_ID);
        this.key.put("CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    protected Class<ClearingJournalEntryFiscalYear> getEntityClass()
    {
        return ClearingJournalEntryFiscalYear.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
