/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CompanyCodeCurrencyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CompanyCodeCurrencySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Company Code Currency (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CompanyCodeCurrency</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CompanyCodeCurrency extends VdmEntity<CompanyCodeCurrency>
{

    /**
     * Selector for all available fields of CompanyCodeCurrency.
     *
     */
    public final static CompanyCodeCurrencySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency_ID</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @Key
    @SerializedName( "CompanyCodeCurrency_ID" )
    @JsonProperty( "CompanyCodeCurrency_ID" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency_ID" )
    private String companyCodeCurrency_ID;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency_ID</b> field to query operations.
     *
     */
    public final static CompanyCodeCurrencyField<String> COMPANY_CODE_CURRENCY_ID =
        new CompanyCodeCurrencyField<String>("CompanyCodeCurrency_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrencyText</b>
     * </p>
     *
     * @return Company Code Currency (Description)
     */
    @SerializedName( "CompanyCodeCurrencyText" )
    @JsonProperty( "CompanyCodeCurrencyText" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrencyText" )
    private String companyCodeCurrencyText;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrencyText</b> field to query operations.
     *
     */
    public final static CompanyCodeCurrencyField<String> COMPANY_CODE_CURRENCY_TEXT =
        new CompanyCodeCurrencyField<String>("CompanyCodeCurrencyText");

    @Nonnull
    @Override
    public Class<CompanyCodeCurrency> getType()
    {
        return CompanyCodeCurrency.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency_ID</b>
     * </p>
     *
     * @param companyCodeCurrency_ID
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency_ID( @Nullable final String companyCodeCurrency_ID )
    {
        rememberChangedField("CompanyCodeCurrency_ID", this.companyCodeCurrency_ID);
        this.companyCodeCurrency_ID = companyCodeCurrency_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrencyText</b>
     * </p>
     *
     * @param companyCodeCurrencyText
     *            Company Code Currency (Description)
     */
    public void setCompanyCodeCurrencyText( @Nullable final String companyCodeCurrencyText )
    {
        rememberChangedField("CompanyCodeCurrencyText", this.companyCodeCurrencyText);
        this.companyCodeCurrencyText = companyCodeCurrencyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CompanyCodeCurrency";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCodeCurrency_ID", getCompanyCodeCurrency_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCodeCurrency_ID", getCompanyCodeCurrency_ID());
        values.put("CompanyCodeCurrencyText", getCompanyCodeCurrencyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCodeCurrency_ID") ) {
                final Object value = values.remove("CompanyCodeCurrency_ID");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency_ID())) ) {
                    setCompanyCodeCurrency_ID(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrencyText") ) {
                final Object value = values.remove("CompanyCodeCurrencyText");
                if( (value == null) || (!value.equals(getCompanyCodeCurrencyText())) ) {
                    setCompanyCodeCurrencyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CompanyCodeCurrencyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CompanyCodeCurrencyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CompanyCodeCurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CompanyCodeCurrencyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
