/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CompanyCodeCurrencySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency CompanyCodeCurrency}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class CompanyCodeCurrencyByKeyFluentHelper
    extends
    FluentHelperByKey<CompanyCodeCurrencyByKeyFluentHelper, CompanyCodeCurrency, CompanyCodeCurrencySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency CompanyCodeCurrency}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param companyCodeCurrency_ID
     *            Company Code Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CompanyCodeCurrency}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CompanyCodeCurrency}
     */
    public CompanyCodeCurrencyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String companyCodeCurrency_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("CompanyCodeCurrency_ID", companyCodeCurrency_ID);
    }

    @Override
    @Nonnull
    protected Class<CompanyCodeCurrency> getEntityClass()
    {
        return CompanyCodeCurrency.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
